# Canonical Webteam Flask-Base

Flask extension that applies common configurations to all of webteam's flask apps.

## Usage

``` python3
from canonicalwebteam.flask_base.app import FlaskBase

app = FlaskBase(__name__, "app.name")
```

Or:

``` python3
from canonicalwebteam.flask_base.app import FlaskBase

app = FlaskBase(
    __name__,
    "app.name",
    template_404="404.html",
    template_500="500.html",
    favicon_url="/static/favicon.ico",
)
```

## Features

### Redirects and deleted paths

FlaskBase uses [yaml-responses](https://github.com/canonical-web-and-design/canonicalwebteam.yaml-responses) to allow easy configuration of redirects and return of deleted responses, by creating `redirects.yaml`, `permanent-redirects.yaml` and `deleted.yaml` in the site root directory.

### Error templates

`FlaskBase` can optionally use templates to generate the `404` and `500` error responses:

``` python3
app = FlaskBase(
    __name__,
    "app.name",
    template_404="404.html",
    template_500="500.html",
)
```

This will lead to e.g. `http://localhost/non-existent-path` returning a `404` status with the contents of `templates/404.html`.

### Redirect /favicon.ico

`FlaskBase` can optionally provide redirects for the commonly queried paths `/favicon.ico`, `/robots.txt` and `/humans.txt` to sensible locations:

``` python3
from canonicalwebteam.flask_base.app import FlaskBase

app = FlaskBase(
    __name__,
    "app.name",
    template_404="404.html",
    template_500="500.html",
    favicon_url="/static/favicon.ico",
    robots_url="/static/robots.txt",
    humans_url="/static/humans.txt"
)
```

This will lead to e.g. `http://localhost/favicon.ico` returning a `302` redirect to `http://localhost/static/favicon.ico`.

### `robots.txt` and `humans.txt`

If you create a `robots.txt` or `humans.txt` in the root of your project, these will be served at `/robots.txt` and `/humans.txt` respectively.

## Generating setup.py

In this project, for the time being, we maintain both a `pyproject.toml` for Poetry and a `setup.py` for traditional Python tooling. If you are developing on the module, you should update `pyproject.toml` first and then regenerate the `setup.py` using:

``` bash
poetry install
poetry run poetry-setup
```

## Tests

To run the tests execute `poetry run python -m unittest discover tests`.
