# User Guide

Welcome to the User Guide for the `soundevent` package! This guide is designed to
help you navigate through the various topics commonly encountered in
computational Bioacoustic analysis and demonstrate how the `soundevent` package
can assist you in your research. Our goal is to provide you with clear and
easy-to-follow instructions to make your Bioacoustic analysis journey smooth
and enjoyable.

Each page in this guide is a fully executable Python script that you can
download and modify. We encourage you to experiment and integrate these
examples into your own analysis workflows to suit your specific needs.

Let's start with the basics, where we will cover essential topics such as:

* How to [read and write](1_saving_and_loading.md) bioacoustic analysis objects in a format compatible with the `soundevent` package.
* [Loading audio data](2_loading_audio.md) from WAV files using the tools provided by `soundevent`.
* [Computing spectrograms](3_computing_spectrograms.md) to gain insights into the acoustic characteristics of your data.

???+ info

    Stay tuned for future releases of the soundevent package, where we will continue to expand the examples and demonstrate additional bioacoustic analysis techniques. We are committed to providing you with the tools and resources you need for successful bioacoustic research. Enjoy exploring the user guide and happy analyzing!
