# coding: utf-8

"""
    Paasta API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from paasta_tools.paastaapi.api_client import ApiClient, Endpoint
from paasta_tools.paastaapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from paasta_tools.paastaapi.model.flink_cluster_overview import FlinkClusterOverview
from paasta_tools.paastaapi.model.flink_config import FlinkConfig
from paasta_tools.paastaapi.model.flink_job_details import FlinkJobDetails
from paasta_tools.paastaapi.model.flink_jobs import FlinkJobs
from paasta_tools.paastaapi.model.inline_response200 import InlineResponse200
from paasta_tools.paastaapi.model.inline_response2001 import InlineResponse2001
from paasta_tools.paastaapi.model.instance_bounce_status import InstanceBounceStatus
from paasta_tools.paastaapi.model.instance_mesh_status import InstanceMeshStatus
from paasta_tools.paastaapi.model.instance_status import InstanceStatus
from paasta_tools.paastaapi.model.instance_tasks import InstanceTasks


class ServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bounce_status_instance(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get bounce status of service_name.instance_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bounce_status_instance(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstanceBounceStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.bounce_status_instance = Endpoint(
            settings={
                'response_type': (InstanceBounceStatus,),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/bounce_status',
                'operation_id': 'bounce_status_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__bounce_status_instance
        )

        def __delay_instance(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get the possible reasons for a deployment delay for a marathon service.instance  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delay_instance(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.delay_instance = Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/delay',
                'operation_id': 'delay_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delay_instance
        )

        def __get_flink_cluster_config(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get config of a flink cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_flink_cluster_config(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FlinkConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.get_flink_cluster_config = Endpoint(
            settings={
                'response_type': (FlinkConfig,),
                'auth': [],
                'endpoint_path': '/flink/{service}/{instance}/config',
                'operation_id': 'get_flink_cluster_config',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_flink_cluster_config
        )

        def __get_flink_cluster_job_details(
            self,
            service,
            instance,
            job_id,
            **kwargs
        ):
            """Get details of a flink job in a flink cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_flink_cluster_job_details(service, instance, job_id, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                job_id (str): Job id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FlinkJobDetails
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['job_id'] = \
                job_id
            return self.call_with_http_info(**kwargs)

        self.get_flink_cluster_job_details = Endpoint(
            settings={
                'response_type': (FlinkJobDetails,),
                'auth': [],
                'endpoint_path': '/flink/{service}/{instance}/jobs/{job_id}',
                'operation_id': 'get_flink_cluster_job_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'job_id',
                ],
                'required': [
                    'service',
                    'instance',
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'job_id':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'job_id': 'job_id',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'job_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_flink_cluster_job_details
        )

        def __get_flink_cluster_overview(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get overview of a flink cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_flink_cluster_overview(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FlinkClusterOverview
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.get_flink_cluster_overview = Endpoint(
            settings={
                'response_type': (FlinkClusterOverview,),
                'auth': [],
                'endpoint_path': '/flink/{service}/{instance}/overview',
                'operation_id': 'get_flink_cluster_overview',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_flink_cluster_overview
        )

        def __instance_set_state(
            self,
            service,
            instance,
            desired_state,
            **kwargs
        ):
            """Change state of service_name.instance_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.instance_set_state(service, instance, desired_state, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                desired_state (str): Desired state

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['desired_state'] = \
                desired_state
            return self.call_with_http_info(**kwargs)

        self.instance_set_state = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/state/{desired_state}',
                'operation_id': 'instance_set_state',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'desired_state',
                ],
                'required': [
                    'service',
                    'instance',
                    'desired_state',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'desired_state':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'desired_state': 'desired_state',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'desired_state': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__instance_set_state
        )

        def __list_flink_cluster_jobs(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get list of flink jobs in a flink cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_flink_cluster_jobs(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FlinkJobs
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.list_flink_cluster_jobs = Endpoint(
            settings={
                'response_type': (FlinkJobs,),
                'auth': [],
                'endpoint_path': '/flink/{service}/{instance}/jobs',
                'operation_id': 'list_flink_cluster_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_flink_cluster_jobs
        )

        def __list_instances(
            self,
            service,
            **kwargs
        ):
            """List instances of service_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_instances(service, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse2001
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            return self.call_with_http_info(**kwargs)

        self.list_instances = Endpoint(
            settings={
                'response_type': (InlineResponse2001,),
                'auth': [],
                'endpoint_path': '/services/{service}',
                'operation_id': 'list_instances',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                ],
                'required': [
                    'service',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                },
                'location_map': {
                    'service': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_instances
        )

        def __list_services_for_cluster(
            self,
            **kwargs
        ):
            """List service names and service instance names on the current cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_services_for_cluster(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse200
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_services_for_cluster = Endpoint(
            settings={
                'response_type': (InlineResponse200,),
                'auth': [],
                'endpoint_path': '/services',
                'operation_id': 'list_services_for_cluster',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_services_for_cluster
        )

        def __mesh_instance(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get mesh status for service_name.instance_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.mesh_instance(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                include_envoy (bool): Include Envoy information. [optional] if omitted the server will use the default value of True
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstanceMeshStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.mesh_instance = Endpoint(
            settings={
                'response_type': (InstanceMeshStatus,),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/mesh_status',
                'operation_id': 'mesh_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'include_envoy',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'include_envoy':
                        (bool,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'include_envoy': 'include_envoy',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'include_envoy': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__mesh_instance
        )

        def __status_instance(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get status of service_name.instance_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.status_instance(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                verbose (int): Include verbose status information. [optional]
                include_envoy (bool): Include Envoy information. [optional]
                include_mesos (bool): Include Mesos information. [optional]
                new (bool): Use new version of paasta status for services. [optional]
                all_namespaces (bool): Search all namespaces for running copies. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstanceStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.status_instance = Endpoint(
            settings={
                'response_type': (InstanceStatus,),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/status',
                'operation_id': 'status_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'verbose',
                    'include_envoy',
                    'include_mesos',
                    'new',
                    'all_namespaces',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'verbose':
                        (int,),
                    'include_envoy':
                        (bool,),
                    'include_mesos':
                        (bool,),
                    'new':
                        (bool,),
                    'all_namespaces':
                        (bool,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'verbose': 'verbose',
                    'include_envoy': 'include_envoy',
                    'include_mesos': 'include_mesos',
                    'new': 'new',
                    'all_namespaces': 'all_namespaces',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'verbose': 'query',
                    'include_envoy': 'query',
                    'include_mesos': 'query',
                    'new': 'query',
                    'all_namespaces': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__status_instance
        )

        def __task_instance(
            self,
            service,
            instance,
            task_id,
            **kwargs
        ):
            """Get mesos task of service_name.instance_name by task_id  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.task_instance(service, instance, task_id, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                task_id (str): mesos task id

            Keyword Args:
                verbose (bool): Return slave and executor for task. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['task_id'] = \
                task_id
            return self.call_with_http_info(**kwargs)

        self.task_instance = Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/tasks/{task_id}',
                'operation_id': 'task_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'task_id',
                    'verbose',
                ],
                'required': [
                    'service',
                    'instance',
                    'task_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'task_id':
                        (str,),
                    'verbose':
                        (bool,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'task_id': 'task_id',
                    'verbose': 'verbose',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'task_id': 'path',
                    'verbose': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__task_instance
        )

        def __tasks_instance(
            self,
            service,
            instance,
            **kwargs
        ):
            """Get mesos tasks of service_name.instance_name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.tasks_instance(service, instance, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name

            Keyword Args:
                slave_hostname (str): slave hostname to filter tasks by. [optional]
                verbose (bool): Return slave and executor for task. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstanceTasks
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.tasks_instance = Endpoint(
            settings={
                'response_type': (InstanceTasks,),
                'auth': [],
                'endpoint_path': '/services/{service}/{instance}/tasks',
                'operation_id': 'tasks_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'slave_hostname',
                    'verbose',
                ],
                'required': [
                    'service',
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'slave_hostname':
                        (str,),
                    'verbose':
                        (bool,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'slave_hostname': 'slave_hostname',
                    'verbose': 'verbose',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'slave_hostname': 'query',
                    'verbose': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__tasks_instance
        )
