LIXI Package Overview
====

``lixi`` is a python package that simplifies working with the LIXI data standards and with messages that are based on the LIXI standards. 

[LIXI Limited]([https://lixi.org.au/) has been facilitating collaboration within the Australian Lending industry for almost two decades, by managing a suite of data standards (for both XML & JSON) used across the industry to improve the efficiency of B2B electronic messaging.

This package is offered under an open source license, however the features are effective when used in conjunction with a LIXI2 Schema which are available to LIXI members  and licensees.

Features
========

The development of this package was driven by a need to simplify the most common tasks associated with the use of the LIXI2 schemas and sample messages. Key features include the following:

* Read an XML or JSON file
* Validate an XML or JSON file against a LIXI2 Schema.
* Validate a LIXI package (XML or JSON) against a Schematron file that contains business rules (in the form of rule and assertions).
* Convert a valid LIXI2 XML file to the equivalent JSON representation.
* Convert a valid LIXI2 JSON file to the equivalent XML representation.
* Transform a LIXI2 message to an older/newer LIXI2 version or show warnings regarding any data loss that would occur in such a transformation.
* Create a list of all LIXI Paths that represent the elements and attributes used in a single package.
* Create a set of [Customisation by Restriction](https://lixi.org.au/join-lixi/benefits-of-lixi-membership/premium-tools/customisation-by-restriction/) instructions or schema based on a single LIXI message.
* Create a customised schema based on a set of Customisation by Restriction instructions. 
* Create LIXI Schema Documentation for any LIXI2 Transaction Schema or any schema created by Customisation by Restriction.


Installation
============

Requirements
------------

The installation of the ``lixi`` package requires [pip](https://pypi.org/project/pip/) to be installed for package installation with your Python installation.

The ``lixi`` package is not supported by Python 2.

The installation of the ``lixi`` using pip will install the following libraries as required dependencies:

* [boto3](https://github.com/boto/boto3)
* [isodate](https://github.com/gweis/isodate/)
* [jsonschema](https://github.com/Julian/jsonschema)
* [lxml](https://lxml.de/)
* [xmljson](https://github.com/sanand0/xmljson)

Installation with pip
----------------
Open a command prompt or a bash window on your PC and type the following command. 

```python
pip install lixi
```

Now to use the ``lixi`` package, simply import the library into your Python project, like so:

```python
import lixi
```

and that's it! You're ready to go.

Assumptions
-----------

The ``lixi`` package requires you to have access to the required LIXI schemas. Members and Licensees of LIXI can access these through the LIXI website or via an API provided by LIXI (contact LIXI for more details if you would like to use this API retrieval mechanism).

# Further Documentation

Detailed class documentation generated by Sphinx along with a quick start guide are available on the LIXI website to logged in members and licensees available [here](https://smedia.lixi.org.au/python-docs/index.html).

# Source Code Management

## GIT Project

This LIXI python library is made available through an open source license, but because the automated testing of the project requires access to the LIXI Schemas that are available to LIXI Members and Licensees, the [lixi-pypi](https://standards.lixi.org.au/lixi-tech/lixi-pypi) project that we use to manage the library will only be available to members and licensees once it stabilises. For now, the source code is available to LIXI Staff, although the library is available on the Python Package Index for anyone to install.

Contributing
------------

For now, you can contribute to the project by installing the library from PyPI and emailing us on lixilab@lixi.org.au to:

* suggest new features; 
* raise issues;
* and report bugs.

Branching, Build, Test & Deployment
----------

The [lixi-pypi](https://standards.lixi.org.au/lixi-tech/lixi-pypi) project contains 3 permanent branches 'master', 'test' and 'dev'. A feature branch 'feature' may be created for new functionality added. Two of these ('master' & 'test') are protected branches, and only allow commits through merge requests. 

Commits and pushes to the 'feature' and 'dev' branch executes a series of test cases and generates the library documentation using Sphinx but does not push the library to any pypi repository. 

Merges into the 'test' branch run the same tests and generate the documentation, but upload the build to the test PyPi repository to be tested ([available here](https://test.pypi.org/project/lixi/)).

Merges into the 'master' branch will also test the build and generate docs but *only* deploy to production PyPI ([available here](https://pypi.org/project/lixi/)) when a tag is applied on the master branch.

The build version number is maintained in CI/CD variables. The first digit is incremented for breaking changes, the second digit is incremented for new features and the third digit is incremented for all other changes,  further digits are timestamps for development/test versions only.

