var glossaryString = `<?xml version="1.0" encoding="utf-8"?>
<Glossary Collection="lixi" Version="DRAFT" Date="2016-07-29T11:26:31.523+10:00" Author="Pageseeder">
	<Term Name="100 Point Identification Check">
		<Definition>An identify verification procedure pursuant to legislation, e.g. in NSW to the Financial Transaction Reports Act 1988, whereby document types have point values and 100 points of identification documentation need to be presented. The 100 point check has been replaced with requirements set out in, for example, the AML/CTF Rules. A succinct example of the modified requirement is Landgate verification of identity practice.</Definition>
	</Term>
	<Term Name="100% Offset Account">
		<Definition>An Offset Account where 100% of the account balance is used to offset the balance owing on the loan, reducing the calculated interest.</Definition>
		<RelatedTerm Name="Offset Account" Collection="lixi"/>
	</Term>
	<Term Name="Average Annual Percentage Rate" Abbr="AAPR">
		<Definition/>
		<RelatedTerm Name="Comparison Rate" Collection="lixi"/>
		<RelatedTerm Name="Deferred Establishment Fee" Collection="lixi"/>
		<RelatedTerm Name="Average Annual Percentage Rate" Collection="lixi"/>
	</Term>
	<Term Name="Australian Bankers' Association" Abbr="ABA">
		<Definition/>
	</Term>
	<Term Name="Australian Business Number" Abbr="ABN">
		<Definition>An identifier issued by the Australian Business Register that can be used to uniquely identify a particular business or organisation.</Definition>
	</Term>
	<Term Name="Australian Business Register" Abbr="ABR">
		<Definition>A database administered by the ATO that contains information collected when businesses and other organisations register for an ABN.</Definition>
	</Term>
	<Term Name="Australian Business Registration Number" Abbr="ABRN">
		<Definition>An alphanumeric identifier for a registered business name, managed by each state for the business names registered therein.</Definition>
	</Term>
	<Term Name="Australian Bureau of Statistics" Abbr="ABS">
		<Definition/>
	</Term>
	<Term Name="Australian Tax Office" Abbr="ATO">
		<Definition>The principal revenue collection agency of the Australian Government.</Definition>
	</Term>
	<Term Name="Asset-Backed Security" Abbr="ABS">
		<Definition/>
	</Term>
	<Term Name="Australian Competition and Consumer Commission" Abbr="ACCC">
		<Definition/>
	</Term>
	<Term Name="Australian Company Number" Abbr="ACN">
		<Definition>An Australian Company Number (ACN) is a unique nine-digit number issued by the ASIC to every company registered under the Commonwealth Corporations Act 2001 that can be used to uniquely identify the company. The ACN must be used on all 'public documents' such as statements, receipts, letterheads, checks and so on.</Definition>
	</Term>
	<Term Name="Australian Credit Licence" Abbr="ACL">
		<Definition>A licence to engage in credit activities within Australia granted under a licensing regime regulated and enforced by ASIC.</Definition>
	</Term>
	<Term Name="Acceptance">
		<Definition>When the recipient of an offer agrees to the terms and conditions of the offer. A typical scenario is that the purchaser makes an offer and the vendor accepts.</Definition>
	</Term>
	<Term Name="Accommodation Bond">
		<Definition>Funds that may be entrusted to an aged-care facility by a pensioner taking up residence to cover some of the costs of the service. The aged-care facility will use the interest that it earns while holding the funds, and is allowed to draw a monthly retention amount, currently $280 per month for a period not to exceed five years. When the pensioner leaves the facility, any remaining funds are returned to the pensioner or their deceased estate. The accommodation bond may be quite large and the pensioner may be required to sell the family home or take out a reverse mortgage and possibly rent out the family home.</Definition>
		<Reference URL="http://www.reverse-mortgage.net.au/accommodation-bonds/" Name="reverse-mortgage.net.au"/>
		<RelatedTerm Name="Reverse Mortgage Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Account">
		<Definition>A loan or deposit facility with a lender that is uniquely identified with an Account Number.</Definition>
		<RelatedTerm Name="Loan Account" Collection="lixi"/>
		<RelatedTerm Name="Account Holder" Collection="lixi"/>
		<RelatedTerm Name="Account Number" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Loan Account" Collection="lixi"/>
		<RelatedTerm Name="Account ID" Collection="lixi"/>
		<RelatedTerm Name="Account Close Fee" Collection="lixi"/>
		<RelatedTerm Name="Account Action" Collection="lixi"/>
	</Term>
	<Term Name="Account Action">
		<Definition>Requested or required action to be taken on an account, such as paying down the balance, increasing the approved limit, or closing the account. The action may be specified in conjunction with a date to perform the action.</Definition>
	</Term>
	<Term Name="Account Balance">
		<Definition>For a loan account, the amount of money drawn on the account (net of any redraw amount (i.e. not drawn)) at a specified point in time. For a deposit account, the amount of money on deposit at a specified point in time.</Definition>
		<RelatedTerm Name="Amortisation" Collection="lixi"/>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="Available Funds" Collection="lixi"/>
		<RelatedTerm Name="Current Balance" Collection="lixi"/>
		<RelatedTerm Name="Unpaid Balance" Collection="lixi"/>
	</Term>
	<Term Name="Account Close Fee">
		<Definition>A fee that may be charged by a lender at the time of closing an account, in relation to the administrative costs of doing so.</Definition>
		<RelatedTerm Name="Payout Figure" Collection="lixi"/>
	</Term>
	<Term Name="Account Holder">
		<Definition>A Party that is the holder of and authorised to operate on an account. There may be one, or two or more joint account holders for any account.</Definition>
		<RelatedTerm Name="Operating Authority" Collection="lixi"/>
		<RelatedTerm Name="Deposit Account" Collection="lixi"/>
		<RelatedTerm Name="Signatory" Collection="lixi"/>
	</Term>
	<Term Name="Account ID">
		<Definition>The unique identifier for an account. For a loan account or a deposit account this is typically BSB and account number. For a credit card this is the credit card number.</Definition>
	</Term>
	<Term Name="Account Name">
		<Definition>The single-string identifier assigned by the lender to 'name' the account. This may be the name of the borrower (person or company); for joint borrowers, a concatenation of the borrowers name; for trust accounts, the name of the trust; for credit cards, the name on the card; or otherwise at the discretion of the lender.</Definition>
	</Term>
	<Term Name="Account Number">
		<Definition>An Identifier that is assigned by a lender to internally identify an account. The account number is associated with a BSB to uniquely identify the account at a national level.</Definition>
		<RelatedTerm Name="Account" Collection="lixi"/>
		<RelatedTerm Name="Account ID" Collection="lixi"/>
	</Term>
	<Term Name="Accrued Interest">
		<Definition>Interest which has calculated but which has not yet paid or charged.</Definition>
		<RelatedTerm Name="Daily Interest" Collection="lixi"/>
	</Term>
	<Term Name="Australian Company Number" Abbr="ACN">
		<Definition/>
	</Term>
	<Term Name="Add-back">
		<Definition>An add-back, or addback, is an expense listed on a profit and loss statement for a business that reduces taxable income and is added back to the net profit figure when assessing profitability or serviceability, to make the net figure as close as possible to the profit actually derived from the business itself, or that the owners could use to service the proposed loan. Add-backs may be non-recurring items or extraordinary such as unexpected bad debt; non-cash expenses such as depreciation or amortisation; optional payments such as dividends; certain interest or lease payments; or they may be unique to a particular owner that would not necessarily apply more generally to the ownership of the business.</Definition>
		<Reference URL="https://www.homeloanexperts.com.au/unusual-employment-loans/self-employed-home-loan/" Name="https://www.homeloanexperts.com.au/unusual-employment-loans/self-employed-home-loan/"/>
	</Term>
	<Term Name="Additional Borrower">
		<Definition>An applicant to be included as a borrower for an existing loan account.</Definition>
	</Term>
	<Term Name="Additional Guarantor">
		<Definition>A party proposed to be added as a guarantor for an existing loan account.</Definition>
	</Term>
	<Term Name="Additional Loan">
		<Definition>The creation of a new loan account with its own product, limit, term and other features, under an existing arrangement.</Definition>
	</Term>
	<Term Name="Additional Loan Repayment">
		<Definition>An extra or lump sum repayment made in addition to regular periodic repayments. Variable rate home loan products typically permit additional repayment, fixed rate home loan products may not or may place limits on any additional loan repayment amount. Depending on the loan features, additional repayments may reduce the principal or may be available to the borrower within a redraw facility.</Definition>
		<RelatedTerm Name="Redraw Facility" Collection="lixi"/>
		<RelatedTerm Name="Extra Repayment" Collection="lixi"/>
	</Term>
	<Term Name="Address">
		<Definition>Information that specifies a physical location or a postal destination.</Definition>
	</Term>
	<Term Name="Authorised Deposit-taking Institution" Abbr="ADI">
		<Definition/>
		<RelatedTerm Name="Covered Bond" Collection="lixi"/>
	</Term>
	<Term Name="Adjustable Rate Mortgage" Abbr="ARM">
		<Definition>A US-style mortgage loan that combines a medium term - often discounted and fixed - interest rate with subsequent periodic rate adjustments. The subsequent adjustments may be annually, but other adjustment periods, such as every two or three years, are possible. The total term of the loan does not differ from a standard mortgage; 15-year and 30-year terms are common. The periodic repayment amount changes as the interest rate changes. Lenders link the interest rate of an option ARM loan to a specified interest rate index such as the Cost of Funds Index (COFI). The interest rate is then determined by adding a margin to the index rate. Some ARMs feature interest rate caps, limitations on how much the interest rate can change. An option ARM may also feature a payment cap.</Definition>
		<Reference URL="http://homebuying.about.com/cs/mortgagearticles/a/mortgages_arm.htm" Name="Homebuying"/>
		<RelatedTerm Name="ARM" Collection="lixi"/>
	</Term>
	<Term Name="Administration Fee">
		<Definition>A fee such as a loan administration fee that is charged for maintaining and administering a service or facility.</Definition>
	</Term>
	<Term Name="Aged Care Unit">
		<Definition>An individual unit in a aged care facility.</Definition>
	</Term>    
	<Term Name="All-in-one Loan Account">
		<Definition>A loan product that combines a home loan with the features of a savings account, transaction account, chequing account, redraw facility and an offset account.</Definition>
	</Term>
	<Term Name="Allotment">
		<Definition>An area of land that has been subdivided into smaller portion of land from a larger one.</Definition>
		<RelatedTerm Name="Regular Shaped Allotment" Collection="lixi"/>
		<RelatedTerm Name="Corner Allotment" Collection="lixi"/>
	</Term>
	<Term Name="Alternative Income Verification">
		<Definition>A method of verifying income for low-doc applications where PAYG payslips are not available.</Definition>
	</Term>
	<Term Name="Amortisation">
		<Definition>To repay the principal of a loan over a period of time, usually by regular instalments, so that the account balance declines over the term of the loan. The account balance of a fully amortised loan will decline to zero, as distinct from a partially amortised or balloon repayment loan.</Definition>
		<RelatedTerm Name="Amortization" Collection="lixi"/>
	</Term>
	<Term Name="Amortisation period">
		<Definition>The period of time used for the calculation of loan repayments.</Definition>
		<RelatedTerm Name="Loan Term" Collection="lixi"/>
		<RelatedTerm Name="Balloon Repayment Loan" Collection="lixi"/>
	</Term>
	<Term Name="Amortization">
		<PreferredTerm Name="" Collection="lixi"/>
	</Term>
	<Term Name="Annual Fee">
		<Definition>A fee such as a loan administration fee that is charged yearly.</Definition>
	</Term>
	<Term Name="Annual Interest Rate">
		<Definition>The interest rate of a loan calculated over one year.</Definition>
	</Term>
	<Term Name="Australian and New Zealand Land Information Council" Abbr="ANZLIC">
		<Definition>Develops standards for spatial information and facilitates easy and cost effective access to the wealth of spatial data and services provided by a wide range of organisations in the public and private sectors.</Definition>
		<Reference URL="http://www.anzlic.org.au/" Name="ANZLIC"/>
	</Term>
  <Term Name="Australian and New Zealand Standard Industrial Classification" Abbr="ANZSIC">
		<Definition>The Australian and New Zealand Standard Industrial Classification (ANZSIC) is a standardised set of industrial classifications for use in the collection, compilation, and publication of statistics. It was jointly developed by the Australian Bureau of Statistics and Statistics New Zealand in order to make it easier to compare industry statistics between the two countries and with the rest of the world.</Definition>
	</Term>
	<Term Name="All present and after-acquired property" Abbr="APAAP">
		<Definition>A replacement concept for fixed and floating charge, where after-acquired means personal or real property acquired after an agreement that the property secures a debt. Thus, the new property also becomes security for the debt.</Definition>
	</Term>
	<Term Name="Australian Payments Clearing Association" Abbr="APCA">
		<Definition/>
	</Term>
	<Term Name="Applicant">
		<Definition>A person or company applying for a loan.</Definition>
		<RelatedTerm Name="borrower" Collection="lixi"/>
		<RelatedTerm Name="Additional Borrower" Collection="lixi"/>
		<RelatedTerm Name="Genuine Savings" Collection="lixi"/>
		<RelatedTerm Name="Borrower" Collection="lixi"/>
	</Term>
	<Term Name="Application">
		<Definition>The forms, processes and information used to apply for a loan, including relevant information in relation to the assessment such as details of the requested loan product(s), the prospective borrower(s), their financial position, and the proposed security.</Definition>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
		<RelatedTerm Name="Total Loan Amount" Collection="lixi"/>
		<RelatedTerm Name="Application Reference Number" Collection="lixi"/>
	</Term>
	<Term Name="Application Fee">
		<Definition>A fee that may be charged by a lender at the time of lodging a loan application.</Definition>
		<RelatedTerm Name="Fee Payment Method" Collection="lixi"/>
	</Term>
	<Term Name="Application Reference Number">
		<Definition>An identifier used to uniquely identify an application within a specific context, such as within a mortgage broker system or at a lender.</Definition>
	</Term>
	<Term Name="Application Status">
		<Definition>The status of an application within a lender workflow. Statuses may include application received, conditional approval, unconditional approval, settled etc. Application status is different from a processing event such as 'valuation received', which may occur at any status.</Definition>
		<RelatedTerm Name="Backchannel Message" Collection="lixi"/>
	</Term>
	<Term Name="Appraisal">
		<Definition>Valuation.</Definition>
	</Term>
	<Term Name="Appreciation">
		<Definition>The increase in value of an asset such as property over time, as compared to the original purchase price.</Definition>
	</Term>
	<Term Name="Approval in Principle">
		<Definition>Pre-approval.</Definition>
	</Term>
	<Term Name="Approved Limit">
		<Definition>The available limit approved by the lender at specified point in time, such as at settlement or following final construction payment.</Definition>
		<RelatedTerm Name="Principal Increase" Collection="lixi"/>
		<RelatedTerm Name="Limit Decrease" Collection="lixi"/>
		<RelatedTerm Name="Limit Increase" Collection="lixi"/>
		<RelatedTerm Name="Overdraft" Collection="lixi"/>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
	</Term>
	<Term Name="Approved Subject To" Abbr="AST">
		<PreferredTerm Name="" Collection="lixi"/>
	</Term>
	<Term Name="Australian Prudential Regulatory Authority" Abbr="APRA">
		<Definition/>
	</Term>
	<Term Name="Australian Registered Body Number" Abbr="ARBN">
		<Definition>A unique national registration number for registrable bodies not registered under the Corporations Act.</Definition>
		<Reference URL="http://www.asic.gov.au/asic/asic.nsf/byheadline/Registering+a+business+name http://www.afr.com/asic/glossary/" Name="ASIC Fin Review"/>
	</Term>
	<Term Name="Adjustable Rate Mortgage" Abbr="ARM">
		<Definition/>
		<RelatedTerm Name="Adjustable Rate Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Arm's Length Transaction">
		<Definition>A transaction there is no family or financial relationship between the transacting parties.</Definition>
		<RelatedTerm Name="Stamp Duty on Property" Collection="lixi"/>
	</Term>
	<Term Name="Arrears">
		<Definition>Loan repayments that are overdue. A number of metrics may be used to quantify the arrears, such as the dollar amount of missed repayments, the number of missed repayments, and whether the scheduled balance is greater or less than the current balance.</Definition>
		<RelatedTerm Name="In Arrears" Collection="lixi"/>
		<RelatedTerm Name="Default" Collection="lixi"/>
	</Term>
	<Term Name="Australian Registered Scheme Number" Abbr="ARSN">
		<Definition>A unique number issued to Managed Investment Schemes.</Definition>
		<Reference URL="http://www.afr.com/asic/glossary/" Name="Fin Review"/>
	</Term>
	<Term Name="Australian Securities and Investments Commission" Abbr="ASIC">
		<Definition/>
		<Reference URL="http://www.asic.gov.au/" Name="ASIC"/>
	</Term>
	<Term Name="Assessment Metric">
		<Definition>One of a number of calculated figures based on information in a loan application. Metrics include NDI, DSR, NSR etc, any of which may be utilised as part of lending policy to indicate the suitability of a loan application.</Definition>
		<RelatedTerm Name="Uncommitted Income" Collection="lixi"/>
		<RelatedTerm Name="Dynamic Risk Score" Collection="lixi"/>
		<RelatedTerm Name="Uncommitted Monthly Income" Collection="lixi"/>
		<RelatedTerm Name="Net Debt to Income Ratio" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Coverage Ratio" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Ratio" Collection="lixi"/>
		<RelatedTerm Name="Loan to Value Ratio" Collection="lixi"/>
		<RelatedTerm Name="Net Surplus Ratio" Collection="lixi"/>
		<RelatedTerm Name="Cash Available for Debt Servicing" Collection="lixi"/>
		<RelatedTerm Name="Dynamic Delinquency Score" Collection="lixi"/>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
	</Term>
	<Term Name="Assessment Rate">
		<Definition>The notional interest rate used to calculate a loan repayment amount during serviceability assessment. The assessment rate is usually several percentage points higher than the interest rate being offered, to take into account the possibility that interest rates may rise during the term of the loan.</Definition>
	</Term>
	<Term Name="Asset">
		<Definition>Money, property or goods of value, such as real estate, bank accounts, shares, motor vehicles etc.</Definition>
		<RelatedTerm Name="Income" Collection="lixi"/>
		<RelatedTerm Name="Asset Lending" Collection="lixi"/>
	</Term>
	<Term Name="Asset Lending">
		<Definition>Lending policy where the assessment is based on accepting the value of an asset as security, rather than by measuring serviceability.</Definition>
	</Term>
	<Term Name="Associative Object">
		<Definition>In a data object model, an associative object is used to link two other objects while providing data about the linkage, e.g. to link between an asset and one or more owners, including the percentage owned.</Definition>
	</Term>
	<Term Name="Approved Subject To" Abbr="AST">
		<Definition/>
		<RelatedTerm Name="Approved Subject To" Collection="lixi"/>
	</Term>
	<Term Name="Atomic Identifier">
		<Definition>An identifier consisting of a single data field.</Definition>
	</Term>
	<Term Name="Attorney">
		<Definition>An authorised representative that is appointed by means of a Power of Attorney to act for another, called the Principal, in business and/or legal matters.</Definition>
		<Reference URL="" Name=""/>
		<RelatedTerm Name="Attorney" Collection="lixi"/>
	</Term>
	<Term Name="Australian Transaction Reports and Analysis Centre" Abbr="AUSTRAC">
		<Definition>The government agency that monitors financial transactions in relation to illegal activity, and has regulatory responsibility to administers customer identification standards such as the 100 points identity check.</Definition>
		<Reference URL="http://www.austrac.gov.au/" Name="AUSTRAC"/>
	</Term>
	<Term Name="Australian Age Pensioners Savings Account">
		<Definition>Proposed savings account scheme to allow recipients of the age and service-related pensions to establish an account with the Government (or its agent) with some or all of the proceeds of the sale of their principal residence.</Definition>
		<Reference URL="http://www.pc.gov.au/inquiries/completed/aged-care/report" Name="Report"/>
	</Term>
	<Term Name="Australian Aged Care Home Credit Scheme">
		<Definition>Proposed Government-backed Australian Aged Care Home Credit scheme to assist older Australians to make a co-contribution to the costs of their aged care and support. Under the scheme, eligible individuals would receive a Government-backed line of credit secured against their principal residence, or their share of that residence.</Definition>
		<Reference URL="http://www.pc.gov.au/inquiries/completed/aged-care/report" Name="Report"/>
	</Term>
	<Term Name="Auto Consol">
		<Definition>An Auto Consol is a single title that includes multiple lots. When the same owners own consecutive lots (titles) on one or more plans, all lots are consolidated into one title.</Definition>
	</Term>
	<Term Name="Automated Mortgage Processing">
		<Definition>A process of assessing and approving a mortgage loan without human intervention. This relies upon but is not the same as straight through processing.</Definition>
		<RelatedTerm Name="Straight Through Processing" Collection="lixi"/>
	</Term>
	<Term Name="Available Balance">
		<Definition>Available Funds.</Definition>
	</Term>
	<Term Name="Available Funds">
		<Definition>The amount of money available from a facility. For a credit facility this is generally the difference between the credit limit and the account balance. For an account with redraw, the available funds is generally the amount available for redraw.</Definition>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="Available Balance" Collection="lixi"/>
	</Term>
	<Term Name="Available Limit">
		<Definition>For a revolving credit facility, the credit limit. For a term loan, the calculated account balance as though all available funds such as redraw had been withdrawn.</Definition>
		<RelatedTerm Name="Approved Limit" Collection="lixi"/>
		<RelatedTerm Name="Scheduled Balance" Collection="lixi"/>
		<RelatedTerm Name="Settled Amount" Collection="lixi"/>
	</Term>
	<Term Name="Average Annual Percentage Rate" Abbr="AAPR">
		<Definition>The calculated effective interest rate of a loan as if there were no fees and charges, used to compare between similar loan products with different interest rates and fees. The calculation takes into account the actual loan amount and loan term as well as all the known and calculable fees and charges associated with the loan.</Definition>
		<RelatedTerm Name="Comparison Rate" Collection="lixi"/>
		<RelatedTerm Name="AAPR" Collection="lixi"/>
	</Term>
	<Term Name="Average Daily Balance">
		<Definition>For the calculation of trailing commission, the average of the daily loan balances for the period (usually one month).</Definition>
	</Term>
	<Term Name="Automated Valuation Method" Abbr="AVM">
		<Definition/>
		<RelatedTerm Name="Confidence Rating" Collection="lixi"/>
		<RelatedTerm Name="Forecast Standard Deviation" Collection="lixi"/>
	</Term>
    <Term Name="Backchannel">
        <Definition>A term used to describe the use of LIXI messages in a bi-directional manner or for additional updates to an initial application message. Status updates and event notifications (including errors or warnings) are typically described as backchannel messages and provide feedback to the brokers and aggregators about how a credit application is progressing. Submission of additional information (for example supporting documents) is also frequently described as a backchannel message.</Definition>
    </Term>
	<Term Name="Backchannel Message">
		<Definition>In a LIXI message sequence, a backchannel message is a status message in response to an application.</Definition>
	</Term>
	<Term Name="Bad Debt">
		<Definition>A debt that is considered not collectible by the creditor and is therefore worthless or near-worthless.</Definition>
		<RelatedTerm Name="Write Off" Collection="lixi"/>
	</Term>
	<Term Name="Balloon Repayment">
		<Definition>The final repayment of a balloon loan, so called because of its large size in comparison to the regular or periodic repayments.</Definition>
		<RelatedTerm Name="Balloon Repayment Loan" Collection="lixi"/>
	</Term>
	<Term Name="Balloon Repayment Loan">
		<Definition>A loan where the amortisation period is longer than the maturity date, so the loan does not fully amortise over the loan term. The final repayment or "balloon" is large in comparison to the regular repayments.</Definition>
		<RelatedTerm Name="Amortisation" Collection="lixi"/>
		<RelatedTerm Name="Balloon Repayment" Collection="lixi"/>
	</Term>
	<Term Name="Bank">
		<Definition>A corporation authorised by law to carry on the general business of banking in Australia that is authorised under the Banking Act 1959 to use the word "bank" or a similar expression in its name.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Bank Bill Swap Rate" Abbr="BBSP">
		<Definition>The floating reference rate for Australian bank bills of a given term on any given day. The reference rates used are supplied at a set time each day by a panel of 10 banks. The rates supplied are averaged (after excluding high and low quotes) and are published on AAP Reuters. These rates are known as BBSW or BBSY bid. BBSW is an acronym for Bank Bill Swap Rate. BBSW is a mid-rate reference, BBSY bid is a bid rate reference and is usually 5 basis points higher than BBSW. The floating rate reference for MRF is usually BBSY bid as that is the rate used as a base rate for debt financing.</Definition>
		<RelatedTerm Name="BBSP" Collection="lixi"/>
	</Term>
	<Term Name="Bank Guarantee">
		<Definition>A promise made by a bank on behalf of a client to pay the clients debts if they are unable to.</Definition>
	</Term>
	<Term Name="Banker's Lien">
		<Definition>A right of a Bank to retain a customer's securities until a liability to the Bank is discharged.</Definition>
	</Term>
	<Term Name="Banking and Financial Services Ombudsman" Abbr="BFSO">
		<Definition>Banking and Financial Services Ombudsman Ltd (ABN 48 050 070 034).</Definition>
		<Reference URL="" Name=""/>
		<RelatedTerm Name="BFSO" Collection="lixi"/>
	</Term>
	<Term Name="Banking Service">
		<Definition>Any financial service or product provided by a bank to a customer whether supplied directly or through an intermediary, other than a financial service or product provided by another party and distributed by the bank.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
		<RelatedTerm Name="Standard Banking Fees and Charges" Collection="lixi"/>
	</Term>
	<Term Name="Bankruptcy">
		<Definition>A legal financial state that an individual is in when unable to meet their debts. A debtor may be declared bankrupt by the Federal Court at either the debtor's or the creditor's instigation, and the debtor's estate will be placed in the hands of an official receiver who will distribute the estate in accordance to the provisions of the Bankruptcy Act.</Definition>
	</Term>
	<Term Name="Base Stage">
		<Definition>Slab Stage.</Definition>
	</Term>
	<Term Name="Basic Home Loan">
		<Definition>A type of home loan with less flexibility and fewer features than a standard loan, and generally offered with a lower interest rate.</Definition>
		<RelatedTerm Name="Basic Rate" Collection="lixi"/>
		<RelatedTerm Name="No Frills Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Basic Living Expenses">
		<Definition>Basic household or living expenses include electricity, gas, telephone, rates and home and contents insurance; transport expenses including public transit, petrol, maintenance, registration and insurance for the primary car(s); most food; children's clothing and footwear; general dental, optical and pharmaceuticals; and government pre-year 1, primary and secondary education including school sports; and pet and pet supplies and maintenance.</Definition>
		<RelatedTerm Name="Living Expenses" Collection="lixi"/>
	</Term>
	<Term Name="Basic Rate">
		<Definition>The interest rate for a basic home loan.</Definition>
	</Term>
	<Term Name="Bank Bill Swap Rate" Abbr="BBSP">
		<Definition/>
		<RelatedTerm Name="Bank Bill Swap Rate" Collection="lixi"/>
	</Term>
  <Term Name="Beneficial Owner">
    <Definition>A beneficial owner is a natural person who ultimately owns or controls the entity. 'Ownership' means owning 25 per cent or more of the entity. 'Control' means control exerted by means of trusts, agreements, arrangements, understandings or practices and control based on legal or equitable rights, and through making decisions about financial and operating policies.</Definition>
  </Term>
	<Term Name="Beneficiary of a guarantee">
		<Definition>A party to a guarantee and who has the benefit of the guarantee.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/s5.html" Name="Austlii"/>
	</Term>
	<Term Name="Banking and Financial Services Ombudsman" Abbr="BFSO">
		<Definition/>
		<RelatedTerm Name="Banking and Financial Services Ombudsman" Collection="lixi"/>
		<RelatedTerm Name="Banking and Financial Services Ombudsman" Collection="lixi"/>
	</Term>
	<Term Name="BIC">
		<Definition>BIC may refer to: Business Industry Classification Code or Business Industry Code.</Definition>
	</Term>
	<Term Name="Bill of Exchange">
		<Definition>A negotiable instrument regulated by the Bills of Exchange Act 1909 (Cth).</Definition>
	</Term>
	<Term Name="Body Corporate">
		<Definition>An administrative body of the owners of units or apartments within a strata building. A self-elected committee handles administration and management of the building and common areas.</Definition>
		<RelatedTerm Name="Owners Corporation" Collection="lixi"/>
	</Term>
	<Term Name="Body Corporate Levy">
		<Definition>The fee paid to a body corporate by the unit owners to cover the costs relating to the common property.</Definition>
	</Term>
	<Term Name="Borrower">
		<Definition>A person or entity that is applying for or has taken out a loan and is or will be responsible for the repayments.</Definition>
		<RelatedTerm Name="Applicant" Collection="lixi"/>
		<RelatedTerm Name="Applicant" Collection="lixi"/>
		<RelatedTerm Name="Mortgagor" Collection="lixi"/>
		<RelatedTerm Name="Loan Party" Collection="lixi"/>
		<RelatedTerm Name="Lender's Mortgage Insurance" Collection="lixi"/>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
	</Term>
	<Term Name="Borrowing Capacity">
		<Definition>The calculated total amount that may be theoretically borrowed by an applicant considering their servicing capability, and considering the general lending policies of the lender and loan product.</Definition>
		<RelatedTerm Name="Max Loan" Collection="lixi"/>
		<RelatedTerm Name="Expense Type" Collection="lixi"/>
	</Term>
	<Term Name="Branch Network">
		<Definition>A financial institution's branch network is the collection of physical locations at which the institution offers products and/or services directly, in person, to their customers.</Definition>
	</Term>
	<Term Name="Break Fee">
		<Definition>A credit fee or charge that relates only to the early repayment of an amount provided under a credit contract for a fixed rate loan; to the portion of the loan that is fixed; and to the part of the credit provider's loss, arising from the early repayment.</Definition>
		<Reference URL="http://www.comlaw.gov.au/Details/F2011C00875/Html/Text" Name="National Consumer Credit Protection Regulations section 79A"/>
		<RelatedTerm Name="Early Repayment Costs" Collection="lixi"/>
	</Term>
	<Term Name="Bridging Finance">
		<Definition>Bridging Loan.</Definition>
	</Term>
	<Term Name="Bridging Loan">
		<Definition>A short term loan designed to allow a borrower to finance the purchase of a new property before selling an existing property. An assessment for a bridging loan involves calculation of peak debt and end debt.</Definition>
		<RelatedTerm Name="Go Between Loan" Collection="lixi"/>
		<RelatedTerm Name="End Debt" Collection="lixi"/>
		<RelatedTerm Name="Relocation Loan" Collection="lixi"/>
		<RelatedTerm Name="Peak Debt" Collection="lixi"/>
		<RelatedTerm Name="Bridging Finance" Collection="lixi"/>
	</Term>
	<Term Name="Brokerage Fee">
		<Definition>A fee charged by an agent, or agent's company to facilitate transactions between the transacting parties. The brokerage fee is charged for services such as negotiations, sales, purchases, delivery or advice on the transaction. In the case of a mortgage loan application, the brokerage fee would be paid by the borrower. An equivalent fee paid by the lender is referred to as a commission.</Definition>
		<Reference URL="http://www.investopedia.com/terms/b/brokerage-fee.asp" Name="Investopedia"/>
	</Term>
	<Term Name="Bank State Branch" Abbr="BSB">
		<Definition>A BSB (Bank State Branch) Number is a unique number that identifies both the Financial Institution and the point of representation of a particular account in Australia. It therefore uniquely identifies a particular branch of a bank. The combination of the BSB and the Account Number of a particular account at that branch is often used to uniquely identify the account within Australia. The BSB Number contains exactly six numerals, the first two or three being identifiers of the financial institution. The BSB may be formatted with a space or a hyphen, but only the numerals have significance. APCA is the issuer and custodian of BSB Numbers in Australia and assigns a two or three digit code to a financial institution and sets guidelines for those financial institutions to issue the remainder of the six digits.</Definition>
		<Reference URL="http://www.bsbnumbers.com/" Name="BSB numbers"/>
		<RelatedTerm Name="Account Number" Collection="lixi"/>
		<RelatedTerm Name="Account ID" Collection="lixi"/>
	</Term>
	<Term Name="Build Price Contract">
		<Definition></Definition>
		<RelatedTerm Name="cost plus building contract" Collection="lixi"/>
	</Term>
	<Term Name="Builders Warranty Insurance">
		<Definition>Builders warranty insurance provides a set period of cover for loss caused by defective or incomplete work in the event of the death, disappearance or insolvency of the building contractor. Mandatory in some states. Also known as home warranty insurance, domestic building insurance, building indemnity insurance, etc.</Definition>
		<Reference URL="http://www.fairtrading.nsw.gov.au/Tradespeople/Home_warranty_insurance.html http://www.masterbuilders.asn.au/insurance/home-warranty-insurance" Name="NSW Dept of Fair Trading Master Builders Assn"/>
	</Term>
	<Term Name="Building Construction Contract">
		<Definition>A legal document, usually in standard form, setting out the roles, rights and responsibilities of the consumer and the builder in relation to a building construction, and the general terms and conditions governing the parties' relationship. Two types of contract are typical, lump sum (or fixed-price) and cost plus.</Definition>
		<Reference URL="http://www.mbawa.com/custom/mba_directory.asp?SID=38" Name="MBAWA"/>
		<RelatedTerm Name="Cost Plus Building Contract" Collection="lixi"/>
		<RelatedTerm Name="Lump Sum Building Contract" Collection="lixi"/>
	</Term>
	<Term Name="Building Inspection">
		<Definition>Is an inspection carried out prior to purchasing a property, generally by a qualified builder, to check for any defects or problems in the building. A contract of sale could be made subject to a building inspection, allowing the purchaser to pull out of the contract if problems are found, or negotiate a new price.</Definition>
	</Term>
	<Term Name="Building Insurance">
		<Definition>Insurance to cover the building itself - not the contents. All lenders require this before they will extend credit to purchase a dwelling.</Definition>
	</Term>
	<Term Name="Building Replacement Cost">
		<Definition>Within a property valuation, an assessment for building insurance purposes of the current replacement cost for the building, including allowances for:</Definition>
		<Reference URL="" Name=""/>
	</Term>
	<Term Name="Business Channel">
		<Definition>The channel that the loan application is being submitted to. Typically, the business channel is the lender. For an application being submitted to a mortgage manager, the mortgage manager is the business channel. For an application being submitted by a mortgage manager to a funder, the funder is the business channel.</Definition>
	</Term>
	<Term Name="Business Day">
		<Definition>A day that is not a Saturday, a Sunday or a public holiday as gazetted under the relevant Government legislation.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
  <Term Name="Business Industry Classification Code">
		<Definition>A Business Industry Classification (BIC) code is a way of classifying a business entity by the main activity undertaken (the main service or product the entity provides). The Business Industry Classification system was developed by the The Accident Compensation Corporation, Inland Revenue New Zealand and Statistics New Zealand.</Definition>
	</Term>
  <Term Name="Business Industry Code">
		<Definition>A Business Industry Code (BIC) is a way of classifying a business entity by the main activity undertaken (the main service or product the entity provides). The Business Industry Code set (maintained by the Australian Tax Office) is derived from the ANZSIC codes, but have been simplified for tax return reporting purposes.</Definition>
	</Term>
	<Term Name="Business Loan">
		<Definition>A loan provided to a company for business purposes. Business loans are not regulated by the UCCC or NCCP</Definition>
		<RelatedTerm Name="Commercial Loan" Collection="lixi"/>
	</Term>
	<Term Name="Business Name">
		<Definition>A registered business name is a trading name under which a person or company carries on business or trades. The owners of a registered business name are referred to as "proprietors". Registered business names are issued by the State or Territory in which the business or trade is carried out. Each registered business name has an individual number but the format and length vary according to the State of issue. Note that the word "company" in a name does not necessarily mean that the organisation is registered as a company under the Corporations Act 2001.</Definition>
		<Reference URL="http://www.asic.gov.au/asic/asic.nsf/byheadline/What+is+a+business+name?openDocument" Name="ASIC"/>
		<RelatedTerm Name="Company Name" Collection="lixi"/>
		<RelatedTerm Name="Proprietor" Collection="lixi"/>
		<RelatedTerm Name="Trading Name" Collection="lixi"/>
	</Term>
	<Term Name="Buyer">
		<Definition>Purchaser.</Definition>
	</Term>
	<Term Name="Buyer's Agent">
		<Definition>Is a company or person who acts on behalf of a buyer to find and negotiate on properties the buyer wishes to purchase.</Definition>
	</Term>
	<Term Name="Call Centre">
		<Definition>The department of an entity through which customers can interact with that entity's representatives over the phone with respect to products or services offered by that entity.</Definition>
	</Term>
	<Term Name="Cash Available for Debt Servicing" Abbr="CADS">
		<Definition>Used in calculation of DSCR.</Definition>
	</Term>
	<Term Name="Cash Available for Debt Servicing" Abbr="CAFDS">
		<Definition/>
		<RelatedTerm Name="Cash Available for Debt Servicing" Collection="lixi"/>
	</Term>
	<Term Name="Credit Approval Level" Abbr="CAL">
		<Definition/>
		<RelatedTerm Name="Credit Application Language" Collection="lixi"/>
		<RelatedTerm Name="Credit Approval Level" Collection="lixi"/>
	</Term>
	<Term Name="Capital Gain">
		<Definition>The financial gain or profit obtained when something is sold for more than it was bought for, the amount by which proceeds from the sale of property exceeds the original purchase price.</Definition>
		<RelatedTerm Name="Equity Finance Mortgage Loan" Collection="lixi"/>
		<RelatedTerm Name="Investment Property" Collection="lixi"/>
		<RelatedTerm Name="Capital Gains Tax" Collection="lixi"/>
	</Term>
	<Term Name="Capital Gains Tax">
		<Definition>A federal tax on a Capital Gain. There are complex rules that specify what capital gains are taxable, and at what rate.</Definition>
	</Term>
	<Term Name="Capital Value">
		<Definition>For real property, the combined value of land plus improvements such as buildings and fences but not including chattels. For the calculation of council rates, the rateable value of property is generally the capital value.</Definition>
	</Term>
	<Term Name="Capitalised Interest">
		<Definition>Interest that is accrued during all or part of the loan term but not paid, and hence is added onto the loan principal.</Definition>
		<RelatedTerm Name="Interest Capitalisation" Collection="lixi"/>
		<RelatedTerm Name="Negative Amortisation" Collection="lixi"/>
		<RelatedTerm Name="Repayment Type" Collection="lixi"/>
	</Term>
	<Term Name="Capped Liability Scheme">
		<Definition>The Capped Liability Scheme, also called a Limited Liability Scheme, refers to a legal provision included in the valuation report that protects the valuer by capping the amount of damages payable by the practice in the event of a claim filed against them.</Definition>
	</Term>
	<Term Name="Capped Rate">
		<Definition>A capped rate is a variable interest rate with a ceiling on how much the variable rate can rise to. The variable rate can rise and fall, but cannot rise past the rate cap. The lender specifies the advertised rate cap in their product rate definition. The advertised capped rate may change at any time, but the rate cap of a settled (existing) loan account does not change for the duration of the cap. A loan offer document will specify the rate cap for the loan.</Definition>
		<RelatedTerm Name="Interest Rate Type" Collection="lixi"/>
		<RelatedTerm Name="Capped Rate Loan" Collection="lixi"/>
	</Term>
	<Term Name="Capped Rate Loan">
		<Definition>A type of variable rate loan where the interest rate is guaranteed not to rise above a certain rate (the capped rate) for a set period of time. The rate may still reduce in the event of an interest rate drop.</Definition>
	</Term>
	<Term Name="Carer Payment">
		<Definition>An income support payment that provides financial assistance to Australian residents that provide constant care, in a private home, to someone with a severe disability, illness, or is an adult who is frail aged, subject to other eligibility criteria.</Definition>
	</Term>
	<Term Name="Cash Advance">
		<Definition>An immediate advancement of money against a credit facility.</Definition>
	</Term>
	<Term Name="Cash Available for Debt Servicing" Abbr="CAFDS">
		<Definition>An available-income assessment metric used in calculation of DSCR, calculated from annual income and expense figures as (Annual Net Income + Amortization/Depreciation + Interest Expense + other non-cash and discretionary items (such as non-contractual management bonuses)).</Definition>
		<RelatedTerm Name="CAFDS" Collection="lixi"/>
		<RelatedTerm Name="CADS" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Coverage Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Cash Rate">
		<Definition>The interest rate set by the Reserve Bank of Australia for overnight loans in the money market, which has a significant influence on home loan standard variable rates.</Definition>
		<Reference URL="http://www.rba.gov.au/monetary-policy/about.html" Name="RBA"/>
	</Term>
	<Term Name="Caveat">
		<Definition>In the context of a Land Title, a notice of warning given to the Titles Office, claiming entitlement to an interest in certain land. The caveat is registered and remains on the Title as a warning to anyone who contemplates dealing with the property. The person entering the caveat, the caveator, will receive notice of any action being taken. The caveat may have the effect of an injunction and require a Land Registry to refrain from registering specified transactions.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Mere Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Equitable Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Constraint" Collection="lixi"/>
	</Term>
	<Term Name="Code Compliance Monitoring Committee" Abbr="CCMC">
		<Definition>In the context of dispute resolution involving a bank.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Certificate of Currency">
		<Definition>A certificate issued by an insurance company showing that a building or property is insured.</Definition>
	</Term>
	<Term Name="Certificate of Title" Abbr="CT">
		<Definition>A certified rendering of information contained in a Land Title issued and delivered by the land titles office, which describes the title reference to a particular parcel of land, the land dimensions, the registered owner of that land and any encumbrances registered against the title, and used to indicate, by possession thereof, the control of the right to deal.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Torrens System" Collection="lixi"/>
		<RelatedTerm Name="Title Deed" Collection="lixi"/>
		<RelatedTerm Name="CT" Collection="lixi"/>
	</Term>
	<Term Name="Charge over property">
		<Definition>A term used to describe any right established over a borrower's property to secure a debt or performance of an obligation.</Definition>
	</Term>
	<Term Name="Chattel">
		<Definition>Personal property that is not fixed to land or its improvements (e.g. carpets, curtains, light fittings, TV aerial, dishwasher)</Definition>
		<RelatedTerm Name="Capital Value" Collection="lixi"/>
	</Term>
	<Term Name="Chattel Mortgage" Abbr="CM">
		<Definition>A commercial finance loan secured by an asset other than real estate (a chattel), where the customer (the borrower) owns the asset.</Definition>
		<RelatedTerm Name="CM" Collection="lixi"/>
	</Term>
	<Term Name="Check Cost">
		<Definition>The check cost is an estimate of the cost of constructing a property based on cost indicators for that style of construction. The check cost is compared with the cost of construction declared by the builder to identify if the tender is in line with market costs.</Definition>
	</Term>
<Term Name="Chequing Account">
		<Definition>In other countries, a checking account is an account used for day-to-day transactions. In Australia, this type of account is known as a transaction account or everyday account.</Definition>
	</Term>
	<Term Name="CHP">
		<Definition>Abbreviation: Commercial Hire Purchase.</Definition>
		<RelatedTerm Name="Commercial Hire Purchase" Collection="lixi"/>
	</Term>
	<Term Name="Circulating Assets">
		<Definition>The property of a company as it exists from time to time, including such assets as inventory and work in progress.</Definition>
		<RelatedTerm Name="Floating Charge" Collection="lixi"/>
	</Term>
	<Term Name="Customer Identity Verification" Abbr="CIV">
		<Definition/>
		<RelatedTerm Name="Customer Identity Verification" Collection="lixi"/>
	</Term>
	<Term Name="Commercial Loan">
		<Definition/>
		<RelatedTerm Name="Commercial Loan" Collection="lixi"/>
	</Term>
	<Term Name="Clawback">
		<Definition>To take back money such as all or part of an upfront commission that has been paid to an intermediary such as a mortgage broker. Examples include early close clawback and incorrect payment clawback.</Definition>
		<RelatedTerm Name="Incorrect Payment Clawback" Collection="lixi"/>
		<RelatedTerm Name="Early Close Clawback" Collection="lixi"/>
	</Term>
	<Term Name="Closing Balance">
		<Definition>The account balance as at the end date of a statement of account.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/sch1.html" Name="Austlii"/>
		<RelatedTerm Name="Statement of Account" Collection="lixi"/>
	</Term>
	<Term Name="Chattel Mortgage" Abbr="CM">
		<Definition/>
		<RelatedTerm Name="Chattel Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Comparative Market Analysis" Abbr="CMA">
		<Definition/>
		<RelatedTerm Name="Comparative Market Analysis" Collection="lixi"/>
	</Term>
	<Term Name="Cost of funds Index" Abbr="COFI">
		<Definition/>
		<RelatedTerm Name="Cost of funds Index" Collection="lixi"/>
	</Term>
  <Term Name="Cost of Goods Sold" Abbr="COGS">
    <Definition>Cost of goods sold (COGS) are the direct costs attributable to the production of the goods sold by a company.</Definition>
  </Term>
	<Term Name="Collateral">
		<Definition>Property pledged as security for a debt.</Definition>
	</Term>
	<Term Name="Collateral mortgage">
		<Definition>A collateral mortgage provides further property as security for the liability secured by the prime mortgage.</Definition>
	</Term>
	<Term Name="Commercial Asset Financing Facility">
		<Definition>A lease, rental, hire purchase, bill of sale, chattel mortgage facility or a related insurance premium funding facility provided to a company.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Commercial Asset Financing Guarantor">
		<Definition>A guarantor where the Guarantee is to be taken for a Facility that is a commercial asset financing facility and: (a) the guarantor is a director of the company, and: (i) the director has not given security to support the Guarantee; or (ii) where the director has previously given security, the director has been notified in writing that the previous security may extend to liabilities under the Guarantee; and (b) apart from guarantees and any security referred to in (a)(ii) given by directors of the company, only the asset financed secures the commercial asset financing facility.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Commercial Hire Purchase" Abbr="CHP">
		<Definition>A type of purchase and loan where the lender buys the required asset and the borrower effectively buys it on an instalment plan.</Definition>
		<Reference URL="http://www.carloans.com.au/commercial-hire-purchase/" Name="Carloans.com.au"/>
		<RelatedTerm Name="CHP" Collection="lixi"/>
	</Term>
	<Term Name="Commercial Loan" Abbr="CL">
		<Definition>Business Loan.</Definition>
		<RelatedTerm Name="CL" Collection="lixi"/>
	</Term>
	<Term Name="Commission">
		<Definition>A financial incentive payment or reward made to an agent or salesperson that directly results from sales (or orders) of a service or product.</Definition>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
		<RelatedTerm Name="Trailing Commission" Collection="lixi"/>
		<RelatedTerm Name="Brokerage Fee" Collection="lixi"/>
	</Term>
	<Term Name="Company">
		<Definition>An Organisation that is a commercial business that has undergone registration with the appropriate statutory regulator pursuant to relevant legislation. An Australian company is a body corporate registered in Australia under the Corporations Act 2001, with ASIC.</Definition>
		<Reference URL="http://www.asic.gov.au/asic/asic.nsf/byheadline/About+the+National+Names+Index?opendocument" Name="ASIC"/>
		<RelatedTerm Name="Company Name" Collection="lixi"/>
		<RelatedTerm Name="Applicant" Collection="lixi"/>
		<RelatedTerm Name="Loan Party" Collection="lixi"/>
	</Term>
	<Term Name="Company Home Loan">
		<Definition>An investment home loan where the borrower is a registered company and is also the owner or purchaser of the security property.</Definition>
	</Term>
	<Term Name="Company Name">
		<Definition>The name of a company as registered with ASIC. A company name will include one of the following legal elements: Proprietary Limited (Pty Ltd); Unlimited Proprietary (Pty); Limited (Ltd); No Liability (NL). If a company wishes to trade using a name other than its registered company name, it must register that trading name as a business name.</Definition>
	</Term>
	<Term Name="Company Title">
		<Definition>A type of title where the unit holders are shareholders in a private company.</Definition>
	</Term>
	<Term Name="Comparable Sale">
		<Definition>For a Valuation Report, a recent property sale where the characteristics are similar to the property being valued, and hence the sale price is comparable.</Definition>
		<RelatedTerm Name="Comparative Market Analysis" Collection="lixi"/>
		<RelatedTerm Name="Valuation" Collection="lixi"/>
	</Term>
	<Term Name="Comparative Market Analysis" Abbr="CMA">
		<Definition>A list of the comparable sales in the vicinity of a property in question.</Definition>
		<RelatedTerm Name="CMA" Collection="lixi"/>
	</Term>
	<Term Name="Comparison Rate">
		<Definition>A pre-calculated indicative interest rate for a loan product as if there were no fees and charges, based on a pre-determined loan amount and loan term, and calculable fees and charges. Used to help consumers compare similar loan products. All lenders are legally required to disclose this as a benchmark rate in their advertising of home loans.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/s146c.html" Name="Austlii"/>
		<RelatedTerm Name="AAPR" Collection="lixi"/>
		<RelatedTerm Name="Relevant Comparison Rate" Collection="lixi"/>
		<RelatedTerm Name="Comparison Rate Schedule" Collection="lixi"/>
		<RelatedTerm Name="Relevant Comparison Rate" Collection="lixi"/>
		<RelatedTerm Name="Average Annual Percentage Rate" Collection="lixi"/>
	</Term>
	<Term Name="Comparison Rate Schedule">
		<Definition>A schedule published by a lender showing the annual percentage rate and the respective comparison rate for the lender's loan products for specified amounts over specified loan terms.</Definition>
	</Term>
	<Term Name="Comprehensive Credit Reporting">
		<Definition>Reporting on both the negative and positive aspects of credit history, including credit repayment history. See also Negative Credit Reporting.</Definition>
		<RelatedTerm Name="Positive Credit Reporting" Collection="lixi"/>
	</Term>
	<Term Name="Conditional Approval">
		<Definition>An application status provided by the lender when the loan application has passed an initial assessment of requirements including serviceability and a credit report. The application will be "conditional" on the satisfaction of other factors such as the submission of supporting documentation, verification of income, property valuation, and LMI. In many cases a conditional approval will be valid only for a 3 month period.</Definition>
		<RelatedTerm Name="Application Status" Collection="lixi"/>
		<RelatedTerm Name="Unconditional Approval" Collection="lixi"/>
		<RelatedTerm Name="Approved Subject To" Collection="lixi"/>
	</Term>
	<Term Name="Confidence Rating">
		<Definition>A quantitative measure of confidence in an AVM assessment.</Definition>
	</Term>
	<Term Name="Confidence Score">
		<Definition>A component of Valuation, essentially a simplified interpretation of the FSD</Definition>
		<RelatedTerm Name="Forecast Standard Deviation" Collection="lixi"/>
	</Term>
	<Term Name="Conforming Loan">
		<Definition>A Loan that caters for borrowers who can meet the traditional income verification and credit history criteria which the mainstream lenders require, generally requiring PAYG employment and a clean credit history.</Definition>
		<RelatedTerm Name="Low Doc Loan" Collection="lixi"/>
		<RelatedTerm Name="Impaired Credit Loan" Collection="lixi"/>
		<RelatedTerm Name="Non-Conforming Loan" Collection="lixi"/>
	</Term>
	<Term Name="Consent to Easement">
		<Definition>Lender - as mortgagee - granting consent to the owner to grant a right of easement over the security property to a third party.</Definition>
	</Term>
	<Term Name="Consent to Lease">
		<Definition>Lender - as mortgagee - granting consent to the owner to grant a lease over the security property.</Definition>
	</Term>
	<Term Name="Consent to Subdivision">
		<Definition>Lender - as mortgagee - granting consent to the owner to sub-divide the security property.</Definition>
	</Term>
	<Term Name="Consolidation">
		<Definition></Definition>
		<RelatedTerm Name="Debt Consolidation" Collection="lixi"/>
		<RelatedTerm Name="Loan Account Consolidation" Collection="lixi"/>
	</Term>
	<Term Name="Constraint">
		<Definition>An arrangement, such as a Caveat or Writ, that may have the effect of prohibiting a Land Registry from taking specific action as regards the Torrens Title Register under its administration, including preventing registration of a registry instrument on a Land Title.</Definition>
		<RelatedTerm Name="Encumbrance" Collection="lixi"/>
		<RelatedTerm Name="Writ" Collection="lixi"/>
	</Term>
	<Term Name="Construction Loan">
		<Definition>A loan designed to finance the cost of construction (e.g. of a house), structured to enable funds to be drawn down in staged (progress payments).</Definition>
		<RelatedTerm Name="Drawdown" Collection="lixi"/>
	</Term>
	<Term Name="Construction Stage">
		<Definition>Any of many stages in the construction of a house or other building. Includes settlement (if the land is purchased under the contract), slab stage, frame stage, lock up, fixing stage, and practical completion.</Definition>
		<RelatedTerm Name="Progress Payment" Collection="lixi"/>
		<RelatedTerm Name="Fixing Stage" Collection="lixi"/>
		<RelatedTerm Name="Practical Completion" Collection="lixi"/>
		<RelatedTerm Name="Slab Stage" Collection="lixi"/>
		<RelatedTerm Name="Frame Stage" Collection="lixi"/>
		<RelatedTerm Name="Enclosed Stage" Collection="lixi"/>
	</Term>
	<Term Name="Consumer Credit Insurance">
		<Definition>Insurance that insures the capacity of the debtor to make repayments under the credit contract, including insurance against sickness of, injury to, or disability or death of, the debtor or against unemployment of the debtor, and also including life insurance (including insurance under a group policy) to cover any outstanding amount on the debtor's death. Types of consumer credit insurance include: loan protection insurance; mortgage protection insurance; credit card insurance; and personal loan insurance.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/sch1.html" Name="Austlii"/>
	</Term>
	<Term Name="Consumer Credit Product">
		<Definition>Any form of facility for the provision of credit (other than under a continuing credit contract) provided to debtors by a credit provider.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/s146c.html" Name="Austlii"/>
		<RelatedTerm Name="Credit Facility" Collection="lixi"/>
	</Term>
	<Term Name="Continuing Credit Contract">
		<Definition>A type of credit with a credit limit, that a borrower (creditor) can repeatedly draw upon (up to an agreed limit) in addition to making regular or irregular repayments. Examples include credit cards and lines of credit. In legal terms, a credit contract under which (a) multiple advances of credit are contemplated; and (b) the amount of available credit ordinarily increases as the amount of credit is reduced.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/sch1.html" Name="Austlii"/>
		<RelatedTerm Name="Credit Facility" Collection="lixi"/>
		<RelatedTerm Name="Revolving Credit Facility" Collection="lixi"/>
		<RelatedTerm Name="Nil Interest Visa Account" Collection="lixi"/>
		<RelatedTerm Name="Revolving Credit Limit" Collection="lixi"/>
	</Term>
	<Term Name="Contract">
		<Definition>An oral or written binding agreement between two or more parties.</Definition>
	</Term>
	<Term Name="Contract of Sale">
		<Definition>A legally binding written agreement between a vendor and a purchaser outlining the terms and conditions for the sale of a property. The contract will include the purchase price and any conditions such as subject to building inspection or subject to finance.</Definition>
		<RelatedTerm Name="Deposit Bond" Collection="lixi"/>
		<RelatedTerm Name="Deposit (downpayment)" Collection="lixi"/>
		<RelatedTerm Name="Purchase Agreement" Collection="lixi"/>
		<RelatedTerm Name="Contract Price" Collection="lixi"/>
	</Term>
	<Term Name="Contract Price">
		<Definition>The purchase price specified in a contract of sale.</Definition>
		<RelatedTerm Name="Security Value" Collection="lixi"/>
	</Term>
	<Term Name="Contribution Funds">
		<Definition>Money that the borrower must have available at the time of settlement in conjunction with a loan. This may consist of genuine savings, gifts, downpayment, FHOG, proceeds of sale, etc. See also Deposit.</Definition>
		<RelatedTerm Name="Own Funds" Collection="lixi"/>
		<RelatedTerm Name="Deposit" Collection="lixi"/>
	</Term>
	<Term Name="Conveyancer">
		<Definition>A person who undertakes the certification and signing of conveyancing related documents on behalf of a party to a transaction.</Definition>
	</Term>
	<Term Name="Conveyancing">
		<Definition>The legal process of transferring property ownership and title from the seller to the buyer, or the granting of an encumbrance such as a mortgage or a lien, generally undertaking by solicitors or conveyancers acting on behalf of each party.</Definition>
		<RelatedTerm Name="Conveyancing Costs" Collection="lixi"/>
	</Term>
	<Term Name="Conveyancing Costs">
		<Definition>The costs associated with conveyancing including legal fees, title transfer fees and stamp duty.</Definition>
	</Term>
	<Term Name="Cooling-off period">
		<Definition>Is a period of time given to the parties to legally withdraw from contract of sale. The length of time varies in each of the states and territories within Australia.</Definition>
	</Term>
	<Term Name="Corner Allotment">
		<Definition>An allotment, not being a battle-axe shaped allotment, having frontage to 2 or more intersecting roads.</Definition>
		<Reference URL="http://www.blacktown.nsw.gov.au/shadomx/apps/fms/fmsdownload.cfm?file_uuid=C1BD14A9-F26E-BD6F-C5EA-BCD769597035&amp;siteName=blacktown" Name="NSW"/>
	</Term>
	<Term Name="Credit Ombudsman Service Limited" Abbr="COSL">
		<Definition/>
		<RelatedTerm Name="Credit Ombudsman Service Limited" Collection="lixi"/>
	</Term>
	<Term Name="Cost of funds Index" Abbr="COFI">
		<Definition>A regional average of interest expenses incurred by financial institutions, which in turn is used as a base for calculating variable rate loans.</Definition>
		<RelatedTerm Name="Adjustable Rate Mortgage" Collection="lixi"/>
		<RelatedTerm Name="COFI" Collection="lixi"/>
	</Term>
	<Term Name="Cost Plus Building Contract">
		<Definition>A type of building contract that provides for the builder to pass on to the owner the actual costs of the project, such as labour and materials, as they are incurred in the course of the work. The builder applies a margin or a flat fee to these actual costs to cover off-site costs and profits.</Definition>
		<Reference URL="http://www.mbawa.com/custom/mba_directory.asp?SID=38" Name="MBAWA"/>
		<RelatedTerm Name="Build Price Contract" Collection="lixi"/>
		<RelatedTerm Name="Building Construction Contract" Collection="lixi"/>
	</Term>
	<Term Name="Cost to Income Ratio">
		<Definition>A standard efficiency measure used widely across the Australian banking industry, being (simplistically) the total expenses less interest divided by the total revenue less interest. A low cost to income ratio reflects short term profitability, but that may be risking long competitiveness and growth, particularly when growth may be offshore, or may require expensive technology investment.</Definition>
		<Reference URL="http://www.nabgroup.com/0,,34379,00.html" Name="NAB"/>
	</Term>
	<Term Name="Costing Valuation">
		<Definition>An evaluation of a construction contract to determine if the contract price is appropriate for the building being constructed, and to estimate the market value as if complete. Used for off the plan or TBE property.</Definition>
	</Term>
	<Term Name="Counterparty Risk">
		<Definition>The risk that a contracted organization does not pay out on a credit derivative, credit default swap, credit-related insurance contract, or similar trade or transaction when it is supposed to.</Definition>
	</Term>
	<Term Name="Covenant">
		<Definition>The terms and conditions governing the usage of a block of land or the buildings on it.</Definition>
	</Term>
	<Term Name="Cover Note">
		<Definition>Is a temporary property insurance cover used to protect a property prior to taking out a formal insurance policy. Cover notes are often taken out while a property is under contract, and a formal policy taken out when the property settles.</Definition>
	</Term>
	<Term Name="Covered Bond">
		<Definition>Covered bonds are bonds, notes or other debentures issued by an ADI and backed by both the ADI and by 15 special purpose vehicle a dedicated group of loans (commonly high-quality mortgage loans) known as a "cover pool" in a covered bond special purpose vehicle. Based on the high quality of the loans in the cover pool and the strength of the issuing banks, most covered bonds receive high credit ratings of double- or triple-A. In general, their maturities range from two to 10 years, although there is a recent trend toward long-term securities greater than 10 years. Covered bonds are similar in many ways to mortgage- and asset-backed securities with one major difference: the loans backing a covered bond remain on the balance sheet of the issuing bank. The bonds are therefore obligations of the issuing bank, and the bank retains control over the assets. If the issuing bank becomes insolvent, the assets in the cover pool are separated from the issuer's other assets solely for the benefit of the covered bondholders.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/bill/babb2011276/index.html" Name="Banking Amendment (Covered Bonds) Bill 2011"/>
	</Term>
	<Term Name="Credit Report" Abbr="CRAA">
		<Definition/>
		<RelatedTerm Name="Credit Report" Collection="lixi"/>
	</Term>
	<Term Name="Credit">
		<Definition>Borrowed money to be paid back under an arrangement with a Lender. Also, a sum of money paid into an account.</Definition>
	</Term>
	<Term Name="Credit Application Language" Abbr="CAL">
		<Definition>The XML schema-based format of LIXI Standards Packages that specifies the message structure and content for electronic lodgement of credit (commonly home loan) applications.</Definition>
	</Term>
	<Term Name="Credit Approval Level" Abbr="CAL">
		<Definition>A credit or lending approval authority level, similar to a delegated underwriting authority except expressed as a level instead of an amount. Within the level, a credit assessor such as a finance intermediary can approve or pre-approve a loan application without referring to the funder.</Definition>
		<RelatedTerm Name="CAL" Collection="lixi"/>
	</Term>
	<Term Name="Credit Assessment">
		<Definition>The process of assessing an application for credit (such as a home loan application) or an application for LMI including serviceability calculation, loan to value calculation, credit worthiness etc. A lender may request LMI as part of their credit assessment process. The process will follow the assessing company's Credit Policy.</Definition>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
		<RelatedTerm Name="Guarantor" Collection="lixi"/>
	</Term>
	<Term Name="Credit Assessor">
		<Definition>A person that assesses an application for credit on behalf of a lender or mortgage insurer.</Definition>
	</Term>
	<Term Name="Credit Card">
		<Definition>A revolving credit facility that allows a borrower to use a card to buy goods, services and obtain cash advances on credit, generally up to a pre-authorised credit limit.</Definition>
		<RelatedTerm Name="Credit Facility" Collection="lixi"/>
		<RelatedTerm Name="Continuing Credit Contract" Collection="lixi"/>
	</Term>
	<Term Name="Credit Check">
		<Definition>An inquiry made via a credit bureau to obtain a credit report.</Definition>
	</Term>
	<Term Name="Credit Facility">
		<Definition>A facility to make funds available through a loan, a revolving line of credit, a credit card or similar arrangement. See Consumer Credit Product and Continuing Credit Contract.</Definition>
		<RelatedTerm Name="Credit Limit" Collection="lixi"/>
		<RelatedTerm Name="Available Funds" Collection="lixi"/>
	</Term>
	<Term Name="Credit History">
		<Definition>Credit Report.</Definition>
		<RelatedTerm Name="Impaired Credit Loan" Collection="lixi"/>
	</Term>
	<Term Name="Credit Licence">
		<Definition>A licence to engage in credit activities in a given jurisdiction. For example, an Australian Credit Licence is required for certain entities to carry out credit activities within Australia.</Definition>
	</Term>
	<Term Name="Credit Limit">
		<Definition>For a credit facility, the maximum amount that can be drawn without penalty or additional authorisation.</Definition>
		<RelatedTerm Name="Credit Card" Collection="lixi"/>
		<RelatedTerm Name="Scheduled Balance" Collection="lixi"/>
		<RelatedTerm Name="Revolving Credit Limit" Collection="lixi"/>
		<RelatedTerm Name="Available Funds" Collection="lixi"/>
		<RelatedTerm Name="Available Limit" Collection="lixi"/>
		<RelatedTerm Name="Continuing Credit Contract" Collection="lixi"/>
	</Term>
	<Term Name="Credit Ombudsman Service Limited">
		<Definition>Abbreviation: COSLCOSL was formerly known as MIOS (Mortgage Industry Ombudsman Service). COSL provides consumers with an alternative to legal proceedings for resolving disputes with Credit Ombudsman Members. The broad aim of the Credit Ombudsman Service is to provide an independent and prompt resolution of disputes in accordance with relevant legal requirements, the MFAA Code of Practice and other recognized Codes of Practice, good practice in the Credit Industry and fairness in all the circumstances.</Definition>
		<RelatedTerm Name="COSL" Collection="lixi"/>
	</Term>
	<Term Name="Credit Policy">
		<Definition>The set of rules and guidelines that determine the circumstances under which a loan application is approved or rejected, including the income types, percentages and amounts that are acceptable. Lending policy varies depending on the lender, the LMI provider, and the loan product.</Definition>
		<RelatedTerm Name="Lending Policy" Collection="lixi"/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
	</Term>
	<Term Name="Credit Rating">
		<Definition>A rating of credit worthiness based on an assessment of factors such as a credit report.</Definition>
	</Term>
	<Term Name="Credit Report" Abbr="CRAA">
		<Definition>A report of an entity's credit history (such as arrears and defaults) from a credit bureau such as Veda Advantage, used by a lender in determining the credit worthiness of a loan party. Obtaining a credit report requires the party's consent.</Definition>
		<RelatedTerm Name="Privacy Consent Form" Collection="lixi"/>
		<RelatedTerm Name="Credit Check" Collection="lixi"/>
		<RelatedTerm Name="Credit History" Collection="lixi"/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
		<RelatedTerm Name="Comprehensive Credit Reporting" Collection="lixi"/>
		<RelatedTerm Name="CRAA" Collection="lixi"/>
	</Term>
	<Term Name="Credit Reporting Agencies">
		<Definition>These are private agencies that hold credit information on individuals and businesses. One agency is Bay Corp Advantage.</Definition>
	</Term>
	<Term Name="Credit-Related Insurance Contract">
		<Definition>A contract for insurance of any of the following kinds in connection with a credit contract: (a) insurance over mortgaged property; (b) consumer credit insurance; (c) insurance that is a "credit-related insurance contract" for the purposes of section 132(1)(c) of the Uniform Consumer Credit Code.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Credit Worthiness">
		<Definition>A generic term that indicates the likelihood that a consumer will repay a consumer credit product as required.</Definition>
	</Term>
	<Term Name="Cross Collateralisation">
		<Definition>The use of two or more security properties as collateral for two or more loans.</Definition>
		<RelatedTerm Name="Non-Cross Collateralised" Collection="lixi"/>
		<RelatedTerm Name="Cross Securitisation" Collection="lixi"/>
	</Term>
	<Term Name="Cross Guarantee">
		<Definition>A cross guarantee is an arrangement between two or more companies to guarantee to each other's loans. The guarantee is commonly used among companies trading under the same group or between a parent company and its subsidiaries.</Definition>
	</Term>
	<Term Name="Cross Securitisation">
		<Definition>Cross Collateralisation.</Definition>
	</Term>
	<Term Name="Cross-collateral mortgage">
		<Definition>A cross-collateral mortgage is a document which is stamped as a prime security and a collateral security as part of a group of mortgage documents.</Definition>
	</Term>
	<Term Name="Certificate of Title" Abbr="CT">
		<Definition/>
		<RelatedTerm Name="Certificate of Title" Collection="lixi"/>
	</Term>
	<Term Name="Current Balance">
		<Definition>The account balance at the current point in time.</Definition>
		<RelatedTerm Name="Arrears" Collection="lixi"/>
		<RelatedTerm Name="Drawn Amount" Collection="lixi"/>
		<RelatedTerm Name="Pay Down Amount" Collection="lixi"/>
		<RelatedTerm Name="In Arrears" Collection="lixi"/>
	</Term>
	<Term Name="Customer ID">
		<Definition>The unique identifier assigned to an individual customer of the lender, often by the lender's Customer Relationship Management (CRM) system. Used as a universal reference number for the customer within the lender's systems.</Definition>
	</Term>
	<Term Name="Customer Identity Verification" Abbr="CIV">
		<Definition>(sometimes Customer Identification and Verification) The processes and procedures required to verify the identity of an entity loosely considered as a 'customer'.</Definition>
		<RelatedTerm Name="CIV" Collection="lixi"/>
	</Term>
	<Term Name="Deferred Administration Fee" Abbr="DAF">
		<Definition/>
		<RelatedTerm Name="Deferred Administration Fee" Collection="lixi"/>
	</Term>
	<Term Name="Daily Interest">
		<Definition>Interest on a financial instrument such as a loan, calculated and accrued on a daily basis on the daily account balance. The accrued interest will generally be debited from the loan account monthly in arrears.</Definition>
	</Term>
	<Term Name="Date of Birth">
		<Definition>The date on which a person was born.</Definition>
	</Term>
	<Term Name="Days in Arrears">
		<Definition>Simplistically, when an account is in arrears this is the number of days between the current date and payment due date for the first unpaid/partially paid instalmentFor the assessment of the performance of a loan book, the days in arrears for each account in arrears is a pro rata calculation taking into account the overdue amount (scheduled balance less current balance) in relation to the scheduled repayment amount and the repayment period.</Definition>
		<RelatedTerm Name="In Arrears" Collection="lixi"/>
	</Term>
	<Term Name="Dynamic Delinquency Score" Abbr="DDS">
		<Definition/>
		<RelatedTerm Name="Dynamic Delinquency Score" Collection="lixi"/>
	</Term>
<Term Name="Debentures">
		<Definition>A debenture is a medium to long term investment in which investors lend their money to a company for a set period. The company makes regular and fixed interest payments and returns the principal and interest to the investor at the maturity date.</Definition>
	</Term>
	<Term Name="Debit">
		<Definition>To withdraw money from an account. Also, the accounting entry of such a withdrawal.</Definition>
	</Term>
	<Term Name="Debit Card">
		<Definition>A card facility used to access available customer funds (i.e. not credit) from an account, for example through EFTPOS or an ATM.</Definition>
	</Term>
	<Term Name="Debit User">
		<Definition>A person who, by agreement with the customer, issues debit payment instructions through their financial institution for distribution to the relevant customer's financial institution.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Debt">
		<Definition>An obligation to pay an amount borrowed or owed.</Definition>
	</Term>
	<Term Name="Debt Agreement">
		<Definition>Part IX of the Bankruptcy Act, a method of coming to an arrangement with creditors of unsecured credit to repay the debt through an administrator and avoiding bankruptcy.</Definition>
	</Term>
	<Term Name="Debt Consolidation">
		<Definition>The refinancing of a number of existing loans (such as personal loans and credit cards) with funds from a new loan, typically from a home loan with a lower total repayment amount.</Definition>
		<RelatedTerm Name="Refinance" Collection="lixi"/>
		<RelatedTerm Name="Consolidation" Collection="lixi"/>
	</Term>
	<Term Name="Debt Service Coverage Ratio" Abbr="DSCR">
		<Definition>An assessment metric. The ratio of income available to that required for debt servicing including interest, principal and lease payments. DSCR is a popular benchmark used in the measurement of a borrower's ability to generate enough cash to make their debt repayments. A lender may have a minimum acceptable DSCR, and the ratio may be a loan covenant such that breaching it could be considered an act of default. Generally, the debt service coverage ratio is calculated as DSCR = (Cash Available for Debt Servicing) / (Principal Repayment + Interest Payments + Lease Payments). See also the similar (but inversed) Debt Service Ratio.</Definition>
		<RelatedTerm Name="Debt Service Ratio" Collection="lixi"/>
		<RelatedTerm Name="DSCR" Collection="lixi"/>
	</Term>
	<Term Name="Debt Service Ratio" Abbr="DSR">
		<Definition>An assessment metric. Loosely, the proportion of a borrower's income that will be used to make repayments on debt, which is an indicator of the borrower's ability to repay the loan. Calculated as the ratio of current and proposed debt repayments to income. While the DSR calculation can use either net or gross income, the normal for most lenders is to use gross income. Most lenders set a maximum DSR between 30% and 40% depending on the circumstances. See also the similar (but inversed) DSCR.</Definition>
		<Reference URL="http://wg.lixi.org.au/ps/page/lixi-glossary/path/Collections/Debt_Service_Ratio.xml" Name="LIXI"/>
		<RelatedTerm Name="Debt Service Coverage Ratio" Collection="lixi"/>
		<RelatedTerm Name="DSR" Collection="lixi"/>
	</Term>
  <Term Name="Debt to Income Ratio" Abbr="DTI">
		<Definition>Debt to Income Ratio (DTI) is the ratio of the total credit limit of all debts to the gross annual income that applies to the parties to the application. Total credit limit of all debts refers to: the credit limit of revolving liabilities + the outstanding balance of non-revolving liabilities + the amount requested for the new Loan. Unlike the Debt Service Ratio (DSR) this calculation does not use the repayment expense. Instead, it uses the limit or outstanding balance of the liabilities.</Definition>
	</Term>
	<Term Name="Debtor">
		<Definition>A person or entity who owes money to another and can be compelled to perform an obligation.A person or company (other than a guarantor) who is liable to repay credit, and including a prospective debtor.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/sch1.html" Name="Austlii"/>
	</Term>
	<Term Name="Debtor Finance">
		<Definition>Debtor finance is lending by a financier to a business based on the value of the accounts receivable ledger. This assists a business to manage its cash flow requirements by providing the business with the more immediate benefits of cash from a credit sale. Debtor financing differs from factoring in that the receivables are provided as security but are not sold or transferred.</Definition>
	</Term>
	<Term Name="Declaration of Trust">
		<Definition>A formal statement that assets are held by one party on behalf of (i.e. in trust for) another.  A declaration of trust clearly establishes the relationship between legal owners and the beneficial owners of the asset, and is used for example in situations where the trust relationship cannot be declared on a property title.</Definition>
	</Term>
	<Term Name="Deed">
		<Definition>A signed written document testifying the agreement of the parties to the deed, to the things contained in the deed.</Definition>
	</Term>
	<Term Name="Deed of Priority">
		<Definition>An agreement between two or more creditors under which they agree the relative and respective rights which they shall have in relation to debts from a common debtor, including the order of priority in which their respective debts will rank.</Definition>
	</Term>
	<Term Name="Deferred Establishment Fee" Abbr="DEF">
		<Definition/>
		<RelatedTerm Name="Deferred Establishment Fee" Collection="lixi"/>
	</Term>
	<Term Name="Default">
		<Definition>Failure to carry out the terms of a contract, especially failure to repay a debt. Although not labelled explicitly as "default", the Cth Privacy Act (1988) S18E(1)(b)(vi) implies that a credit contract is in default when a repayment is overdue by more than 60 days and the credit provider has taken steps to recover any part of the credit.</Definition>
		<Reference URL="" Name=""/>
		<RelatedTerm Name="Arrears" Collection="lixi"/>
	</Term>
	<Term Name="Deferred Administration Fee">
		<Definition/>
		<Reference URL="http://www.aussie.com.au/wizard/faq.htm" Name="Aussie-Wizard"/>
		<RelatedTerm Name="DAF" Collection="lixi"/>
		<RelatedTerm Name="Deferred Establishment Fee" Collection="lixi"/>
		<RelatedTerm Name="DAF" Collection="lixi"/>
	</Term>
	<Term Name="Deferred Establishment Fee" Abbr="DEF">
		<Definition>A type of establishment fee that is deferred for some time after settlement and may be waived. Typically DEF is only payable if a home loan is repaid within the first few years, typically 3 to 5 years, otherwise the fee is waived. DEF's are not included in the calculation of AAPR. DEF's are no longer permitted under NCCP.</Definition>
		<RelatedTerm Name="Deferred Administration Fee" Collection="lixi"/>
		<RelatedTerm Name="DEF" Collection="lixi"/>
	</Term>
	<Term Name="Density">
		<Definition>Is the level of occupancy in a given area, or the number of people permitted to reside in an area. For example, inner-city areas are usually higher density than outer-suburban areas.</Definition>
	</Term>
	<Term Name="Deposit">
		<Definition>For a purchase or refinance, the difference between the Funds Required and the loan amount. A deposit of 20% of the sale price notionally implies an LVR of 80% although fees and other charges may alter that figure slightly. See also Contribution Funds and Deposit (downpayment)</Definition>
		<RelatedTerm Name="Deposit Bond" Collection="lixi"/>
		<RelatedTerm Name="Funds Required" Collection="lixi"/>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
	</Term>
	<Term Name="Deposit (downpayment)">
		<Definition>In relation to a contract of sale, means an amount not exceeding 10% of the purchase price; paid or payable in one or more amounts; and liable to be forfeited and retained by the vendor in the event of a breach of contract by the purchaser. Money (cash or equivalent, see deposit bond) paid to the vendor as assurance that the purchaser will proceed with the sale, generally paid at the time of signing the contract of sale or when the contract becomes unconditional.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/sch1.html" Name="Austlii"/>
		<RelatedTerm Name="Exchange of Contracts" Collection="lixi"/>
		<RelatedTerm Name="Downpayment" Collection="lixi"/>
		<RelatedTerm Name="Deposit" Collection="lixi"/>
	</Term>
	<Term Name="Deposit Account">
		<Definition>A current account, savings account, or other type of bank account other than a loan account, at a banking institution that allows money to be deposited and withdrawn by the account holder.</Definition>
		<RelatedTerm Name="Overdraft" Collection="lixi"/>
	</Term>
	<Term Name="Deposit Bond">
		<Definition>A deposit bond is a form of guarantee accepted by a vendor in lieu of a deposit. The underwriter guarantees payment of the deposit bond value to the vendor in the case that the purchaser does not proceed with the purchase under the normal terms of the contract of sale.</Definition>
		<RelatedTerm Name="Deposit (downpayment)" Collection="lixi"/>
	</Term>
	<Term Name="Depreciation">
		<Definition>The accounting practice where the cost of a fixed asset of a business is spread over the life of the asset. Depreciation is a non-cash expense which allows the money to be retained by the business, thus technically allowing the business the capacity to replace the asset over time.The decrease in value of a home or property over time when compared to the original purchase price.</Definition>
	</Term>
	<Term Name="Desktop Valuation">
		<Definition>A valuation where the property has not been inspected.</Definition>
	</Term>
	<Term Name="Direct Debit">
		<Definition>An amount debited to a specified account of a customer with the customer's financial institution, as requested and authorised in writing by that customer, to and in favour of a debit user (or to a third party in its capacity as agent for that named debit user) which is processed through the Bulk Electronic Clearing System.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
		<RelatedTerm Name="Linked Bank Account" Collection="lixi"/>
		<RelatedTerm Name="Repayment Method" Collection="lixi"/>
	</Term>
	<Term Name="Direct Debit Request">
		<Definition>An authority and request to debit amounts to a specified account of a customer with the customer's financial institution, given in writing by that customer to and in favour of a debit user or their agent.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Director Guarantor">
		<Definition>A guarantor of a Facility who is a director of a company which is to be the debtor for a loan facility, other than a sole director guarantor or a commercial asset financing guarantor.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
	</Term>
	<Term Name="Disability Support Pension">
		<Definition>An income support payment that provides financial assistance to Australian residents that have a permanent physical, intellectual or psychiatric condition that stops them from working, aged 16 years or older but under age pension age, that also meet other eligibility criteria.</Definition>
	</Term>    
	<Term Name="Disbursement Method">
		<Definition>The method of disbursing funds such as surplus funds or solicitor disbursements. Methods include cheque, bank cheque, deposit to specified account, deposit to linked direct debit account, deposit to new account.</Definition>
	</Term>
	<Term Name="Disbursements">
		<Definition>Solicitor's incidental costs involved when dealing with a client or on behalf of the Lender. Services may include searches, certificates, pest reports, buyer's share of rates etc.</Definition>
		<RelatedTerm Name="Disbursement Method" Collection="lixi"/>
	</Term>
	<Term Name="Discharge">
		<Definition>When a lender releases a mortgage over a security property, generally when the secured loan has been fully repaid either directly or through sale or refinance.</Definition>
		<RelatedTerm Name="Outgoing Mortgagee" Collection="lixi"/>
		<RelatedTerm Name="Release of Security" Collection="lixi"/>
		<RelatedTerm Name="Partial Discharge" Collection="lixi"/>
		<RelatedTerm Name="Full Discharge" Collection="lixi"/>
		<RelatedTerm Name="Discharge Fee" Collection="lixi"/>
	</Term>
	<Term Name="Discharge Fee">
		<Definition>A fee charged by the lender in relation to the administrative costs of finalising the discharge of a mortgage.A credit fee or charge that only reimburses the credit provider for the reasonable administrative cost of terminating the credit contract.</Definition>
		<Reference URL="https://www.legislation.gov.au/Details/F2014C00815" Name="National Consumer Credit Protection Regulations"/>
		<RelatedTerm Name="Early Repayment Costs" Collection="lixi"/>
		<RelatedTerm Name="Payout Figure" Collection="lixi"/>
	</Term>
	<Term Name="Discounted Interest Rate">
		<Definition></Definition>
		<RelatedTerm Name="Introductory Rate" Collection="lixi"/>
		<RelatedTerm Name="Interest Rate Discount Margin" Collection="lixi"/>
	</Term>
	<Term Name="Discretionary Living Expenses">
		<Definition>Discretionary household or living expenses include childcare; entertainment, pay TV, sports, hobbies, taxi fares and domestic holidays; restaurant food, take away and luxury food items, alcohol and tobacco; furniture and furnishings; and adults' clothing and footwear.</Definition>
		<RelatedTerm Name="Living Expenses" Collection="lixi"/>
	</Term>
	<Term Name="Display House">
		<Definition>A house constructed on a development to provide an indicative representation of the living space and features of homes that will make up the remainder of the development. Also known as a model home or a show house.</Definition>
	</Term> 
	<Term Name="Diversified Company">
		<Definition>A diversified company is a company that has multiple, unrelated businesses. Unrelated businesses are those who require unique management expertise, have different end customers and produce different products or provide different services.</Definition>
	</Term>
	<Term Name="Dividend">
		<Definition>Is a share from profits that is paid by a publicly listed company to a shareholder. Dividends are an income sources that can generally be used when applying for a home loan.</Definition>
	</Term>
	<Term Name="Downpayment">
		<Definition>Deposit (downpayment)</Definition>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
	</Term>
	<Term Name="Drawdown">
		<Definition>Act of transferring money from lending institution to the borrower after the loan has settled, either once-off or, in the case of a construction loan in a series of progress payments.</Definition>
	</Term>
	<Term Name="Drawn Amount">
		<Definition>The current balance of a loan account.</Definition>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
	</Term>
	<Term Name="Dynamic Risk Score" Abbr="DRS">
		<Definition/>
		<RelatedTerm Name="Dynamic Risk Score" Collection="lixi"/>
	</Term>
	<Term Name="Debt Service Coverage Ratio" Abbr="DSCR">
		<Definition/>
		<RelatedTerm Name="CADS" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Coverage Ratio" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Ratio" Collection="lixi"/>
		<RelatedTerm Name="Cash Available for Debt Servicing" Collection="lixi"/>
	</Term>
	<Term Name="Defence Services Homes" Abbr="DSH">
		<Definition>Schemeprovides housing benefits such as subsidised housing loans to eligible veterans, ADF personnel and their dependants. Housing loans are provided by Westpac and its subsidiaries.</Definition>
		<Reference URL="http://www.dsh.gov.au/lending/assign_loan_ent_app.htm" Name="DSH"/>
	</Term>
	<Term Name="DSH Certificate of Assignment">
		<Definition>Under the DSH, a certificate of assignment assigns the assignor's subsidy to be payable by the Commonwealth to a credit provider if, in accordance with the certificate, the credit provider makes an advance to another person (the assignee).</Definition>
		<Reference URL="" Name=""/>
	</Term>
	<Term Name="DSH Certificate of Entitlement">
		<Definition>A certificate of entitlement certifies that a subsidy is payable by the Commonwealth to the credit provider if, in accordance with the agreement, the credit provider makes that advance to the applicant or the assignee of the applicant.</Definition>
		<Reference URL="" Name=""/>
	</Term>
	<Term Name="Debt Service Ratio" Abbr="DSR">
		<Definition/>
		<RelatedTerm Name="Assessment Metric" Collection="lixi"/>
		<RelatedTerm Name="Debt Service Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Duty">
		<Definition>A tax that is imposed on certain documents and transactions by a Revenue Office. See also Stamp Duty.</Definition>
		<RelatedTerm Name="Revenue Office" Collection="lixi"/>
	</Term>
	<Term Name="Dynamic Delinquency Score" Abbr="DDS">
		<Definition>DDS is an assessment metric, statistically derived from a compilation of financial, credit and demographic factors, that assesses the probability of a firm paying its bills in a severely delinquent manner (90+day past terms) over the next 12 months.</Definition>
		<Reference URL="http://www.dnb.com.au/CreditRisk/reports/AU/rating_tables.asp" Name="Dun &amp; Bradstreet"/>
		<RelatedTerm Name="DDS" Collection="lixi"/>
	</Term>
	<Term Name="Dynamic Risk Score" Abbr="DRS">
		<Definition>DRS is an assessment metric, evaluating the probability that a business will experience financial distress. This statistical analysis uses past behaviour to predict future performance - specifically that a business will experience financial distress within the next 12 months.</Definition>
		<Reference URL="http://www.dnb.com.au/CreditRisk/reports/AU/rating_tables.asp" Name="Dun &amp; Bradstreet"/>
		<RelatedTerm Name="DRS" Collection="lixi"/>
	</Term>
	<Term Name="Early Close Clawback">
		<Definition>Clawback of commission (typically of the upfront commission) for loans that are refinanced or otherwise closed within the first few years of the loan term.</Definition>
		<RelatedTerm Name="Clawback" Collection="lixi"/>
	</Term>
	<Term Name="Early Repayment Costs">
		<Definition>Costs that will become payable should a loan be repaid within a certain period, either directly, by changing loan product, or through re-financing. This often relates to fixed rate loans or discounted interest rate when the borrower terminates the loan contract before the expiry of the fixed or discounted rate period. The charge includes discharge fees and break fees.</Definition>
		<RelatedTerm Name="Redemption Penalty" Collection="lixi"/>
		<RelatedTerm Name="Exit Fee" Collection="lixi"/>
		<RelatedTerm Name="Redraw Facility" Collection="lixi"/>
		<RelatedTerm Name="Portable Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Easement">
		<Definition>A right to use a corridor or passage of land which is owned by another.</Definition>
		<RelatedTerm Name="Encumbrance" Collection="lixi"/>
	</Term>
	<Term Name="Economic cost">
		<Definition>A fee which may be payable if, during a fixed rate period, the borrower makes certain changes such as switching the loan from a fixed to variable rate or fully prepaying the loan prior to the expiry of the fixed rate period. Economic cost is the lender's estimate of its loss resulting from the change.</Definition>
	</Term>
	<Term Name="Equity Finance Mortgage" Abbr="EFM">
		<Definition/>
	</Term>
	<Term Name="Equity Finance Mortgage Loan" Abbr="EFM">
		<Definition/>
		<RelatedTerm Name="Equity Finance Mortgage Loan" Collection="lixi"/>
	</Term>
	<Term Name="Electronic Funds Transfer at Point of Sale" Abbr="EFTPOS">
		<Definition>Electronic transfer of funds, generally for a purchase, at the place and time of the purchase.</Definition>
	</Term>
	<Term Name="Electronic Lodgement Network Operator" Abbr="ELNO">
		<Definition>An electronic conveyancing system and supporting arrangements that facilitates the completion of property transactions electronically. NECS is planned to be the first and maybe the only instance of an ELNO.</Definition>
		<RelatedTerm Name="ELNO" Collection="lixi"/>
	</Term>
	<Term Name="Electronic Notice of Settlement" Abbr="ENOS">
		<Definition>A notice that is sent from the land titles office to the state revenue office notifying them of a settlement, to ensure that duty is paid.</Definition>
		<RelatedTerm Name="ENOS" Collection="lixi"/>
	</Term>
	<Term Name="Electronic Lodgement Network Operator" Abbr="ELNO">
		<Definition/>
		<RelatedTerm Name="Electronic Lodgement Network Operator" Collection="lixi"/>
	</Term>
	<Term Name="Enclosed Stage">
		<Definition>A construction stage when the building is enclosed and secure. The roof covering is fixed, structural flooring is laid, external doors installed and lockable, and external windows are fixed.</Definition>
		<RelatedTerm Name="Lock Up Stage" Collection="lixi"/>
	</Term>
	<Term Name="Encumbrance">
		<Definition>An Interest In Land or Constraint that is recorded on a Land Title and held by ("in favour of") a Party or Parties not being the registered proprietor in that Land Title. The right generally passes with title when title is transferred, for instance easements. An encumbrance does not hinder transfer of ownership, though it may affect the market value of the property.</Definition>
	</Term>
	<Term Name="End Debt">
		<Definition>The debt remaining from a Bridging Loan after the to-be-sold property has been sold. End Debt will typically be calculated as the total loan amount minus the value of the to-be-sold property, plus capitalised interest.</Definition>
		<RelatedTerm Name="Bridging Loan" Collection="lixi"/>
	</Term>
	<Term Name="End of Month Balance">
		<Definition>For the calculation of trailing commission, the loan balance at the end of the month (usually a calendar month)</Definition>
	</Term>
	<Term Name="Electronic Notice of Settlement" Abbr="ENOS">
		<Definition/>
		<RelatedTerm Name="Electronic Notice of Settlement" Collection="lixi"/>
	</Term>
	<Term Name="EPlan">
		<Definition>An electronic lodgement and validation system for plans of subdivision, developed by the state governments and being rolled out for use by surveyors and property developers.</Definition>
		<Reference URL="http://www.icsm.gov.au/eplan/index.html" Name="ICSM"/>
	</Term>
	<Term Name="Equitable Mortgage">
		<Definition>A security interest in land, usually protected by lodgement of a caveat on the title of the security property, but where the mortgage itself has not actually been registered.</Definition>
		<RelatedTerm Name="Mere Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Unregistered Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Equity">
		<Definition>Generally used to denote the financial interest of a person in a property or business enterprise. For example: a person's equity in a house is the difference between its value and the amount still owed to a Lender. A person's overall equity refers to net financial worth, or the difference between what is owned and what is owed (i.e. Assets - Liabilities = Equity).</Definition>
		<RelatedTerm Name="Refinance" Collection="lixi"/>
	</Term>
	<Term Name="Equity Finance Mortgage Loan" Abbr="EFM">
		<Definition>A type of mortgage loan where the borrower can borrow 20 per cent of the property's purchase price interest-free and in return the lender gets 40 per cent of any capital gain made when the property is sold or the borrower repays the loan, in addition to the loan principal.</Definition>
		<RelatedTerm Name="Shared Equity Loan" Collection="lixi"/>
		<RelatedTerm Name="EFM" Collection="lixi"/>
	</Term>
	<Term Name="Equity Guarantee">
		<Definition>Security guarantee.</Definition>
	</Term>
	<Term Name="Equity Loan">
		<Definition>A home loan secured with the borrowers existing property where the lending purpose is for any personal use. Lenders sometimes describe line of credit loans as equity loans, although properly an equity loan does not need to be a revolving facility.</Definition>
	</Term>
	<Term Name="Equity Release Home Loan">
		<Definition>Reverse Mortgage Home Loan.</Definition>
	</Term>
	<Term Name="Essential Repairs">
		<Definition>Observable building and/or construction defects that a valuer has identified in the real estate asset.</Definition>
	</Term>
	<Term Name="Establishment Fee">
		<Definition>Simply, any fee charged by the lender when setting up a loan. Specifically, any fee or charge payable under the credit contract that relates to the costs incurred by the creditor in connection with the application for credit, processing and considering that application, documenting the contract, and advancing the credit; but does not include any fee or charge to the extent that it is a charge for an optional service.</Definition>
		<Reference URL="http://www.legislation.govt.nz/act/public/2003/0052/latest/DLM211520.html" Name="NZ Legislation"/>
		<RelatedTerm Name="Fee Payment Method" Collection="lixi"/>
	</Term>
	<Term Name="Estate">
		<Definition>A Proprietorship that is of a parcel of land together with an associated "bundle of rights" and a measure of duration, being an Estate in Fee Simple, Leasehold Estate, Life Estate, Estate in Remainder. See also Interest in land.</Definition>
		<RelatedTerm Name="Proprietor" Collection="lixi"/>
		<RelatedTerm Name="Interest in Land" Collection="lixi"/>
		<RelatedTerm Name="Transfer of Land" Collection="lixi"/>
	</Term>
	<Term Name="Estate in Fee Simple">
		<Definition>The estate in fee simple is the highest estate in the land, and it is the closest the law comes to recognising absolute ownership for all practical purposes. However, while we refer to a proprietor of an estate in fee simple (who is the owner for all practical purposes), their ownership is not legally absolute, for absolute legal ownership of all land rests with the Crown.</Definition>
		<RelatedTerm Name="Estate" Collection="lixi"/>
		<RelatedTerm Name="Fee Simple" Collection="lixi"/>
		<RelatedTerm Name="Freehold" Collection="lixi"/>
	</Term>
	<Term Name="Event Notification">
        <Definition>An event notification is a message that describes the occurrence of an event with respect to a credit application that was triggered by the submission of a LIXI credit application message. An event doesn't necessarily invoke a change in status (and trigger a status update backchannel message).</Definition>
    </Term>
	<Term Name="Evidence of Income">
		<Definition>Evidence provided by the applicant that their income is as-stated. For employed applicants this will normally be in the form of copies of two recent wage slips and a copy of their last Group Certificate or a letter from their current employer. For Self-Employed applicants this will normally be copies of the last 2 years personal and company tax returns.</Definition>
	</Term>
	<Term Name="Exchange of Contracts">
		<Definition>A formal legal process that creates a binding contract for the sale of real property on agreed terms, during which time a holding fee or deposit is usually paid to the seller. The exchange of contracts is most often governed by a three days cooling off period.</Definition>
	</Term>
	<Term Name="Existing Loan Party">
		<Definition>A party (borrower or guarantor) to an existing loan, rather than e.g. an applicant.</Definition>
	</Term>
	<Term Name="Exit Fee">
		<Definition>Early Repayment Costs.</Definition>
	</Term>
	<Term Name="Expected Settlement Date">
		<Definition>The date that settlement is expected, from a time perspective during the application process.</Definition>
	</Term>
	<Term Name="Expense">
		<Definition>A regular payment such as rent, repayment on a liability, insurance, etc. When assessing a loan application, credit card expense is commonly estimated as a proportion of the total limit (e.g. 3% per month) rather than on the current balance. The living allowance is commonly pre-calculated by the lender rather than provided by the borrower. Quantifying an expense requires capturing the expense type, the dollar value, and the recurring payment period. An expense may be linked to an associated liability.</Definition>
		<RelatedTerm Name="Uncommitted Income" Collection="lixi"/>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
		<RelatedTerm Name="Expense Type" Collection="lixi"/>
	</Term>
	<Term Name="Expense Type">
		<Definition>The characteristic type of an expense, such as rent, loan repayment, or household expense such as electricity. Expense types are an important attribute when calculating borrowing capacity.</Definition>
		<Reference URL="http://files.lixi.org.au/CAL_ExpenseTypes.xml" Name="CAL Expense Types"/>
		<RelatedTerm Name="Expense" Collection="lixi"/>
	</Term>
	<Term Name="Extra Repayment">
		<Definition>Additional Loan Repayment.</Definition>
		<RelatedTerm Name="Repayment" Collection="lixi"/>
	</Term>
	<Term Name="Facility">
		<Definition>A non-specific term variously used to describe an account, a portfolio, a master agreement, the accounts associated with a loan contract, etc. Not recommended to be used unless the context itself is unambiguous.</Definition>
	</Term>
	<Term Name="Facility Limit">
		<Definition>A non-specific term variously used to describe a loan account limit, a portfolio limit, a master agreement limit, etc. Not recommended to be used unless the context itself is unambiguous.</Definition>
	</Term>
	<Term Name="Family guarantee">
		<Definition>A guarantee provided by a guarantor that is directly related to the borrower, typically being the parents, siblings, spouse or children. A family guarantee can be limited.</Definition>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
	</Term>
	<Term Name="Fast Refinance">
		<Definition>"Fast Re-Fi" is a characteristic of some mortgage loan application processes, where the incoming mortgagee refinances an existing loan from another lender without initially securing the loan with a mortgage. The mortgage is registered shortly after settlement. The incoming mortgagee may also not performing the normal due diligence such as obtaining a copy of title or obtaining a valuation. The process enables the new loan to be settled faster than if the mortgage transaction was conducted simultaneously with the loan transaction. Fast refinance generally utilises, and may be dependent upon, the lender obtaining title insurance to insure the incoming mortgagee against failure to settle the mortgage transaction.</Definition>
	</Term>
	<Term Name="Favourable Purchase">
		<Definition>A sale of property, usually between family members, where the sale price is less than the value, by a not-insignificant amount.</Definition>
	</Term>
	<Term Name="Fee Payment Method">
		<Definition>The method by which top-up, rate lock, application and other establishment fees will be paid. Options include added to loan; paid by customer; credit card charge; debit other account (including redraw).</Definition>
	</Term>
	<Term Name="Fee Simple">
		<Definition>Estate in Fee Simple.</Definition>
	</Term>
	<Term Name="First Home Owner Grant" Abbr="FHOG">
		<Definition/>
		<RelatedTerm Name="First Home Owner Grant" Collection="lixi"/>
	</Term>
	<Term Name="Financial Institution">
		<Definition>A financial institution is a company that provides financial products or services. The Reserve Bank Of Australia categories financial institutions into three main types. 1) Authorized Deposit Taking Institution (ADIs) such as banks, credit unions, building societies which are allowed to receive deposits. 2) Non-ADI Financial Institutions such as money market corporations, finance companies, and securitisers which are not allowed to receive deposits. 3) Insurers and Funds Managers such as life insurance companies, general insurance companies, and superannuation and approved deposit funds.</Definition>
	</Term>
	<Term Name="Financial institutions duty" Abbr="FID">
		<Definition/>
		<RelatedTerm Name="Financial institutions duty" Collection="lixi"/>
	</Term>
  <Term Name="Financial Product">
    <Definition>A financial product is a facility through which a person makes a financial investment, manages financial risk, or makes non-cash payments.</Definition>
  </Term>
	<Term Name="Final Payout Figure">
		<Definition>The payout figure that a lender produces just prior to finalising the account close process, generally within a day of the settlement.</Definition>
	</Term>
	<Term Name="Finance Broking Contract">
		<Definition>Is a contract that should be made available for all instances of consumer lending as detailed by the applicable state governing bodies. NSW office of Fair Trading has a brochure available for download that explains a finance broking contract in more detail.</Definition>
	</Term>
	<Term Name="Finance Lease" Abbr="FL">
		<Definition>A purchase and lease arrangement where the financier (lessor) buys the required tangible asset and leases it to the customer (lessee). The agreement transfers substantially all the risks and benefits incident to ownership of the asset (including residual value) from the lessor to the lessee, without transferring the legal ownership during the term.</Definition>
		<RelatedTerm Name="Operating Lease" Collection="lixi"/>
		<RelatedTerm Name="FL" Collection="lixi"/>
	</Term>
	<Term Name="Financial Distress">
		<Definition>For a company, the forced change of control by appointment of an administrator or receiver manager; or involuntary liquidation / insolvency (ceasing operations while owing money to creditors)</Definition>
		<RelatedTerm Name="Dynamic Risk Score" Collection="lixi"/>
	</Term>
	<Term Name="Financial institutions duty" Abbr="FID">
		<Definition>State duty on the receipts of financial institutions.</Definition>
		<RelatedTerm Name="FID" Collection="lixi"/>
	</Term>
	<Term Name="First Home Owner Grant" Abbr="FHOG">
		<Definition>A government scheme providing a grant to eligible first home buyers, currently up to $7000. The funds received from FHOG can be included in the settlement.</Definition>
		<Reference URL="http://www.firsthome.gov.au/" Name="FirstHome"/>
		<RelatedTerm Name="FHOG" Collection="lixi"/>
	</Term>
	<Term Name="First Mortgage">
		<Definition>When a mortgage is taken out over a property ranked in front of other mortgages or is the only mortgage. The finance provider who holds the First Mortgage has first recourse on the proceeds of sale of the security in the event of a mortgagee sale.</Definition>
	</Term>
		<Term Name="First Property Buyer">
		<Definition>A first property buyer is a borrower entering the property ownership market for the first time, whether or not they are purchasing a dwelling for owner-occupied (principal place of residence and non principal place of residence) or investment purposes. This includes all borrowers entering the property ownership market for the first time, regardless of whether or not they have received or are eligible for a first-home buyer grant.</Definition>
	</Term>
	<Term Name="Fittings">
		<Definition>Items that can be removed from a property without causing damage to it, such as blinds, curtains, and carpets. See also Fixtures.</Definition>
		<RelatedTerm Name="Fixtures" Collection="lixi"/>
	</Term>
	<Term Name="Fixed Charge">
		<Definition>An interest in property of a company that attaches to specific identifiable assets. The charge prevents the grantor from dealing with the property without some sort of specific permission from the secured party that has taken the charge in the property.</Definition>
		<RelatedTerm Name="Floating Charge" Collection="lixi"/>
	</Term>
	<Term Name="Fixed Interest Rate">
		<Definition>An interest rate which is fixed (i.e. unchanging) for an agreed term.</Definition>
		<RelatedTerm Name="Rate Lock" Collection="lixi"/>
		<RelatedTerm Name="Interest Rate Type" Collection="lixi"/>
		<RelatedTerm Name="Interest Rate" Collection="lixi"/>
	</Term>
	<Term Name="Fixed Price Building Contract">
		<Definition></Definition>
		<RelatedTerm Name="lump sum building contract" Collection="lixi"/>
	</Term>
	<Term Name="Fixed Rate Loan">
		<Definition>A loan where the interest rate is fixed for a set period, unlike a variable rate loan. If the fixed rate period is shorter than the loan term, at the end of the fixed rate period the interest rate will typically convert to a variable rate.</Definition>
	</Term>
	<Term Name="Fixed Rate Term">
		<Definition>The contracted term (generally in months or years) that a fixed interest rate is applicable. At the end of the fixed rate term, the interest rate will usually convert to a variable rate.</Definition>
		<RelatedTerm Name="Loan Term" Collection="lixi"/>
	</Term>
	<Term Name="Fixing Stage">
		<Definition>A construction stage when all internal lining, skirtings, doors, baths, wet area tiling, built in cabinets are fitted and fixed into position.</Definition>
	</Term>
	<Term Name="Fixtures">
		<Definition>Items that cannot be removed from a property without causing damage to it, such as baths, sinks, ducted heating systems and air-conditioning units, and possibly ovens. If to be removed, their removal must be stipulated in the contract of sale and any damage made good by the seller. See also Fittings.</Definition>
		<RelatedTerm Name="Fittings" Collection="lixi"/>
	</Term>
	<Term Name="Finance Lease" Abbr="FL">
		<Definition/>
		<RelatedTerm Name="Finance Lease" Collection="lixi"/>
	</Term>
	<Term Name="Floating Charge">
		<Definition>An interest in the general property of a company (particularly the circulating assets) that is granted by the company to a lender. This makes it possible for the company that has given the charge to deal with a specific item of property without first needing to seek the permission of the secured party. See also Fixed Charge.</Definition>
		<RelatedTerm Name="Purchase Money Security Interest" Collection="lixi"/>
		<RelatedTerm Name="APAAP" Collection="lixi"/>
	</Term>
	<Term Name="Floor Area">
		<Definition>Simply, the area of the house in square metres. Somewhat more specifically, the area of the finished above-ground residential portion of the house where the ceiling is of adequate height.</Definition>
		<Reference URL="http://tlc.howstuffworks.com/home/measure-square-footage.htm" Name="How Stuff Works"/>
	</Term>
	<Term Name="Folio">
		<Definition>A document such as a Land Title held by a Land Registry. A Folio is identified within a Volume by its Folio Number.</Definition>
		<RelatedTerm Name="Folio Number" Collection="lixi"/>
		<RelatedTerm Name="Volume" Collection="lixi"/>
		<RelatedTerm Name="Register Book" Collection="lixi"/>
	</Term>
	<Term Name="Folio Number">
		<Definition>The number used by the land registry to identify a Folio.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Folio" Collection="lixi"/>
	</Term>
	<Term Name="Forced Sale Days">
		<Definition>In an Asset Realization valuation, either the estimated or actual number of days to complete the forced sale of the property.</Definition>
	</Term>
	<Term Name="Forecast Standard Deviation" Abbr="FSD">
		<Definition>A measure of the confidence that an AVM provider has in the assessment that has been calculated. The FSD may be mapped into a confidence score or colours, 0-13% = green, 13-19% = yellow, 20+% = red.</Definition>
		<RelatedTerm Name="FSD" Collection="lixi"/>
	</Term>
	<Term Name="Formal Approval">
		<Definition/>
		<RelatedTerm Name="Unconditional Approval" Collection="lixi"/>
	</Term>
	<Term Name="Frame Stage">
		<Definition>A construction stage when a building's frame is finished.</Definition>
		<RelatedTerm Name="Walls Erected" Collection="lixi"/>
	</Term>
	<Term Name="Freehold">
		<Definition/>
		<Reference URL="http://www.dia.wa.gov.au/en/Land/Land-Facts/15-What-is-freehold-land/" Name="Freehold"/>
		<RelatedTerm Name="Estate in Fee Simple" Collection="lixi"/>
	</Term>
	<Term Name="Forecast Standard Deviation" Abbr="FSD">
		<Definition/>
		<RelatedTerm Name="Forecast Standard Deviation" Collection="lixi"/>
		<RelatedTerm Name="Confidence Score" Collection="lixi"/>
	</Term>
	<Term Name="Fulfilment">
		<Definition>Completion of an order or application. In the context of loans processing, the completion of the loan application, variation, or mortgage discharge.</Definition>
	</Term>
	<Term Name="Full Discharge">
		<Definition>When a lender discharges all mortgages associated with a loan.</Definition>
	</Term>
	<Term Name="Full Discharge Authority">
		<Definition>A signed authorisation provided by the loan parties to request the outgoing mortgagee to pay out the loan or loans and discharge the mortgage on the security property. This document is part of the process of a discharge transaction as well as a refinance.</Definition>
	</Term>
	<Term Name="Full Registered Valuation">
		<Definition>A "full" valuation including internal inspection.</Definition>
	</Term>
	<Term Name="Funding Position">
		<Definition>Is a combination of calculations to establish the total amount of funds required to purchase a property. A funding position includes costs such as the purchase price, duties and taxes, legal costs, building and pest reports, deposit available, first home owners grant if available, cost of lenders mortgage insurance if required and home loan application fees etc.</Definition>
	</Term>
	<Term Name="Funds Available">
		<Definition>Funds that a borrower knows at the time of application that they will have at the time of settlement that can be used to complete a transaction. Includes the prospective loan amount or limit increase (new limit less unpaid balance), FHOG, cash or equivalent, and the net proceeds of sale of other property.</Definition>
		<RelatedTerm Name="Funds To Complete" Collection="lixi"/>
	</Term>
	<Term Name="Funds Required">
		<Definition>The sum of purchase price less deposit paid, existing loan refinance (unpaid balance less new limit), other purpose amount (where lending purpose is not purchase of security or refinance of liability), bank fees, LMI fees, and government fees and charges.</Definition>
		<RelatedTerm Name="Funds To Complete" Collection="lixi"/>
		<RelatedTerm Name="Deposit" Collection="lixi"/>
	</Term>
	<Term Name="Funds To Complete">
		<Definition>The funds required to complete a purchase or refinance transaction in addition to the funds available, i.e. the difference between funds available and funds required, when that difference is negative.</Definition>
	</Term>
	<Term Name="Further Advance">
		<Definition/>
		<RelatedTerm Name="Principal increase" Collection="lixi"/>
	</Term>
	<Term Name="Garnishee Order">
		<Definition>Is a court order taken out by a creditor on a person's employer or banker for the deduction of funds from his wages or bank account to repay a debt.</Definition>
	</Term>
	<Term Name="General Lien">
		<Definition>A written document setting out a lender's right to retain property until a debt is paid. It includes Power of Attorney and other clauses generally contained in bank security forms.</Definition>
	</Term>
	<Term Name="Genuine Savings">
		<Definition>Available funds that have been genuinely saved out of earnings by the applicant over a period of time rather than accumulated by other means such as a gift or irregular earnings. Lenders have differing criteria as to precisely what constitutes genuine savings, however they will generally expect to see evidence of money being regularly put away as savings.</Definition>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
	</Term>
	<Term Name="Gift">
		<Definition>Money that has been received by one party from another with no expectation of repayment.</Definition>
		<RelatedTerm Name="Genuine Savings" Collection="lixi"/>
	</Term>
  <Term Name="Global Industry Classification Standard" Abbr="GICS">
		<Definition>A Global Industry Classification Standard code ("GICS" is a registered trademark) is used to classify the Sector, Industry Group, Industry and Sub-Industry of a business entity by the principal activity undertaken. The Global Industry Classification Standard was developed by commercial entities (MSCI Inc. and Standard &amp; Poor's Financial Services LLC).</Definition>
	</Term>
  <Term Name="Global Trade Item Number" Abbr="GTIN">
		<Definition>A Global Trade Item Number can be used to uniquely identify all trade items, with the specification maintained by GS1 (www.gs1.org).</Definition>
	</Term>
	<Term Name="Go Between Loan">
		<Definition>Bridging Loan.</Definition>
	</Term>
	<Term Name="Government Charges">
		<Definition>State and other government charges which may include transfer of land stamp duty, mortgage stamp duty, and transfer and mortgage registration fees.</Definition>
	</Term>
	<Term Name="Gross Income">
		<Definition>Income for a person before tax, superannuation or payroll deductions; or earnings of a company before tax.</Definition>
		<RelatedTerm Name="Income" Collection="lixi"/>
	</Term>
	<Term Name="Guarantee">
		<Definition>A form of surety for a loan where another person or entity (the Guarantor) promises to repay all or part of a loan (or loans) if the Borrower defaults. Typical examples include a family guarantee and a director guarantee. If the guarantee is for part of the loan it is called a limited guarantee. The guarantor may offer assets as security, and if so then all registered owners of the security must be guarantors. The requirements include: that a guarantee must be associated with one or more guarantors; that a guarantee must be associated with one or more loan details; that a guarantee may be associated with zero or more security assets; that a guarantee may have a guarantee limit; and that an application may include more than one guarantee.</Definition>
		<RelatedTerm Name="Surety" Collection="lixi"/>
		<RelatedTerm Name="Limited Guarantee" Collection="lixi"/>
		<RelatedTerm Name="Security guarantee" Collection="lixi"/>
		<RelatedTerm Name="Income guarantee" Collection="lixi"/>
		<RelatedTerm Name="Guarantor" Collection="lixi"/>
	</Term>
	<Term Name="Guarantor">
		<Definition>A person or entity who agrees to provide a guarantee for a borrower and/or who provides security for a loan, when the assets or income of an applicant are insufficient to meet the lenders assessment criteria.</Definition>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
		<RelatedTerm Name="Surety" Collection="lixi"/>
		<RelatedTerm Name="Mortgagor" Collection="lixi"/>
		<RelatedTerm Name="Loan Party" Collection="lixi"/>
	</Term>
	<Term Name="Household Expenditure Measure" Abbr="HEM">
		<Definition/>
		<RelatedTerm Name="Household Expenditure Measure" Collection="lixi"/>
	</Term>
	<Term Name="Henderson Poverty Index" Abbr="HPI">
		<Definition>A measure of basic living expenses Usage:</Definition>
		<RelatedTerm Name="HPI" Collection="lixi"/>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
	</Term>
	<Term Name="Holding Deposit">
		<Definition>A refundable deposit establishing the goodwill of the buyer to go ahead with the purchase.</Definition>
	</Term>
	<Term Name="Home Equity Loan">
		<Definition>A term loan or revolving line of credit provided to a borrower based on the equity in the security property.</Definition>
	</Term>
	<Term Name="Home Insurance">
		<Definition>The Borrower organizes this insurance to cover the house in the event of a fire. Contents Insurance is a separate insurance but is often taken out in conjunction with Home Insurance.</Definition>
	</Term>
	<Term Name="Home Loan">
		<Definition>A mortgage loan secured by residential property.</Definition>
		<RelatedTerm Name="Investment Home Loan" Collection="lixi"/>
		<RelatedTerm Name="All-in-one Loan Account" Collection="lixi"/>
	</Term>
	<Term Name="Honeymoon Rate">
		<Definition>Introductory Rate.</Definition>
	</Term>
	<Term Name="Household">
		<Definition>A person or a group of people living in the same residence. For loan assessment, the number of households represented by the loan parties is relevant to the calculation of total household expenses. See living allowance.</Definition>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
	</Term>
	<Term Name="Household Expenditure Measure" Abbr="HEM">
		<Definition>A measure of basic living expenses including cost of food, clothing, general motor vehicle expenses, rates, insurances, property maintenance/repairs, telephone, gas, electricity etc. Used in loan assessment as a replacement for the Henderson Poverty Index.</Definition>
		<Reference URL="http://www.homeloanexperts.com.au/blog/news/mortgage-lending-calculators-for-major-lenders-are-changing/" Name="homeloanexperts"/>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
		<RelatedTerm Name="HEM" Collection="lixi"/>
	</Term>
	<Term Name="Household Expenses">
		<Definition></Definition>
		<RelatedTerm Name="Living Expenses" Collection="lixi"/>
		<RelatedTerm Name="Expense Type" Collection="lixi"/>
	</Term>
	<Term Name="Henderson Poverty Index" Abbr="HPI">
		<Definition/>
		<RelatedTerm Name="Henderson Poverty Index" Collection="lixi"/>
	</Term>
	<Term Name="High Density Apartment">
		<Definition>An apartment that forms part of a development where the dwelling density of the development meets an arbitrary measurement above which is considered 'high density'.</Definition>
	</Term>
	<Term Name="Interest Coverage Ratio" Abbr="ICR">
		<Definition/>
		<RelatedTerm Name="Interest Coverage Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Identifier">
		<Definition>Metadata used to identify an entity or instance of a data object. May consist of a structured data field (generally characters or symbols) or a set of structured data fields, and may or may not have a characteristic of local or global uniqueness.</Definition>
		<RelatedTerm Name="Atomic Identifier" Collection="lixi"/>
		<RelatedTerm Name="Application Reference Number" Collection="lixi"/>
		<RelatedTerm Name="Customer ID" Collection="lixi"/>
	</Term>
	<Term Name="Impaired Credit Loan">
		<Definition>A loan where the credit history of the borrower does not meet the lending policy requirements of a conforming loan.</Definition>
		<RelatedTerm Name="Non-Conforming Loan" Collection="lixi"/>
	</Term>
	<Term Name="Improved Land">
		<Definition>A parcel of land that has sewerage, electricity and water already connected, but no established dwelling suitable for permanent occupancy.</Definition>
	</Term>
	<Term Name="In Arrears">
		<Definition>The status of a loan whereby the current balance less the scheduled balance is a positive number, and the effective number of days in arrears is the equivalent of 1 or more payments in arrears.</Definition>
		<RelatedTerm Name="Performing Loan" Collection="lixi"/>
		<RelatedTerm Name="Non-Performing Loan" Collection="lixi"/>
		<RelatedTerm Name="Arrears" Collection="lixi"/>
	</Term>
	<Term Name="Income">
		<Definition>Earnings for an individual or company over a specified period time, including salary or wages, overtime payments, interest and dividends, rental income etc. Income such as rental income or dividends may be apportioned to more than one party if they jointly own the income-producing asset. Income is generally recorded as either gross (before tax) or net (after tax)</Definition>
		<RelatedTerm Name="Uncommitted Income" Collection="lixi"/>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
	</Term>
	<Term Name="Income guarantee">
		<Definition>A type of guarantee where the guarantor pledges their income to be used to help to make the repayments.</Definition>
	</Term>
	<Term Name="Income Protection Insurance">
		<Definition>Insurance taken out by a borrower to ensure they have sufficient cash flow to meet their home loan repayments in the event of sickness or loss of employment.</Definition>
		<RelatedTerm Name="Mortgage Protection Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Incoming Mortgagee">
		<Definition>A mortgagee that is taking a new mortgage, for instance a lender that is providing funds to purchase a property.</Definition>
	</Term>
	<Term Name="Incorporated Association">
		<Definition>A member-based not-for-profit corporate body with legal status. Incorporated associations are registered by the State or Territory in which the association is based.</Definition>
	</Term>
	<Term Name="Incorrect Payment Clawback">
		<Definition>A commission clawback when the original commission payment was in error.</Definition>
		<RelatedTerm Name="Clawback" Collection="lixi"/>
	</Term>
	<Term Name="Indemnity">
		<Definition>Is security against damage or loss. A sum paid in compensation for loss incurred. Instalment is a regular repayment that the borrower makes to pay off a home loan. These repayments will typically be made at monthly, fortnightly or weekly intervals.</Definition>
	</Term>
	<Term Name="Indicative Approval">
		<Definition>An application status provided by a lender for a loan application, based on limited assessment such as serviceability but not a credit report. A lender may use this approval to send the interest rate on a non-conforming loan application to the borrower.</Definition>
	</Term>
	<Term Name="Individual">
		<Definition>Person.</Definition>
	</Term>
	<Term Name="Inertia Payment">
		<Definition>Inertia Payments are the continuation of normal payments on an operating lease or rental agreement after the contract term has expired.</Definition>
	</Term>
	<Term Name="Instalment">
		<Definition>Periodic Repayment.</Definition>
	</Term>
	<Term Name="Instrument">
		<Definition>A formal legal document in writing such as a deed of conveyance.</Definition>
	</Term>
	<Term Name="Insurance">
		<Definition>A form of contract that provides compensation for specific losses in exchange for a fee.</Definition>
	</Term>
	<Term Name="Insurance Premium">
		<Definition>The fee for obtaining insurance.</Definition>
		<RelatedTerm Name="Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Interest">
		<Definition>The Lender's charge for the use of funds; or the return on deposited funds.</Definition>
		<RelatedTerm Name="Daily Interest" Collection="lixi"/>
	</Term>
	<Term Name="Interest Capitalisation">
		<Definition>Capitalised Interest.</Definition>
	</Term>
	<Term Name="Interest Coverage Ratio" Abbr="ICR">
		<Definition>ICR is a measure of how easily a company can pay interest expenses on outstanding debt. Interest coverage ratio over a specified time period is calculated as EBIT divided by interest expenses.</Definition>
		<RelatedTerm Name="ICR" Collection="lixi"/>
	</Term>
	<Term Name="Interest in Advance">
		<Definition>An arrangement to pay interest on a loan before it has been accrued.</Definition>
		<RelatedTerm Name="Repayment Type" Collection="lixi"/>
	</Term>
	<Term Name="Interest in Land">
		<Definition>A Proprietorship that is of a right in land other than an Estate, such as a Mortgage, Lease, Easement, Covenant etc.</Definition>
		<RelatedTerm Name="Encumbrance" Collection="lixi"/>
		<RelatedTerm Name="Estate" Collection="lixi"/>
		<RelatedTerm Name="Proprietor" Collection="lixi"/>
	</Term>
	<Term Name="Interest Only Loan">
		<Definition>A loan agreement requiring the borrower to make periodic repayments solely of the interest due rather than on a combination of principal and interest. This is generally only used for business or investment home loans, and the period of interest only repayments is usually set from between 1 to 5 years.</Definition>
	</Term>
	<Term Name="Interest Only Repayment">
		<Definition>A periodic repayment on a loan which only covers interest charges, with no reduction of the principal loan amount.</Definition>
		<RelatedTerm Name="Principal and Interest Repayment" Collection="lixi"/>
		<RelatedTerm Name="Repayment" Collection="lixi"/>
		<RelatedTerm Name="Periodic Repayment" Collection="lixi"/>
		<RelatedTerm Name="Repayment Type" Collection="lixi"/>
	</Term>
	<Term Name="Interest Only Term">
		<Definition>The contracted term (generally in months or years) that interest only repayments are applicable. At the end of the interest only term, the repayment type will usually convert to principal and interest.</Definition>
		<RelatedTerm Name="Loan Term" Collection="lixi"/>
	</Term>
	<Term Name="Interest Rate">
		<Definition>The cost of borrowing money, or the return on invested money, expressed as a percentage of the amount borrowed or invested over a defined period, usually one year. The interest rate type can be fixed or variable.</Definition>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
	</Term>
	<Term Name="Interest Rate Discount Margin">
		<Definition>The margin at which a 'normal' interest rate may be discounted for a specified customer or purpose. The margin is always relative to another interest rate.</Definition>
		<RelatedTerm Name="Discounted Interest Rate" Collection="lixi"/>
	</Term>
	<Term Name="Interest Rate Type">
		<Definition>A characteristic of an interest rate, including variable, fixed, or capped.</Definition>
	</Term>
	<Term Name="Internal Rate of Return">
		<Definition>A measure of the return on an investment which denotes the rate of interest at which the present value of future cash flows is equal to the cost of the investment or loan.</Definition>
	</Term>
	<Term Name="Internet Banking">
		<Definition>The use of the internet to access bank account details, or to perform actions related to those bank accounts, such as viewing balances and transaction history, transferring money, making payments.</Definition>
	</Term>
	<Term Name="Introductory Rate">
		<Definition>A reduced interest rate (often called a honeymoon rate) offered for an introductory period such as the first year of a home loan. After the introductory period the loan will revert to a standard (higher) rate.</Definition>
		<RelatedTerm Name="Discounted Interest Rate" Collection="lixi"/>
		<RelatedTerm Name="Honeymoon Rate" Collection="lixi"/>
	</Term>
	<Term Name="Investment Home Loan">
		<Definition>A home loan where the security property is an investment rather than being owner occupied.</Definition>
		<RelatedTerm Name="Company Home Loan" Collection="lixi"/>
		<RelatedTerm Name="Regulated Loan" Collection="lixi"/>
		<RelatedTerm Name="Residential Investment Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Investment Property">
		<Definition>A property that is not occupied by the owner, usually purchased for the sole purpose of earning a return on the investment in the form of rent and/or capital gain.</Definition>
	</Term>
	<Term Name="Irregular Shaped Allotment">
		<Definition>An allotment which is not a regular shaped allotment.</Definition>
		<Reference URL="http://www.blacktown.nsw.gov.au/shadomx/apps/fms/fmsdownload.cfm?file_uuid=C1BD14A9-F26E-BD6F-C5EA-BCD769597035&amp;siteName=blacktown" Name="NSW"/>
	</Term>
	<Term Name="Joint Tenancy">
		<Definition>A Tenancy that consists of proprietorship of undivided property jointly with another or others such that the Joint Tenants can act and be treated as if they are one Proprietor, and where the legal title or right in the property on the death of a Joint Tenant passes to the surviving Joint Tenants in the same Joint Tenancy.</Definition>
		<Reference URL="http://files.lixi.org.au/glossary/NECS_Vocab_v1.4.html" Name="NECS Vocab"/>
		<RelatedTerm Name="Tenancy" Collection="lixi"/>
		<RelatedTerm Name="Joint Tenant" Collection="lixi"/>
	</Term>
	<Term Name="Joint Tenant">
		<Definition>A tenant in a joint tenancy.</Definition>
		<Reference URL="http://files.lixi.org.au/glossary/NECS_Vocab_v1.4.html" Name="NECS Vocab"/>
		<RelatedTerm Name="Joint Tenancy" Collection="lixi"/>
	</Term>
	<Term Name="Kangaroo Bond">
		<Definition>Bonds issued by non-residents into the Australian capital markets, denominated in Australian dollars. The kangaroo bond market is generally served by high-credit quality (typically AAA-rated) issuers, and has been entirely comprised of sovereign, supranational or major financial institutions in recent times.</Definition>
	</Term>
	<Term Name="Kerb-side Valuation">
		<Definition>Restricted Access Assessment.</Definition>
	</Term>
	<Term Name="Kit Home">
		<Definition>A house where most of the components of the home are prefabricated and are brought to your property where it is assembled.</Definition>
	</Term>
	<Term Name="Land Registry">
		<Definition>A Government Body that is responsible for administering a Torrens Title Register for a Jurisdiction.</Definition>
		<RelatedTerm Name="Land Titles Office" Collection="lixi"/>
		<RelatedTerm Name="Writ" Collection="lixi"/>
		<RelatedTerm Name="Titles Office" Collection="lixi"/>
		<RelatedTerm Name="Folio" Collection="lixi"/>
		<RelatedTerm Name="Torrens Title Register" Collection="lixi"/>
		<RelatedTerm Name="Constraint" Collection="lixi"/>
		<RelatedTerm Name="Lot and Plan" Collection="lixi"/>
	</Term>
	<Term Name="Land Tax">
		<Definition>Based on the property value, it is a state government tax payable by the owners of the property. Exemptions may apply in some states.</Definition>
	</Term>
	<Term Name="Land Title">
		<Definition>An authoritative record that is held in a Torrens Title Register and records a description of a specific quantum of land, any stratum above or below that land, details of each Estate, each Registered Proprietor of an Estate, and any Interest in Land or other matters affecting that land.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Encumbrance" Collection="lixi"/>
		<RelatedTerm Name="Title" Collection="lixi"/>
		<RelatedTerm Name="Whole" Collection="lixi"/>
		<RelatedTerm Name="Folio" Collection="lixi"/>
		<RelatedTerm Name="Title Search" Collection="lixi"/>
		<RelatedTerm Name="Certificate of Title" Collection="lixi"/>
		<RelatedTerm Name="Constraint" Collection="lixi"/>
		<RelatedTerm Name="Register Book" Collection="lixi"/>
	</Term>
	<Term Name="Land Titles Office">
		<Definition>Land Registry.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
	</Term>
	<Term Name="Linked Bank Account" Abbr="LBA">
		<Definition/>
		<RelatedTerm Name="Linked Bank Account" Collection="lixi"/>
	</Term>
	<Term Name="Legal Fee">
		<Definition>May be incurred in the case of an outside party being used to prepare bank documentation.</Definition>
	</Term>
	<Term Name="Lender">
		<Definition>A party that lends funds, generally a bank, credit union or building society.</Definition>
		<RelatedTerm Name="Lender's Mortgage Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Lenders Mortgage Insurance" Abbr="LMI">
		<Definition>Insurance to protect the lender against financial loss in the case when a borrower defaults on a home loan and the proceeds from the sale of the security property do not cover the unpaid loan balance and related expenses. For moderate LVR loans (e.g. under 80%), if the lender takes out LMI the lender does not charge a fee to the borrower. For higher LVR loans the lender will usually charge the borrower an LMI Fee.</Definition>
		<RelatedTerm Name="Mortgage Insurance" Collection="lixi"/>
		<RelatedTerm Name="LMI" Collection="lixi"/>
	</Term>
	<Term Name="Lending Policy">
		<Definition>Credit Policy.</Definition>
		<RelatedTerm Name="Assessment Metric" Collection="lixi"/>
		<RelatedTerm Name="Impaired Credit Loan" Collection="lixi"/>
	</Term>
	<Term Name="Lending Purpose">
		<Definition>The specific purpose that loaned funds will be used for by the borrower, indicated in CAL by the lending purpose code. May be associated with a Purpose Amount.</Definition>
		<RelatedTerm Name="Equity Loan" Collection="lixi"/>
		<RelatedTerm Name="Purpose Amount" Collection="lixi"/>
		<RelatedTerm Name="Loan Primary Purpose" Collection="lixi"/>
		<RelatedTerm Name="Lending Purpose Code" Collection="lixi"/>
		<RelatedTerm Name="Renovation Loan" Collection="lixi"/>
	</Term>
	<Term Name="Lending Purpose Code">
		<Definition>A specific code used as the enumeration of a lending purpose, originally derived from the data field ID of the ABS lending reporting forms.</Definition>
		<Reference URL="http://lixi.org.au/sites/default/files/LendingPurposes.xml" Name="ABS codes"/>
		<RelatedTerm Name="Lending Purpose" Collection="lixi"/>
	</Term>
	<Term Name="Liability">
		<Definition>A debt or other financial obligation. Examples include home loans, personal loans, hire purchases, credit facilities etc.</Definition>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="Expense" Collection="lixi"/>
		<RelatedTerm Name="Expense" Collection="lixi"/>
	</Term>
	<Term Name="Liability Amount">
		<Definition>The amount that a borrower is liable for in relation to a credit facility. For the calculation of serviceability, the value of the liability for a revolving credit facility may be assumed to be the credit limit, for other debts the value of the liability is generally the outstanding account balance. For a loan account with a redraw facility, the liability amount will be the account balance plus the available funds.</Definition>
	</Term>
	<Term Name="Lien">
		<Definition>A legal claim related to a financial liability and noted on a property title.</Definition>
	</Term>
	<Term Name="Limit Decrease">
		<Definition>Decrease of approved limit of a single loan account, reducing the funds available to the borrower within the account.</Definition>
	</Term>
	<Term Name="Limit Increase">
		<Definition>Increase of approved limit of a single loan account, increasing the funds available to the borrower within the account.</Definition>
	</Term>
	<Term Name="Limited Guarantee">
		<Definition>A guarantee provided by a guarantor that is limited to be no greater than a specified amount, that amount being less than the loan amount.</Definition>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
		<RelatedTerm Name="Family guarantee" Collection="lixi"/>
	</Term>
  <Term Name="Loan Condition">
		<Definition>A loan condition is issued when the lender requires additional information in order to process a loan application.</Definition>
	</Term>
  <Term Name="Loan Covenant">
		<Definition>A condition on a financial product that requires the borrower fulfill certain conditions, forbids certain actions, or restricts certain activities.</Definition>
	</Term>
	<Term Name="Loan Identification Number Code" Abbr="LINC">
		<Definition/>
		<RelatedTerm Name="Loan Identification Number Code" Collection="lixi"/>
	</Term>
	<Term Name="Line of Credit" Abbr="LOC">
		<Definition>A type of secured loan in the form of a revolving credit facility.</Definition>
		<RelatedTerm Name="Equity Loan" Collection="lixi"/>
		<RelatedTerm Name="Revolving Line of Credit" Collection="lixi"/>
		<RelatedTerm Name="LOC" Collection="lixi"/>
		<RelatedTerm Name="Continuing Credit Contract" Collection="lixi"/>
	</Term>
	<Term Name="Linked Bank Account" Abbr="LBA">
		<Definition>A transaction account that is linked to another facility such as a loan account, term deposit account or share trading account, being the account from which funds or repayments can be drawn and to which disbursements or other funds can be transferred. The linking may involve a direct debit agreement to permit the drawing of funds.</Definition>
		<RelatedTerm Name="LBA" Collection="lixi"/>
	</Term>
	<Term Name="Linked Loans">
		<Definition>An arrangement of separate home, investment and/or business loan facilities where the repayment arrangements are linked.</Definition>
		<Reference URL="http://www.ato.gov.au/corporate/content.asp?doc=/content/00106851.htm" Name="ATO"/>
	</Term>
	<Term Name="Liquid Asset">
		<Definition>An asset readily convertible to cash.</Definition>
	</Term>
	<Term Name="Living Allowance">
		<Definition>An estimation of the basic cost of living used by lenders as part of credit assessment and taking into account the number of households, adults and children. The baseline figure is calculated from the Henderson Poverty Index or the more recent Household Expenditure Method, although lenders may use the borrower-provided basic living expenses if higher.</Definition>
		<RelatedTerm Name="Household" Collection="lixi"/>
		<RelatedTerm Name="Expense" Collection="lixi"/>
		<RelatedTerm Name="Living Expenses" Collection="lixi"/>
	</Term>
	<Term Name="Living Expenses">
		<Definition>Recurring expenses associated with the cost of living, as opposed to expenses such as loan repayments, credit card repayments, or rent. Living expenses can be categorised as 'basic' - such as food, transport, electricity and primary and secondary public education - or 'discretionary' - such as domestic holidays, restaurant and takeaway food, and adult clothing. For serviceability calculation, living expenses may be estimated using the Henderson Poverty Index or Household Expenditure Method. Note that other living expenses such as private school fees and ongoing medical expenses are not generally included as "living" expenses in serviceability calculations.</Definition>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
		<RelatedTerm Name="Household Expenses" Collection="lixi"/>
		<RelatedTerm Name="Henderson Poverty Index" Collection="lixi"/>
		<RelatedTerm Name="Living Allowance" Collection="lixi"/>
		<RelatedTerm Name="Household Expenditure Measure" Collection="lixi"/>
	</Term>
	<Term Name="Lender's Mortgage Insurance" Abbr="LMI">
		<Definition/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
		<RelatedTerm Name="Lender's Mortgage Insurance" Collection="lixi"/>
		<RelatedTerm Name="LMI Fee" Collection="lixi"/>
	</Term>
	<Term Name="LMI Fee">
		<Definition>The insurance premium for LMI charged to the borrower. The premium amount depends on variables such as the loan amount, the value of the asset and the exact Loan to Value Ratio and is a one-off payment usually made at the time of settlement.</Definition>
		<RelatedTerm Name="Total Loan Amount not including LMI" Collection="lixi"/>
		<RelatedTerm Name="Lender's Mortgage Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Lo-doc" Abbr="Lo-doc">
		<Definition>Low Doc Loan.</Definition>
		<RelatedTerm Name="Non-Conforming Loan" Collection="lixi"/>
	</Term>
	<Term Name="Loan">
		<Definition>An advance of funds from a lender to a borrower on the agreement that the borrower pays interest on the loan as well as the principal loan amount on an agreed date or over an agreed time period and schedule.</Definition>
		<RelatedTerm Name="Credit Facility" Collection="lixi"/>
		<RelatedTerm Name="Loan Account" Collection="lixi"/>
		<RelatedTerm Name="Full Discharge" Collection="lixi"/>
		<RelatedTerm Name="Borrower" Collection="lixi"/>
	</Term>
	<Term Name="Loan Account">
		<Definition>An individual Account that is associated with a Loan.</Definition>
		<RelatedTerm Name="Deposit Account" Collection="lixi"/>
		<RelatedTerm Name="Additional Borrower" Collection="lixi"/>
		<RelatedTerm Name="Limit Decrease" Collection="lixi"/>
		<RelatedTerm Name="Additional Guarantor" Collection="lixi"/>
		<RelatedTerm Name="Limit Increase" Collection="lixi"/>
		<RelatedTerm Name="Settled Amount" Collection="lixi"/>
		<RelatedTerm Name="Opening Balance" Collection="lixi"/>
	</Term>
	<Term Name="Loan Account Consolidation">
		<Definition>Decreasing the number of loan accounts with the same lender, while retain the same borrowing limit across those accounts.</Definition>
		<RelatedTerm Name="Consolidation" Collection="lixi"/>
	</Term>
	<Term Name="Loan Administration Fee">
		<Definition>A recurring (usually monthly) fee charged by a lender for maintaining and administering a home loan.</Definition>
		<RelatedTerm Name="Ongoing Fee" Collection="lixi"/>
		<RelatedTerm Name="Annual Fee" Collection="lixi"/>
		<RelatedTerm Name="Administration Fee" Collection="lixi"/>
		<RelatedTerm Name="Loan Maintenance Fee" Collection="lixi"/>
		<RelatedTerm Name="Service Fee" Collection="lixi"/>
		<RelatedTerm Name="Monthly Fee" Collection="lixi"/>
	</Term>
	<Term Name="Loan Approval Fee">
		<Definition>A fee charged by the lender to process a home loan application. Some lenders may waive or reduce this fee for certain products.</Definition>
	</Term>
	<Term Name="Loan Contract">
		<Definition>A legally binding written agreement between a lender and a borrower outlining the terms and conditions for the loan.</Definition>
	</Term>
	<Term Name="Loan Identification Number Code" Abbr="LINC">
		<Definition>An industry-wide internationally unique loan identification code developed by the American Securitization Forum to provide increased disclosure and transparency to the U.S. residential and asset-backed securities marketplace. They do not replace lender loan identifiers, but will be associated with them. The LINC code comprises a loan type, country code, establishment date, and a random ID sequence, provided by Standard &amp; Poor's FIRMS service.</Definition>
		<Reference URL="http://www.americansecuritization.com/story.aspx?id=3623" Name="American Securitization"/>
		<RelatedTerm Name="LINC" Collection="lixi"/>
	</Term>
	<Term Name="Loan Maintenance Fee">
		<Definition/>
		<RelatedTerm Name="Loan Administration Fee" Collection="lixi"/>
	</Term>
	<Term Name="Loan Party">
		<Definition>A party to a loan or to an application for a loan, being either a Company or a Person, and being either a Borrower or a Guarantor.</Definition>
		<RelatedTerm Name="Party" Collection="lixi"/>
		<RelatedTerm Name="Full Discharge Authority" Collection="lixi"/>
		<RelatedTerm Name="Post-settlement Address" Collection="lixi"/>
	</Term>
	<Term Name="Loan Primary Purpose">
		<Definition>The primary purpose of a loan, specified in a manner compatible with the UCCC or NCCP including 'owner occupied', 'investment in residential property', 'investment in non-residential property', and 'business'. See also Lending Purpose.</Definition>
		<RelatedTerm Name="NCCP-Related Information" Collection="lixi"/>
	</Term>
	<Term Name="Loan Product">
		<Definition>Any form of facility for the provision of credit provided to debtors by a credit provider, denoting the rules by which the facility will operate.</Definition>
		<RelatedTerm Name="Product Feature" Collection="lixi"/>
		<RelatedTerm Name="Product" Collection="lixi"/>
	</Term>
	<Term Name="Loan Servicing">
		<Definition>The processes and actions around managing issues with, and changes to, loans and borrowers post-settlement.</Definition>
	</Term>
	<Term Name="Loan Statement">
		<Definition>Lenders are required to send out statements (at least once a year, but generally they do so more often) showing the interest accrued, the balance of the loan, and all payments made by the borrower.</Definition>
	</Term>
	<Term Name="Loan Surplus">
		<Definition/>
		<RelatedTerm Name="Surplus Funds" Collection="lixi"/>
	</Term>
	<Term Name="Loan Term">
		<Definition></Definition>
		<RelatedTerm Name="Total loan term" Collection="lixi"/>
		<RelatedTerm Name="fixed rate term" Collection="lixi"/>
		<RelatedTerm Name="interest only term" Collection="lixi"/>
		<RelatedTerm Name="Balloon Repayment Loan" Collection="lixi"/>
		<RelatedTerm Name="Fixed Rate Loan" Collection="lixi"/>
		<RelatedTerm Name="Amortisation period" Collection="lixi"/>
		<RelatedTerm Name="Early Close Clawback" Collection="lixi"/>
	</Term>
	<Term Name="Loan Term Change">
		<Definition>A change of Interest Only term, Total Term and/or Fixed Rate Term of a loan.</Definition>
	</Term>
	<Term Name="Loan to Valuation Ratio" Abbr="LVR">
		<Definition>An assessment metric, being the measure of total lending amount to total security value. It is calculated by expressing the loan amount as a percentage of the security property value. For example, for a home loan application of $320,000 on a property worth $400,000, the LVR would be 80%. When there are multiple loans and/or multiple security properties, the totals of each are used in the calculation.</Definition>
	</Term>
	<Term Name="Loan to Value Ratio" Abbr="LVR">
		<Definition>An assessment metric, being the measure of total lending amount to total security value. It is calculated by expressing the loan amount as a percentage of the security property value. For example, for a home loan application of $320,000 on a property worth $400,000, the LVR would be 80%. When there are multiple loans and/or multiple security properties, the totals of each are used in the calculation.</Definition>
		<RelatedTerm Name="Maximum LVR" Collection="lixi"/>
		<RelatedTerm Name="LVR" Collection="lixi"/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
	</Term>
 	<Term Name="Loan Writer">
		<Definition>The individual that engages with a credit applicant in activities related to the provision of a credit product where that individual is either covered under a credit licence, or as an authorised representative of a credit licensee.</Definition>
	</Term>   
	<Term Name="LOC" Abbr="LOC">
		<Definition>Line of Credit.</Definition>
		<RelatedTerm Name="Line of Credit" Collection="lixi"/>
	</Term>
	<Term Name="Lock Up Stage">
		<Definition>Enclosed Stage.</Definition>
	</Term>
	<Term Name="Locked Rate">
		<Definition>Rate Lock.</Definition>
		<RelatedTerm Name="Rate Lock Fee" Collection="lixi"/>
	</Term>
	<Term Name="Lot">
		<Definition>A single parcel or separate connected parcels of land with a defined area that is defined by reference to a Registry Plan (not necessarily a Registry Plan of subdivision).</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
	</Term>
	<Term Name="Lot and Plan">
		<Definition>The identifier for a Registry Plan at a Land Registry.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
	</Term>
	<Term Name="Low Density Apartment">
		<Definition>An apartment that forms part of a development where the dwelling density of the development meets an arbitrary measurement which is considered 'low density'.</Definition>
	</Term>
	<Term Name="Low Deposit Home Loan">
		<Definition>A home loan that can be applied for with less than the normal 15 to 20% deposit amount. Low deposit home loans normally require either 5% non-genuine savings, this 5% can be a gift etc, or 3% genuine savings and the 3% generally needs to be proved as genuine savings by way of bank account statements etc demonstrating that the 3% has been saved over a period of time. Lenders Mortgage Insurance is required for low deposit home loans.</Definition>
	</Term>
	<Term Name="Low Doc Loan">
		<Definition>Low Documentation Loan: A type of non-conforming loan structured for borrowers such as self-employed persons or those who cannot provide or do not wish to provide evidence of employment such as payslips, but who have a clean credit history. Also referred to as "stated income" or "stated serviceability" loans. With such a loan the lender takes on more risk, and consequently interest rates are generally higher for these kinds of loans than for conventional (conforming) loans.</Definition>
		<RelatedTerm Name="Lo-doc" Collection="lixi"/>
	</Term>
	<Term Name="Lump Sum Building Contract">
		<Definition>A type of building contract that establishes the contract price at the outset. There may be adjustments to the contract price when there are variations to the original work, and where provisional sum and prime cost items are included.</Definition>
		<RelatedTerm Name="Building Construction Contract" Collection="lixi"/>
		<RelatedTerm Name="Fixed Price Building Contract" Collection="lixi"/>
	</Term>
	<Term Name="Loan to Value Ratio">
		<Definition/>
		<RelatedTerm Name="Technically In Arrears" Collection="lixi"/>
		<RelatedTerm Name="Loan to Value Ratio" Collection="lixi"/>
		<RelatedTerm Name="Lender's Mortgage Insurance" Collection="lixi"/>
		<RelatedTerm Name="Deposit" Collection="lixi"/>
	</Term>

	<Term Name="Managed Fund">
		<Definition>A managed fund is a managed investment scheme where the money of multiple investors is pooled together and invested by an investment manager.</Definition>
	</Term>

	<Term Name="Master Agreement Finance Facility" Abbr="MAFF">
		<Definition/>
		<RelatedTerm Name="Master Agreement Finance Facility" Collection="lixi"/>
	</Term>
	<Term Name="Marital Status">
		<Definition>The status of a person indicating whether the person is married. In the simplest sense, the only possible choices are "single" and "married", however either the person or the information recipient may prefer more specific detail so "de facto", "separated", "divorced", "widowed" etc are also normally permissible.</Definition>
	</Term>
	<Term Name="Market Risk Rating">
		<Definition>A component of Valuation, rating the risk of changing value associated with changes in the market. Related to but different from Property Risk Rating.</Definition>
		<RelatedTerm Name="Property Risk Rating" Collection="lixi"/>
	</Term>
	<Term Name="Market Value">
		<Definition>The estimated amount for which an asset should exchange on the valuation date between a willing buyer and a willing seller in an arm's length transaction, after proper marketing and where the parties had each acted knowledgeably, prudently and without compulsion.</Definition>
		<Reference URL="" Name=""/>
		<RelatedTerm Name="Market Value as if Complete" Collection="lixi"/>
	</Term>
	<Term Name="Market Value as if Complete">
		<Definition>The value of a property that is to-be-constructed or being constructed, estimated as though it were complete at the time of valuation.</Definition>
		<RelatedTerm Name="Costing Valuation" Collection="lixi"/>
	</Term>
	<Term Name="Master Agreement Finance Facility">
		<Definition>Abbreviation: MAFFIn lending finance, a Master Agreement finance facility is a contractual document under which supplementary agreements for loans can be executed. A Master Agreement may include a total authorised Master Facility Limit. A typical use is to obtain pre-approval of an upper limit of funds prior to the actual purchase of equipment, and when items are identified for purchase, a loan application is made to obtain the specific funds for those items within the umbrella master facility.</Definition>
		<RelatedTerm Name="Master Facility Limit" Collection="lixi"/>
		<RelatedTerm Name="Portfolio Loan Facility" Collection="lixi"/>
		<RelatedTerm Name="MAFF" Collection="lixi"/>
	</Term>
	<Term Name="Master Facility Limit">
		<Definition>The total authorised lending limit within a Master Agreement under which individual loans can be drawn, such that the total of all approved limits or outstanding loan balances should be no greater than the master facility limit.</Definition>
		<RelatedTerm Name="Master Agreement Finance Facility" Collection="lixi"/>
		<RelatedTerm Name="Portfolio Limit" Collection="lixi"/>
	</Term>
	<Term Name="Maturity">
		<Definition>The date the debt or investment must be paid in full.</Definition>
	</Term>
	<Term Name="Max Loan">
		<Definition/>
		<RelatedTerm Name="Borrowing Capacity" Collection="lixi"/>
	</Term>
	<Term Name="Maximum LVR">
		<Definition>The maximum loan to value ratio for which a lender will provide funding e.g. for a specific application or a specific loan product.</Definition>
	</Term>
	<Term Name="Maximum Rate Facility" Abbr="MRF">
		<Definition>The MRF enables you to place a 'cap' or maximum rate on all or part of a bank bill facility. On any rollover, if floating rates are above the maximum rate, you are protected and pay only the agreed maximum rate. When floating rates are below the maximum rate, then you pay that lower rate plus any premium applicable. In return for the protection offered by the cap and the flexibility to avail of lower rates, an MRF premium is payable. The premium can be amortised over the term of the facility increasing the rate paid on each rollover or if preferred, can be paid in one instalment up-front.</Definition>
		<Reference URL="http://www.anz.com/documents/FXOnline/MRF_1.pdf" Name="ANZ"/>
		<RelatedTerm Name="MRF" Collection="lixi"/>
	</Term>
	<Term Name="Median House Price">
		<Definition>The median house price is the middle price of all sales recorded in a particular suburb, postcode, city or state. If there were 99 sales in a particular suburb, in ascending order, the median would be number 50 on the list. It's commonly assumed that the median price is the same as the average price, but that's not the case. To calculate the average, you would add up the value of the 99 sales and divide the total by 99 (the number of sales).</Definition>
	</Term>
<Term Name="Medicare Levy Surcharge'">
		<Definition>The Medicare levy surcharge (MLS) is levied on Australian taxpayers who do not have an appropriate level of private hospital insurance and who earn above a certain income. It is paid in addition to the Medicare levy..</Definition>
	</Term>
	<Term Name="Medium Density Apartment">
		<Definition>An apartment that forms part of a development where the dwelling density of the development meets an arbitrary measurement which is considered 'medium density'.</Definition>
	</Term>
	<Term Name="Mere Mortgage">
		<Definition>An equitable mortgage that is not protected by a caveat.</Definition>
	</Term>
	<Term Name="Metadata">
		<Definition>Structured data which is associated with and describes other data, for instance the title and author of a document can be stored as metadata in conjunction with the document.</Definition>
		<Reference URL="http://en.wikipedia.org/wiki/Metadata" Name="Wikipedia"/>
	</Term>
	<Term Name="Minimum Monthly Repayment">
		<Definition>The minimum repayment specified in a loan contract for a term loan, calculated on a monthly repayment frequency, and sufficient to replay the principal and interest over the term. If the interest rate changes during the term, the lender may recalculate the minimum repayment.</Definition>
	</Term>
	<Term Name="Minor">
		<Definition>A person younger than 18 years of age.</Definition>
	</Term>
	<Term Name="Mobile Payment">
		<Definition>Payment for goods or services with a mobile device such as a phone or PDA. A remote mobile payment is when the retailer is remote from the mobile customer, a point of sale or proximity mobile payment is when the customer is physically at the retail location.</Definition>
	</Term>
	<Term Name="Monthly Fee">
		<Definition>A fee such as a loan administration fee that is charged monthly.</Definition>
	</Term>
	<Term Name="Mortgage">
		<Definition>A security interest over a property or properties, generally to a creditor (the mortgagee) as security for a mortgage loan. The mortgagee then has a legal or equitable interest in, or charge over real or personal property as security for a liability, giving some rights over the security if the mortgagor defaults on the loan.</Definition>
		<RelatedTerm Name="Security Substitution" Collection="lixi"/>
		<RelatedTerm Name="Mortgagor" Collection="lixi"/>
		<RelatedTerm Name="Discharge" Collection="lixi"/>
		<RelatedTerm Name="Mortgagee" Collection="lixi"/>
		<RelatedTerm Name="Incoming Mortgagee" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Loan" Collection="lixi"/>
		<RelatedTerm Name="Fast Refinance" Collection="lixi"/>
		<RelatedTerm Name="Registered Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Mortgage Aggregator">
		<Definition>A commercial entity that gives mortgage brokers access to a range of lenders and their products through some type of wholesale arrangement. In the context of LIXI, the term can include entities described as mortgage aggregators, dealer groups and franchise groups.</Definition>
	</Term>
	<Term Name="Mortgage Broker">
		<Definition>An entity that acts as an intermediary between a borrower and a lender that assists the borrower in obtaining a mortgage. In Australia, mortgage brokers operate under the National Consumer Credit Protection Act, requiring them to have their own credit licence or to operate as a representative of another entity that holds a credit licence.</Definition>
	</Term>
	<Term Name="Mortgage Document">
		<Definition>A document or documents setting out the terms of a mortgage by reference to which the mortgage is created, acknowledging, evidencing or recording a legal or equitable interest in, or charge over real or personal property as security for a liability. Although the mortgage document does not normally specify the relationship between the loan and the mortgage (although it can), there is a contractual relationship that is relevant, for example in the case of a refinance.</Definition>
	</Term>
	<Term Name="Mortgage Insurance">
		<Definition>Insurance to protect the lender against financial loss in the case when a borrower defaults on a home loan and the proceeds from the sale of the security property do not cover the unpaid loan balance and related expenses. For moderate LVR loans (e.g. under 80%), if the lender takes out LMI the lender does not charge a fee to the borrower. For higher LVR loans the lender will usually charge the borrower an LMI Fee.</Definition>
		<RelatedTerm Name="Lenders Mortgage Insurance" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Protection Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Mortgage Loan">
		<Definition>A type of secured loan where the security is provided by way of a mortgage.</Definition>
		<RelatedTerm Name="Equity Finance Mortgage Loan" Collection="lixi"/>
		<RelatedTerm Name="Trailing Commission" Collection="lixi"/>
		<RelatedTerm Name="Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Loan Account" Collection="lixi"/>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
	</Term>
	<Term Name="Mortgage Loan Account">
		<Definition>An Account specifically associated with a Mortgage Loan.</Definition>
	</Term>
	<Term Name="Mortgage Manager">
		<Definition>A mortgage manager is a mortgage specialist who organises funding for ordinary home buyers and property investors and retains the customer relationship for the duration of the loan.</Definition>
	</Term>
	<Term Name="Mortgage offset">
		<Definition>Offset accounts can help reduce your tax bill by offsetting taxable income from deposit accounts against interest paid in after tax dollars on mortgage repayments. However, not all offset accounts are equal, with many not paying the same interest as you are charged on your mortgage.</Definition>
	</Term>
	<Term Name="Mortgage Offset Account">
		<Definition>Offset Account.</Definition>
	</Term>
	<Term Name="Mortgage Originator">
		<Definition>An entity that works with a borrower, as an Authorised Representative, to complete a mortgage transaction. Mortgage originators typically have access to sell the complete suite of products offered to mortgage managers but they do not have the ability to approve an application. The product may be offered white labelled to the borrower. Credit assessment is performed by the lending institution. Mortgage Brokers typically do not have access to the complete suite of products offered by the lending institution, and do not have access to the white labelled products, instead selling the products branded by the lending institution.</Definition>
	</Term>
	<Term Name="Mortgage Protection Insurance">
		<Definition>Income Protection Insurance.</Definition>
		<RelatedTerm Name="Mortgage Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Mortgage Registration Fee">
		<Definition>Is a fee charged to register a mortgage with the State Government. Fees will vary from state to state. The fee will be part of the upfront settlement costs of a loan along with stamp duty, transfer fees etc.</Definition>
	</Term>
	<Term Name="Mortgage Stamp Duty">
		<Definition>This is a State Government tax on the loan amount, applicable to new mortgages as well as refinanced loans. The amount varies from state to state, with some states offering concessions for first home buyers. Mortgage stamp duty is calculated as a percentage of the purchase price. Mortgage stamp duty is separate from standard stamp duty, as it involves the registration of the mortgage itself, and not the property or land being purchased. Dependent upon state legislation, borrowers may be entitled to a reimbursement of previous Mortgage Stamp Duty paid on a property if they are increasing their loan on that property.</Definition>
		<RelatedTerm Name="Upstamp" Collection="lixi"/>
		<RelatedTerm Name="Stamp Duty" Collection="lixi"/>
		<RelatedTerm Name="Stamp Duty on a Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Mortgagee">
		<Definition>The party who holds a mortgage as security, generally the lender who provided funds for the loan being secured.</Definition>
		<RelatedTerm Name="Outgoing Mortgagee" Collection="lixi"/>
		<RelatedTerm Name="Incoming Mortgagee" Collection="lixi"/>
		<RelatedTerm Name="Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Document" Collection="lixi"/>
	</Term>
	<Term Name="Mortgagor">
		<Definition>The party who has provided property as security for a loan via a mortgage, generally the borrower or property owner (guarantor).</Definition>
		<RelatedTerm Name="Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Maximum Rate Facility" Abbr="MRF">
		<Definition/>
		<RelatedTerm Name="Maximum Rate Facility" Collection="lixi"/>
	</Term>
	<Term Name="Multi-Tier Market">
		<Definition></Definition>
		<RelatedTerm Name="two-tier marketing" Collection="lixi"/>
	</Term>
	<Term Name="National Consumer Credit Protection Act 2009" Abbr="NCCP">
		<Definition>Cth act to protect consumers in the context of the provision of credit, regulating credit providers and advisors (or assistants). Regulated loans include owner occupied and residential investment loans.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/index.html" Name="Austlii"/>
		<RelatedTerm Name="NCCP" Collection="lixi"/>
	</Term>
	<Term Name="National Credit Code">
		<Definition>Schedule 1 of the NCCP, at.</Definition>
	</Term>
	<Term Name="National Rental Affordability Scheme" Abbr="NRAS">
		<Definition>A Commonwealth Government initiative delivered in partnership with state and territory governments to increase new affordable rental housing supply. NRAS incentives are allocated to private sector and not-for-profit organisations to build new properties specifically targeted to low to moderate income earners with rents set at least 20 percent below local market rates for up to 10 years. NRAS provides a substantial annual incentive to persons or entities to build and rent new dwellings to low and moderate income household.</Definition>
		<Reference URL="http://www.dss.gov.au/our-responsibilities/housing-support/programs-services/national-rental-affordability-scheme" Name="Cth Dept of Social Services"/>
		<RelatedTerm Name="NRAS" Collection="lixi"/>
	</Term>
	<Term Name="Natural Person">
		<Definition>Person.</Definition>
		<RelatedTerm Name="Surname" Collection="lixi"/>
	</Term>
	<Term Name="National Consumer Credit Protection Act 2009" Abbr="NCCP">
		<Definition/>
		<RelatedTerm Name="Unregulated Loan" Collection="lixi"/>
		<RelatedTerm Name="UCCC" Collection="lixi"/>
		<RelatedTerm Name="Regulated Loan" Collection="lixi"/>
		<RelatedTerm Name="Owner Occupied" Collection="lixi"/>
		<RelatedTerm Name="National Consumer Credit Protection Act 2009" Collection="lixi"/>
		<RelatedTerm Name="National Credit Code" Collection="lixi"/>
	</Term>
	<Term Name="NCCP-Related Information">
		<Definition>Under the NCCP guidelines, Information about the consumer's financial situation, and their requirements and objectives. This includes loan primary purpose, refinance reason, and information related to the risk of substantial hardship.</Definition>
	</Term>
	<Term Name="Net Debt to Income Ratio" Abbr="NDI">
		<Definition/>
		<RelatedTerm Name="Assessment Metric" Collection="lixi"/>
		<RelatedTerm Name="Net Debt to Income Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Negative Amortisation" Abbr="NegAm">
		<Definition/>
		<RelatedTerm Name="Negative Amortisation" Collection="lixi"/>
	</Term>
	<Term Name="Negative Amortisation" Abbr="NegAm">
		<Definition>The situation when periodic repayments are less than the accrued interest. The unpaid interest is capitalised and the principal increases each payment period.</Definition>
		<RelatedTerm Name="NegAm" Collection="lixi"/>
	</Term>
	<Term Name="Negative Credit Reporting">
		<Definition>Reporting primarily on the "negative" aspects of credit history such as arrears and defaults.</Definition>
		<RelatedTerm Name="Negative Reporting" Collection="lixi"/>
		<RelatedTerm Name="Comprehensive Credit Reporting" Collection="lixi"/>
	</Term>
	<Term Name="Negative Gearing">
		<Definition>The circumstances when the costs to own and maintain an investment property (interest payments, rates, maintenance etc.) exceed the incoming rent on the property, and the loss is used to reduce net assessed income for taxation purposes.</Definition>
	</Term>
	<Term Name="Negative Reporting">
		<Definition>Negative Credit Reporting.</Definition>
	</Term>
	<Term Name="Net Debt to Income Ratio" Abbr="NDI">
		<Definition>An assessment metric. The ratio of a borrower's net disposable income to total assessed repayments for new debt. Most lenders target a minimum NDI between 1.1 and 1.25, i.e. the borrower should have more disposable income than required to service the proposed debt.</Definition>
		<RelatedTerm Name="NDI" Collection="lixi"/>
	</Term>
	<Term Name="Net Disposable Income">
		<Definition>Uncommitted Income.</Definition>
		<RelatedTerm Name="Net Debt to Income Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Net Income">
		<Definition>Money earned by a person or company, after tax. Gross income less tax.</Definition>
	</Term>
	<Term Name="Net Mortgage Book Flow">
		<Definition>A type of flow analysis, being the net change over a period of time for the value of a mortgage book in dollars.</Definition>
		<RelatedTerm Name="Net Mortgage Book Flow by Percent" Collection="lixi"/>
	</Term>
	<Term Name="Net Mortgage Book Flow by Percent">
		<Definition>A type of flow analysis, being the impact of the net mortgage book flow, displayed as a per cent.</Definition>
	</Term>
	<Term Name="Net Profit">
		<Definition>The pre-tax profit remaining in a business after all expenses have been taken out.</Definition>
	</Term>
	<Term Name="Net Surplus Ratio" Abbr="NSR">
		<Definition>An assessment metric. The ratio of all current and proposed expense commitments as a percentage of the borrower's net (after tax) income. The calculation will take into account whether a proposed loan has a tax implication. The figure required for loan approval varies on the circumstances, but in all cases will be &lt;= 1.</Definition>
		<RelatedTerm Name="NSR" Collection="lixi"/>
	</Term>
	<Term Name="New Balance">
		<Definition>For a loan account variation, the proposed account balance after the variation request has been processed.</Definition>
		<RelatedTerm Name="New Limit" Collection="lixi"/>
		<RelatedTerm Name="New Money" Collection="lixi"/>
	</Term>
	<Term Name="New Limit">
		<Definition>For an existing credit facility, a proposed new credit limit. This can be a credit limit increase, or a decreased limit such as a partial payout of an existing liability.</Definition>
		<RelatedTerm Name="New Money" Collection="lixi"/>
		<RelatedTerm Name="Funds Available" Collection="lixi"/>
		<RelatedTerm Name="Funds Required" Collection="lixi"/>
		<RelatedTerm Name="New Balance" Collection="lixi"/>
	</Term>
	<Term Name="New Money">
		<Definition>Funds that have been provided by a lender to a borrower in addition to existing loans. New Money may be in the form of a principal increase or in the form of a new or replacement loan.Funds that have been provided or made available to a borrower, extending an existing loan. New Money may be requested as a principal increase but may be provided via a replacement loan.</Definition>
		<RelatedTerm Name="Principal Increase" Collection="lixi"/>
		<RelatedTerm Name="New Limit" Collection="lixi"/>
		<RelatedTerm Name="New Balance" Collection="lixi"/>
	</Term>
	<Term Name="Newstart Allowance">
		<Definition>An income support payment that provides financial assistance to Australian citizens and Australian permanent residents, aged 22 years or older but under age pension age, who are unemployed or treated as unemployed (such as those in part time or casual employment below a threshold income level), and meeting other eligibility criteria.</Definition>
	</Term>
	<Term Name="Next Pay Loan">
		<Definition>A short-term unsecured loan advanced to a borrower who needs money for bills or unforeseen circumstances until they receive their next pay.</Definition>
		<RelatedTerm Name="Payday Loan" Collection="lixi"/>
	</Term>
	<Term Name="Nil Interest Visa Account" Abbr="NIVA">
		<Definition>A credit card where the credit balance is linked to a revolving loan such as a secured home loan line of credit. Credit on the card is not technically nil interest, but it occurs no interest penalty above the interest on the LOC.</Definition>
		<RelatedTerm Name="NIVA" Collection="lixi"/>
	</Term>
	<Term Name="Nil Interest Visa Account" Abbr="NIVA">
		<Definition/>
		<RelatedTerm Name="Nil Interest Visa Account" Collection="lixi"/>
	</Term>
	<Term Name="No Deposit Home Loan">
		<Definition>A home loan that enables purchasers to borrow 100% of the property value. With this type of home loan, an unblemished clean credit history and proof of good income and the ability to service the home loan is required. The interest rate for No Deposit Home Loans may also be higher than for a standard home loan.</Definition>
	</Term>
	<Term Name="No Doc Loan">
		<Definition>Similar to a low doc loan, but require no proof of income. Instead the borrower will be required to sign an agreement certifying that they will be able to service the home loan.</Definition>
		<RelatedTerm Name="Non-Conforming Loan" Collection="lixi"/>
	</Term>
	<Term Name="No Frills Home Loan">
		<Definition>Basic Home Loan.</Definition>
	</Term>
	<Term Name="Nominated Borrower">
		<Definition>A borrower or other entity nominated to receive documentation related to the loan application. There can be one nominated borrower, more than one, or all loan parties can be nominated.</Definition>
	</Term>
	<Term Name="Non-Conforming Loan">
		<Definition>A type of loan that caters for those who cannot meet the traditional income verification and/or credit history criteria which the mainstream lenders require. Low doc and no doc loans are examples of non-conforming loans, as are impaired credit loans. Non-conforming loans typically incur higher interest rates than conforming loans.</Definition>
		<RelatedTerm Name="Low Doc Loan" Collection="lixi"/>
		<RelatedTerm Name="Technically In Arrears" Collection="lixi"/>
		<RelatedTerm Name="Sub-prime Loan" Collection="lixi"/>
	</Term>
	<Term Name="Non-Cross Collateralised">
		<Definition>The situation when a borrower has more than one property securing more than one loan with a lender, but the securities are not cross-linked between the loans. See also cross collateralisation.</Definition>
	</Term>
	<Term Name="Non-Performing Loan">
		<Definition/>
		<RelatedTerm Name="In Arrears" Collection="lixi"/>
	</Term>
	<Term Name="National Rental Affordability Scheme" Abbr="NRAS">
		<Definition/>
		<RelatedTerm Name="National Rental Affordability Scheme" Collection="lixi"/>
	</Term>
	<Term Name="Net Surplus Ratio" Abbr="NSR">
		<Definition/>
		<RelatedTerm Name="Assessment Metric" Collection="lixi"/>
		<RelatedTerm Name="Net Surplus Ratio" Collection="lixi"/>
	</Term>
	<Term Name="Offer and Acceptance">
		<Definition/>
		<RelatedTerm Name="Offer and Acceptance" Collection="lixi"/>
	</Term>
	<Term Name="Occupancy Rate">
		<Definition>Percentage of currently rented units in a building, neighbourhood, complex, or city.</Definition>
	</Term>
	<Term Name="Off The Plan Purchase">
		<Definition>Buying a property from the plans only, prior to construction or completion. A contract for the purchase of the home on a proposed lot in an unregistered plan of a subdivision of land.</Definition>
		<RelatedTerm Name="Costing Valuation" Collection="lixi"/>
		<RelatedTerm Name="To Be Erected" Collection="lixi"/>
	</Term>
	<Term Name="Offer and Acceptance" Abbr="O&amp;A">
		<Definition>A binding form of contract where an offer (e.g. to purchase a property) is made in writing and the offer is accepted (e.g. by the owner) in writing.</Definition>
		<RelatedTerm Name="O&amp;A" Collection="lixi"/>
	</Term>
	<Term Name="Offset Account">
		<Definition>A transaction account which is linked to a loan account such that some or all of the balance in the transaction account 'offsets' the loan principal. Interest is then calculated on the loan principal minus the offset account balance. The reduction in interest is a tax-free benefit for the borrower.</Definition>
		<Reference URL="http://invested.com.au/71/offset-account-2489/" Name="InvestEd.com.au"/>
		<RelatedTerm Name="100% Offset Account" Collection="lixi"/>
		<RelatedTerm Name="Partial Offset Account" Collection="lixi"/>
		<RelatedTerm Name="100% Offset Account" Collection="lixi"/>
		<RelatedTerm Name="Offset Loan" Collection="lixi"/>
		<RelatedTerm Name="Partial Offset Account" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Offset Account" Collection="lixi"/>
		<RelatedTerm Name="All-in-one Loan Account" Collection="lixi"/>
	</Term>
	<Term Name="Offset Loan">
		<Definition/>
		<RelatedTerm Name="Offset Account" Collection="lixi"/>
	</Term>
	<Term Name="Old Title">
		<Definition>A paper title document from the era preceding the Torrens System.</Definition>
	</Term>
	<Term Name="Ombudsman">
		<Definition>The Australia banking industry ombudsman provides an avenue through which customers can make complaints about their bank and have them dealt with independently.</Definition>
	</Term>
	<Term Name="Ongoing Fee">
		<Definition/>
		<RelatedTerm Name="Loan Administration Fee" Collection="lixi"/>
	</Term>
  <Term Name="Online Channel">
		<Definition>A sales channel that delivers products or services to customers over the internet.</Definition>
	</Term>
	<Term Name="Opening Balance">
		<Definition>The loan balance at the time that the loan account is opened.The account balance as at the beginning date of a statement of account.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/sch1.html" Name="Austlii"/>
		<RelatedTerm Name="Statement of Account" Collection="lixi"/>
	</Term>
	<Term Name="Operating Authority">
		<Definition>The specification of the persons authorised to operate on an account with a lender. The lender may be authorised to accept and act on instructions from any borrower, or may to require all borrowers to act together.</Definition>
		<RelatedTerm Name="Account Holder" Collection="lixi"/>
	</Term>
	<Term Name="Operating Lease">
		<Definition>A leasing arrangement under which the lessor (the financier) own the leased asset and retains substantially all the risks and benefits incident to ownership of the asset including residual value, as distinct from a Finance Lease.</Definition>
		<RelatedTerm Name="Inertia Payment" Collection="lixi"/>
	</Term>
	<Term Name="Organisation">
		<Definition>An organised body such as a Company, Incorporated Association or Government Body.</Definition>
		<RelatedTerm Name="Party" Collection="lixi"/>
		<RelatedTerm Name="Company" Collection="lixi"/>
	</Term>
  <Term Name="Origination Date">
		<Definition>The date on which the credit product was funded, the liability was accrued, or the account was active for owners to access to make deposits and withdrawals as applicable.</Definition>
	</Term>
	<Term Name="Other Living Expenses">
		<Definition>Other expenses include other (neither basic nor discretionary) living expenses such as private education and tertiary education; life, health, plane, boat and income protection insurance; overseas holidays; medical expenses; pet purchase; and financial services and house or garden services; and general expenses (not household or living expenses) include rent; loan repayments; child maintenance; lease payments; and credit card, store card and debt repayment.</Definition>
		<RelatedTerm Name="Living Expenses" Collection="lixi"/>
	</Term>
	<Term Name="Outgoing Mortgagee">
		<Definition>A mortgagee that is discharging a mortgage, for instance a lender where the borrowed funds are being refinanced or otherwise paid back.</Definition>
		<RelatedTerm Name="Full Discharge Authority" Collection="lixi"/>
	</Term>
	<Term Name="Overdraft">
		<Definition>A facility to draw funds from an account in excess of the approved limit, or in the case of a deposit account to draw funds when there are no deposited funds.</Definition>
	</Term>
	<Term Name="Overpayment">
		<Definition>Loan repayment over and above the required periodic repayment amount. For example, if the required payment is $1,500 per month and the borrower makes payments of $2,000 per month, they are making $500 per month overpayments. Variable home loan products typically permit overpayment, fixed home loan products typically do not. Depending on the loan features, overpayments may reduce the principal or may be available to the borrower within a redraw facility.</Definition>
	</Term>
	<Term Name="Own Funds">
		<Definition></Definition>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
	</Term>
	<Term Name="Owner Builder">
		<Definition>An owner of land who builds a home or has a home built on their land without entering into a registered builder contract.</Definition>
	</Term>
	<Term Name="Owner Finance">
		<Definition>A property purchase transaction where the seller provides the financing.</Definition>
	</Term>
	<Term Name="Owner Occupied">
		<Definition>The circumstance when a property is the principal residence of the owner. If there are more than one owners, then at the property must be the principal residence of at least one. There are capital gains tax benefits that accrue to the owner. Owner occupied properties are regulated by the NCCP</Definition>
		<RelatedTerm Name="Investment Home Loan" Collection="lixi"/>
		<RelatedTerm Name="Regulated Loan" Collection="lixi"/>
	</Term>
	<Term Name="Owners Corporation">
		<Definition>Body Corporate.</Definition>
	</Term>
	<Term Name="Principal and Interest Repayment" Abbr="P&amp;I">
		<Definition/>
		<RelatedTerm Name="Principal and Interest Repayment" Collection="lixi"/>
	</Term>
	<Term Name="Partial Discharge">
		<Definition>Where more than one property secures one or more loans, and one of those securities is released (for example because it is sold or refinanced) without repaying all loan amounts.</Definition>
		<RelatedTerm Name="discharge" Collection="lixi"/>
	</Term>
	<Term Name="Partial Offset Account">
		<Definition>An Offset Account where some but not all of the account balance is used to offset the balance on the loan in order to reduce the calculated interest.</Definition>
		<RelatedTerm Name="Offset Account" Collection="lixi"/>
	</Term>
	<Term Name="Partially Secured">
		<Definition>Where an asset is provided as security for a loan, but the loan amount exceeds the value of the security, (thus the need for additional security).</Definition>
	</Term>
	<Term Name="Party">
		<Definition>Loosely, an Organisation or a Person. More specifically one who was, is, or may become party to something such as an agreement, transaction or relationship, for example a Loan Party.</Definition>
		<RelatedTerm Name="Party Type" Collection="lixi"/>
		<RelatedTerm Name="Encumbrance" Collection="lixi"/>
		<RelatedTerm Name="Gift" Collection="lixi"/>
		<RelatedTerm Name="Personal Details" Collection="lixi"/>
		<RelatedTerm Name="Transfer" Collection="lixi"/>
		<RelatedTerm Name="Account Holder" Collection="lixi"/>
		<RelatedTerm Name="Proprietor" Collection="lixi"/>
		<RelatedTerm Name="Existing Loan Party" Collection="lixi"/>
		<RelatedTerm Name="Transfer of Land" Collection="lixi"/>
		<RelatedTerm Name="Signatory" Collection="lixi"/>
	</Term>
	<Term Name="Party Type">
		<Definition>The characterisation of a Party within a specific context, such as a Person or Company, or as an Applicant or Guarantor.</Definition>
	</Term>
	<Term Name="Pay Down Amount">
		<Definition>An amount of money that is used to pay down the current balance of a liability account.</Definition>
	</Term>
	<Term Name="Payday Loan">
		<Definition>Next Pay Loan.</Definition>
	</Term>
	<Term Name="Payment Method">
		<Definition>Repayment Method.</Definition>
	</Term>
	<Term Name="Payout Figure">
		<Definition>The amount of money that would be required by a lender to repay and close a loan including the lender's closing fees and discharge fees.</Definition>
		<RelatedTerm Name="Final Payout Figure" Collection="lixi"/>
	</Term>
	<Term Name="Prime Cost Items" Abbr="PC Items">
		<Definition/>
	</Term>
	<Term Name="Peak Debt">
		<Definition>The maximum loan amount during the term of a loan (typically a bridging loan) taking into consideration initial loan amount, repayments, and capitalised interest.</Definition>
		<RelatedTerm Name="Bridging Loan" Collection="lixi"/>
	</Term>
<Term Name="Pension Account">
		<Definition>An account that uses some or all of your superannuation fund to provide you with an income when retired.</Definition>
	</Term>
	<Term Name="Per Diem Payment">
		<Definition>For a new loan, a partial period first repayment that is utilised to bring the scheduled payment date for the new loan to a specific anniversary date, typically a date in common with other loans.</Definition>
	</Term>
	<Term Name="Performing Loan">
		<Definition>A loan that is not in arrears.</Definition>
		<RelatedTerm Name="Trailing Commission" Collection="lixi"/>
		<RelatedTerm Name="Seriously In Arrears" Collection="lixi"/>
	</Term>
	<Term Name="Periodic Repayment">
		<Definition>A regularly scheduled payment towards a loan. The periodic repayment type can be principal and interest, or interest only.</Definition>
		<RelatedTerm Name="Repayment" Collection="lixi"/>
		<RelatedTerm Name="Instalment" Collection="lixi"/>
		<RelatedTerm Name="Additional Loan Repayment" Collection="lixi"/>
		<RelatedTerm Name="Interest Only Repayment" Collection="lixi"/>
		<RelatedTerm Name="Overpayment" Collection="lixi"/>
		<RelatedTerm Name="Interest Only Loan" Collection="lixi"/>
		<RelatedTerm Name="Balloon Repayment" Collection="lixi"/>
		<RelatedTerm Name="Negative Amortisation" Collection="lixi"/>
		<RelatedTerm Name="Structured Payments" Collection="lixi"/>
	</Term>
	<Term Name="Permanent Principal Reduction" Abbr="PPR">
		<Definition>A lump sum that is made to a loan account and is not available for redraw. The lump sum amount permanently reduces the principal amount owing.</Definition>
		<RelatedTerm Name="PPR" Collection="lixi"/>
	</Term>
	<Term Name="Person">
		<Definition>A natural living human.</Definition>
		<RelatedTerm Name="Individual" Collection="lixi"/>
		<RelatedTerm Name="Party" Collection="lixi"/>
		<RelatedTerm Name="Applicant" Collection="lixi"/>
		<RelatedTerm Name="Loan Party" Collection="lixi"/>
		<RelatedTerm Name="Natural Person" Collection="lixi"/>
		<RelatedTerm Name="Minor" Collection="lixi"/>
		<RelatedTerm Name="Date of Birth" Collection="lixi"/>
	</Term>
	<Term Name="Personal Details">
		<Definition>Characteristic details related to, or related to contacting, a Party.</Definition>
	</Term>
	<Term Name="Personal Financial Management">
		<Definition>PFMA class of online tools and services for money tracking, budgeting, and advice.</Definition>
		<RelatedTerm Name="PFM" Collection="lixi"/>
	</Term>
	<Term Name="Personal Loan">
		<Definition>Money borrowed to meet personal needs.</Definition>
	</Term>
	<Term Name="Personal Property">
		<Definition>Assets other than land that a person can own and for which ownership can be transferred. This includes tangible assets such as livestock, cars and artwork or intangible assets such as licences or copyright.</Definition>
		<RelatedTerm Name="Personal Property Security" Collection="lixi"/>
	</Term>
	<Term Name="Personal Property Securities Register" Abbr="PPSR">
		<Definition>A national online register that enables security interests in personal property to be recorded. The register can then be searched for a fee to determine if a piece of personal property has a security interest attached to it. The Australian PPSR is administered by the Australian Financial Security Authority, whilst the New Zealand PPSR is adminstered by the New Zealand Companies Office.</Definition>
	</Term>
	<Term Name="Personal Property Security">
		<Definition>An interest in personal property such as a motor vehicle that is held as security against the non-payment of a debt or claim.</Definition>
	</Term>
	<Term Name="Pest Report">
		<Definition>Is similar to a building report but carried out generally by a qualified person to check that the building is not infested and at risk of damage from any pests such as termites, white ants, rodents, borers etc.</Definition>
	</Term>
	<Term Name="Personal Financial Management" Abbr="PFM">
		<Definition/>
		<RelatedTerm Name="Personal Financial Management" Collection="lixi"/>
	</Term>
	<Term Name="Purchase Money Security Interest" Abbr="PMSI">
		<Definition/>
		<RelatedTerm Name="Purchase Money Security Interest" Collection="lixi"/>
	</Term>
	<Term Name="Policy Exception">
		<Definition>An instance where the application data does not sufficiently satisfy a specific requirement within the credit policy.</Definition>
	</Term>
	<Term Name="Portable Home Loan">
		<Definition>A loan feature that allows the borrower to sell a security property and provide a new one without having to refinance the loan or go through a full approval process. Such a feature saves some of the fees associated with setting up a loan, including application and legal fees, mortgage stamp duty, and early redemption costs. Typically lenders insist that the loan amount remains the same or less.</Definition>
	</Term>
	<Term Name="Portfolio Limit">
		<Definition>The total available credit limit across a portfolio loan facility. Similar to a master facility limit.</Definition>
	</Term>
	<Term Name="Portfolio Loan Facility">
		<Definition>A group of accounts at a single lender; associated with one or more borrowers and securities; which may or may not be cross-collateralised; and generally have some other common characteristics such as repayment arrangements or access to a line of credit. Examples include the St George Portfolio Loan and the NAB Portfolio Facility. Similar to a master agreement finance facility.</Definition>
		<RelatedTerm Name="Portfolio Limit" Collection="lixi"/>
	</Term>
	<Term Name="Portfolio Fund">
		<Definition>A portfolio fund is a special purpose vehicle (could be a trust or company) used in securitisation. Through the special purpose vehicle, loans are packaged against securities (bonds) that are sold into the capital markets. The funds raised from the issue of the bonds are used to acquire an interest in the portfolio of loans or other asset classes. The funds from the bond issue are used to repay the warehouse provider that provided the initial funds to originate the assets.</Definition>
		<RelatedTerm Name="Portfolio Limit" Collection="lixi"/>
	</Term>
	<Term Name="Positive Credit Reporting">
		<Definition/>
		<RelatedTerm Name="Comprehensive Credit Reporting" Collection="lixi"/>
	</Term>
	<Term Name="Positively Geared">
		<Definition>Occurs when the investment income exceeds your interest expense (and other possible deductions). For example, the rent you receive may be $1000 a month, but the monthly repayments are only $850. Note that this may be subject to additional tax on any income derived from a positively geared investment.</Definition>
	</Term>
	<Term Name="Post-settlement Address">
		<Definition>An address for a loan party that will be effective after settlement of the loan application or property transaction is complete, for instance the address of a purchased, owner-occupied property.</Definition>
	</Term>
	<Term Name="Power of Attorney">
		<Definition>A document which authorizes a person to act on behalf of another, to perform certain acts for the signer as if they were the signer such as handling their financial affairs.</Definition>
		<RelatedTerm Name="General Lien" Collection="lixi"/>
		<RelatedTerm Name="Attorney" Collection="lixi"/>
	</Term>
	<Term Name="Permanent Principal Reduction" Abbr="PPR">
		<Definition/>
		<RelatedTerm Name="Permanent Principal Reduction" Collection="lixi"/>
	</Term>
	<Term Name="Practical Completion">
		<Definition>A construction stage when the works have been completed in accordance with the building contract including all relevant statutory requirements apart from correction of minor defects or minor omissions. The property is suitable for habitation.</Definition>
	</Term>
	<Term Name="Pre-approval">
		<Definition>An application status provided by the lender giving in-principle approval of home loan finance before the prospective borrower has made an offer on a property, or perhaps even before looking for a property. This allows the borrower to make an offer on a property with the knowledge that they should be able to get home loan finance for the pre-approved amount, providing the circumstances have not changed and the property meets the lenders requirements.</Definition>
		<RelatedTerm Name="Approval in Principle" Collection="lixi"/>
	</Term>
	<Term Name="Prepayment">
		<Definition>Additional payment made to a fixed rate loan, in addition to the scheduled principal and interest repayments.</Definition>
	</Term>
	<Term Name="Prime Cost Item">
		<Definition>Prime Cost Items in a building contract are items that either have not been selected or whose price is not known at the time the contract is entered into, and for which the builder has made allowance in the contract price for cost of supply and delivery. Examples include white-goods, tap-ware and light fittings.</Definition>
		<Reference URL="http://hia.com.au/hia/content/Builder/region/National/classification/Workplace%20Services/Contracts/article/IS/WS/VIC_Provisional_Sum_Prime_Cost.aspx" Name="HIA"/>
		<RelatedTerm Name="Lump Sum Building Contract" Collection="lixi"/>
	</Term>
	<Term Name="Principal">
		<Definition>The capital sum upon which interest is charged. The principal decreases when principal repayments are made, and increases when interest is capitalised or additional funds are withdrawn.</Definition>
	</Term>
	<Term Name="Principal and Interest Loan">
		<Definition>A term loan utilising principal and interest repayments to enable the full debt plus interest and fees to be repaid within the agreed term.</Definition>
		<RelatedTerm Name="Reducing Loan" Collection="lixi"/>
		<RelatedTerm Name="Interest Only Loan" Collection="lixi"/>
	</Term>
	<Term Name="Principal and Interest Repayment" Abbr="P&amp;I">
		<Definition>A repayment structure on a loan in which both the principal and interest are paid during the term of the loan, unlike Interest Only Repayment.</Definition>
		<RelatedTerm Name="Repayment" Collection="lixi"/>
		<RelatedTerm Name="Term Loan" Collection="lixi"/>
		<RelatedTerm Name="P&amp;I" Collection="lixi"/>
		<RelatedTerm Name="Periodic Repayment" Collection="lixi"/>
		<RelatedTerm Name="Principal and Interest Loan" Collection="lixi"/>
		<RelatedTerm Name="Repayment Type" Collection="lixi"/>
	</Term>
	<Term Name="Principal Increase">
		<Definition>New Money provided into an existing loan account, where the approved limit or drawn amount is increased.</Definition>
		<RelatedTerm Name="Top Up" Collection="lixi"/>
		<RelatedTerm Name="Upstamp" Collection="lixi"/>
		<RelatedTerm Name="New Money" Collection="lixi"/>
		<RelatedTerm Name="New Money" Collection="lixi"/>
		<RelatedTerm Name="Further Advance" Collection="lixi"/>
		<RelatedTerm Name="Variation Type" Collection="lixi"/>
	</Term>
	<Term Name="Principal Place of Residence">
		<Definition>In any tax year, one property which has been (or, in the case of purchase, will be) continuously used and occupied by the owner (being a natural person) or any one of the joint owners of jointly owned land, for residential purposes and for no other purpose. Leeway is permitted as long as the property is not used for investment purposes and no other property is claimed at the same time to also be the principal residence.</Definition>
	</Term>
	<Term Name="Priority Amount">
		<Definition>A dollar amount that may be included in a mortgage document that sets the limit up to which the lender's funds may be recovered, ranking before any subsequent lender's funds. A mortgagee may establish a priority sum that is higher than the loan amount in order to recoup money owing to it including principal, interest and other costs.</Definition>
	</Term>
	<Term Name="Privacy Consent Form">
		<Definition>A form to be signed by each loan party acknowledging the purpose for which the lender will collect and use personal information; and providing consent to the lender to obtain a credit report and to disclose or exchange information with specified other parties.</Definition>
		<RelatedTerm Name="Credit Report" Collection="lixi"/>
	</Term>
	<Term Name="Professional Package" Abbr="Pro Pack">
		<Definition/>
		<RelatedTerm Name="Professional Package" Collection="lixi"/>
	</Term>
	<Term Name="Product">
		<Definition>Loan Product.</Definition>
	</Term>
	<Term Name="Product Conversion">
		<Definition>Changing the product that applies to a loan account to a different product at the same lender. For Example: Term Loan to a Line of Credit.</Definition>
		<RelatedTerm Name="Product Switch" Collection="lixi"/>
		<RelatedTerm Name="Product Swap" Collection="lixi"/>
		<RelatedTerm Name="Variation Type" Collection="lixi"/>
	</Term>
	<Term Name="Product Feature">
		<Definition>Characteristics of a loan product other than the product name and interest rate.</Definition>
	</Term>
	<Term Name="Product Feature Change">
		<Definition>Changing the election for a product feature from one setting to another.</Definition>
	</Term>
	<Term Name="Product Split">
		<Definition>Changing a loan from single loan product to two or more products, generally within the same approved limit.</Definition>
	</Term>
	<Term Name="Product Swap">
		<Definition></Definition>
		<RelatedTerm Name="Product Conversion" Collection="lixi"/>
	</Term>
	<Term Name="Product Switch">
		<Definition>Product Conversion.</Definition>
	</Term>
	<Term Name="Professional Package" Abbr="Pro Pack">
		<Definition>A home loan package with a discounted interest rate based on loan amount (often the total value of financial products at the lender) and possibly including other non-mortgage benefits such as a credit card. Discounts vary from as little as 0.15% to as high as 1.0% or more. Pro Packs often have a package fee structure distinctly different from the fee structure on standard loans.</Definition>
		<RelatedTerm Name="Pro Pack" Collection="lixi"/>
	</Term>
	<Term Name="Profit">
		<Definition>The positive gain from an investment or business operation after expenses.</Definition>
	</Term>
	<Term Name="Progress Draw">
		<Definition>Progress Payment.</Definition>
	</Term>
	<Term Name="Progress Inspection">
		<Definition>An inspection and valuation of a building under construction.</Definition>
		<RelatedTerm Name="Progress Payment" Collection="lixi"/>
	</Term>
	<Term Name="Progress Inspection Fees">
		<Definition>Fees to cover the cost of sending out an inspector before a progress payment is provided.</Definition>
	</Term>
	<Term Name="Progress Payment">
		<Definition>The sequence and dollar amount of progress. A tranche of funds provided from a loan at a specific stage of construction, e.g. on settlement of the land, on the slab being laid etc. up until construction is finished and the final draw down occurs, payments are usually agreed in advance, and the provision of the draw down may require receipt of builder's invoices and a progress inspection.</Definition>
		<RelatedTerm Name="Construction Loan" Collection="lixi"/>
		<RelatedTerm Name="Drawdown" Collection="lixi"/>
		<RelatedTerm Name="Progress Draw" Collection="lixi"/>
	</Term>
	<Term Name="Property">
		<Definition>Is a person's or entity's property and is "what is he or she owns to do what they like with." It may be tangible or intangible, and may be given a monetary value such as a house, car or goodwill. Property may be classed 'real' which relates to land or interests in land (except leaseholds) and buildings, etc or 'personal', which relates to other kinds of property such as cars, bank accounts, leasehold interests in land.</Definition>
	</Term>
	<Term Name="Property Portfolio">
		<Definition>Is the number and type of investment properties an investor owns.</Definition>
	</Term>
	<Term Name="Property Risk Rating">
		<Definition>A component of Valuation, rating the risk of changing value associated with the property. Related to but different from Market Risk Rating.</Definition>
		<RelatedTerm Name="Market Risk Rating" Collection="lixi"/>
	</Term>
	<Term Name="Proprietor">
		<Definition>A Party that is an owner of property; as regards land, the owner of an Estate or an Interest In LandThe owner(s) of a registered business name.</Definition>
		<RelatedTerm Name="Joint Tenancy" Collection="lixi"/>
		<RelatedTerm Name="Sole Tenancy" Collection="lixi"/>
		<RelatedTerm Name="Tenancy" Collection="lixi"/>
		<RelatedTerm Name="Business Name" Collection="lixi"/>
	</Term>
	<Term Name="Provisional Sum Item">
		<Definition>A provisional sum item in a building contract is used for work (including labour and materials) for which the builder cannot give a definite price at the time the contract is signed.  Common examples include landscaping, tiling and concreting. The builder will include an allowance for the work in the contract price.  This allowance includes GST if the contract price includes GST.</Definition>
		<Reference URL="http://hia.com.au/hia/content/Builder/region/National/classification/Workplace%20Services/Contracts/article/IS/WS/VIC_Provisional_Sum_Prime_Cost.aspx" Name="HIA"/>
		<RelatedTerm Name="Lump Sum Building Contract" Collection="lixi"/>
	</Term>
	<Term Name="Purchase Agreement">
		<Definition>Contract of Sale.</Definition>
	</Term>
	<Term Name="Purchase Money Security Interest" Abbr="PMSI">
		<Definition>A PMSI is a security interest in collateral that secures the assistance provided by the secured party to the grantor to enable their purchase or acquisition of rights in the collateral. It is a replacement concept for fixed and floating charge.</Definition>
		<Reference URL="https://www.ppsr.gov.au/purchase-money-security-interests" Name="PPSR"/>
		<RelatedTerm Name="PMSI" Collection="lixi"/>
	</Term>
	<Term Name="Purchaser">
		<Definition>A party purchasing property from a vendor.</Definition>
		<RelatedTerm Name="Deposit Bond" Collection="lixi"/>
		<RelatedTerm Name="Buyer" Collection="lixi"/>
		<RelatedTerm Name="Deposit (downpayment)" Collection="lixi"/>
		<RelatedTerm Name="Acceptance" Collection="lixi"/>
	</Term>
	<Term Name="Purpose Amount">
		<Definition>The amount of loan funds that will be used for the specified lending purpose. As an example, if $300,000 is borrowed to purchase a $400,000 house (with a $100,000 deposit), the purpose amount is $300,000.</Definition>
		<RelatedTerm Name="Lending Purpose" Collection="lixi"/>
		<RelatedTerm Name="Funds Required" Collection="lixi"/>
	</Term>
	<Term Name="Rate Lock">
		<Definition>The action of locking in the interest rate for a fixed rate product for a period of time, prior to settlement, typically at the then-current rate. The rate lock period only applies until the loan is actually settled, at which point the "locked" fixed rate is applied to the product. The rated is locked for a specified period (the rate lock period) after which it expires. A rate lock typically attracts a rate lock fee. OR: Where a lender, in exchange for a fee from the borrower, agrees to lock in an agreed fixed interest rate and term for the loan at the time of application. The duration or period of the Rate Lock can be up to funds drawdown (loan commencement or start date), when the locked in fixed rate and term apply, or for an agreed period, for example "x" months or until "y" date. Most banks negotiate the interest rate and term to apply, some customers agree to the advertised rate, but most negotiate, so what gets captured is fixed interest rate and term (either months/years from application date, drawdown date) or an agreed end date for the fixed rate period; plus fee amount and duration of the actual rate lock. This can be expressed as an agreed date, drawdown date or "x" days/weeks/months from application lodgement date.</Definition>
		<RelatedTerm Name="Locked Rate" Collection="lixi"/>
	</Term>
	<Term Name="Rate Lock Fee">
		<Definition>The fee associated with locking a fixed interest rate prior to settlement.</Definition>
		<RelatedTerm Name="Rate Lock" Collection="lixi"/>
		<RelatedTerm Name="Fee Payment Method" Collection="lixi"/>
	</Term>
	<Term Name="Reserve Bank of Australia" Abbr="RBA">
		<Definition/>
	</Term>
	<Term Name="Real Estate">
		<Definition>Property, consisting of land and all things affixed to it.</Definition>
		<RelatedTerm Name="Real Property" Collection="lixi"/>
	</Term>
	<Term Name="Real Property">
		<Definition>Real Estate.</Definition>
		<RelatedTerm Name="Writ" Collection="lixi"/>
		<RelatedTerm Name="Torrens Title Register" Collection="lixi"/>
	</Term>
	<Term Name="Real Time Gross Settlement">
		<Definition>Real time gross settlement is a process for funds transfer where transfer of money or securities takes place from one bank to another on a "real time" and on "gross" basis. Settlement in "real time" means payment transaction is not subjected to any waiting period. The transactions are settled as soon as they are processed. "Gross settlement" means the transaction is settled on one to one basis without bunching or netting with any other transaction. Once processed, payments are final and irrevocable.</Definition>
		<Reference URL="http://en.wikipedia.org/wiki/Real_Time_Gross_Settlement" Name="Wikipedia"/>
		<RelatedTerm Name="RTGS" Collection="lixi"/>
	</Term>
	<Term Name="Redemption Penalty">
		<Definition>Early Redemption Charge.</Definition>
	</Term>
	<Term Name="Redraw">
		<Definition>The process of withdrawing funds from a redraw facility.</Definition>
		<RelatedTerm Name="Available Funds" Collection="lixi"/>
		<RelatedTerm Name="Account Balance" Collection="lixi"/>
	</Term>
	<Term Name="Redraw Facility">
		<Definition>A facility on a loan that allows the borrower to make additional loan repayments into their loan (thereby temporarily reducing the amount upon which interest is charged), and to withdraw this money again at a later time. There may be restrictions on the redraw amount or the redraw frequency, and redraw may incur a fee.</Definition>
		<RelatedTerm Name="Redraw Fee" Collection="lixi"/>
		<RelatedTerm Name="Additional Loan Repayment" Collection="lixi"/>
		<RelatedTerm Name="Redraw" Collection="lixi"/>
		<RelatedTerm Name="Overpayment" Collection="lixi"/>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="All-in-one Loan Account" Collection="lixi"/>
	</Term>
	<Term Name="Redraw Fee">
		<Definition>A fee charged by a lender when the borrow redraws funds from a redraw facility.</Definition>
	</Term>
	<Term Name="Reducing Loan">
		<Definition>Principal and Interest Loan.</Definition>
	</Term>
	<Term Name="Refinance">
		<Definition>When a loan is taken out and some or all of the funds are used to pay off an existing loan. The new loan may or may not be with the same lender. Refinancing is often used to access built up equity in a property, for debt consolidation, or simply to obtain a lower interest rate.</Definition>
		<RelatedTerm Name="Settlement Date" Collection="lixi"/>
		<RelatedTerm Name="Refinance Reason" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Stamp Duty" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Document" Collection="lixi"/>
		<RelatedTerm Name="Funds Required" Collection="lixi"/>
		<RelatedTerm Name="Fast Refinance" Collection="lixi"/>
	</Term>
	<Term Name="Refinance Reason">
		<Definition>With respect to a loan that is used for refinance purposes, the reason that the borrower requests this loan.</Definition>
		<RelatedTerm Name="NCCP-Related Information" Collection="lixi"/>
	</Term>
	<Term Name="Register">
		<Definition>Register Book.</Definition>
	</Term>
	<Term Name="Register Book">
		<Definition>A set of Volumes that contain Folios being Land Titles.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Register" Collection="lixi"/>
	</Term>
	<Term Name="Registered Builder Contract">
		<Definition>A building construction contract that has been made with a registered builder.</Definition>
	</Term>
	<Term Name="Registered Mortgage">
		<Definition>A mortgage that has been registered with the titles office.</Definition>
	</Term>
	<Term Name="Regular Shaped Allotment">
		<Definition>An allotment which is either square or rectangular in shape, or any other shape where a square or rectangular shape equivalent in area to the minimum area for the allotment type could be contained within the boundaries of the allotment, and includes a battle-axe shaped allotment and a corner allotment where the only deviation from the above requirements is the access corridor or splay corner respectively.</Definition>
		<Reference URL="http://www.blacktown.nsw.gov.au/shadomx/apps/fms/fmsdownload.cfm?file_uuid=C1BD14A9-F26E-BD6F-C5EA-BCD769597035&amp;siteName=blacktown" Name="NSW"/>
		<RelatedTerm Name="Irregular Shaped Allotment" Collection="lixi"/>
	</Term>
	<Term Name="Regulated Loan">
		<Definition>A loan that is regulated by the UCCC or NCCP, typically an owner occupied or investment home loan.</Definition>
	</Term>
	<Term Name="Release of Security">
		<Definition>Releasing a security used to secure a loan. This may or may not involve discharging the mortgage, since the property may still be used to secure another loan.</Definition>
	</Term>
	<Term Name="Relevant Comparison Rate">
		<Definition>The comparison rate calculated for whichever of the designated amounts and terms most closely represents the typical amount of credit and term initially provided by the credit provider for the consumer credit product being advertised.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/s146f.html" Name="Austlii"/>
		<RelatedTerm Name="Comparison Rate" Collection="lixi"/>
	</Term>
	<Term Name="Relocatable Home">
		<Definition>A dwelling that is not permanently attached to a site other than for the provision of services and can be designed and constructed to be moved in one or more prefabricated sections.</Definition>
	</Term>
	<Term Name="Relocation Loan">
		<Definition>Bridging Loan.</Definition>
	</Term>
	<Term Name="Renegotiation">
		<Definition>Renewal.</Definition>
	</Term>
	<Term Name="Renewal">
		<Definition>Renewing the loan repayment type, i.e. changing from Interest Only to Principal and Interest and vice versa, or renewing the Interest Rate Type, i.e. changing from variable to fixed or vice versa.</Definition>
		<RelatedTerm Name="Renegotiation" Collection="lixi"/>
	</Term>
	<Term Name="Renovation Loan">
		<Definition>A loan where the purpose is to make improvements to an existing property.</Definition>
	</Term>
	<Term Name="Rental Yield">
		<Definition>The return on an investment as a percentage of the amount invested. Gross rental yield can be calculated by multiplying the weekly rent by 52 (weeks in a year), then dividing by the value of the property and multiplying this figure by 100 to get the percentage.</Definition>
	</Term>
	<Term Name="Repayment">
		<Definition>An incremental payment towards a loan, periodic repayments can be principal and interest, or interest only. Extra repayments can be payments toward the principal or available to for redraw.</Definition>
		<RelatedTerm Name="Repayment Method" Collection="lixi"/>
		<RelatedTerm Name="Minimum Monthly Repayment" Collection="lixi"/>
		<RelatedTerm Name="Structured Payments" Collection="lixi"/>
		<RelatedTerm Name="Expense Type" Collection="lixi"/>
		<RelatedTerm Name="Repayment Type" Collection="lixi"/>
		<RelatedTerm Name="Borrower" Collection="lixi"/>
	</Term>
	<Term Name="Repayment Frequency">
		<Definition>The frequency with which loan repayments are made. Typically repayments are scheduled weekly, fortnightly or monthly.</Definition>
	</Term>
	<Term Name="Repayment Method">
		<Definition>The method by which a borrower agrees to make loan repayments, such as direct debit from an existing or new account.</Definition>
		<RelatedTerm Name="Payment Method" Collection="lixi"/>
	</Term>
	<Term Name="Repayment Type">
		<Definition>The structure of loan repayment, being interest only; principal and interest; interest in advance; capitalised interest, etc.</Definition>
	</Term>
	<Term Name="Replacement Cost Estimate">
		<Definition>An estimate of the cost to rebuild the real estate asset which normally includes construction cost, home contents replacement cost, allowances for demolition and clean up, and professional fees.</Definition>
	</Term>
	<Term Name="Reserve Price">
		<Definition>The minimum amount a seller will accept at an auction, irrespective of the starting price.</Definition>
	</Term>
	<Term Name="Residential Investment Home Loan">
		<Definition>Investment Home Loan.</Definition>
	</Term>
	<Term Name="Residential Mortgage Backed Security" Abbr="RMBS">
		<Definition>A type of securitisation where the income producing assets are secured home loans.</Definition>
		<RelatedTerm Name="RMBS" Collection="lixi"/>
	</Term>
	<Term Name="Residential Property">
		<Definition>Land on which a dwelling is or will be affixed predominantly for residential purposes.</Definition>
	</Term>
	<Term Name="Restricted Access Assessment">
		<Definition>An inspection and valuation of a property without an internal inspection.</Definition>
		<RelatedTerm Name="Kerb-side Valuation" Collection="lixi"/>
	</Term>
	<Term Name="Resubmission">
		<Definition>The process by which a borrower (or mortgage broker) submits an updated loan application to a lender, either updating or replacing the original application. Resubmission generally requires the inclusion of the lender's original application reference number on the resubmitted application.</Definition>
	</Term>
	<Term Name="Revenue Office">
		<Definition>A Government Body that is a jurisdiction-based collector of Duty and taxes payable on certain transactions and responsible for effective systems of compliance with legislated Duty and tax obligations.</Definition>
		<RelatedTerm Name="Duty" Collection="lixi"/>
	</Term>
  <Term Name="Reverse Mortgage">
    <Definition>A reverse mortgage is a type of home loan that allows a party to borrow money using the equity in their home as security.</Definition>
  </Term>
	<Term Name="Reverse Mortgage Home Loan">
		<Definition>A type of home loan where all interest is capitalised and no principal or interest repayments are required until the security property is sold, generally when the borrower is deceased. These loans are designed for retired people who own their own home and wish to convert some of the equity into cash. A reverse mortgage allows such a person access the equity without having to sell the property. The funds may be provided as a lump sum, as instalment payments, or both.</Definition>
		<Reference URL="http://www.reverse-mortgage.net.au/2008/asic-report-109/%20" Name="reverse-mortgage.net.au/ asic-report-109"/>
		<RelatedTerm Name="accommodation bond" Collection="lixi"/>
		<RelatedTerm Name="Accommodation Bond" Collection="lixi"/>
		<RelatedTerm Name="Equity Release Home Loan" Collection="lixi"/>
	</Term>
	<Term Name="Revolving Credit Facility">
		<Definition>Continuing Credit Contract.</Definition>
		<RelatedTerm Name="Credit Card" Collection="lixi"/>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="Line of Credit" Collection="lixi"/>
	</Term>
	<Term Name="Revolving Credit Limit">
		<Definition>The credit limit for a revolving credit facility (being a continuing credit contract)</Definition>
	</Term>
	<Term Name="Revolving Line of Credit">
		<Definition>Line of Credit.</Definition>
		<RelatedTerm Name="Credit Facility" Collection="lixi"/>
	</Term>
	<Term Name="Rework">
		<Definition>The process by which a lender changes details of a loan application prior to settlement, either because of data issues (missing or incorrect information) or because the circumstances change (for instance the borrower changes product or loan amount, or adds a guarantor)</Definition>
	</Term>
	<Term Name="Residential Mortgage Backed Security" Abbr="RMBS">
		<Definition/>
		<RelatedTerm Name="Securitisation" Collection="lixi"/>
		<RelatedTerm Name="Residential Mortgage Backed Security" Collection="lixi"/>
	</Term>
	<Term Name="Real Time Gross Settlement" Abbr="RTGS">
		<Definition/>
		<RelatedTerm Name="Real Time Gross Settlement" Collection="lixi"/>
	</Term>
	<Term Name="Sales Channel">
		<Definition>The method and/or entities through which the product is sold to the applicant. It encompasses details of whether the applicant is engaged directly via an online channel such as an institution's internet presence, via the institution's branch network, via a call centre, as well as  details of any third parties involved such as mortgage brokers, mortgage managers,  mortgage aggregators, and mortgage introducers.</Definition>
	</Term>
	<Term Name="Scheduled Balance">
		<Definition>For a term loan, the calculated value of the loan balance under the hypothetical circumstance that the borrower made only the minimum payments as required under the loan contract. For a revolving credit facility, this is the credit limit. See also available limit.</Definition>
		<RelatedTerm Name="Arrears" Collection="lixi"/>
		<RelatedTerm Name="In Arrears" Collection="lixi"/>
	</Term>
  <Term Name="Schema Version">
    <Definition>Each LIXI release includes a LIXI schema that is identified by a schema version number. LIXI messages that validate against a specific LIXI schema version will not validate against other LIXI schema versions.</Definition>
  </Term>
	<Term Name="Second Mortgage">
		<Definition>A mortgage that is taken over a property where a mortgage already exists with a different lender. In the event that the borrower defaults, whoever holds the second mortgage cannot gain recourse from the proceeds of sale until loans secured by the first mortgage have been recovered, including interest, fees and costs.</Definition>
	</Term>
	<Term Name="Section 32">
		<Definition/>
		<RelatedTerm Name="Vendor's Statement" Collection="lixi"/>
	</Term>
	<Term Name="Secured Loan">
		<Definition>A loan that is secured by collateral, i.e. by a lien over property.</Definition>
		<RelatedTerm Name="Discharge" Collection="lixi"/>
		<RelatedTerm Name="Line of Credit" Collection="lixi"/>
		<RelatedTerm Name="Mortgage Loan" Collection="lixi"/>
	</Term>
	<Term Name="Securitisation">
		<Definition>The packaging of cash flow producing assets e.g. property, roads, bridges, etc. into a marketable security where bonds are sold into the capital markets.</Definition>
		<RelatedTerm Name="RMBS" Collection="lixi"/>
		<RelatedTerm Name="Residential Mortgage Backed Security" Collection="lixi"/>
	</Term>
	<Term Name="Security">
		<Definition>Property that is pledged as collateral for a debt such as a home loan.</Definition>
		<RelatedTerm Name="Guarantee" Collection="lixi"/>
		<RelatedTerm Name="Personal Property Security" Collection="lixi"/>
		<RelatedTerm Name="Application" Collection="lixi"/>
		<RelatedTerm Name="Security Substitution" Collection="lixi"/>
		<RelatedTerm Name="Security guarantee" Collection="lixi"/>
		<RelatedTerm Name="Asset Lending" Collection="lixi"/>
		<RelatedTerm Name="Guarantor" Collection="lixi"/>
		<RelatedTerm Name="Mortgage" Collection="lixi"/>
		<RelatedTerm Name="Security Value" Collection="lixi"/>
	</Term>
	<Term Name="Security Addition">
		<Definition>Adding a new security to the relevant loan account. The lender may already hold a mortgage over the security property, in which case the Security Addition results in an extension of the security to the relevant account; if not then a new mortgage must be taken over the security property.</Definition>
	</Term>
 <Term Name="Security Agreement">
		<Definition>An agreement with which interest in a security is provided.</Definition>
	</Term>
	<Term Name="Security guarantee">
		<Definition>A form of guarantee where the guarantors agree to co-secure a loan or loans and offering their own asset(s) as security. With this type of guarantee the guarantor uses real estate that they own as additional security for a loan. If the guarantor already has a loan on their property then in most cases the bank can take a 2nd mortgage as security.</Definition>
		<RelatedTerm Name="Equity Guarantee" Collection="lixi"/>
	</Term>
	<Term Name="Security Substitution">
		<Definition>Replacing an existing security with a different security on a mortgage. An example is the replacement of a prior property with a newly purchased property, when the existing loan arrangements with the lender continue.</Definition>
		<RelatedTerm Name="Variation Type" Collection="lixi"/>
	</Term>
	<Term Name="Security Value">
		<Definition>The value of property offered or held as security, generally either the purchase price or the result of a valuation.</Definition>
	</Term>
	<Term Name="Self Employed">
		<Definition>An individual who operates a business as a sole proprietor.</Definition>
	</Term>
	<Term Name="Seriously In Arrears">
		<Definition>The status of a loan whereby the loan has been in arrears for a period of time and it is probable that the loan may not return to a performing loan. Defined as a loan whereby the current loan balance less the scheduled loan balance is a positive number, and the resultant arrears amount is the equivalent of 3 or more payments in arrears.</Definition>
	</Term>
	<Term Name="Service Fee">
		<Definition/>
		<RelatedTerm Name="Loan Administration Fee" Collection="lixi"/>
	</Term>
	<Term Name="Serviceability">
		<Definition>The ability of the borrower to 'service' new loan commitments, i.e. make the proposed loan repayments and still maintain a standard of living.</Definition>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
		<RelatedTerm Name="Liability Amount" Collection="lixi"/>
		<RelatedTerm Name="Asset Lending" Collection="lixi"/>
		<RelatedTerm Name="Borrowing Capacity" Collection="lixi"/>
		<RelatedTerm Name="Credit Assessment" Collection="lixi"/>
	</Term>
  <Term Name="Servicing Guarantee">
		<Definition>A form of guarantee where the guarantors agree to co-secure a loan or loans by offering their own income to meet the loan repayment commitment if the borrowers fail to do so.    </Definition>
  </Term>
	<Term Name="Serviceability Calculation">
		<Definition>A calculation that lenders use to determine an applicants' ability to repay a given loan. The calculation is generally based on the borrower's income and expenses and the interest rate and term of the loan, and varies from lender to lender and product to product depending on credit policy. Serviceability calculation generally provides a pass/fail result in addition to servicing metrics such as NSR.</Definition>
		<RelatedTerm Name="Serviceability" Collection="lixi"/>
	</Term>
	<Term Name="Session">
		<Definition>A series of interactions between a service and a consumer of that service, within a window of time during which authorisation is granted by the service for the the consumer to perform specific tasks.</Definition>
	</Term>
	<Term Name="Settled Amount">
		<Definition>The available limit of a loan account immediately following settlement.</Definition>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
	</Term>
	<Term Name="Settlement">
		<Definition>Final completion of a home or property sale transaction, or mortgage transfer. Includes transfer of all final funds and payments including fees and charges, and resulting (in the case of a purchase transaction) in the purchaser receiving ownership documents for the home or property.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Application Status" Collection="lixi"/>
		<RelatedTerm Name="First Home Owner Grant" Collection="lixi"/>
		<RelatedTerm Name="Progress Payment" Collection="lixi"/>
		<RelatedTerm Name="Settled Amount" Collection="lixi"/>
		<RelatedTerm Name="Stamp Duty" Collection="lixi"/>
		<RelatedTerm Name="Expected Settlement Date" Collection="lixi"/>
		<RelatedTerm Name="Post-settlement Address" Collection="lixi"/>
		<RelatedTerm Name="Settlement Meeting" Collection="lixi"/>
		<RelatedTerm Name="Contribution Funds" Collection="lixi"/>
		<RelatedTerm Name="Upfront Commission" Collection="lixi"/>
	</Term>
	<Term Name="Settlement Date">
		<Definition>The date that funds are transferred for the purchase of a property or for the refinance of a loan. For a purchase, the date in which all remaining funds are handed over to the vendor and the buyer takes complete legal ownership of the property. For a refinance, the date in which all funds are handed over from the new lender to the previous lender.</Definition>
	</Term>
	<Term Name="Settlement Meeting">
		<Definition>A meeting of representatives of all parties involved in the transaction to settle the transaction.</Definition>
	</Term>
	<Term Name="Shared Equity Loan">
		<Definition>Equity Finance Mortgage Loan.</Definition>
	</Term>
  <Term Name="Shareholder Funds">
    <Definition>Shareholder funds is the balance sheet value of the shareholder interest in a company (all assets less all liabilities).</Definition>
  </Term>
	<Term Name="Signatory">
		<Definition>A person authorized to access and use an account. An account holder.A Party that affixes their signature to a document to indicate their intention, or the intention of a Party they represent, to be bound by the contents of that document.</Definition>
	</Term>
	<Term Name="Slab Stage">
		<Definition>A stage of house construction, when the building's floor is completed.</Definition>
		<RelatedTerm Name="Base Stage" Collection="lixi"/>
	</Term>
	<Term Name="Small Business">
		<Definition>A business having: (a) less than 100 full time (or equivalent) people if the business is or includes the manufacture of goods; or (b) in any other case, less than 20 full time (or equivalent) people.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Sole Director">
		<Definition>A director of a company that has only one director.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Sole Ownership">
		<Definition>Ownership of property by a single person or entity.</Definition>
	</Term>
	<Term Name="Sole Tenancy">
		<Definition>A Tenancy that consists of proprietorship of property by a single Proprietor - namely the sole tenant.</Definition>
		<RelatedTerm Name="Tenancy" Collection="lixi"/>
	</Term>
	<Term Name="Superannuation Product Identification Number" Abbr="SPIN">
		<Definition/>
		<RelatedTerm Name="Superannuation Product Identification Number" Collection="lixi"/>
	</Term>
	<Term Name="Special Purpose Vehicle" Abbr="SPV">
		<Definition>A special purpose vehicle is a subsidiary of a company which is bankruptcy remote from the parent company. Assets held by the SPV are protected when the parent organisation goes bankrupt. The actions of an SPV are tightly controlled; SPVs are only allowed to finance, buy and sell assets.</Definition>
	</Term>
	<Term Name="Split Loan">
		<Definition>A loan arrangement comprising two or more loan accounts, often with different loan characteristics, for instance a fixed rate loan and a variable rate loan, or a residential home loan and an investment loan.</Definition>
		<Reference URL="https://www.moneysmart.gov.au/borrowing-and-credit/home-loans/interest-rates" Name="ASIC"/>
		<RelatedTerm Name="Split Property Loan" Collection="lixi"/>
	</Term>
	<Term Name="Split Property Loan">
		<Definition>A split loan structure that combines a residential loan and an investment loan which, up until 2004, allowed home owners a tax benefit by diverting cash inflows to the home loan (or an offset account) while capitalising the interest on the investment loan. The High Court has ruled this tax structure illegal.</Definition>
	</Term>
	<Term Name="Spouse">
		<Definition>Either member of a legally or de facto married couple in relation to the other; one's husband, wife or partner.</Definition>
	</Term>
	<Term Name="Square">
		<Definition>A measure of area in a house, being 100 sq. feet, or 9.29 square meters.</Definition>
	</Term>
	<Term Name="Stamp Duty">
		<Definition>A state government tax on a dutiable transaction, for example on the purchase of land or property, or on a mortgage loan, payable by the buyer on or prior to settlement. Stamp duty varies from state to state, and first home owners may be eligible for concessions in some states.</Definition>
		<RelatedTerm Name="Duty" Collection="lixi"/>
		<RelatedTerm Name="Stamp Duty Concession" Collection="lixi"/>
	</Term>
	<Term Name="Stamp Duty Concession">
		<Definition>A waiver or discount on stamp duty available in certain circumstances such as for first home buyers. The amount of the concession depends on the circumstances, and varies from state to state.</Definition>
		<RelatedTerm Name="Stamp Duty" Collection="lixi"/>
	</Term>
	<Term Name="Stamp Duty on a Home Loan">
		<Definition>Mortgage Stamp Duty.</Definition>
	</Term>
	<Term Name="Stamp Duty on Property">
		<Definition>Is a State Government tax paid on the value of the property. It will vary from State to State, and may be discounted in certain circumstances such as for first home buyers. The value of the property is normally considered to be the purchase price, however if the transaction is not an arm's length transaction the value will be determined by other means.</Definition>
		<RelatedTerm Name="Stamp Duty" Collection="lixi"/>
	</Term>
	<Term Name="Standard Banking Fees and Charges">
		<Definition>Fees and charges normally charged in respect of a banking service.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Standard Variable Rate" Abbr="SVR">
		<Definition>The variable interest rate which lenders apply to their standard or fully featured home loan product.</Definition>
		<RelatedTerm Name="SVR" Collection="lixi"/>
	</Term>
	<Term Name="Statement of Account">
		<Definition>An account statement containing such information as the beginning and end dates, opening and closing balances, credit provided, interest charged, and annualised interest rate.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/sch1.html" Name="Austlii"/>
	</Term>
	<Term Name="Statement of Financial Position">
		<Definition>A statement listing the income, expenses, assets and liabilities of a party or parties.</Definition>
		<RelatedTerm Name="Statement of Position" Collection="lixi"/>
	</Term>
	<Term Name="Statement of Position">
		<Definition>Statement of Financial Position.</Definition>
	</Term>
	<Term Name="Statement Period">
		<Definition>The period between the beginning and end dates (inclusive) of a statement of account.</Definition>
	</Term>
    <Term Name="Status Update">
        <Definition>A status update is a message that describes a change of state in the status of a transaction that was triggered by the submission of a LIXI credit application message.</Definition>
    </Term>
	<Term Name="Straight Through Processing" Abbr="STP">
		<Definition/>
		<RelatedTerm Name="Straight Through Processing" Collection="lixi"/>
	</Term>
	<Term Name="Straight Through Processing" Abbr="STP">
		<Definition>A concept related to mortgage processing where information is maintained in its original state to ensure data fidelity, and derived data fields are stored or manipulated separately. This helps to ensure consistency in meeting expectations, as the original data is available throughout the process, including being available for transfer to external parties in the processing chain. See also Automated Mortgage Processing.</Definition>
		<RelatedTerm Name="Automated Mortgage Processing" Collection="lixi"/>
		<RelatedTerm Name="STP" Collection="lixi"/>
	</Term>
	<Term Name="Strata Corporation">
		<Definition>A body corporate incorporated in relation to land subdivided wholly or mainly for residential purposes under applicable law; or a body corporate whose issued shares confer a right to occupy land for residential purposes.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/cth/consol_act/nccpa2009377/sch1.html" Name="Austlii"/>
	</Term>
	<Term Name="Strata Hotel Unit">
		<Definition>A unit located in a hotel complex that has been stratified for individual unit ownership. The hotel is managed by a management company and governed by an elected strata council representing the owners of the property. Each unit may be sold independently. The conditions of rental/owner use conditions may be unique to each hotel.</Definition>
	</Term>
	<Term Name="Strata Title">
		<Definition>This type of title demarcates ownership of a section or a 'unit' of a larger building or property. Strata title is a type of ownership in real property where all of the owners own the property, common areas and buildings together, with the exception of the interior of the unit to which they have title. This 'unit' can be sold or transferred by the owner.</Definition>
		<RelatedTerm Name="Unit Title" Collection="lixi"/>
	</Term>
	<Term Name="Street Type">
		<Definition>The part of a full street name that indicated its 'type', such as "road", "avenue", or "street"</Definition>
		<Reference URL="http://lixi.org.au/sites/default/files/LIXI_StreetTypes.xml" Name="LIXI street types"/>
	</Term>
	<Term Name="Structured Payments">
		<Definition>For a loan, structured payments are repayments that are agreed and scheduled in advance, but are not categorised as regular or periodic repayments because the timing and/or the repayment amounts may vary.</Definition>
	</Term>
	<Term Name="Structured Payments Schedule">
		<Definition>The schedule of loan repayments where the timing and/or amount of each repayment varies such that each repayment is itemised in advanced with a date and amount.</Definition>
	</Term>
	<Term Name="Sub-prime Loan">
		<Definition>Non-Conforming Loan.</Definition>
	</Term>
	<Term Name="Subdivision">
		<Definition>A parcel of land divided into individual lots.</Definition>
	</Term>
	<Term Name="Submission Document">
		<Definition>A document generated by the loan writer and submitted to the lender. A submission document is generated based on the application data collected by the loan writer. It could be be a checklist, print form, summary, etc.</Definition>
	</Term>
	<Term Name="Substantial Hardship">
		<Definition>A loosely defined phrase used to imply that a borrower may have grave difficulty repaying a loan due to current or foreseeable circumstances.</Definition>
		<Reference URL="" Name=""/>
		<RelatedTerm Name="NCCP-Related Information" Collection="lixi"/>
	</Term>
	<Term Name="Superannuation Product Identification Number" Abbr="SPIN">
		<Definition>An identification number assigned to every superannuation product and administered by APIR systems.</Definition>
		<RelatedTerm Name="SPIN" Collection="lixi"/>
	</Term>
	<Term Name="Superannuation Wrap Account">
		<Definition>A 'wrap' superannuation product is a personal superannuation arrangement on a platform whereby superannuation contributions are managed by the provider of the product, and the provider offer a greater choice of where funds are invested. The investor can control and consolidate all investments in one place, wrap accounts lets the investor access managed funds, shares, cash providing great diversification benefits. The arrangement typically allows the account holder to direct investments to other fund managers beyond the provider's or financial institutions' own range of investment products. Some allow for direct investments in shares listed on the stock exchange. The range of investments is typically restricted to ones pre-selected by the provider or financial institution. The choice, however, may come at a cost that is higher than a standard retail superannuation fund that does not offer 'wrap' arrangements.</Definition>
		<RelatedTerm Name="Wrap Account" Collection="lixi"/>
	</Term>
	<Term Name="Supporting Document">
		<Definition>A document that aids in proving the correctness of data provided by an applicant.</Definition>
	</Term>
	<Term Name="Surety">
		<Definition>Guarantee.</Definition>
		<RelatedTerm Name="Guarantor" Collection="lixi"/>
	</Term>
	<Term Name="Surname">
		<Definition>The hereditary name of a Natural Person that is usually common to all members of that person's family.</Definition>
	</Term>
	<Term Name="Surplus Funds">
		<Definition>Funds from the borrowed loan amount that are in excess of the amount required for purchase, refinance, debt consolidation, fees etc.</Definition>
		<RelatedTerm Name="Disbursement Method" Collection="lixi"/>
		<RelatedTerm Name="Loan Surplus" Collection="lixi"/>
	</Term>
	<Term Name="Survey">
		<Definition>The precise plan of a property prepared by a registered land surveyor, showing the location of the land with reference to known points, and the location of the property boundaries, easements, services running through the property and any buildings on the land. A surveyor can use the survey to check the boundaries of a property prior to purchase.</Definition>
	</Term>
	<Term Name="Standard Variable Rate" Abbr="SVR">
		<Definition/>
		<RelatedTerm Name="Standard Variable Rate" Collection="lixi"/>
	</Term>
	<Term Name="Switching fee">
		<Definition>A fee charged by a lender when a borrower switches a loan product or rate, such as from a variable rate to a fixed rate.</Definition>
	</Term>
	<Term Name="Tax File Number" Abbr="TFN">
		<Definition>A Tax File Number (TFN) is issued by the the ATO an is an identifier that is used within the tax and superannuation systems. The TFN remains with a person for life through name changes, job changes and movements interstate or overseas.</Definition>
	</Term>	
	<Term Name="To Be Erected" Abbr="TBE">
		<Definition/>
		<RelatedTerm Name="Costing Valuation" Collection="lixi"/>
		<RelatedTerm Name="To Be Erected" Collection="lixi"/>
	</Term>
	<Term Name="Technically In Arrears">
		<Definition>Typically, the status of a loan whereby the current loan balance less the scheduled loan balance is a positive number, and the resultant arrears amount is the equivalent of less than 1 payment in arrears. However, for certain mortgage loans (high LVR, non-conforming and subprime in particular), the mortgage loan contract may contain terms and conditions whereby a loan is deemed to be technically in arrears if a payment is missed despite the scheduled loan balance exceeding the current loan balance.</Definition>
	</Term>
	<Term Name="Tenancy">
		<Definition>The nature of a proprietorship, being either a Sole Tenancy, Joint Tenancy or Tenancy In Common, that determines the manner of interaction between each Proprietor of the same property, including the method of disposition of the property of a deceased Proprietor.</Definition>
		<RelatedTerm Name="Joint Tenancy" Collection="lixi"/>
		<RelatedTerm Name="Sole Tenancy" Collection="lixi"/>
	</Term>
	<Term Name="Tenants in Common">
		<Definition>The equal or unequal holding of property by two or more persons. The Proprietors that hold property in common with another or others in a Tenancy In Common, and each of whom has a distinct, separately transferable share fraction in the property, and where the Share Fraction in the property on the death of a Tenant in Common passes to any beneficiary in the will of the deceased or, in the absence of a will, as directed by a Court.</Definition>
		<Reference URL="http://files.lixi.org.au/glossary/NECS_Vocab_v1.4.html" Name="NECS Vocab"/>
		<RelatedTerm Name="Tenancy" Collection="lixi"/>
	</Term>
	<Term Name="Tentative On Completion Valuation" Abbr="TOC">
		<Definition>An estimate of the value of a construction property at completion, from which the lender will base the security amount for lending. Typically this is done by adding together the value of the land and the price of the fixed price builder's contract and then assessed by an independent valuer.</Definition>
		<Reference URL="https://www.peachhomeloans.com.au/vacant-land-construction-loan.htm" Name="Peach Construction Loans"/>
		<RelatedTerm Name="TOC" Collection="lixi"/>
	</Term>
<Term Name="Term Deposit Account">
		<Definition>A term deposit account holds a cash investment placed with a financial institution for a fixed period of time, at a fixed interest rate.</Definition>
	</Term>
	<Term Name="Term Loan">
		<Definition>A loan that is to be repaid within a set term, normally requiring regular principal and interest repayments and perhaps a final repayment to fully repay the debt.</Definition>
		<RelatedTerm Name="Scheduled Balance" Collection="lixi"/>
		<RelatedTerm Name="Minimum Monthly Repayment" Collection="lixi"/>
		<RelatedTerm Name="Total Loan Term" Collection="lixi"/>
		<RelatedTerm Name="Principal and Interest Loan" Collection="lixi"/>
	</Term>
  <Term Name="Term Premium">
		<Definition>A premium paid by the applicant on the basis of the loan term.</Definition>
	</Term>
	<Term Name="Third Party Mortgage">
		<Definition>A mortgage or charge given for the purpose of securing a mortgage loan, other than a security which contains a personal undertaking by the mortgagor to pay the secured money.</Definition>
		<Reference URL="http://www.bankers.asn.au/ArticleDocuments/20040603_FINAL_CODE_MODIFIED_PDF.pdf" Name="Bankers.asn"/>
	</Term>
	<Term Name="Third Party Security">
		<Definition>Security provided for a mortgage by a third party (someone different from actual borrowers) who is legally different from the borrower or debtor.</Definition>
	</Term>
	<Term Name="Title">
		<Definition>Land Title.</Definition>
		<RelatedTerm Name="Company Title" Collection="lixi"/>
		<RelatedTerm Name="Title Insurance" Collection="lixi"/>
	</Term>
	<Term Name="Title Deed">
		<Definition>Certificate of Title.</Definition>
	</Term>
	<Term Name="Title Insurance">
		<Definition>A Title Insurance policy is a no-fault contract of indemnity based upon an agreed representation of the state of title to a particular property as at the policy date (being the date of settlement).</Definition>
		<Reference URL="http://www.lawyersconveyancing.com.au/news/conveyancing_162_title_insurance.asp" Name="Lawyers Conveyancing"/>
		<RelatedTerm Name="Fast Refinance" Collection="lixi"/>
	</Term>
	<Term Name="Title Prefix">
		<Definition>A 2-character code that uniquely identifies a type of title that may be or may have been issued.</Definition>
		<Reference URL="http://wg.lixi.org.au/ps/page/lixi-settlement/comment/thread?xlink.id=159423" Name="LIXI Settlement"/>
	</Term>
	<Term Name="Title Search">
		<Definition>An examination of the Land Title report by a transacting party or their representative, to confirm that the vendor is in a position to sell the property and to identify any encumbrances on the property.</Definition>
	</Term>
	<Term Name="Title Suffix">
		<Definition>A single character that is appended to the Folio Number to create a unique identifier for a Title where for historical reasons the Folio Number within a Title Volume has been repeated.</Definition>
		<Reference URL="http://wg.lixi.org.au/ps/page/lixi-settlement/comment/thread?xlink.id=159423" Name="LIXI Settlement"/>
	</Term>
	<Term Name="Title Transfer Fee">
		<Definition>A fee charged by the state land titles office to a purchaser to cover the transfer of the title deed for a purchased property.</Definition>
	</Term>
	<Term Name="Titles Office">
		<Definition>Land Registry.</Definition>
	</Term>
	<Term Name="To Be Erected" Abbr="TBE">
		<Definition>Off the plan or other to-be-constructed contract.</Definition>
		<RelatedTerm Name="TBE" Collection="lixi"/>
	</Term>
	<Term Name="Tentative On Completion Valuation" Abbr="TOC">
		<Definition/>
		<RelatedTerm Name="Tentative On Completion Valuation" Collection="lixi"/>
	</Term>
	<Term Name="Top Up">
		<PreferredTerm Name="" Collection="lixi"/>
	</Term>
	<Term Name="Torrens System">
		<Definition>Is a system of registration whereby ownership and all dealings on a property are detailed on the one document, i.e. a Certificate of Title or Deed of Grant. Under this system a mortgage is a charge or encumbrance on the title. Registration with the Titles Office is compulsory to effect legal transfer of an interest in property and each time the property is sold, mortgaged, or a mortgage discharged, the transaction is recorded on the Certificate of Title.</Definition>
		<RelatedTerm Name="Torrens Title" Collection="lixi"/>
	</Term>
	<Term Name="Torrens Title">
		<Definition>A title document within the Torrens System.</Definition>
	</Term>
	<Term Name="Torrens Title Register">
		<Definition>A public register that is maintained by a Land Registry under relevant legislation and contains information related to Real Property.</Definition>
		<RelatedTerm Name="Constraint" Collection="lixi"/>
	</Term>
	<Term Name="Total Loan Amount">
		<Definition>For a loan application, the total amount of credit that will be provided by a lender at the time of settlement, including all capitalised fees.</Definition>
		<RelatedTerm Name="Total Loan Amount not including LMI" Collection="lixi"/>
	</Term>
	<Term Name="Total Loan Amount not including LMI">
		<Definition>Similar to Total Loan Amount, but not including the estimated or actual LMI Fee. This figure is often used in the calculation of LVR for mortgage-insured loans, since the mortgage insurer will have received the benefit of the fee prior to any default.</Definition>
	</Term>
	<Term Name="Total Loan Term">
		<Definition>The period of time during over which loan payments are made on a term loan. At the end of the loan term, the loan must be repaid. Loan terms may be expressed in years but may alternatively be expressed in months, for example a 30 year home loan can be expressed as 360 months.</Definition>
		<RelatedTerm Name="Loan Term" Collection="lixi"/>
		<RelatedTerm Name="Term Loan" Collection="lixi"/>
		<RelatedTerm Name="Serviceability Calculation" Collection="lixi"/>
	</Term>
	<Term Name="Trade Practices Act">
		<Definition>The part of law that controls the conduct of businesses. Loans which are not governed by the Consumer Credit Code (e.g. commercial or investment loans) are governed by the Trade Practices Act.</Definition>
	</Term>
	<Term Name="Trade Receivables">
		<Definition>Trade receivables is an account that shows the outstanding amount for goods and services that are sold to customers on credit where money has not yet been received.</Definition>
	</Term>
	<Term Name="Trading Name">
		<Definition>See Business Name.</Definition>
		<RelatedTerm Name="Business Name" Collection="lixi"/>
	</Term>
	<Term Name="Trailing Commission">
		<Definition>For a mortgage loan, regularly recurring commission to an agent or mortgage broker, paid on the basis that the loan is a performing loan and the customer is making loan repayments. The commission is normally a small proportion of the current or average loan balance.</Definition>
		<RelatedTerm Name="Commission" Collection="lixi"/>
		<RelatedTerm Name="Average Daily Balance" Collection="lixi"/>
		<RelatedTerm Name="End of Month Balance" Collection="lixi"/>
	</Term>
	<Term Name="Transfer">
		<Definition>An arrangement that passes a legal right from one Party to another so as to vest that right in the other.</Definition>
		<RelatedTerm Name="Transfer of Land" Collection="lixi"/>
	</Term>
	<Term Name="Transfer of Land">
		<Definition>An arrangement that passes the rights in an Estate from one Party or Parties to another so as to vest that right in the other.</Definition>
		<RelatedTerm Name="Transfer" Collection="lixi"/>
	</Term>
	<Term Name="Transfer of Land Amount">
		<Definition>The dutiable value of a sale of land, being the greater of the contract price and the unencumbered value of the property.</Definition>
		<Reference URL="http://www.osr.nsw.gov.au/taxes/transfer_land/rates/" Name="NSW OSR"/>
	</Term>
	<Term Name="Trust">
		<Definition>A trust is a relationship which exists where one or more trustees hold and administer property on behalf of one or more beneficiaries. The trustee is the legal owner of the property. The trustee can be an individual, group of individuals or a company. Where there is only one beneficiary the trustee and beneficiary cannot be the same person. A trust is not a legal entity in its own right. See also Trust Structure and Trust Purpose.</Definition>
		<RelatedTerm Name="Trust Purpose" Collection="lixi"/>
		<RelatedTerm Name="Trustee" Collection="lixi"/>
		<RelatedTerm Name="Trust Structure" Collection="lixi"/>
	</Term>
	<Term Name="Trust Purpose">
		<Definition>The purpose for which a trust has been set up, as distinct from the structure. These include: Family Trust - a discretionary trust for which a family trust election has been made; SMSF - Self managed super fund trust; Protective - The trust has been established for a person who is unable to manage his or her own affairs, such as a minor; Security Trust - a trust, typically a simple (bare) trust, set up to hold property as security for a loan, for example for an SMSF. Also known as a property trust.</Definition>
		<RelatedTerm Name="Trust" Collection="lixi"/>
	</Term>
	<Term Name="Trust Structure">
		<Definition>A trust can be structured as a bare or simple trust, a fixed trust, a discretionary trust, a unit trust, or a hybrid. A bare trust has one trustee, one beneficiary, and no specified obligations. In a fixed trust, the trustee holds the trust assets for the benefit of the beneficiaries in specified fixed proportions. In a discretionary trust, the trustee has discretion as to the distribution of trust property to the beneficiaries. In a unit trust, the beneficiaries (called unit holders) each possess a certain share (called units) and can direct the trustee to pay money to them out of the trust property according to the number of units they possess. A hybrid trust combines elements of both discretionary and unit trusts, in that the trustee must pay a certain amount of the trust property to each beneficiary, but otherwise has discretion as to how any remaining trust property is distributed.</Definition>
		<RelatedTerm Name="Trust" Collection="lixi"/>
	</Term>
	<Term Name="Trustee">
		<Definition>A person who has charge of money in a Trust. The Trustee maintains ownership of the Trust's assets on behalf of the beneficiaries and ensures guidelines of the Trust Deed and legal requirements are complied with.</Definition>
		<RelatedTerm Name="Trust" Collection="lixi"/>
	</Term>
	<Term Name="Two-tier marketing">
		<Definition>Refers to property scams where investors, usually those who are not familiar with an area, are deceived into buying property at hugely inflated prices. 'Two-tier-marketing' is generally taken to mean that there are two prices for a property (or a development), one price for locals and one price for out-of-towners.</Definition>
		<Reference URL="http://www.jenman.com.au/news_article.php?id=42" Name="Jenman"/>
		<RelatedTerm Name="Multi-Tier Market" Collection="lixi"/>
	</Term>
	<Term Name="UCCC">
		<Definition>Uniform Consumer Credit Code. Legislation which regulates credit provided to personal customers and strata corporations and which provides uniform standards for all forms of customer lending. It is designed to protect the rights of the individual (personal consumer) by ensuring banks and other financial institutions all adhere to the same rules when providing personal, domestic or household credit. Since Jan 1st 2011 the UCCC has been replaced by the NCCP</Definition>
		<RelatedTerm Name="Unregulated Loan" Collection="lixi"/>
		<RelatedTerm Name="Regulated Loan" Collection="lixi"/>
	</Term>
	<Term Name="UCCL">
		<Definition>The Uniform Consumer Credit Code Legislation - a Federal Act of Parliament to ensure uniformity amongst all credit providers. The lender or its agent are required, by this legislation, to set out all fees / charges that the borrower are liable for under the loan contract.</Definition>
	</Term>
	<Term Name="Uncommitted Monthly Income" Abbr="UMI">
		<Definition/>
		<RelatedTerm Name="Uncommitted Income" Collection="lixi"/>
		<RelatedTerm Name="Uncommitted Monthly Income" Collection="lixi"/>
	</Term>
	<Term Name="Uncoded Loan">
		<Definition>Unregulated Loan.</Definition>
	</Term>
	<Term Name="Uncommitted Income" Abbr="UMI">
		<Definition>An assessment metric, being the calculated remaining amount of income that is available once all expenses, including payments for loans being refinanced, are deducted. Typically calculated monthly, as .</Definition>
		<RelatedTerm Name="Uncommitted Monthly Income" Collection="lixi"/>
		<RelatedTerm Name="Net Disposable Income" Collection="lixi"/>
	</Term>
	<Term Name="Uncommitted Monthly Income" Abbr="UMI">
		<Definition>Uncommitted Income calculated as a monthly net figure. Usage:</Definition>
		<RelatedTerm Name="assessment metric" Collection="lixi"/>
		<RelatedTerm Name="UMI" Collection="lixi"/>
	</Term>
	<Term Name="Unconditional Approval">
		<Definition>An application status provided by the lender when the loan application is approved with all stated conditions having been satisfied.</Definition>
		<RelatedTerm Name="Application Status" Collection="lixi"/>
		<RelatedTerm Name="Formal Approval" Collection="lixi"/>
	</Term>
	<Term Name="Under Contract">
		<Definition>A real estate asset is under contract if the vendor and buyer have signed a contract, and have agreed upon a price, but not all conditions of the contract have been met and the contract can become void before sale.</Definition>
	</Term>
	<Term Name="Under Offer">
		<Definition>A real estate asset is under offer if the buyer has made a formal offer to buy a property, but the vendor has not yet accepted the offer and a contract of sale has not yet been signed.</Definition>
	</Term>
	<Term Name="Unencumbered">
		<Definition>A characteristic of property where it is owned outright, being free of liabilities, restrictions or mortgages.</Definition>
	</Term>
	<Term Name="Unit Entitlement">
		<Definition>When a property is constructed on a parcel of land, new units can be strata titled to enable individual titles to be issued for each new unit, therefore enabling each lot to be sold. The strata scheme plan determines the unit entitlement per lot. Unit entitlement states the overall interest (part-ownership) in the common property, and helps calculate the levies payable, and voting entitlements for each owner.</Definition>
		<Reference URL="https://www.fairtrading.nsw.gov.au/housing-and-property/buying-and-selling-property/buying-a-property/buying-into-a-strata-scheme" Name="Fairtrading"/>
	</Term>
	<Term Name="Unit Title">
		<Definition>Strata Title.</Definition>
	</Term>
	<Term Name="Unpaid Balance">
		<Definition>In relation to a credit contract at a particular time, the difference between all amounts credited and all amounts debited to the debtor under the contract at that time. The legal definition is used in the context of calculation of interest, hence "unpaid balance" is equivalent to account balance.</Definition>
		<Reference URL="http://www.austlii.edu.au/au/legis/qld/consol_act/ccc176/s25.html" Name="Austlii"/>
		<RelatedTerm Name="Funds Available" Collection="lixi"/>
		<RelatedTerm Name="Funds Required" Collection="lixi"/>
	</Term>
	<Term Name="Unregistered Mortgage">
		<Definition/>
		<RelatedTerm Name="Equitable Mortgage" Collection="lixi"/>
	</Term>
	<Term Name="Unregulated Loan">
		<Definition>A loan not regulated by the UCCC or NCCP, typically a loan related to business or investment purposes. They are governed by the Trade Practices Act.</Definition>
		<RelatedTerm Name="Uncoded Loan" Collection="lixi"/>
	</Term>
	<Term Name="Unsecured Loan">
		<Definition>Where credit is provided to a borrower and no security is taken. Unsecured lending restricts the Bank's ability to recover debt in the event the borrower cannot repay the debt within the agreed arrangements and therefore a higher interest rate usually applies.</Definition>
	</Term>
	<Term Name="Upfront Commission">
		<Definition>For a mortgage loan, an initial commission to an agent or mortgage broker, generally once-off, and generally paid following settlement. The commission is normally a proportion of the settled amount, drawn amount, or a portion of the approved limit.</Definition>
		<RelatedTerm Name="Commission" Collection="lixi"/>
		<RelatedTerm Name="Clawback" Collection="lixi"/>
		<RelatedTerm Name="Early Close Clawback" Collection="lixi"/>
	</Term>
	<Term Name="Upfront Costs">
		<Definition>Are the various fees and charges that a required when a home loan settles, including stamp duty, legal fees, mortgage registration fees etc.</Definition>
	</Term>
	<Term Name="Upstamp">
		<Definition>A term often used to mean principal increase but technically relates to the stamping of a new mortgage and the payment of mortgage stamp duty on the new money. The upstamp itself is the payment of additional stamp duty on a mortgage where the mortgage secures a loan facility that is being subject to a limit increase. As mortgage stamp duty is calculated by reference to the amount secured by the instrument/mortgage document being stamped and increase in the limit of the facility being secured results in increased stamp duty.</Definition>
	</Term>
	<Term Name="Valuation">
		<Definition>The process of estimating the value of a property and preparing a valuation report, usually performed by a registered valuer based on their own experiences and judgment as well as recent sales in the area.</Definition>
		<RelatedTerm Name="Market Risk Rating" Collection="lixi"/>
		<RelatedTerm Name="Forced Sale Days" Collection="lixi"/>
		<RelatedTerm Name="Appraisal" Collection="lixi"/>
		<RelatedTerm Name="Confidence Score" Collection="lixi"/>
		<RelatedTerm Name="Transfer of Land Amount" Collection="lixi"/>
		<RelatedTerm Name="Property Risk Rating" Collection="lixi"/>
		<RelatedTerm Name="Market Value" Collection="lixi"/>
		<RelatedTerm Name="Security Value" Collection="lixi"/>
	</Term>
	<Term Name="Valuation Fee">
		<Definition>A fee charged for obtaining a valuation report on a property. Depending on the context it may refer to the charge from a lender to an applicant in relation to the valuation, or from the valuer to the party ordering the report.</Definition>
	</Term>
	<Term Name="Valuation Report">
		<Definition>A report detailing an estimation of the value of a property, with an explanation of how the figure was reached.</Definition>
		<RelatedTerm Name="Comparable Sale" Collection="lixi"/>
		<RelatedTerm Name="Valuation" Collection="lixi"/>
	</Term>
	<Term Name="Valuer Additional Comments">
		<Definition>A valuation report that follows the Australian Property Institute Valuation and Property Standards will include a section for the valuer to provide additional comments. Additional comments can be made about the content of other sections of the report and should enhance or elaborate on what has already been provided.</Definition>
	</Term>
	<Term Name="Variable Rate">
		<Definition>An interest rate that varies from time to time, following fluctuations in the mortgage market and changes in the cash rate.</Definition>
		<RelatedTerm Name="Interest Rate Type" Collection="lixi"/>
		<RelatedTerm Name="Capped Rate" Collection="lixi"/>
		<RelatedTerm Name="Variable Rate Loan" Collection="lixi"/>
		<RelatedTerm Name="Interest Rate" Collection="lixi"/>
	</Term>
	<Term Name="Variable Rate Loan">
		<Definition>A loan with a variable rate. The minimum repayment obligations may change as the interest rate varies.</Definition>
		<RelatedTerm Name="Capped Rate Loan" Collection="lixi"/>
		<RelatedTerm Name="Fixed Rate Loan" Collection="lixi"/>
	</Term>
	<Term Name="Variation">
		<Definition>Changing any part of an original contract. In the case of a loan variation, changing any part of the agreed loan contract.</Definition>
		<RelatedTerm Name="Variation Type" Collection="lixi"/>
		<RelatedTerm Name="Variation Type" Collection="lixi"/>
	</Term>
	<Term Name="Variation Type">
		<Definition>The type of variation being requested, such as a principal increase, product conversion, or security substitution.</Definition>
		<RelatedTerm Name="Variation" Collection="lixi"/>
	</Term>
	<Term Name="Vendor">
		<Definition>A party (being an owner) who is selling property such as real estate or equipment.</Definition>
		<RelatedTerm Name="Deposit Bond" Collection="lixi"/>
		<RelatedTerm Name="Deposit Bond" Collection="lixi"/>
		<RelatedTerm Name="Deposit (downpayment)" Collection="lixi"/>
		<RelatedTerm Name="Acceptance" Collection="lixi"/>
	</Term>
	<Term Name="Vendor's Statement">
		<Definition>A legal document (usually prepared by the seller's solicitor) detailing material particulars regarding the property being sold.</Definition>
		<RelatedTerm Name="Section 32" Collection="lixi"/>
	</Term>
	<Term Name="Vendor's Terms">
		<Definition>The circumstance when a vendor is prepared to offer finance or other assistance such as staged payments to the purchaser to assist with the purchase of the property.</Definition>
		<RelatedTerm Name="Wrapping" Collection="lixi"/>
	</Term>
	<Term Name="Victorian Online Title System" Abbr="VOTS">
		<Definition>The electronic register at the Victorian title office.</Definition>
		<Reference URL="http://www.landexchange.vic.gov.au/ec/s_fs5.html" Name="Land Exchange"/>
		<RelatedTerm Name="VOTS" Collection="lixi"/>
	</Term>
	<Term Name="Volume">
		<Definition>A set of Folios that are filed together. A volume is identified by its Volume Number.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Volume Number" Collection="lixi"/>
		<RelatedTerm Name="Folio" Collection="lixi"/>
		<RelatedTerm Name="Register Book" Collection="lixi"/>
	</Term>
	<Term Name="Volume and Folio">
		<Definition>An identifier for a specific land title within a land registry.</Definition>
	</Term>
	<Term Name="Volume Number">
		<Definition>The number used by the land registry to identify a Volume.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Volume" Collection="lixi"/>
	</Term>
	<Term Name="Victorian Online Title System" Abbr="VOTS">
		<Definition/>
		<RelatedTerm Name="Victorian Online Title System" Collection="lixi"/>
	</Term>
	<Term Name="Walls Erected">
		<Definition/>
		<RelatedTerm Name="Frame Stage" Collection="lixi"/>
	</Term>
	<Term Name="Whole">
		<Definition>A Land Extent that specifies the quantum of land affected is the whole of the parcel of land referenced in a Land Title.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
	</Term>
	<Term Name="Wholesale Funder">
		<Definition>Wholesale funders provide "white labelled" loan products to resellers (mortgage managers), on a loan-by-loan basis (as distinct from warehouse funders). The wholesale funder generally has their own lending policy and will hold the mortgage on the loan. Examples include Adelaide Bank, ING and ANZ's Origin.</Definition>
	</Term>
	<Term Name="Wrap Account">
		<Definition/>
		<RelatedTerm Name="Superannuation Wrap Account" Collection="lixi"/>
	</Term>
	<Term Name="Wrapping">
		<Definition/>
		<RelatedTerm Name="Vendor's Terms" Collection="lixi"/>
	</Term>
	<Term Name="Writ">
		<Definition>A Constraint that, in relation to Real Property, is an order in writing to a Court officer to take certain actions as regards the Real Property of a judgment debtor, and when registered requires the Land Registry to refrain from registering certain transactions.</Definition>
		<Reference URL="http://wiki.lixi.org.au/index.php/NECS_Vocab" Name="NECS Vocab"/>
		<RelatedTerm Name="Constraint" Collection="lixi"/>
	</Term>
	<Term Name="Write Off">
		<Definition/>
		<RelatedTerm Name="Bad Debt" Collection="lixi"/>
	</Term>
	<Term Name="Yield">
		<Definition>A measurement of the annual rate of return earned on an investment, shown as a percentage of the amount invested. Yield is a function of the purchase price and interest rate.</Definition>
	</Term>
	<Term Name="Zone">
		<Definition>An area reserved for specific limited use, often subject to restrictions or conditions.</Definition>
	</Term>
	<Term Name="Zoning">
		<Definition>Statutory descriptions of the allowable uses of land as set out by local councils or planning authorities, e.g. rural use or residential density.</Definition>
	</Term>
	<Term Name="Zoning Effect">
		<Definition>Impact of zoning restrictions on real estate asset prices. </Definition>
	</Term>
</Glossary>`