# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, constr, validator

from typing import Dict, Optional

from lusid.models.batch_amend_custom_data_model_membership_response import BatchAmendCustomDataModelMembershipResponse
from lusid.models.create_custom_data_model_request import CreateCustomDataModelRequest
from lusid.models.custom_data_model import CustomDataModel
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.membership_amendment_request import MembershipAmendmentRequest
from lusid.models.resource_list_of_data_model_summary import ResourceListOfDataModelSummary
from lusid.models.resource_list_of_string import ResourceListOfString
from lusid.models.update_custom_data_model_request import UpdateCustomDataModelRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class CustomDataModelsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def batch_amend(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, MembershipAmendmentRequest], Field(..., description="The payload describing the amendments to make for the given Custom Data Model.")], **kwargs) -> BatchAmendCustomDataModelMembershipResponse:  # noqa: E501
        ...

    @overload
    def batch_amend(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, MembershipAmendmentRequest], Field(..., description="The payload describing the amendments to make for the given Custom Data Model.")], async_req: Optional[bool]=True, **kwargs) -> BatchAmendCustomDataModelMembershipResponse:  # noqa: E501
        ...

    @validate_arguments
    def batch_amend(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, MembershipAmendmentRequest], Field(..., description="The payload describing the amendments to make for the given Custom Data Model.")], async_req: Optional[bool]=None, **kwargs) -> Union[BatchAmendCustomDataModelMembershipResponse, Awaitable[BatchAmendCustomDataModelMembershipResponse]]:  # noqa: E501
        """[EXPERIMENTAL] BatchAmend: Batch amend entities Custom Data Model membership.  # noqa: E501

        Add/Remove entities to/from a Custom Data Model in a single operation.                Each amendment request must be keyed by a unique correlation ID.  This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each amendment in the response.                Note: If using partial failure modes, then it is important to check the response body for failures as any  failures will still return a 200 status code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_amend(success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial. (required)
        :type success_mode: str
        :param request_body: The payload describing the amendments to make for the given Custom Data Model. (required)
        :type request_body: Dict[str, MembershipAmendmentRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchAmendCustomDataModelMembershipResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_amend_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.batch_amend_with_http_info(success_mode, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def batch_amend_with_http_info(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, MembershipAmendmentRequest], Field(..., description="The payload describing the amendments to make for the given Custom Data Model.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] BatchAmend: Batch amend entities Custom Data Model membership.  # noqa: E501

        Add/Remove entities to/from a Custom Data Model in a single operation.                Each amendment request must be keyed by a unique correlation ID.  This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each amendment in the response.                Note: If using partial failure modes, then it is important to check the response body for failures as any  failures will still return a 200 status code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_amend_with_http_info(success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial. (required)
        :type success_mode: str
        :param request_body: The payload describing the amendments to make for the given Custom Data Model. (required)
        :type request_body: Dict[str, MembershipAmendmentRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchAmendCustomDataModelMembershipResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'success_mode',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_amend" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('success_mode') is not None:  # noqa: E501
            _query_params.append(('successMode', _params['success_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "BatchAmendCustomDataModelMembershipResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/$batchamend', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], create_custom_data_model_request : Annotated[Optional[CreateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @overload
    def create_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], create_custom_data_model_request : Annotated[Optional[CreateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, async_req: Optional[bool]=True, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @validate_arguments
    def create_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], create_custom_data_model_request : Annotated[Optional[CreateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CustomDataModel, Awaitable[CustomDataModel]]:  # noqa: E501
        """[EXPERIMENTAL] CreateCustomDataModel: Create a Custom Data Model  # noqa: E501

        Creates a Custom Data Model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_data_model(entity_type, create_custom_data_model_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param create_custom_data_model_request: The request containing the details of the Data Model.
        :type create_custom_data_model_request: CreateCustomDataModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomDataModel
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_custom_data_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_custom_data_model_with_http_info(entity_type, create_custom_data_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_custom_data_model_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], create_custom_data_model_request : Annotated[Optional[CreateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateCustomDataModel: Create a Custom Data Model  # noqa: E501

        Creates a Custom Data Model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_data_model_with_http_info(entity_type, create_custom_data_model_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param create_custom_data_model_request: The request containing the details of the Data Model.
        :type create_custom_data_model_request: CreateCustomDataModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomDataModel, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'create_custom_data_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_data_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_custom_data_model_request'] is not None:
            _body_params = _params['create_custom_data_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "CustomDataModel",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/{entityType}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteCustomDataModel: Delete a Custom Data Model  # noqa: E501

        Delete a Custom Data Model. The data model will remain viewable at previous as at times, but will no longer  be part of any hierarchies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_data_model(entity_type, scope, code, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_custom_data_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_custom_data_model_with_http_info(entity_type, scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_custom_data_model_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteCustomDataModel: Delete a Custom Data Model  # noqa: E501

        Delete a Custom Data Model. The data model will remain viewable at previous as at times, but will no longer  be part of any hierarchies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_data_model_with_http_info(entity_type, scope, code, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_data_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/{entityType}/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @overload
    def get_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @validate_arguments
    def get_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CustomDataModel, Awaitable[CustomDataModel]]:  # noqa: E501
        """[EXPERIMENTAL] GetCustomDataModel: Get a Custom Data Model  # noqa: E501

        Retrieves a Custom Data Model at a given as at time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_data_model(entity_type, scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomDataModel
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_custom_data_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_custom_data_model_with_http_info(entity_type, scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_custom_data_model_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetCustomDataModel: Get a Custom Data Model  # noqa: E501

        Retrieves a Custom Data Model at a given as at time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_data_model_with_http_info(entity_type, scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomDataModel, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_data_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomDataModel",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/{entityType}/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_data_model_hierarchies(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Only EntityType is supported")] = None, **kwargs) -> ResourceListOfDataModelSummary:  # noqa: E501
        ...

    @overload
    def list_data_model_hierarchies(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Only EntityType is supported")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfDataModelSummary:  # noqa: E501
        ...

    @validate_arguments
    def list_data_model_hierarchies(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Only EntityType is supported")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfDataModelSummary, Awaitable[ResourceListOfDataModelSummary]]:  # noqa: E501
        """[EXPERIMENTAL] ListDataModelHierarchies: List Custom Data Model hierarchies.  # noqa: E501

        Lists the data model summaries within their hierarchical structure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_model_hierarchies(as_at, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results. Only EntityType is supported
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfDataModelSummary
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_data_model_hierarchies_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_data_model_hierarchies_with_http_info(as_at, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_data_model_hierarchies_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Only EntityType is supported")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListDataModelHierarchies: List Custom Data Model hierarchies.  # noqa: E501

        Lists the data model summaries within their hierarchical structure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_model_hierarchies_with_http_info(as_at, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the Data Model. Defaults to return              the latest version of the Data Model if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results. Only EntityType is supported
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfDataModelSummary, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_model_hierarchies" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfDataModelSummary",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/hierarchies', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_supported_entity_types(self, **kwargs) -> ResourceListOfString:  # noqa: E501
        ...

    @overload
    def list_supported_entity_types(self, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfString:  # noqa: E501
        ...

    @validate_arguments
    def list_supported_entity_types(self, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfString, Awaitable[ResourceListOfString]]:  # noqa: E501
        """[EXPERIMENTAL] ListSupportedEntityTypes: List the currently supported entity types for use in Custom Data Models.  # noqa: E501

        Lists the currently supported entity types available to bind with Custom Data Models.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_supported_entity_types(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfString
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_supported_entity_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_supported_entity_types_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_supported_entity_types_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListSupportedEntityTypes: List the currently supported entity types for use in Custom Data Models.  # noqa: E501

        Lists the currently supported entity types available to bind with Custom Data Models.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_supported_entity_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfString, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_supported_entity_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfString",
        }

        return self.api_client.call_api(
            '/api/datamodel/entitytype', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], update_custom_data_model_request : Annotated[Optional[UpdateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @overload
    def update_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], update_custom_data_model_request : Annotated[Optional[UpdateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, async_req: Optional[bool]=True, **kwargs) -> CustomDataModel:  # noqa: E501
        ...

    @validate_arguments
    def update_custom_data_model(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], update_custom_data_model_request : Annotated[Optional[UpdateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CustomDataModel, Awaitable[CustomDataModel]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateCustomDataModel: Update a Custom Data Model  # noqa: E501

        Updates a Custom Data Model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_custom_data_model(entity_type, scope, code, update_custom_data_model_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param update_custom_data_model_request: The request containing the details of the Data Model.
        :type update_custom_data_model_request: UpdateCustomDataModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomDataModel
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_custom_data_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_custom_data_model_with_http_info(entity_type, scope, code, update_custom_data_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_custom_data_model_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The entity type of the Data Model.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified Data Model.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Data Model.")], update_custom_data_model_request : Annotated[Optional[UpdateCustomDataModelRequest], Field(description="The request containing the details of the Data Model.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateCustomDataModel: Update a Custom Data Model  # noqa: E501

        Updates a Custom Data Model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_custom_data_model_with_http_info(entity_type, scope, code, update_custom_data_model_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The entity type of the Data Model. (required)
        :type entity_type: str
        :param scope: The scope of the specified Data Model. (required)
        :type scope: str
        :param code: The code of the specified Data Model. (required)
        :type code: str
        :param update_custom_data_model_request: The request containing the details of the Data Model.
        :type update_custom_data_model_request: UpdateCustomDataModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomDataModel, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'scope',
            'code',
            'update_custom_data_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_data_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_custom_data_model_request'] is not None:
            _body_params = _params['update_custom_data_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomDataModel",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datamodel/{entityType}/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
