# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, conint, constr, validator

from typing import Optional

from lusid.models.custom_entity_definition import CustomEntityDefinition
from lusid.models.custom_entity_definition_request import CustomEntityDefinitionRequest
from lusid.models.paged_resource_list_of_custom_entity_definition import PagedResourceListOfCustomEntityDefinition
from lusid.models.update_custom_entity_definition_request import UpdateCustomEntityDefinitionRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class CustomEntityDefinitionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_custom_entity_definition(self, custom_entity_definition_request : Annotated[CustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @overload
    def create_custom_entity_definition(self, custom_entity_definition_request : Annotated[CustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], async_req: Optional[bool]=True, **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_custom_entity_definition(self, custom_entity_definition_request : Annotated[CustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], async_req: Optional[bool]=None, **kwargs) -> Union[CustomEntityDefinition, Awaitable[CustomEntityDefinition]]:  # noqa: E501
        """[EARLY ACCESS] CreateCustomEntityDefinition: Define a new Custom Entity type.  # noqa: E501

        The API will return a Bad Request if the Custom Entity type already exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_entity_definition(custom_entity_definition_request, async_req=True)
        >>> result = thread.get()

        :param custom_entity_definition_request: The payload containing the description of the Custom Entity type. (required)
        :type custom_entity_definition_request: CustomEntityDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_custom_entity_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_custom_entity_definition_with_http_info(custom_entity_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_custom_entity_definition_with_http_info(self, custom_entity_definition_request : Annotated[CustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateCustomEntityDefinition: Define a new Custom Entity type.  # noqa: E501

        The API will return a Bad Request if the Custom Entity type already exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_entity_definition_with_http_info(custom_entity_definition_request, async_req=True)
        >>> result = thread.get()

        :param custom_entity_definition_request: The payload containing the description of the Custom Entity type. (required)
        :type custom_entity_definition_request: CustomEntityDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomEntityDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'custom_entity_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_entity_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['custom_entity_definition_request'] is not None:
            _body_params = _params['custom_entity_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomEntityDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/entitytypes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the definition.")] = None, **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @overload
    def get_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the definition.")] = None, async_req: Optional[bool]=True, **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the definition.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CustomEntityDefinition, Awaitable[CustomEntityDefinition]]:  # noqa: E501
        """[EARLY ACCESS] GetDefinition: Get a Custom Entity type definition.  # noqa: E501

        Retrieve a CustomEntityDefinition by a specific entityType at a point in AsAt time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_definition(entity_type, as_at, async_req=True)
        >>> result = thread.get()

        :param entity_type: The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation. (required)
        :type entity_type: str
        :param as_at: The AsAt datetime at which to retrieve the definition.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_definition_with_http_info(entity_type, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_definition_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the definition.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetDefinition: Get a Custom Entity type definition.  # noqa: E501

        Retrieve a CustomEntityDefinition by a specific entityType at a point in AsAt time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_definition_with_http_info(entity_type, as_at, async_req=True)
        >>> result = thread.get()

        :param entity_type: The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation. (required)
        :type entity_type: str
        :param as_at: The AsAt datetime at which to retrieve the definition.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomEntityDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomEntityDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/entitytypes/{entityType}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_custom_entity_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.")] = None, **kwargs) -> PagedResourceListOfCustomEntityDefinition:  # noqa: E501
        ...

    @overload
    def list_custom_entity_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCustomEntityDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_custom_entity_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCustomEntityDefinition, Awaitable[PagedResourceListOfCustomEntityDefinition]]:  # noqa: E501
        """[EARLY ACCESS] ListCustomEntityDefinitions: List the Custom Entity type definitions  # noqa: E501

        List all Custom Entity type definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_custom_entity_definitions(as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCustomEntityDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_custom_entity_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_custom_entity_definitions_with_http_info(as_at, limit, filter, page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_custom_entity_definitions_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListCustomEntityDefinitions: List the Custom Entity type definitions  # noqa: E501

        List all Custom Entity type definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_custom_entity_definitions_with_http_info(as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, limit              and asAt fields must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCustomEntityDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'limit',
            'filter',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_custom_entity_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCustomEntityDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/entitytypes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_custom_entity_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], update_custom_entity_definition_request : Annotated[UpdateCustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @overload
    def update_custom_entity_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], update_custom_entity_definition_request : Annotated[UpdateCustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], async_req: Optional[bool]=True, **kwargs) -> CustomEntityDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_custom_entity_definition(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], update_custom_entity_definition_request : Annotated[UpdateCustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], async_req: Optional[bool]=None, **kwargs) -> Union[CustomEntityDefinition, Awaitable[CustomEntityDefinition]]:  # noqa: E501
        """[EARLY ACCESS] UpdateCustomEntityDefinition: Modify an existing Custom Entity type.  # noqa: E501

        The API will return a Bad Request if the Custom Entity type does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_custom_entity_definition(entity_type, update_custom_entity_definition_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation. (required)
        :type entity_type: str
        :param update_custom_entity_definition_request: The payload containing the description of the Custom Entity type. (required)
        :type update_custom_entity_definition_request: UpdateCustomEntityDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_custom_entity_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_custom_entity_definition_with_http_info(entity_type, update_custom_entity_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_custom_entity_definition_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation.")], update_custom_entity_definition_request : Annotated[UpdateCustomEntityDefinitionRequest, Field(..., description="The payload containing the description of the Custom Entity type.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateCustomEntityDefinition: Modify an existing Custom Entity type.  # noqa: E501

        The API will return a Bad Request if the Custom Entity type does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_custom_entity_definition_with_http_info(entity_type, update_custom_entity_definition_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The identifier for the Custom Entity type, derived from the \"entityTypeName\" provided on creation. (required)
        :type entity_type: str
        :param update_custom_entity_definition_request: The payload containing the description of the Custom Entity type. (required)
        :type update_custom_entity_definition_request: UpdateCustomEntityDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomEntityDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'update_custom_entity_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_entity_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_custom_entity_definition_request'] is not None:
            _body_params = _params['update_custom_entity_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomEntityDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/entitytypes/{entityType}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
