# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist 
from lusid.models.link import Link

class StagedModificationsEntityHrefs(BaseModel):
    """
    StagedModificationsEntityHrefs
    """
    when_staged:  Optional[StrictStr] = Field(None,alias="whenStaged", description="The specific Uniform Resource Identifier (URI) for the staged modification change at the time when the change was requested.") 
    preview:  Optional[StrictStr] = Field(None,alias="preview", description="The specific Uniform Resource Identifier (URI) for the preview of staged modification change once applied.") 
    latest:  Optional[StrictStr] = Field(None,alias="latest", description="The specific Uniform Resource Identifier (URI) for the staged modification at latest time.") 
    links: Optional[conlist(Link)] = None
    __properties = ["whenStaged", "preview", "latest", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagedModificationsEntityHrefs:
        """Create an instance of StagedModificationsEntityHrefs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if when_staged (nullable) is None
        # and __fields_set__ contains the field
        if self.when_staged is None and "when_staged" in self.__fields_set__:
            _dict['whenStaged'] = None

        # set to None if preview (nullable) is None
        # and __fields_set__ contains the field
        if self.preview is None and "preview" in self.__fields_set__:
            _dict['preview'] = None

        # set to None if latest (nullable) is None
        # and __fields_set__ contains the field
        if self.latest is None and "latest" in self.__fields_set__:
            _dict['latest'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagedModificationsEntityHrefs:
        """Create an instance of StagedModificationsEntityHrefs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagedModificationsEntityHrefs.parse_obj(obj)

        _obj = StagedModificationsEntityHrefs.parse_obj({
            "when_staged": obj.get("whenStaged"),
            "preview": obj.get("preview"),
            "latest": obj.get("latest"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
