# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr 
from lusid.models.link import Link
from lusid.models.model_property import ModelProperty

class ValuationPointOverview(BaseModel):
    """
    ValuationPointOverview
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    diary_entry_code:  StrictStr = Field(...,alias="diaryEntryCode", description="The code for the Valuation Point.") 
    effective_from: datetime = Field(..., alias="effectiveFrom", description="The effective time of the last Valuation Point.")
    effective_to: datetime = Field(..., alias="effectiveTo", description="The effective time of the current Valuation Point.")
    query_as_at: Optional[datetime] = Field(None, alias="queryAsAt", description="The query time of the Valuation Point. Defaults to latest.")
    type:  StrictStr = Field(...,alias="type", description="The type of the diary entry. This is 'ValuationPoint'.") 
    status:  StrictStr = Field(...,alias="status", description="The status of the Valuation Point. Can be 'Estimate', 'Candidate' or 'Final'.") 
    gav: Union[StrictFloat, StrictInt] = Field(..., description="The Gross Asset Value of the Fund or Share Class at the Valuation Point. This is effectively a summation of all Trial balance entries linked to accounts of types 'Asset' and 'Liabilities'.")
    nav: Union[StrictFloat, StrictInt] = Field(..., description="The Net Asset Value of the Fund or Share Class at the Valuation Point. This represents the GAV with any fees applied in the period.")
    properties: Optional[Dict[str, ModelProperty]] = Field(None, description="The Fee properties. These will be from the 'Fee' domain.")
    links: Optional[conlist(Link)] = None
    __properties = ["href", "diaryEntryCode", "effectiveFrom", "effectiveTo", "queryAsAt", "type", "status", "gav", "nav", "properties", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ValuationPointOverview:
        """Create an instance of ValuationPointOverview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ValuationPointOverview:
        """Create an instance of ValuationPointOverview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ValuationPointOverview.parse_obj(obj)

        _obj = ValuationPointOverview.parse_obj({
            "href": obj.get("href"),
            "diary_entry_code": obj.get("diaryEntryCode"),
            "effective_from": obj.get("effectiveFrom"),
            "effective_to": obj.get("effectiveTo"),
            "query_as_at": obj.get("queryAsAt"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "gav": obj.get("gav"),
            "nav": obj.get("nav"),
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
