"""
EvenAge - A small-surface, high-abstraction distributed agent framework.

EvenAge provides:
- Minimal API with @actor and @tool decorators
- Pluggable backends (queue, database, LLM, cache, vector)
- Internal observability (no Jaeger/Prometheus needed)
- Async-first architecture
- Docker-native execution
- Real distributed runtime with message bus
"""

__version__ = "0.4.0"

# Core exports
from evenage.core import (
    Agent,
    AgentConfig,
    AgentRunner,
    BackendFactory,
    DatabaseService,
    EvenAgeConfig,
    MemoryBus,
    RedisBus,
    ToolRegistry,
    actor,
    discover_tools,
    run_agent,
    tool,
)


__all__ = [
    # Main API
    "Agent",
    "AgentRunner",
    "actor",
    "tool",
    "run_agent",
    # Configuration
    "EvenAgeConfig",
    "AgentConfig",
    "BackendFactory",
    # Core services
    "DatabaseService",
    "RedisBus",
    "MemoryBus",
    "ToolRegistry",
    "discover_tools",
]
