"""
EvenAge Core module.

Exports:
- Configuration: EvenAgeConfig, AgentConfig, ProjectConfig
- Agent runtime: Agent, AgentRunner, run_agent
- Decorators: actor, tool
- Backends: BackendFactory
- Database: DatabaseService
- Message bus: RedisBus, MemoryBus
- Tool registry: ToolRegistry, discover_tools, bind_tools
- Coordinator: CoordinatorRuntime
- MCP: MCPToolSource, MCPToolRegistry
"""

from .agent_runtime import Agent, AgentMemory
from .cache import InMemoryCache, RedisCache
from .config import (
    AgentConfig,
    BackendFactory,
    CacheBackend as CacheBackendProtocol,
    DatabaseBackend,
    EvenAgeConfig,
    LLMBackend,
    PipelineConfig,
    ProjectConfig,
    QueueBackend,
    VectorBackend,
)
from .coordinator_runtime import CoordinatorRuntime
from .database import (
    AgentRegistry,
    DatabaseService,
    Job,
    Memory,
    PromptExecution,
    Trace,
)
from .decorators import actor
from .llm import AnthropicLLM, GeminiLLM, NoOpLLM, OpenAILLM
from .mcp_client import MCPToolRegistry, MCPToolSource
from .message_bus import MemoryBus, RedisBus, ResponseMessage, TaskMessage
from .runtime_entry import AgentRunner, run_agent
from .tooling import (
    Tool,
    ToolRegistry,
    bind_tools,
    create_tool_schema,
    discover_tools,
    register_mcp_tools,
    tool,
)
from .vector import LocalVectorStore


# Backward-compatible aliases for protocol types
LLMBase = LLMBackend
VectorBase = VectorBackend

__all__ = [
    # Core classes
    "Agent",
    "AgentMemory",
    "AgentRunner",
    "run_agent",
    # Decorators
    "actor",
    "tool",
    # Configuration
    "EvenAgeConfig",
    "AgentConfig",
    "ProjectConfig",
    "PipelineConfig",
    "BackendFactory",
    # Database
    "DatabaseService",
    "Job",
    "PromptExecution",
    "Trace",
    "Memory",
    "AgentRegistry",
    # Message bus
    "RedisBus",
    "MemoryBus",
    "TaskMessage",
    "ResponseMessage",
    # Tooling
    "Tool",
    "ToolRegistry",
    "discover_tools",
    "bind_tools",
    "register_mcp_tools",
    "create_tool_schema",
    # Coordinator
    "CoordinatorRuntime",
    # MCP
    "MCPToolSource",
    "MCPToolRegistry",
    # Backend protocols
    "QueueBackend",
    "DatabaseBackend",
    "VectorBackend",
    "LLMBackend",
    "CacheBackendProtocol",
    # Backend implementations
    "InMemoryCache",
    "RedisCache",
    "NoOpLLM",
    "OpenAILLM",
    "AnthropicLLM",
    "GeminiLLM",
    "LocalVectorStore",
    "LLMBase",
    "VectorBase",
]
