import asyncio
from evenage.core import AgentConfig, EvenAgeConfig
from .agents.diagnostic.handler import DiagnosticAgent


def test_memory_persistence_roundtrip():
    cfg = EvenAgeConfig(queue_backend="memory", db_backend="sqlite", database_url="sqlite:///:memory:")
    agent_cfg = AgentConfig(name="diagnostic", role="Diagnostic", goal="Test")
    agent = DiagnosticAgent(agent_cfg, cfg)

    async def run():
        await agent.connect_bus()
        res = await agent.handle({"message": "ping"})
        assert res["status"] == "success"
        # memory was written in custom step
        stored = agent.database.memory_get("diagnostic", "last_message", res["job_id"])
        assert stored == "ping"

    asyncio.run(run())
