import asyncio
from evenage.core import AgentConfig, EvenAgeConfig
from .agents.diagnostic.handler import DiagnosticAgent


async def _prepare_agent():
    cfg = EvenAgeConfig(queue_backend="memory", db_backend="sqlite", database_url="sqlite:///:memory:")
    agent_cfg = AgentConfig(name="diagnostic", role="Diagnostic", goal="Test")
    agent = DiagnosticAgent(agent_cfg, cfg)
    await agent.connect_bus()
    return agent


def test_tool_registration():
    agent = asyncio.run(_prepare_agent())
    tools = agent.tools.list_names()
    assert "echo" in tools
    assert "sum" in tools
    # system tools should be present (allow legacy names for backward-compat)
    assert any(
        t.startswith("system_") or t in {"delegate_task", "store_artifact", "retrieve_artifact", "list_artifacts"}
        for t in tools
    )
