# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CedgeMulticastFeatureTemplateArgs', 'CedgeMulticastFeatureTemplate']

@pulumi.input_type
class CedgeMulticastFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 local_replicator: Optional[pulumi.Input[bool]] = None,
                 local_replicator_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spt_only: Optional[pulumi.Input[bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 threshold_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CedgeMulticastFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[str] local_replicator_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[str] spt_only_variable: Variable name
        :param pulumi.Input[int] threshold: Set number of joins per group the router supports - Range: `0`-`1000`
        :param pulumi.Input[str] threshold_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if local_replicator is not None:
            pulumi.set(__self__, "local_replicator", local_replicator)
        if local_replicator_variable is not None:
            pulumi.set(__self__, "local_replicator_variable", local_replicator_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spt_only is not None:
            pulumi.set(__self__, "spt_only", spt_only)
        if spt_only_variable is not None:
            pulumi.set(__self__, "spt_only_variable", spt_only_variable)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_variable is not None:
            pulumi.set(__self__, "threshold_variable", threshold_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> Optional[pulumi.Input[bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @local_replicator.setter
    def local_replicator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_replicator", value)

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @local_replicator_variable.setter
    def local_replicator_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_replicator_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @spt_only.setter
    def spt_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spt_only", value)

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @spt_only_variable.setter
    def spt_only_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spt_only_variable", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`1000`
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @threshold_variable.setter
    def threshold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold_variable", value)


@pulumi.input_type
class _CedgeMulticastFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_replicator: Optional[pulumi.Input[bool]] = None,
                 local_replicator_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spt_only: Optional[pulumi.Input[bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 threshold_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CedgeMulticastFeatureTemplate resources.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[str] local_replicator_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[str] spt_only_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] threshold: Set number of joins per group the router supports - Range: `0`-`1000`
        :param pulumi.Input[str] threshold_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if local_replicator is not None:
            pulumi.set(__self__, "local_replicator", local_replicator)
        if local_replicator_variable is not None:
            pulumi.set(__self__, "local_replicator_variable", local_replicator_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spt_only is not None:
            pulumi.set(__self__, "spt_only", spt_only)
        if spt_only_variable is not None:
            pulumi.set(__self__, "spt_only_variable", spt_only_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_variable is not None:
            pulumi.set(__self__, "threshold_variable", threshold_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> Optional[pulumi.Input[bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @local_replicator.setter
    def local_replicator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_replicator", value)

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @local_replicator_variable.setter
    def local_replicator_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_replicator_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @spt_only.setter
    def spt_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spt_only", value)

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @spt_only_variable.setter
    def spt_only_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spt_only_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`1000`
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @threshold_variable.setter
    def threshold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CedgeMulticastFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_replicator: Optional[pulumi.Input[bool]] = None,
                 local_replicator_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spt_only: Optional[pulumi.Input[bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 threshold_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a cEdge Multicast feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CedgeMulticastFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            spt_only=True,
            local_replicator=True,
            threshold=200)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cedgeMulticastFeatureTemplate:CedgeMulticastFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[str] local_replicator_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[str] spt_only_variable: Variable name
        :param pulumi.Input[int] threshold: Set number of joins per group the router supports - Range: `0`-`1000`
        :param pulumi.Input[str] threshold_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CedgeMulticastFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a cEdge Multicast feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CedgeMulticastFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            spt_only=True,
            local_replicator=True,
            threshold=200)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cedgeMulticastFeatureTemplate:CedgeMulticastFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CedgeMulticastFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CedgeMulticastFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_replicator: Optional[pulumi.Input[bool]] = None,
                 local_replicator_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spt_only: Optional[pulumi.Input[bool]] = None,
                 spt_only_variable: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 threshold_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CedgeMulticastFeatureTemplateArgs.__new__(CedgeMulticastFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["local_replicator"] = local_replicator
            __props__.__dict__["local_replicator_variable"] = local_replicator_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["spt_only"] = spt_only
            __props__.__dict__["spt_only_variable"] = spt_only_variable
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["threshold_variable"] = threshold_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CedgeMulticastFeatureTemplate, __self__).__init__(
            'sdwan:index/cedgeMulticastFeatureTemplate:CedgeMulticastFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local_replicator: Optional[pulumi.Input[bool]] = None,
            local_replicator_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            spt_only: Optional[pulumi.Input[bool]] = None,
            spt_only_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            threshold: Optional[pulumi.Input[int]] = None,
            threshold_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CedgeMulticastFeatureTemplate':
        """
        Get an existing CedgeMulticastFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] local_replicator: Replicator is local to this device - Default value: `false`
        :param pulumi.Input[str] local_replicator_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] spt_only: Shortest Path Tree (SPT) Only Mode - Default value: `false`
        :param pulumi.Input[str] spt_only_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] threshold: Set number of joins per group the router supports - Range: `0`-`1000`
        :param pulumi.Input[str] threshold_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CedgeMulticastFeatureTemplateState.__new__(_CedgeMulticastFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["local_replicator"] = local_replicator
        __props__.__dict__["local_replicator_variable"] = local_replicator_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["spt_only"] = spt_only
        __props__.__dict__["spt_only_variable"] = spt_only_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["threshold_variable"] = threshold_variable
        __props__.__dict__["version"] = version
        return CedgeMulticastFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> pulumi.Output[Optional[bool]]:
        """
        Replicator is local to this device - Default value: `false`
        """
        return pulumi.get(self, "local_replicator")

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Shortest Path Tree (SPT) Only Mode - Default value: `false`
        """
        return pulumi.get(self, "spt_only")

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Set number of joins per group the router supports - Range: `0`-`1000`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

