# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CentralizedPolicyArgs', 'CentralizedPolicy']

@pulumi.input_type
class CentralizedPolicyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CentralizedPolicy resource.
        :param pulumi.Input[str] description: The description of the centralized policy
        :param pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[str] name: The name of the centralized policy
        """
        pulumi.set(__self__, "description", description)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the centralized policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the centralized policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CentralizedPolicyState:
    def __init__(__self__, *,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CentralizedPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the centralized policy
        :param pulumi.Input[str] name: The name of the centralized policy
        :param pulumi.Input[int] version: The version of the object
        """
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CentralizedPolicyDefinitionArgs']]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the centralized policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the centralized policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CentralizedPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CentralizedPolicyDefinitionArgs', 'CentralizedPolicyDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Centralized Policy .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CentralizedPolicy("example",
            name="Example",
            description="My description",
            definitions=[{
                "id": "2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                "type": "data",
                "entries": [{
                    "site_list_ids": ["2081c2f4-3f9f-4fee-8078-dcc8904e368d"],
                    "vpn_list_ids": ["7d0c2444-8743-4414-add0-866945ea9f70"],
                    "direction": "service",
                }],
            }])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/centralizedPolicy:CentralizedPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CentralizedPolicyDefinitionArgs', 'CentralizedPolicyDefinitionArgsDict']]]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the centralized policy
        :param pulumi.Input[str] name: The name of the centralized policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CentralizedPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Centralized Policy .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CentralizedPolicy("example",
            name="Example",
            description="My description",
            definitions=[{
                "id": "2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                "type": "data",
                "entries": [{
                    "site_list_ids": ["2081c2f4-3f9f-4fee-8078-dcc8904e368d"],
                    "vpn_list_ids": ["7d0c2444-8743-4414-add0-866945ea9f70"],
                    "direction": "service",
                }],
            }])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/centralizedPolicy:CentralizedPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CentralizedPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CentralizedPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CentralizedPolicyDefinitionArgs', 'CentralizedPolicyDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CentralizedPolicyArgs.__new__(CentralizedPolicyArgs)

            __props__.__dict__["definitions"] = definitions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(CentralizedPolicy, __self__).__init__(
            'sdwan:index/centralizedPolicy:CentralizedPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CentralizedPolicyDefinitionArgs', 'CentralizedPolicyDefinitionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CentralizedPolicy':
        """
        Get an existing CentralizedPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CentralizedPolicyDefinitionArgs', 'CentralizedPolicyDefinitionArgsDict']]]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the centralized policy
        :param pulumi.Input[str] name: The name of the centralized policy
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CentralizedPolicyState.__new__(_CentralizedPolicyState)

        __props__.__dict__["definitions"] = definitions
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return CentralizedPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Output[Optional[Sequence['outputs.CentralizedPolicyDefinition']]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the centralized policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the centralized policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

