# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoOspfv3FeatureTemplateArgs', 'CiscoOspfv3FeatureTemplate']

@pulumi.input_type
class CiscoOspfv3FeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 ipv4_areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]] = None,
                 ipv4_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv4_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv4_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv4_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_filter: Optional[pulumi.Input[bool]] = None,
                 ipv4_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]] = None,
                 ipv4_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv4_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]] = None,
                 ipv4_router_id: Optional[pulumi.Input[str]] = None,
                 ipv4_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]] = None,
                 ipv6_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv6_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv6_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv6_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_filter: Optional[pulumi.Input[bool]] = None,
                 ipv6_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]] = None,
                 ipv6_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv6_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]] = None,
                 ipv6_router_id: Optional[pulumi.Input[str]] = None,
                 ipv6_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoOspfv3FeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]] ipv4_areas: Configure OSPF area
        :param pulumi.Input[int] ipv4_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv4_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv4_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv4_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv4_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv4_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv4_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv4_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv4_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv4_distance: Distance - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[int] ipv4_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv4_distance_variable: Variable name
        :param pulumi.Input[bool] ipv4_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv4_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]] ipv4_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv4_policy_name: Policy Name
        :param pulumi.Input[str] ipv4_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]] ipv4_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv4_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv4_router_id_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv4_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv4_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv4_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]] ipv6_areas: Configure OSPF area
        :param pulumi.Input[int] ipv6_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv6_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv6_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv6_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv6_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv6_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv6_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv6_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv6_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv6_distance: Distance - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[int] ipv6_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv6_distance_variable: Variable name
        :param pulumi.Input[bool] ipv6_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv6_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]] ipv6_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv6_policy_name: Name
        :param pulumi.Input[str] ipv6_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]] ipv6_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv6_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv6_router_id_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv6_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv6_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv6_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if ipv4_areas is not None:
            pulumi.set(__self__, "ipv4_areas", ipv4_areas)
        if ipv4_auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "ipv4_auto_cost_reference_bandwidth", ipv4_auto_cost_reference_bandwidth)
        if ipv4_auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "ipv4_auto_cost_reference_bandwidth_variable", ipv4_auto_cost_reference_bandwidth_variable)
        if ipv4_compatible_rfc1583 is not None:
            pulumi.set(__self__, "ipv4_compatible_rfc1583", ipv4_compatible_rfc1583)
        if ipv4_compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "ipv4_compatible_rfc1583_variable", ipv4_compatible_rfc1583_variable)
        if ipv4_default_information_originate is not None:
            pulumi.set(__self__, "ipv4_default_information_originate", ipv4_default_information_originate)
        if ipv4_default_information_originate_always is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_always", ipv4_default_information_originate_always)
        if ipv4_default_information_originate_always_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_always_variable", ipv4_default_information_originate_always_variable)
        if ipv4_default_information_originate_metric is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric", ipv4_default_information_originate_metric)
        if ipv4_default_information_originate_metric_type is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_type", ipv4_default_information_originate_metric_type)
        if ipv4_default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_type_variable", ipv4_default_information_originate_metric_type_variable)
        if ipv4_default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_variable", ipv4_default_information_originate_metric_variable)
        if ipv4_distance is not None:
            pulumi.set(__self__, "ipv4_distance", ipv4_distance)
        if ipv4_distance_external is not None:
            pulumi.set(__self__, "ipv4_distance_external", ipv4_distance_external)
        if ipv4_distance_external_variable is not None:
            pulumi.set(__self__, "ipv4_distance_external_variable", ipv4_distance_external_variable)
        if ipv4_distance_inter_area is not None:
            pulumi.set(__self__, "ipv4_distance_inter_area", ipv4_distance_inter_area)
        if ipv4_distance_inter_area_variable is not None:
            pulumi.set(__self__, "ipv4_distance_inter_area_variable", ipv4_distance_inter_area_variable)
        if ipv4_distance_intra_area is not None:
            pulumi.set(__self__, "ipv4_distance_intra_area", ipv4_distance_intra_area)
        if ipv4_distance_intra_area_variable is not None:
            pulumi.set(__self__, "ipv4_distance_intra_area_variable", ipv4_distance_intra_area_variable)
        if ipv4_distance_variable is not None:
            pulumi.set(__self__, "ipv4_distance_variable", ipv4_distance_variable)
        if ipv4_filter is not None:
            pulumi.set(__self__, "ipv4_filter", ipv4_filter)
        if ipv4_filter_variable is not None:
            pulumi.set(__self__, "ipv4_filter_variable", ipv4_filter_variable)
        if ipv4_max_metric_router_lsas is not None:
            pulumi.set(__self__, "ipv4_max_metric_router_lsas", ipv4_max_metric_router_lsas)
        if ipv4_policy_name is not None:
            pulumi.set(__self__, "ipv4_policy_name", ipv4_policy_name)
        if ipv4_policy_name_variable is not None:
            pulumi.set(__self__, "ipv4_policy_name_variable", ipv4_policy_name_variable)
        if ipv4_redistributes is not None:
            pulumi.set(__self__, "ipv4_redistributes", ipv4_redistributes)
        if ipv4_router_id is not None:
            pulumi.set(__self__, "ipv4_router_id", ipv4_router_id)
        if ipv4_router_id_variable is not None:
            pulumi.set(__self__, "ipv4_router_id_variable", ipv4_router_id_variable)
        if ipv4_timers_spf_delay is not None:
            pulumi.set(__self__, "ipv4_timers_spf_delay", ipv4_timers_spf_delay)
        if ipv4_timers_spf_delay_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_delay_variable", ipv4_timers_spf_delay_variable)
        if ipv4_timers_spf_initial_hold is not None:
            pulumi.set(__self__, "ipv4_timers_spf_initial_hold", ipv4_timers_spf_initial_hold)
        if ipv4_timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_initial_hold_variable", ipv4_timers_spf_initial_hold_variable)
        if ipv4_timers_spf_max_hold is not None:
            pulumi.set(__self__, "ipv4_timers_spf_max_hold", ipv4_timers_spf_max_hold)
        if ipv4_timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_max_hold_variable", ipv4_timers_spf_max_hold_variable)
        if ipv6_areas is not None:
            pulumi.set(__self__, "ipv6_areas", ipv6_areas)
        if ipv6_auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "ipv6_auto_cost_reference_bandwidth", ipv6_auto_cost_reference_bandwidth)
        if ipv6_auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "ipv6_auto_cost_reference_bandwidth_variable", ipv6_auto_cost_reference_bandwidth_variable)
        if ipv6_compatible_rfc1583 is not None:
            pulumi.set(__self__, "ipv6_compatible_rfc1583", ipv6_compatible_rfc1583)
        if ipv6_compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "ipv6_compatible_rfc1583_variable", ipv6_compatible_rfc1583_variable)
        if ipv6_default_information_originate is not None:
            pulumi.set(__self__, "ipv6_default_information_originate", ipv6_default_information_originate)
        if ipv6_default_information_originate_always is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_always", ipv6_default_information_originate_always)
        if ipv6_default_information_originate_always_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_always_variable", ipv6_default_information_originate_always_variable)
        if ipv6_default_information_originate_metric is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric", ipv6_default_information_originate_metric)
        if ipv6_default_information_originate_metric_type is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_type", ipv6_default_information_originate_metric_type)
        if ipv6_default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_type_variable", ipv6_default_information_originate_metric_type_variable)
        if ipv6_default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_variable", ipv6_default_information_originate_metric_variable)
        if ipv6_distance is not None:
            pulumi.set(__self__, "ipv6_distance", ipv6_distance)
        if ipv6_distance_external is not None:
            pulumi.set(__self__, "ipv6_distance_external", ipv6_distance_external)
        if ipv6_distance_external_variable is not None:
            pulumi.set(__self__, "ipv6_distance_external_variable", ipv6_distance_external_variable)
        if ipv6_distance_inter_area is not None:
            pulumi.set(__self__, "ipv6_distance_inter_area", ipv6_distance_inter_area)
        if ipv6_distance_inter_area_variable is not None:
            pulumi.set(__self__, "ipv6_distance_inter_area_variable", ipv6_distance_inter_area_variable)
        if ipv6_distance_intra_area is not None:
            pulumi.set(__self__, "ipv6_distance_intra_area", ipv6_distance_intra_area)
        if ipv6_distance_intra_area_variable is not None:
            pulumi.set(__self__, "ipv6_distance_intra_area_variable", ipv6_distance_intra_area_variable)
        if ipv6_distance_variable is not None:
            pulumi.set(__self__, "ipv6_distance_variable", ipv6_distance_variable)
        if ipv6_filter is not None:
            pulumi.set(__self__, "ipv6_filter", ipv6_filter)
        if ipv6_filter_variable is not None:
            pulumi.set(__self__, "ipv6_filter_variable", ipv6_filter_variable)
        if ipv6_max_metric_router_lsas is not None:
            pulumi.set(__self__, "ipv6_max_metric_router_lsas", ipv6_max_metric_router_lsas)
        if ipv6_policy_name is not None:
            pulumi.set(__self__, "ipv6_policy_name", ipv6_policy_name)
        if ipv6_policy_name_variable is not None:
            pulumi.set(__self__, "ipv6_policy_name_variable", ipv6_policy_name_variable)
        if ipv6_redistributes is not None:
            pulumi.set(__self__, "ipv6_redistributes", ipv6_redistributes)
        if ipv6_router_id is not None:
            pulumi.set(__self__, "ipv6_router_id", ipv6_router_id)
        if ipv6_router_id_variable is not None:
            pulumi.set(__self__, "ipv6_router_id_variable", ipv6_router_id_variable)
        if ipv6_timers_spf_delay is not None:
            pulumi.set(__self__, "ipv6_timers_spf_delay", ipv6_timers_spf_delay)
        if ipv6_timers_spf_delay_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_delay_variable", ipv6_timers_spf_delay_variable)
        if ipv6_timers_spf_initial_hold is not None:
            pulumi.set(__self__, "ipv6_timers_spf_initial_hold", ipv6_timers_spf_initial_hold)
        if ipv6_timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_initial_hold_variable", ipv6_timers_spf_initial_hold_variable)
        if ipv6_timers_spf_max_hold is not None:
            pulumi.set(__self__, "ipv6_timers_spf_max_hold", ipv6_timers_spf_max_hold)
        if ipv6_timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_max_hold_variable", ipv6_timers_spf_max_hold_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ipv4Areas")
    def ipv4_areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv4_areas")

    @ipv4_areas.setter
    def ipv4_areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]]):
        pulumi.set(self, "ipv4_areas", value)

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidth")
    def ipv4_auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth")

    @ipv4_auto_cost_reference_bandwidth.setter
    def ipv4_auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidthVariable")
    def ipv4_auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth_variable")

    @ipv4_auto_cost_reference_bandwidth_variable.setter
    def ipv4_auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583")
    def ipv4_compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583")

    @ipv4_compatible_rfc1583.setter
    def ipv4_compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_compatible_rfc1583", value)

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583Variable")
    def ipv4_compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583_variable")

    @ipv4_compatible_rfc1583_variable.setter
    def ipv4_compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginate")
    def ipv4_default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate")

    @ipv4_default_information_originate.setter
    def ipv4_default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_default_information_originate", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlways")
    def ipv4_default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate_always")

    @ipv4_default_information_originate_always.setter
    def ipv4_default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_default_information_originate_always", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlwaysVariable")
    def ipv4_default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_always_variable")

    @ipv4_default_information_originate_always_variable.setter
    def ipv4_default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetric")
    def ipv4_default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric")

    @ipv4_default_information_originate_metric.setter
    def ipv4_default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_default_information_originate_metric", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricType")
    def ipv4_default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type")

    @ipv4_default_information_originate_metric_type.setter
    def ipv4_default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricTypeVariable")
    def ipv4_default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type_variable")

    @ipv4_default_information_originate_metric_type_variable.setter
    def ipv4_default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricVariable")
    def ipv4_default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_variable")

    @ipv4_default_information_originate_metric_variable.setter
    def ipv4_default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_variable", value)

    @property
    @pulumi.getter(name="ipv4Distance")
    def ipv4_distance(self) -> Optional[pulumi.Input[int]]:
        """
        Distance - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance")

    @ipv4_distance.setter
    def ipv4_distance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance", value)

    @property
    @pulumi.getter(name="ipv4DistanceExternal")
    def ipv4_distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_external")

    @ipv4_distance_external.setter
    def ipv4_distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_external", value)

    @property
    @pulumi.getter(name="ipv4DistanceExternalVariable")
    def ipv4_distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_external_variable")

    @ipv4_distance_external_variable.setter
    def ipv4_distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_external_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceInterArea")
    def ipv4_distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_inter_area")

    @ipv4_distance_inter_area.setter
    def ipv4_distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_inter_area", value)

    @property
    @pulumi.getter(name="ipv4DistanceInterAreaVariable")
    def ipv4_distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_inter_area_variable")

    @ipv4_distance_inter_area_variable.setter
    def ipv4_distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceIntraArea")
    def ipv4_distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_intra_area")

    @ipv4_distance_intra_area.setter
    def ipv4_distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_intra_area", value)

    @property
    @pulumi.getter(name="ipv4DistanceIntraAreaVariable")
    def ipv4_distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_intra_area_variable")

    @ipv4_distance_intra_area_variable.setter
    def ipv4_distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceVariable")
    def ipv4_distance_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_variable")

    @ipv4_distance_variable.setter
    def ipv4_distance_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_variable", value)

    @property
    @pulumi.getter(name="ipv4Filter")
    def ipv4_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv4_filter")

    @ipv4_filter.setter
    def ipv4_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_filter", value)

    @property
    @pulumi.getter(name="ipv4FilterVariable")
    def ipv4_filter_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_filter_variable")

    @ipv4_filter_variable.setter
    def ipv4_filter_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_filter_variable", value)

    @property
    @pulumi.getter(name="ipv4MaxMetricRouterLsas")
    def ipv4_max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv4_max_metric_router_lsas")

    @ipv4_max_metric_router_lsas.setter
    def ipv4_max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "ipv4_max_metric_router_lsas", value)

    @property
    @pulumi.getter(name="ipv4PolicyName")
    def ipv4_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "ipv4_policy_name")

    @ipv4_policy_name.setter
    def ipv4_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_policy_name", value)

    @property
    @pulumi.getter(name="ipv4PolicyNameVariable")
    def ipv4_policy_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_policy_name_variable")

    @ipv4_policy_name_variable.setter
    def ipv4_policy_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_policy_name_variable", value)

    @property
    @pulumi.getter(name="ipv4Redistributes")
    def ipv4_redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv4_redistributes")

    @ipv4_redistributes.setter
    def ipv4_redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]]):
        pulumi.set(self, "ipv4_redistributes", value)

    @property
    @pulumi.getter(name="ipv4RouterId")
    def ipv4_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv4_router_id")

    @ipv4_router_id.setter
    def ipv4_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_router_id", value)

    @property
    @pulumi.getter(name="ipv4RouterIdVariable")
    def ipv4_router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_router_id_variable")

    @ipv4_router_id_variable.setter
    def ipv4_router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_router_id_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfDelay")
    def ipv4_timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv4_timers_spf_delay")

    @ipv4_timers_spf_delay.setter
    def ipv4_timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_delay", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfDelayVariable")
    def ipv4_timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_delay_variable")

    @ipv4_timers_spf_delay_variable.setter
    def ipv4_timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHold")
    def ipv4_timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold")

    @ipv4_timers_spf_initial_hold.setter
    def ipv4_timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHoldVariable")
    def ipv4_timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold_variable")

    @ipv4_timers_spf_initial_hold_variable.setter
    def ipv4_timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHold")
    def ipv4_timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold")

    @ipv4_timers_spf_max_hold.setter
    def ipv4_timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHoldVariable")
    def ipv4_timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold_variable")

    @ipv4_timers_spf_max_hold_variable.setter
    def ipv4_timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_max_hold_variable", value)

    @property
    @pulumi.getter(name="ipv6Areas")
    def ipv6_areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv6_areas")

    @ipv6_areas.setter
    def ipv6_areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]]):
        pulumi.set(self, "ipv6_areas", value)

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidth")
    def ipv6_auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth")

    @ipv6_auto_cost_reference_bandwidth.setter
    def ipv6_auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidthVariable")
    def ipv6_auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth_variable")

    @ipv6_auto_cost_reference_bandwidth_variable.setter
    def ipv6_auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583")
    def ipv6_compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583")

    @ipv6_compatible_rfc1583.setter
    def ipv6_compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_compatible_rfc1583", value)

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583Variable")
    def ipv6_compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583_variable")

    @ipv6_compatible_rfc1583_variable.setter
    def ipv6_compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginate")
    def ipv6_default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate")

    @ipv6_default_information_originate.setter
    def ipv6_default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_default_information_originate", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlways")
    def ipv6_default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate_always")

    @ipv6_default_information_originate_always.setter
    def ipv6_default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_default_information_originate_always", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlwaysVariable")
    def ipv6_default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_always_variable")

    @ipv6_default_information_originate_always_variable.setter
    def ipv6_default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetric")
    def ipv6_default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric")

    @ipv6_default_information_originate_metric.setter
    def ipv6_default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_default_information_originate_metric", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricType")
    def ipv6_default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type")

    @ipv6_default_information_originate_metric_type.setter
    def ipv6_default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricTypeVariable")
    def ipv6_default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type_variable")

    @ipv6_default_information_originate_metric_type_variable.setter
    def ipv6_default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricVariable")
    def ipv6_default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_variable")

    @ipv6_default_information_originate_metric_variable.setter
    def ipv6_default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_variable", value)

    @property
    @pulumi.getter(name="ipv6Distance")
    def ipv6_distance(self) -> Optional[pulumi.Input[int]]:
        """
        Distance - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance")

    @ipv6_distance.setter
    def ipv6_distance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance", value)

    @property
    @pulumi.getter(name="ipv6DistanceExternal")
    def ipv6_distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_external")

    @ipv6_distance_external.setter
    def ipv6_distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_external", value)

    @property
    @pulumi.getter(name="ipv6DistanceExternalVariable")
    def ipv6_distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_external_variable")

    @ipv6_distance_external_variable.setter
    def ipv6_distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_external_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceInterArea")
    def ipv6_distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_inter_area")

    @ipv6_distance_inter_area.setter
    def ipv6_distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_inter_area", value)

    @property
    @pulumi.getter(name="ipv6DistanceInterAreaVariable")
    def ipv6_distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_inter_area_variable")

    @ipv6_distance_inter_area_variable.setter
    def ipv6_distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceIntraArea")
    def ipv6_distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_intra_area")

    @ipv6_distance_intra_area.setter
    def ipv6_distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_intra_area", value)

    @property
    @pulumi.getter(name="ipv6DistanceIntraAreaVariable")
    def ipv6_distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_intra_area_variable")

    @ipv6_distance_intra_area_variable.setter
    def ipv6_distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceVariable")
    def ipv6_distance_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_variable")

    @ipv6_distance_variable.setter
    def ipv6_distance_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_variable", value)

    @property
    @pulumi.getter(name="ipv6Filter")
    def ipv6_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv6_filter")

    @ipv6_filter.setter
    def ipv6_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_filter", value)

    @property
    @pulumi.getter(name="ipv6FilterVariable")
    def ipv6_filter_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_filter_variable")

    @ipv6_filter_variable.setter
    def ipv6_filter_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_filter_variable", value)

    @property
    @pulumi.getter(name="ipv6MaxMetricRouterLsas")
    def ipv6_max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv6_max_metric_router_lsas")

    @ipv6_max_metric_router_lsas.setter
    def ipv6_max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "ipv6_max_metric_router_lsas", value)

    @property
    @pulumi.getter(name="ipv6PolicyName")
    def ipv6_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "ipv6_policy_name")

    @ipv6_policy_name.setter
    def ipv6_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_policy_name", value)

    @property
    @pulumi.getter(name="ipv6PolicyNameVariable")
    def ipv6_policy_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_policy_name_variable")

    @ipv6_policy_name_variable.setter
    def ipv6_policy_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_policy_name_variable", value)

    @property
    @pulumi.getter(name="ipv6Redistributes")
    def ipv6_redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv6_redistributes")

    @ipv6_redistributes.setter
    def ipv6_redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]]):
        pulumi.set(self, "ipv6_redistributes", value)

    @property
    @pulumi.getter(name="ipv6RouterId")
    def ipv6_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv6_router_id")

    @ipv6_router_id.setter
    def ipv6_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_router_id", value)

    @property
    @pulumi.getter(name="ipv6RouterIdVariable")
    def ipv6_router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_router_id_variable")

    @ipv6_router_id_variable.setter
    def ipv6_router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_router_id_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfDelay")
    def ipv6_timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv6_timers_spf_delay")

    @ipv6_timers_spf_delay.setter
    def ipv6_timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_delay", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfDelayVariable")
    def ipv6_timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_delay_variable")

    @ipv6_timers_spf_delay_variable.setter
    def ipv6_timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHold")
    def ipv6_timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold")

    @ipv6_timers_spf_initial_hold.setter
    def ipv6_timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHoldVariable")
    def ipv6_timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold_variable")

    @ipv6_timers_spf_initial_hold_variable.setter
    def ipv6_timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHold")
    def ipv6_timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold")

    @ipv6_timers_spf_max_hold.setter
    def ipv6_timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHoldVariable")
    def ipv6_timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold_variable")

    @ipv6_timers_spf_max_hold_variable.setter
    def ipv6_timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_max_hold_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CiscoOspfv3FeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]] = None,
                 ipv4_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv4_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv4_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv4_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_filter: Optional[pulumi.Input[bool]] = None,
                 ipv4_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]] = None,
                 ipv4_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv4_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]] = None,
                 ipv4_router_id: Optional[pulumi.Input[str]] = None,
                 ipv4_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]] = None,
                 ipv6_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv6_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv6_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv6_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_filter: Optional[pulumi.Input[bool]] = None,
                 ipv6_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]] = None,
                 ipv6_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv6_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]] = None,
                 ipv6_router_id: Optional[pulumi.Input[str]] = None,
                 ipv6_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoOspfv3FeatureTemplate resources.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]] ipv4_areas: Configure OSPF area
        :param pulumi.Input[int] ipv4_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv4_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv4_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv4_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv4_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv4_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv4_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv4_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv4_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv4_distance: Distance - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[int] ipv4_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv4_distance_variable: Variable name
        :param pulumi.Input[bool] ipv4_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv4_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]] ipv4_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv4_policy_name: Policy Name
        :param pulumi.Input[str] ipv4_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]] ipv4_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv4_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv4_router_id_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv4_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv4_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv4_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]] ipv6_areas: Configure OSPF area
        :param pulumi.Input[int] ipv6_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv6_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv6_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv6_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv6_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv6_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv6_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv6_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv6_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv6_distance: Distance - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[int] ipv6_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv6_distance_variable: Variable name
        :param pulumi.Input[bool] ipv6_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv6_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]] ipv6_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv6_policy_name: Name
        :param pulumi.Input[str] ipv6_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]] ipv6_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv6_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv6_router_id_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv6_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv6_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv6_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if ipv4_areas is not None:
            pulumi.set(__self__, "ipv4_areas", ipv4_areas)
        if ipv4_auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "ipv4_auto_cost_reference_bandwidth", ipv4_auto_cost_reference_bandwidth)
        if ipv4_auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "ipv4_auto_cost_reference_bandwidth_variable", ipv4_auto_cost_reference_bandwidth_variable)
        if ipv4_compatible_rfc1583 is not None:
            pulumi.set(__self__, "ipv4_compatible_rfc1583", ipv4_compatible_rfc1583)
        if ipv4_compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "ipv4_compatible_rfc1583_variable", ipv4_compatible_rfc1583_variable)
        if ipv4_default_information_originate is not None:
            pulumi.set(__self__, "ipv4_default_information_originate", ipv4_default_information_originate)
        if ipv4_default_information_originate_always is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_always", ipv4_default_information_originate_always)
        if ipv4_default_information_originate_always_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_always_variable", ipv4_default_information_originate_always_variable)
        if ipv4_default_information_originate_metric is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric", ipv4_default_information_originate_metric)
        if ipv4_default_information_originate_metric_type is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_type", ipv4_default_information_originate_metric_type)
        if ipv4_default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_type_variable", ipv4_default_information_originate_metric_type_variable)
        if ipv4_default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "ipv4_default_information_originate_metric_variable", ipv4_default_information_originate_metric_variable)
        if ipv4_distance is not None:
            pulumi.set(__self__, "ipv4_distance", ipv4_distance)
        if ipv4_distance_external is not None:
            pulumi.set(__self__, "ipv4_distance_external", ipv4_distance_external)
        if ipv4_distance_external_variable is not None:
            pulumi.set(__self__, "ipv4_distance_external_variable", ipv4_distance_external_variable)
        if ipv4_distance_inter_area is not None:
            pulumi.set(__self__, "ipv4_distance_inter_area", ipv4_distance_inter_area)
        if ipv4_distance_inter_area_variable is not None:
            pulumi.set(__self__, "ipv4_distance_inter_area_variable", ipv4_distance_inter_area_variable)
        if ipv4_distance_intra_area is not None:
            pulumi.set(__self__, "ipv4_distance_intra_area", ipv4_distance_intra_area)
        if ipv4_distance_intra_area_variable is not None:
            pulumi.set(__self__, "ipv4_distance_intra_area_variable", ipv4_distance_intra_area_variable)
        if ipv4_distance_variable is not None:
            pulumi.set(__self__, "ipv4_distance_variable", ipv4_distance_variable)
        if ipv4_filter is not None:
            pulumi.set(__self__, "ipv4_filter", ipv4_filter)
        if ipv4_filter_variable is not None:
            pulumi.set(__self__, "ipv4_filter_variable", ipv4_filter_variable)
        if ipv4_max_metric_router_lsas is not None:
            pulumi.set(__self__, "ipv4_max_metric_router_lsas", ipv4_max_metric_router_lsas)
        if ipv4_policy_name is not None:
            pulumi.set(__self__, "ipv4_policy_name", ipv4_policy_name)
        if ipv4_policy_name_variable is not None:
            pulumi.set(__self__, "ipv4_policy_name_variable", ipv4_policy_name_variable)
        if ipv4_redistributes is not None:
            pulumi.set(__self__, "ipv4_redistributes", ipv4_redistributes)
        if ipv4_router_id is not None:
            pulumi.set(__self__, "ipv4_router_id", ipv4_router_id)
        if ipv4_router_id_variable is not None:
            pulumi.set(__self__, "ipv4_router_id_variable", ipv4_router_id_variable)
        if ipv4_timers_spf_delay is not None:
            pulumi.set(__self__, "ipv4_timers_spf_delay", ipv4_timers_spf_delay)
        if ipv4_timers_spf_delay_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_delay_variable", ipv4_timers_spf_delay_variable)
        if ipv4_timers_spf_initial_hold is not None:
            pulumi.set(__self__, "ipv4_timers_spf_initial_hold", ipv4_timers_spf_initial_hold)
        if ipv4_timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_initial_hold_variable", ipv4_timers_spf_initial_hold_variable)
        if ipv4_timers_spf_max_hold is not None:
            pulumi.set(__self__, "ipv4_timers_spf_max_hold", ipv4_timers_spf_max_hold)
        if ipv4_timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "ipv4_timers_spf_max_hold_variable", ipv4_timers_spf_max_hold_variable)
        if ipv6_areas is not None:
            pulumi.set(__self__, "ipv6_areas", ipv6_areas)
        if ipv6_auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "ipv6_auto_cost_reference_bandwidth", ipv6_auto_cost_reference_bandwidth)
        if ipv6_auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "ipv6_auto_cost_reference_bandwidth_variable", ipv6_auto_cost_reference_bandwidth_variable)
        if ipv6_compatible_rfc1583 is not None:
            pulumi.set(__self__, "ipv6_compatible_rfc1583", ipv6_compatible_rfc1583)
        if ipv6_compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "ipv6_compatible_rfc1583_variable", ipv6_compatible_rfc1583_variable)
        if ipv6_default_information_originate is not None:
            pulumi.set(__self__, "ipv6_default_information_originate", ipv6_default_information_originate)
        if ipv6_default_information_originate_always is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_always", ipv6_default_information_originate_always)
        if ipv6_default_information_originate_always_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_always_variable", ipv6_default_information_originate_always_variable)
        if ipv6_default_information_originate_metric is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric", ipv6_default_information_originate_metric)
        if ipv6_default_information_originate_metric_type is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_type", ipv6_default_information_originate_metric_type)
        if ipv6_default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_type_variable", ipv6_default_information_originate_metric_type_variable)
        if ipv6_default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "ipv6_default_information_originate_metric_variable", ipv6_default_information_originate_metric_variable)
        if ipv6_distance is not None:
            pulumi.set(__self__, "ipv6_distance", ipv6_distance)
        if ipv6_distance_external is not None:
            pulumi.set(__self__, "ipv6_distance_external", ipv6_distance_external)
        if ipv6_distance_external_variable is not None:
            pulumi.set(__self__, "ipv6_distance_external_variable", ipv6_distance_external_variable)
        if ipv6_distance_inter_area is not None:
            pulumi.set(__self__, "ipv6_distance_inter_area", ipv6_distance_inter_area)
        if ipv6_distance_inter_area_variable is not None:
            pulumi.set(__self__, "ipv6_distance_inter_area_variable", ipv6_distance_inter_area_variable)
        if ipv6_distance_intra_area is not None:
            pulumi.set(__self__, "ipv6_distance_intra_area", ipv6_distance_intra_area)
        if ipv6_distance_intra_area_variable is not None:
            pulumi.set(__self__, "ipv6_distance_intra_area_variable", ipv6_distance_intra_area_variable)
        if ipv6_distance_variable is not None:
            pulumi.set(__self__, "ipv6_distance_variable", ipv6_distance_variable)
        if ipv6_filter is not None:
            pulumi.set(__self__, "ipv6_filter", ipv6_filter)
        if ipv6_filter_variable is not None:
            pulumi.set(__self__, "ipv6_filter_variable", ipv6_filter_variable)
        if ipv6_max_metric_router_lsas is not None:
            pulumi.set(__self__, "ipv6_max_metric_router_lsas", ipv6_max_metric_router_lsas)
        if ipv6_policy_name is not None:
            pulumi.set(__self__, "ipv6_policy_name", ipv6_policy_name)
        if ipv6_policy_name_variable is not None:
            pulumi.set(__self__, "ipv6_policy_name_variable", ipv6_policy_name_variable)
        if ipv6_redistributes is not None:
            pulumi.set(__self__, "ipv6_redistributes", ipv6_redistributes)
        if ipv6_router_id is not None:
            pulumi.set(__self__, "ipv6_router_id", ipv6_router_id)
        if ipv6_router_id_variable is not None:
            pulumi.set(__self__, "ipv6_router_id_variable", ipv6_router_id_variable)
        if ipv6_timers_spf_delay is not None:
            pulumi.set(__self__, "ipv6_timers_spf_delay", ipv6_timers_spf_delay)
        if ipv6_timers_spf_delay_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_delay_variable", ipv6_timers_spf_delay_variable)
        if ipv6_timers_spf_initial_hold is not None:
            pulumi.set(__self__, "ipv6_timers_spf_initial_hold", ipv6_timers_spf_initial_hold)
        if ipv6_timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_initial_hold_variable", ipv6_timers_spf_initial_hold_variable)
        if ipv6_timers_spf_max_hold is not None:
            pulumi.set(__self__, "ipv6_timers_spf_max_hold", ipv6_timers_spf_max_hold)
        if ipv6_timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "ipv6_timers_spf_max_hold_variable", ipv6_timers_spf_max_hold_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ipv4Areas")
    def ipv4_areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv4_areas")

    @ipv4_areas.setter
    def ipv4_areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4AreaArgs']]]]):
        pulumi.set(self, "ipv4_areas", value)

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidth")
    def ipv4_auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth")

    @ipv4_auto_cost_reference_bandwidth.setter
    def ipv4_auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidthVariable")
    def ipv4_auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth_variable")

    @ipv4_auto_cost_reference_bandwidth_variable.setter
    def ipv4_auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583")
    def ipv4_compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583")

    @ipv4_compatible_rfc1583.setter
    def ipv4_compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_compatible_rfc1583", value)

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583Variable")
    def ipv4_compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583_variable")

    @ipv4_compatible_rfc1583_variable.setter
    def ipv4_compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginate")
    def ipv4_default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate")

    @ipv4_default_information_originate.setter
    def ipv4_default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_default_information_originate", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlways")
    def ipv4_default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate_always")

    @ipv4_default_information_originate_always.setter
    def ipv4_default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_default_information_originate_always", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlwaysVariable")
    def ipv4_default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_always_variable")

    @ipv4_default_information_originate_always_variable.setter
    def ipv4_default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetric")
    def ipv4_default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric")

    @ipv4_default_information_originate_metric.setter
    def ipv4_default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_default_information_originate_metric", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricType")
    def ipv4_default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type")

    @ipv4_default_information_originate_metric_type.setter
    def ipv4_default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricTypeVariable")
    def ipv4_default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type_variable")

    @ipv4_default_information_originate_metric_type_variable.setter
    def ipv4_default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricVariable")
    def ipv4_default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_variable")

    @ipv4_default_information_originate_metric_variable.setter
    def ipv4_default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_default_information_originate_metric_variable", value)

    @property
    @pulumi.getter(name="ipv4Distance")
    def ipv4_distance(self) -> Optional[pulumi.Input[int]]:
        """
        Distance - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance")

    @ipv4_distance.setter
    def ipv4_distance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance", value)

    @property
    @pulumi.getter(name="ipv4DistanceExternal")
    def ipv4_distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_external")

    @ipv4_distance_external.setter
    def ipv4_distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_external", value)

    @property
    @pulumi.getter(name="ipv4DistanceExternalVariable")
    def ipv4_distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_external_variable")

    @ipv4_distance_external_variable.setter
    def ipv4_distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_external_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceInterArea")
    def ipv4_distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_inter_area")

    @ipv4_distance_inter_area.setter
    def ipv4_distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_inter_area", value)

    @property
    @pulumi.getter(name="ipv4DistanceInterAreaVariable")
    def ipv4_distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_inter_area_variable")

    @ipv4_distance_inter_area_variable.setter
    def ipv4_distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceIntraArea")
    def ipv4_distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_intra_area")

    @ipv4_distance_intra_area.setter
    def ipv4_distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_distance_intra_area", value)

    @property
    @pulumi.getter(name="ipv4DistanceIntraAreaVariable")
    def ipv4_distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_intra_area_variable")

    @ipv4_distance_intra_area_variable.setter
    def ipv4_distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="ipv4DistanceVariable")
    def ipv4_distance_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_variable")

    @ipv4_distance_variable.setter
    def ipv4_distance_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_distance_variable", value)

    @property
    @pulumi.getter(name="ipv4Filter")
    def ipv4_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv4_filter")

    @ipv4_filter.setter
    def ipv4_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_filter", value)

    @property
    @pulumi.getter(name="ipv4FilterVariable")
    def ipv4_filter_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_filter_variable")

    @ipv4_filter_variable.setter
    def ipv4_filter_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_filter_variable", value)

    @property
    @pulumi.getter(name="ipv4MaxMetricRouterLsas")
    def ipv4_max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv4_max_metric_router_lsas")

    @ipv4_max_metric_router_lsas.setter
    def ipv4_max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "ipv4_max_metric_router_lsas", value)

    @property
    @pulumi.getter(name="ipv4PolicyName")
    def ipv4_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "ipv4_policy_name")

    @ipv4_policy_name.setter
    def ipv4_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_policy_name", value)

    @property
    @pulumi.getter(name="ipv4PolicyNameVariable")
    def ipv4_policy_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_policy_name_variable")

    @ipv4_policy_name_variable.setter
    def ipv4_policy_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_policy_name_variable", value)

    @property
    @pulumi.getter(name="ipv4Redistributes")
    def ipv4_redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv4_redistributes")

    @ipv4_redistributes.setter
    def ipv4_redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs']]]]):
        pulumi.set(self, "ipv4_redistributes", value)

    @property
    @pulumi.getter(name="ipv4RouterId")
    def ipv4_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv4_router_id")

    @ipv4_router_id.setter
    def ipv4_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_router_id", value)

    @property
    @pulumi.getter(name="ipv4RouterIdVariable")
    def ipv4_router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_router_id_variable")

    @ipv4_router_id_variable.setter
    def ipv4_router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_router_id_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfDelay")
    def ipv4_timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv4_timers_spf_delay")

    @ipv4_timers_spf_delay.setter
    def ipv4_timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_delay", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfDelayVariable")
    def ipv4_timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_delay_variable")

    @ipv4_timers_spf_delay_variable.setter
    def ipv4_timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHold")
    def ipv4_timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold")

    @ipv4_timers_spf_initial_hold.setter
    def ipv4_timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHoldVariable")
    def ipv4_timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold_variable")

    @ipv4_timers_spf_initial_hold_variable.setter
    def ipv4_timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHold")
    def ipv4_timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold")

    @ipv4_timers_spf_max_hold.setter
    def ipv4_timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHoldVariable")
    def ipv4_timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold_variable")

    @ipv4_timers_spf_max_hold_variable.setter
    def ipv4_timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_timers_spf_max_hold_variable", value)

    @property
    @pulumi.getter(name="ipv6Areas")
    def ipv6_areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv6_areas")

    @ipv6_areas.setter
    def ipv6_areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6AreaArgs']]]]):
        pulumi.set(self, "ipv6_areas", value)

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidth")
    def ipv6_auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth")

    @ipv6_auto_cost_reference_bandwidth.setter
    def ipv6_auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidthVariable")
    def ipv6_auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth_variable")

    @ipv6_auto_cost_reference_bandwidth_variable.setter
    def ipv6_auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583")
    def ipv6_compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583")

    @ipv6_compatible_rfc1583.setter
    def ipv6_compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_compatible_rfc1583", value)

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583Variable")
    def ipv6_compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583_variable")

    @ipv6_compatible_rfc1583_variable.setter
    def ipv6_compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginate")
    def ipv6_default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate")

    @ipv6_default_information_originate.setter
    def ipv6_default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_default_information_originate", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlways")
    def ipv6_default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate_always")

    @ipv6_default_information_originate_always.setter
    def ipv6_default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_default_information_originate_always", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlwaysVariable")
    def ipv6_default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_always_variable")

    @ipv6_default_information_originate_always_variable.setter
    def ipv6_default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetric")
    def ipv6_default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric")

    @ipv6_default_information_originate_metric.setter
    def ipv6_default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_default_information_originate_metric", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricType")
    def ipv6_default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type")

    @ipv6_default_information_originate_metric_type.setter
    def ipv6_default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricTypeVariable")
    def ipv6_default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type_variable")

    @ipv6_default_information_originate_metric_type_variable.setter
    def ipv6_default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricVariable")
    def ipv6_default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_variable")

    @ipv6_default_information_originate_metric_variable.setter
    def ipv6_default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_default_information_originate_metric_variable", value)

    @property
    @pulumi.getter(name="ipv6Distance")
    def ipv6_distance(self) -> Optional[pulumi.Input[int]]:
        """
        Distance - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance")

    @ipv6_distance.setter
    def ipv6_distance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance", value)

    @property
    @pulumi.getter(name="ipv6DistanceExternal")
    def ipv6_distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_external")

    @ipv6_distance_external.setter
    def ipv6_distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_external", value)

    @property
    @pulumi.getter(name="ipv6DistanceExternalVariable")
    def ipv6_distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_external_variable")

    @ipv6_distance_external_variable.setter
    def ipv6_distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_external_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceInterArea")
    def ipv6_distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_inter_area")

    @ipv6_distance_inter_area.setter
    def ipv6_distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_inter_area", value)

    @property
    @pulumi.getter(name="ipv6DistanceInterAreaVariable")
    def ipv6_distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_inter_area_variable")

    @ipv6_distance_inter_area_variable.setter
    def ipv6_distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceIntraArea")
    def ipv6_distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_intra_area")

    @ipv6_distance_intra_area.setter
    def ipv6_distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_distance_intra_area", value)

    @property
    @pulumi.getter(name="ipv6DistanceIntraAreaVariable")
    def ipv6_distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_intra_area_variable")

    @ipv6_distance_intra_area_variable.setter
    def ipv6_distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="ipv6DistanceVariable")
    def ipv6_distance_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_variable")

    @ipv6_distance_variable.setter
    def ipv6_distance_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_distance_variable", value)

    @property
    @pulumi.getter(name="ipv6Filter")
    def ipv6_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv6_filter")

    @ipv6_filter.setter
    def ipv6_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_filter", value)

    @property
    @pulumi.getter(name="ipv6FilterVariable")
    def ipv6_filter_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_filter_variable")

    @ipv6_filter_variable.setter
    def ipv6_filter_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_filter_variable", value)

    @property
    @pulumi.getter(name="ipv6MaxMetricRouterLsas")
    def ipv6_max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv6_max_metric_router_lsas")

    @ipv6_max_metric_router_lsas.setter
    def ipv6_max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "ipv6_max_metric_router_lsas", value)

    @property
    @pulumi.getter(name="ipv6PolicyName")
    def ipv6_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "ipv6_policy_name")

    @ipv6_policy_name.setter
    def ipv6_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_policy_name", value)

    @property
    @pulumi.getter(name="ipv6PolicyNameVariable")
    def ipv6_policy_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_policy_name_variable")

    @ipv6_policy_name_variable.setter
    def ipv6_policy_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_policy_name_variable", value)

    @property
    @pulumi.getter(name="ipv6Redistributes")
    def ipv6_redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv6_redistributes")

    @ipv6_redistributes.setter
    def ipv6_redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs']]]]):
        pulumi.set(self, "ipv6_redistributes", value)

    @property
    @pulumi.getter(name="ipv6RouterId")
    def ipv6_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv6_router_id")

    @ipv6_router_id.setter
    def ipv6_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_router_id", value)

    @property
    @pulumi.getter(name="ipv6RouterIdVariable")
    def ipv6_router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_router_id_variable")

    @ipv6_router_id_variable.setter
    def ipv6_router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_router_id_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfDelay")
    def ipv6_timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv6_timers_spf_delay")

    @ipv6_timers_spf_delay.setter
    def ipv6_timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_delay", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfDelayVariable")
    def ipv6_timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_delay_variable")

    @ipv6_timers_spf_delay_variable.setter
    def ipv6_timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHold")
    def ipv6_timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold")

    @ipv6_timers_spf_initial_hold.setter
    def ipv6_timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHoldVariable")
    def ipv6_timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold_variable")

    @ipv6_timers_spf_initial_hold_variable.setter
    def ipv6_timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHold")
    def ipv6_timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold")

    @ipv6_timers_spf_max_hold.setter
    def ipv6_timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHoldVariable")
    def ipv6_timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold_variable")

    @ipv6_timers_spf_max_hold_variable.setter
    def ipv6_timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_timers_spf_max_hold_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoOspfv3FeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4AreaArgs', 'CiscoOspfv3FeatureTemplateIpv4AreaArgsDict']]]]] = None,
                 ipv4_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv4_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv4_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv4_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_filter: Optional[pulumi.Input[bool]] = None,
                 ipv4_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgsDict']]]]] = None,
                 ipv4_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv4_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv4RedistributeArgsDict']]]]] = None,
                 ipv4_router_id: Optional[pulumi.Input[str]] = None,
                 ipv4_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6AreaArgs', 'CiscoOspfv3FeatureTemplateIpv6AreaArgsDict']]]]] = None,
                 ipv6_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv6_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv6_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv6_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_filter: Optional[pulumi.Input[bool]] = None,
                 ipv6_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgsDict']]]]] = None,
                 ipv6_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv6_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv6RedistributeArgsDict']]]]] = None,
                 ipv6_router_id: Optional[pulumi.Input[str]] = None,
                 ipv6_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco OSPFv3 feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOspfv3FeatureTemplate:CiscoOspfv3FeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4AreaArgs', 'CiscoOspfv3FeatureTemplateIpv4AreaArgsDict']]]] ipv4_areas: Configure OSPF area
        :param pulumi.Input[int] ipv4_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv4_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv4_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv4_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv4_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv4_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv4_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv4_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv4_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv4_distance: Distance - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[int] ipv4_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv4_distance_variable: Variable name
        :param pulumi.Input[bool] ipv4_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv4_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgsDict']]]] ipv4_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv4_policy_name: Policy Name
        :param pulumi.Input[str] ipv4_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv4RedistributeArgsDict']]]] ipv4_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv4_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv4_router_id_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv4_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv4_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv4_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6AreaArgs', 'CiscoOspfv3FeatureTemplateIpv6AreaArgsDict']]]] ipv6_areas: Configure OSPF area
        :param pulumi.Input[int] ipv6_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv6_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv6_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv6_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv6_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv6_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv6_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv6_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv6_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv6_distance: Distance - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[int] ipv6_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv6_distance_variable: Variable name
        :param pulumi.Input[bool] ipv6_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv6_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgsDict']]]] ipv6_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv6_policy_name: Name
        :param pulumi.Input[str] ipv6_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv6RedistributeArgsDict']]]] ipv6_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv6_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv6_router_id_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv6_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv6_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv6_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoOspfv3FeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco OSPFv3 feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOspfv3FeatureTemplate:CiscoOspfv3FeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoOspfv3FeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoOspfv3FeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4AreaArgs', 'CiscoOspfv3FeatureTemplateIpv4AreaArgsDict']]]]] = None,
                 ipv4_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv4_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv4_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv4_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv4_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv4_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_filter: Optional[pulumi.Input[bool]] = None,
                 ipv4_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgsDict']]]]] = None,
                 ipv4_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv4_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv4RedistributeArgsDict']]]]] = None,
                 ipv4_router_id: Optional[pulumi.Input[str]] = None,
                 ipv4_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv4_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv4_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6AreaArgs', 'CiscoOspfv3FeatureTemplateIpv6AreaArgsDict']]]]] = None,
                 ipv6_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 ipv6_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 ipv6_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 ipv6_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 ipv6_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_external_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_inter_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_intra_area: Optional[pulumi.Input[int]] = None,
                 ipv6_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_distance_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_filter: Optional[pulumi.Input[bool]] = None,
                 ipv6_filter_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgsDict']]]]] = None,
                 ipv6_policy_name: Optional[pulumi.Input[str]] = None,
                 ipv6_policy_name_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv6RedistributeArgsDict']]]]] = None,
                 ipv6_router_id: Optional[pulumi.Input[str]] = None,
                 ipv6_router_id_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 ipv6_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 ipv6_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoOspfv3FeatureTemplateArgs.__new__(CiscoOspfv3FeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["ipv4_areas"] = ipv4_areas
            __props__.__dict__["ipv4_auto_cost_reference_bandwidth"] = ipv4_auto_cost_reference_bandwidth
            __props__.__dict__["ipv4_auto_cost_reference_bandwidth_variable"] = ipv4_auto_cost_reference_bandwidth_variable
            __props__.__dict__["ipv4_compatible_rfc1583"] = ipv4_compatible_rfc1583
            __props__.__dict__["ipv4_compatible_rfc1583_variable"] = ipv4_compatible_rfc1583_variable
            __props__.__dict__["ipv4_default_information_originate"] = ipv4_default_information_originate
            __props__.__dict__["ipv4_default_information_originate_always"] = ipv4_default_information_originate_always
            __props__.__dict__["ipv4_default_information_originate_always_variable"] = ipv4_default_information_originate_always_variable
            __props__.__dict__["ipv4_default_information_originate_metric"] = ipv4_default_information_originate_metric
            __props__.__dict__["ipv4_default_information_originate_metric_type"] = ipv4_default_information_originate_metric_type
            __props__.__dict__["ipv4_default_information_originate_metric_type_variable"] = ipv4_default_information_originate_metric_type_variable
            __props__.__dict__["ipv4_default_information_originate_metric_variable"] = ipv4_default_information_originate_metric_variable
            __props__.__dict__["ipv4_distance"] = ipv4_distance
            __props__.__dict__["ipv4_distance_external"] = ipv4_distance_external
            __props__.__dict__["ipv4_distance_external_variable"] = ipv4_distance_external_variable
            __props__.__dict__["ipv4_distance_inter_area"] = ipv4_distance_inter_area
            __props__.__dict__["ipv4_distance_inter_area_variable"] = ipv4_distance_inter_area_variable
            __props__.__dict__["ipv4_distance_intra_area"] = ipv4_distance_intra_area
            __props__.__dict__["ipv4_distance_intra_area_variable"] = ipv4_distance_intra_area_variable
            __props__.__dict__["ipv4_distance_variable"] = ipv4_distance_variable
            __props__.__dict__["ipv4_filter"] = ipv4_filter
            __props__.__dict__["ipv4_filter_variable"] = ipv4_filter_variable
            __props__.__dict__["ipv4_max_metric_router_lsas"] = ipv4_max_metric_router_lsas
            __props__.__dict__["ipv4_policy_name"] = ipv4_policy_name
            __props__.__dict__["ipv4_policy_name_variable"] = ipv4_policy_name_variable
            __props__.__dict__["ipv4_redistributes"] = ipv4_redistributes
            __props__.__dict__["ipv4_router_id"] = ipv4_router_id
            __props__.__dict__["ipv4_router_id_variable"] = ipv4_router_id_variable
            __props__.__dict__["ipv4_timers_spf_delay"] = ipv4_timers_spf_delay
            __props__.__dict__["ipv4_timers_spf_delay_variable"] = ipv4_timers_spf_delay_variable
            __props__.__dict__["ipv4_timers_spf_initial_hold"] = ipv4_timers_spf_initial_hold
            __props__.__dict__["ipv4_timers_spf_initial_hold_variable"] = ipv4_timers_spf_initial_hold_variable
            __props__.__dict__["ipv4_timers_spf_max_hold"] = ipv4_timers_spf_max_hold
            __props__.__dict__["ipv4_timers_spf_max_hold_variable"] = ipv4_timers_spf_max_hold_variable
            __props__.__dict__["ipv6_areas"] = ipv6_areas
            __props__.__dict__["ipv6_auto_cost_reference_bandwidth"] = ipv6_auto_cost_reference_bandwidth
            __props__.__dict__["ipv6_auto_cost_reference_bandwidth_variable"] = ipv6_auto_cost_reference_bandwidth_variable
            __props__.__dict__["ipv6_compatible_rfc1583"] = ipv6_compatible_rfc1583
            __props__.__dict__["ipv6_compatible_rfc1583_variable"] = ipv6_compatible_rfc1583_variable
            __props__.__dict__["ipv6_default_information_originate"] = ipv6_default_information_originate
            __props__.__dict__["ipv6_default_information_originate_always"] = ipv6_default_information_originate_always
            __props__.__dict__["ipv6_default_information_originate_always_variable"] = ipv6_default_information_originate_always_variable
            __props__.__dict__["ipv6_default_information_originate_metric"] = ipv6_default_information_originate_metric
            __props__.__dict__["ipv6_default_information_originate_metric_type"] = ipv6_default_information_originate_metric_type
            __props__.__dict__["ipv6_default_information_originate_metric_type_variable"] = ipv6_default_information_originate_metric_type_variable
            __props__.__dict__["ipv6_default_information_originate_metric_variable"] = ipv6_default_information_originate_metric_variable
            __props__.__dict__["ipv6_distance"] = ipv6_distance
            __props__.__dict__["ipv6_distance_external"] = ipv6_distance_external
            __props__.__dict__["ipv6_distance_external_variable"] = ipv6_distance_external_variable
            __props__.__dict__["ipv6_distance_inter_area"] = ipv6_distance_inter_area
            __props__.__dict__["ipv6_distance_inter_area_variable"] = ipv6_distance_inter_area_variable
            __props__.__dict__["ipv6_distance_intra_area"] = ipv6_distance_intra_area
            __props__.__dict__["ipv6_distance_intra_area_variable"] = ipv6_distance_intra_area_variable
            __props__.__dict__["ipv6_distance_variable"] = ipv6_distance_variable
            __props__.__dict__["ipv6_filter"] = ipv6_filter
            __props__.__dict__["ipv6_filter_variable"] = ipv6_filter_variable
            __props__.__dict__["ipv6_max_metric_router_lsas"] = ipv6_max_metric_router_lsas
            __props__.__dict__["ipv6_policy_name"] = ipv6_policy_name
            __props__.__dict__["ipv6_policy_name_variable"] = ipv6_policy_name_variable
            __props__.__dict__["ipv6_redistributes"] = ipv6_redistributes
            __props__.__dict__["ipv6_router_id"] = ipv6_router_id
            __props__.__dict__["ipv6_router_id_variable"] = ipv6_router_id_variable
            __props__.__dict__["ipv6_timers_spf_delay"] = ipv6_timers_spf_delay
            __props__.__dict__["ipv6_timers_spf_delay_variable"] = ipv6_timers_spf_delay_variable
            __props__.__dict__["ipv6_timers_spf_initial_hold"] = ipv6_timers_spf_initial_hold
            __props__.__dict__["ipv6_timers_spf_initial_hold_variable"] = ipv6_timers_spf_initial_hold_variable
            __props__.__dict__["ipv6_timers_spf_max_hold"] = ipv6_timers_spf_max_hold
            __props__.__dict__["ipv6_timers_spf_max_hold_variable"] = ipv6_timers_spf_max_hold_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoOspfv3FeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoOspfv3FeatureTemplate:CiscoOspfv3FeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv4_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4AreaArgs', 'CiscoOspfv3FeatureTemplateIpv4AreaArgsDict']]]]] = None,
            ipv4_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
            ipv4_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
            ipv4_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
            ipv4_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
            ipv4_default_information_originate: Optional[pulumi.Input[bool]] = None,
            ipv4_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
            ipv4_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
            ipv4_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
            ipv4_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
            ipv4_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
            ipv4_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
            ipv4_distance: Optional[pulumi.Input[int]] = None,
            ipv4_distance_external: Optional[pulumi.Input[int]] = None,
            ipv4_distance_external_variable: Optional[pulumi.Input[str]] = None,
            ipv4_distance_inter_area: Optional[pulumi.Input[int]] = None,
            ipv4_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
            ipv4_distance_intra_area: Optional[pulumi.Input[int]] = None,
            ipv4_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
            ipv4_distance_variable: Optional[pulumi.Input[str]] = None,
            ipv4_filter: Optional[pulumi.Input[bool]] = None,
            ipv4_filter_variable: Optional[pulumi.Input[str]] = None,
            ipv4_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgsDict']]]]] = None,
            ipv4_policy_name: Optional[pulumi.Input[str]] = None,
            ipv4_policy_name_variable: Optional[pulumi.Input[str]] = None,
            ipv4_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv4RedistributeArgsDict']]]]] = None,
            ipv4_router_id: Optional[pulumi.Input[str]] = None,
            ipv4_router_id_variable: Optional[pulumi.Input[str]] = None,
            ipv4_timers_spf_delay: Optional[pulumi.Input[int]] = None,
            ipv4_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
            ipv4_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
            ipv4_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
            ipv4_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
            ipv4_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
            ipv6_areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6AreaArgs', 'CiscoOspfv3FeatureTemplateIpv6AreaArgsDict']]]]] = None,
            ipv6_auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
            ipv6_auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
            ipv6_compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
            ipv6_compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
            ipv6_default_information_originate: Optional[pulumi.Input[bool]] = None,
            ipv6_default_information_originate_always: Optional[pulumi.Input[bool]] = None,
            ipv6_default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
            ipv6_default_information_originate_metric: Optional[pulumi.Input[int]] = None,
            ipv6_default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
            ipv6_default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
            ipv6_default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
            ipv6_distance: Optional[pulumi.Input[int]] = None,
            ipv6_distance_external: Optional[pulumi.Input[int]] = None,
            ipv6_distance_external_variable: Optional[pulumi.Input[str]] = None,
            ipv6_distance_inter_area: Optional[pulumi.Input[int]] = None,
            ipv6_distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
            ipv6_distance_intra_area: Optional[pulumi.Input[int]] = None,
            ipv6_distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
            ipv6_distance_variable: Optional[pulumi.Input[str]] = None,
            ipv6_filter: Optional[pulumi.Input[bool]] = None,
            ipv6_filter_variable: Optional[pulumi.Input[str]] = None,
            ipv6_max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgsDict']]]]] = None,
            ipv6_policy_name: Optional[pulumi.Input[str]] = None,
            ipv6_policy_name_variable: Optional[pulumi.Input[str]] = None,
            ipv6_redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv6RedistributeArgsDict']]]]] = None,
            ipv6_router_id: Optional[pulumi.Input[str]] = None,
            ipv6_router_id_variable: Optional[pulumi.Input[str]] = None,
            ipv6_timers_spf_delay: Optional[pulumi.Input[int]] = None,
            ipv6_timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
            ipv6_timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
            ipv6_timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
            ipv6_timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
            ipv6_timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoOspfv3FeatureTemplate':
        """
        Get an existing CiscoOspfv3FeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4AreaArgs', 'CiscoOspfv3FeatureTemplateIpv4AreaArgsDict']]]] ipv4_areas: Configure OSPF area
        :param pulumi.Input[int] ipv4_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv4_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv4_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv4_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv4_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv4_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv4_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv4_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv4_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv4_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv4_distance: Distance - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[int] ipv4_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv4_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv4_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv4_distance_variable: Variable name
        :param pulumi.Input[bool] ipv4_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv4_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsaArgsDict']]]] ipv4_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv4_policy_name: Policy Name
        :param pulumi.Input[str] ipv4_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv4RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv4RedistributeArgsDict']]]] ipv4_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv4_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv4_router_id_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv4_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv4_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv4_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv4_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6AreaArgs', 'CiscoOspfv3FeatureTemplateIpv6AreaArgsDict']]]] ipv6_areas: Configure OSPF area
        :param pulumi.Input[int] ipv6_auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] ipv6_auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] ipv6_compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] ipv6_compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] ipv6_default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] ipv6_default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] ipv6_default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] ipv6_default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] ipv6_default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] ipv6_default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] ipv6_distance: Distance - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[int] ipv6_distance_external: Set distance for external routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_external_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_inter_area: Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_inter_area_variable: Variable name
        :param pulumi.Input[int] ipv6_distance_intra_area: Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        :param pulumi.Input[str] ipv6_distance_intra_area_variable: Variable name
        :param pulumi.Input[str] ipv6_distance_variable: Variable name
        :param pulumi.Input[bool] ipv6_filter: Filter - Default value: `false`
        :param pulumi.Input[str] ipv6_filter_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgs', 'CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsaArgsDict']]]] ipv6_max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] ipv6_policy_name: Name
        :param pulumi.Input[str] ipv6_policy_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfv3FeatureTemplateIpv6RedistributeArgs', 'CiscoOspfv3FeatureTemplateIpv6RedistributeArgsDict']]]] ipv6_redistributes: Redistribute routes
        :param pulumi.Input[str] ipv6_router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] ipv6_router_id_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        :param pulumi.Input[str] ipv6_timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        :param pulumi.Input[str] ipv6_timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] ipv6_timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        :param pulumi.Input[str] ipv6_timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoOspfv3FeatureTemplateState.__new__(_CiscoOspfv3FeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["ipv4_areas"] = ipv4_areas
        __props__.__dict__["ipv4_auto_cost_reference_bandwidth"] = ipv4_auto_cost_reference_bandwidth
        __props__.__dict__["ipv4_auto_cost_reference_bandwidth_variable"] = ipv4_auto_cost_reference_bandwidth_variable
        __props__.__dict__["ipv4_compatible_rfc1583"] = ipv4_compatible_rfc1583
        __props__.__dict__["ipv4_compatible_rfc1583_variable"] = ipv4_compatible_rfc1583_variable
        __props__.__dict__["ipv4_default_information_originate"] = ipv4_default_information_originate
        __props__.__dict__["ipv4_default_information_originate_always"] = ipv4_default_information_originate_always
        __props__.__dict__["ipv4_default_information_originate_always_variable"] = ipv4_default_information_originate_always_variable
        __props__.__dict__["ipv4_default_information_originate_metric"] = ipv4_default_information_originate_metric
        __props__.__dict__["ipv4_default_information_originate_metric_type"] = ipv4_default_information_originate_metric_type
        __props__.__dict__["ipv4_default_information_originate_metric_type_variable"] = ipv4_default_information_originate_metric_type_variable
        __props__.__dict__["ipv4_default_information_originate_metric_variable"] = ipv4_default_information_originate_metric_variable
        __props__.__dict__["ipv4_distance"] = ipv4_distance
        __props__.__dict__["ipv4_distance_external"] = ipv4_distance_external
        __props__.__dict__["ipv4_distance_external_variable"] = ipv4_distance_external_variable
        __props__.__dict__["ipv4_distance_inter_area"] = ipv4_distance_inter_area
        __props__.__dict__["ipv4_distance_inter_area_variable"] = ipv4_distance_inter_area_variable
        __props__.__dict__["ipv4_distance_intra_area"] = ipv4_distance_intra_area
        __props__.__dict__["ipv4_distance_intra_area_variable"] = ipv4_distance_intra_area_variable
        __props__.__dict__["ipv4_distance_variable"] = ipv4_distance_variable
        __props__.__dict__["ipv4_filter"] = ipv4_filter
        __props__.__dict__["ipv4_filter_variable"] = ipv4_filter_variable
        __props__.__dict__["ipv4_max_metric_router_lsas"] = ipv4_max_metric_router_lsas
        __props__.__dict__["ipv4_policy_name"] = ipv4_policy_name
        __props__.__dict__["ipv4_policy_name_variable"] = ipv4_policy_name_variable
        __props__.__dict__["ipv4_redistributes"] = ipv4_redistributes
        __props__.__dict__["ipv4_router_id"] = ipv4_router_id
        __props__.__dict__["ipv4_router_id_variable"] = ipv4_router_id_variable
        __props__.__dict__["ipv4_timers_spf_delay"] = ipv4_timers_spf_delay
        __props__.__dict__["ipv4_timers_spf_delay_variable"] = ipv4_timers_spf_delay_variable
        __props__.__dict__["ipv4_timers_spf_initial_hold"] = ipv4_timers_spf_initial_hold
        __props__.__dict__["ipv4_timers_spf_initial_hold_variable"] = ipv4_timers_spf_initial_hold_variable
        __props__.__dict__["ipv4_timers_spf_max_hold"] = ipv4_timers_spf_max_hold
        __props__.__dict__["ipv4_timers_spf_max_hold_variable"] = ipv4_timers_spf_max_hold_variable
        __props__.__dict__["ipv6_areas"] = ipv6_areas
        __props__.__dict__["ipv6_auto_cost_reference_bandwidth"] = ipv6_auto_cost_reference_bandwidth
        __props__.__dict__["ipv6_auto_cost_reference_bandwidth_variable"] = ipv6_auto_cost_reference_bandwidth_variable
        __props__.__dict__["ipv6_compatible_rfc1583"] = ipv6_compatible_rfc1583
        __props__.__dict__["ipv6_compatible_rfc1583_variable"] = ipv6_compatible_rfc1583_variable
        __props__.__dict__["ipv6_default_information_originate"] = ipv6_default_information_originate
        __props__.__dict__["ipv6_default_information_originate_always"] = ipv6_default_information_originate_always
        __props__.__dict__["ipv6_default_information_originate_always_variable"] = ipv6_default_information_originate_always_variable
        __props__.__dict__["ipv6_default_information_originate_metric"] = ipv6_default_information_originate_metric
        __props__.__dict__["ipv6_default_information_originate_metric_type"] = ipv6_default_information_originate_metric_type
        __props__.__dict__["ipv6_default_information_originate_metric_type_variable"] = ipv6_default_information_originate_metric_type_variable
        __props__.__dict__["ipv6_default_information_originate_metric_variable"] = ipv6_default_information_originate_metric_variable
        __props__.__dict__["ipv6_distance"] = ipv6_distance
        __props__.__dict__["ipv6_distance_external"] = ipv6_distance_external
        __props__.__dict__["ipv6_distance_external_variable"] = ipv6_distance_external_variable
        __props__.__dict__["ipv6_distance_inter_area"] = ipv6_distance_inter_area
        __props__.__dict__["ipv6_distance_inter_area_variable"] = ipv6_distance_inter_area_variable
        __props__.__dict__["ipv6_distance_intra_area"] = ipv6_distance_intra_area
        __props__.__dict__["ipv6_distance_intra_area_variable"] = ipv6_distance_intra_area_variable
        __props__.__dict__["ipv6_distance_variable"] = ipv6_distance_variable
        __props__.__dict__["ipv6_filter"] = ipv6_filter
        __props__.__dict__["ipv6_filter_variable"] = ipv6_filter_variable
        __props__.__dict__["ipv6_max_metric_router_lsas"] = ipv6_max_metric_router_lsas
        __props__.__dict__["ipv6_policy_name"] = ipv6_policy_name
        __props__.__dict__["ipv6_policy_name_variable"] = ipv6_policy_name_variable
        __props__.__dict__["ipv6_redistributes"] = ipv6_redistributes
        __props__.__dict__["ipv6_router_id"] = ipv6_router_id
        __props__.__dict__["ipv6_router_id_variable"] = ipv6_router_id_variable
        __props__.__dict__["ipv6_timers_spf_delay"] = ipv6_timers_spf_delay
        __props__.__dict__["ipv6_timers_spf_delay_variable"] = ipv6_timers_spf_delay_variable
        __props__.__dict__["ipv6_timers_spf_initial_hold"] = ipv6_timers_spf_initial_hold
        __props__.__dict__["ipv6_timers_spf_initial_hold_variable"] = ipv6_timers_spf_initial_hold_variable
        __props__.__dict__["ipv6_timers_spf_max_hold"] = ipv6_timers_spf_max_hold
        __props__.__dict__["ipv6_timers_spf_max_hold_variable"] = ipv6_timers_spf_max_hold_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CiscoOspfv3FeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="ipv4Areas")
    def ipv4_areas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv4Area']]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv4_areas")

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidth")
    def ipv4_auto_cost_reference_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth")

    @property
    @pulumi.getter(name="ipv4AutoCostReferenceBandwidthVariable")
    def ipv4_auto_cost_reference_bandwidth_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_auto_cost_reference_bandwidth_variable")

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583")
    def ipv4_compatible_rfc1583(self) -> pulumi.Output[Optional[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583")

    @property
    @pulumi.getter(name="ipv4CompatibleRfc1583Variable")
    def ipv4_compatible_rfc1583_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_compatible_rfc1583_variable")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginate")
    def ipv4_default_information_originate(self) -> pulumi.Output[Optional[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlways")
    def ipv4_default_information_originate_always(self) -> pulumi.Output[Optional[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv4_default_information_originate_always")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateAlwaysVariable")
    def ipv4_default_information_originate_always_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_always_variable")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetric")
    def ipv4_default_information_originate_metric(self) -> pulumi.Output[Optional[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricType")
    def ipv4_default_information_originate_metric_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricTypeVariable")
    def ipv4_default_information_originate_metric_type_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_type_variable")

    @property
    @pulumi.getter(name="ipv4DefaultInformationOriginateMetricVariable")
    def ipv4_default_information_originate_metric_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_default_information_originate_metric_variable")

    @property
    @pulumi.getter(name="ipv4Distance")
    def ipv4_distance(self) -> pulumi.Output[Optional[int]]:
        """
        Distance - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance")

    @property
    @pulumi.getter(name="ipv4DistanceExternal")
    def ipv4_distance_external(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_external")

    @property
    @pulumi.getter(name="ipv4DistanceExternalVariable")
    def ipv4_distance_external_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_external_variable")

    @property
    @pulumi.getter(name="ipv4DistanceInterArea")
    def ipv4_distance_inter_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_inter_area")

    @property
    @pulumi.getter(name="ipv4DistanceInterAreaVariable")
    def ipv4_distance_inter_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_inter_area_variable")

    @property
    @pulumi.getter(name="ipv4DistanceIntraArea")
    def ipv4_distance_intra_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv4_distance_intra_area")

    @property
    @pulumi.getter(name="ipv4DistanceIntraAreaVariable")
    def ipv4_distance_intra_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_intra_area_variable")

    @property
    @pulumi.getter(name="ipv4DistanceVariable")
    def ipv4_distance_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_distance_variable")

    @property
    @pulumi.getter(name="ipv4Filter")
    def ipv4_filter(self) -> pulumi.Output[Optional[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv4_filter")

    @property
    @pulumi.getter(name="ipv4FilterVariable")
    def ipv4_filter_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_filter_variable")

    @property
    @pulumi.getter(name="ipv4MaxMetricRouterLsas")
    def ipv4_max_metric_router_lsas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv4MaxMetricRouterLsa']]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv4_max_metric_router_lsas")

    @property
    @pulumi.getter(name="ipv4PolicyName")
    def ipv4_policy_name(self) -> pulumi.Output[Optional[str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "ipv4_policy_name")

    @property
    @pulumi.getter(name="ipv4PolicyNameVariable")
    def ipv4_policy_name_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_policy_name_variable")

    @property
    @pulumi.getter(name="ipv4Redistributes")
    def ipv4_redistributes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv4Redistribute']]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv4_redistributes")

    @property
    @pulumi.getter(name="ipv4RouterId")
    def ipv4_router_id(self) -> pulumi.Output[Optional[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv4_router_id")

    @property
    @pulumi.getter(name="ipv4RouterIdVariable")
    def ipv4_router_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_router_id_variable")

    @property
    @pulumi.getter(name="ipv4TimersSpfDelay")
    def ipv4_timers_spf_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv4_timers_spf_delay")

    @property
    @pulumi.getter(name="ipv4TimersSpfDelayVariable")
    def ipv4_timers_spf_delay_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_delay_variable")

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHold")
    def ipv4_timers_spf_initial_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold")

    @property
    @pulumi.getter(name="ipv4TimersSpfInitialHoldVariable")
    def ipv4_timers_spf_initial_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_initial_hold_variable")

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHold")
    def ipv4_timers_spf_max_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold")

    @property
    @pulumi.getter(name="ipv4TimersSpfMaxHoldVariable")
    def ipv4_timers_spf_max_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_timers_spf_max_hold_variable")

    @property
    @pulumi.getter(name="ipv6Areas")
    def ipv6_areas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv6Area']]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "ipv6_areas")

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidth")
    def ipv6_auto_cost_reference_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth")

    @property
    @pulumi.getter(name="ipv6AutoCostReferenceBandwidthVariable")
    def ipv6_auto_cost_reference_bandwidth_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_auto_cost_reference_bandwidth_variable")

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583")
    def ipv6_compatible_rfc1583(self) -> pulumi.Output[Optional[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583")

    @property
    @pulumi.getter(name="ipv6CompatibleRfc1583Variable")
    def ipv6_compatible_rfc1583_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_compatible_rfc1583_variable")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginate")
    def ipv6_default_information_originate(self) -> pulumi.Output[Optional[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlways")
    def ipv6_default_information_originate_always(self) -> pulumi.Output[Optional[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "ipv6_default_information_originate_always")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateAlwaysVariable")
    def ipv6_default_information_originate_always_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_always_variable")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetric")
    def ipv6_default_information_originate_metric(self) -> pulumi.Output[Optional[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricType")
    def ipv6_default_information_originate_metric_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricTypeVariable")
    def ipv6_default_information_originate_metric_type_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_type_variable")

    @property
    @pulumi.getter(name="ipv6DefaultInformationOriginateMetricVariable")
    def ipv6_default_information_originate_metric_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_default_information_originate_metric_variable")

    @property
    @pulumi.getter(name="ipv6Distance")
    def ipv6_distance(self) -> pulumi.Output[Optional[int]]:
        """
        Distance - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance")

    @property
    @pulumi.getter(name="ipv6DistanceExternal")
    def ipv6_distance_external(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for external routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_external")

    @property
    @pulumi.getter(name="ipv6DistanceExternalVariable")
    def ipv6_distance_external_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_external_variable")

    @property
    @pulumi.getter(name="ipv6DistanceInterArea")
    def ipv6_distance_inter_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_inter_area")

    @property
    @pulumi.getter(name="ipv6DistanceInterAreaVariable")
    def ipv6_distance_inter_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_inter_area_variable")

    @property
    @pulumi.getter(name="ipv6DistanceIntraArea")
    def ipv6_distance_intra_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`254` - Default value: `110`
        """
        return pulumi.get(self, "ipv6_distance_intra_area")

    @property
    @pulumi.getter(name="ipv6DistanceIntraAreaVariable")
    def ipv6_distance_intra_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_intra_area_variable")

    @property
    @pulumi.getter(name="ipv6DistanceVariable")
    def ipv6_distance_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_distance_variable")

    @property
    @pulumi.getter(name="ipv6Filter")
    def ipv6_filter(self) -> pulumi.Output[Optional[bool]]:
        """
        Filter - Default value: `false`
        """
        return pulumi.get(self, "ipv6_filter")

    @property
    @pulumi.getter(name="ipv6FilterVariable")
    def ipv6_filter_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_filter_variable")

    @property
    @pulumi.getter(name="ipv6MaxMetricRouterLsas")
    def ipv6_max_metric_router_lsas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv6MaxMetricRouterLsa']]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "ipv6_max_metric_router_lsas")

    @property
    @pulumi.getter(name="ipv6PolicyName")
    def ipv6_policy_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name
        """
        return pulumi.get(self, "ipv6_policy_name")

    @property
    @pulumi.getter(name="ipv6PolicyNameVariable")
    def ipv6_policy_name_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_policy_name_variable")

    @property
    @pulumi.getter(name="ipv6Redistributes")
    def ipv6_redistributes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfv3FeatureTemplateIpv6Redistribute']]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "ipv6_redistributes")

    @property
    @pulumi.getter(name="ipv6RouterId")
    def ipv6_router_id(self) -> pulumi.Output[Optional[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "ipv6_router_id")

    @property
    @pulumi.getter(name="ipv6RouterIdVariable")
    def ipv6_router_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_router_id_variable")

    @property
    @pulumi.getter(name="ipv6TimersSpfDelay")
    def ipv6_timers_spf_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `0`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "ipv6_timers_spf_delay")

    @property
    @pulumi.getter(name="ipv6TimersSpfDelayVariable")
    def ipv6_timers_spf_delay_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_delay_variable")

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHold")
    def ipv6_timers_spf_initial_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold")

    @property
    @pulumi.getter(name="ipv6TimersSpfInitialHoldVariable")
    def ipv6_timers_spf_initial_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_initial_hold_variable")

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHold")
    def ipv6_timers_spf_max_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `0`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold")

    @property
    @pulumi.getter(name="ipv6TimersSpfMaxHoldVariable")
    def ipv6_timers_spf_max_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_timers_spf_max_hold_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

