# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntrusionPreventionPolicyDefinitionArgs', 'IntrusionPreventionPolicyDefinition']

@pulumi.input_type
class IntrusionPreventionPolicyDefinitionArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_id: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_version: Optional[pulumi.Input[int]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signature_set: Optional[pulumi.Input[str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IntrusionPreventionPolicyDefinition resource.
        :param pulumi.Input[str] description: The description of the policy definition
        :param pulumi.Input[str] inspection_mode: The inspection mode - Choices: `protection`, `detection`
        :param pulumi.Input[str] ips_signature_list_id: IPS signature list ID
        :param pulumi.Input[int] ips_signature_list_version: IPS signature list version
        :param pulumi.Input[str] log_level: Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition
        :param pulumi.Input[str] signature_set: Signature set - Choices: `balanced`, `connectivity`, `security`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_vpns: List of VPN IDs
        """
        pulumi.set(__self__, "description", description)
        if inspection_mode is not None:
            pulumi.set(__self__, "inspection_mode", inspection_mode)
        if ips_signature_list_id is not None:
            pulumi.set(__self__, "ips_signature_list_id", ips_signature_list_id)
        if ips_signature_list_version is not None:
            pulumi.set(__self__, "ips_signature_list_version", ips_signature_list_version)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signature_set is not None:
            pulumi.set(__self__, "signature_set", signature_set)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The inspection mode - Choices: `protection`, `detection`
        """
        return pulumi.get(self, "inspection_mode")

    @inspection_mode.setter
    def inspection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspection_mode", value)

    @property
    @pulumi.getter(name="ipsSignatureListId")
    def ips_signature_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPS signature list ID
        """
        return pulumi.get(self, "ips_signature_list_id")

    @ips_signature_list_id.setter
    def ips_signature_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ips_signature_list_id", value)

    @property
    @pulumi.getter(name="ipsSignatureListVersion")
    def ips_signature_list_version(self) -> Optional[pulumi.Input[int]]:
        """
        IPS signature list version
        """
        return pulumi.get(self, "ips_signature_list_version")

    @ips_signature_list_version.setter
    def ips_signature_list_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ips_signature_list_version", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="signatureSet")
    def signature_set(self) -> Optional[pulumi.Input[str]]:
        """
        Signature set - Choices: `balanced`, `connectivity`, `security`
        """
        return pulumi.get(self, "signature_set")

    @signature_set.setter
    def signature_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_set", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_vpns", value)


@pulumi.input_type
class _IntrusionPreventionPolicyDefinitionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_id: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_version: Optional[pulumi.Input[int]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signature_set: Optional[pulumi.Input[str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering IntrusionPreventionPolicyDefinition resources.
        :param pulumi.Input[str] description: The description of the policy definition
        :param pulumi.Input[str] inspection_mode: The inspection mode - Choices: `protection`, `detection`
        :param pulumi.Input[str] ips_signature_list_id: IPS signature list ID
        :param pulumi.Input[int] ips_signature_list_version: IPS signature list version
        :param pulumi.Input[str] log_level: Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition
        :param pulumi.Input[str] signature_set: Signature set - Choices: `balanced`, `connectivity`, `security`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_vpns: List of VPN IDs
        :param pulumi.Input[int] version: The version of the object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inspection_mode is not None:
            pulumi.set(__self__, "inspection_mode", inspection_mode)
        if ips_signature_list_id is not None:
            pulumi.set(__self__, "ips_signature_list_id", ips_signature_list_id)
        if ips_signature_list_version is not None:
            pulumi.set(__self__, "ips_signature_list_version", ips_signature_list_version)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signature_set is not None:
            pulumi.set(__self__, "signature_set", signature_set)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The inspection mode - Choices: `protection`, `detection`
        """
        return pulumi.get(self, "inspection_mode")

    @inspection_mode.setter
    def inspection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspection_mode", value)

    @property
    @pulumi.getter(name="ipsSignatureListId")
    def ips_signature_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPS signature list ID
        """
        return pulumi.get(self, "ips_signature_list_id")

    @ips_signature_list_id.setter
    def ips_signature_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ips_signature_list_id", value)

    @property
    @pulumi.getter(name="ipsSignatureListVersion")
    def ips_signature_list_version(self) -> Optional[pulumi.Input[int]]:
        """
        IPS signature list version
        """
        return pulumi.get(self, "ips_signature_list_version")

    @ips_signature_list_version.setter
    def ips_signature_list_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ips_signature_list_version", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="signatureSet")
    def signature_set(self) -> Optional[pulumi.Input[str]]:
        """
        Signature set - Choices: `balanced`, `connectivity`, `security`
        """
        return pulumi.get(self, "signature_set")

    @signature_set.setter
    def signature_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_set", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_vpns", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class IntrusionPreventionPolicyDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_id: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_version: Optional[pulumi.Input[int]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signature_set: Optional[pulumi.Input[str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource can manage a Intrusion Prevention Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.IntrusionPreventionPolicyDefinition("example",
            name="Example",
            description="My description",
            mode="security",
            inspection_mode="protection",
            log_level="alert",
            signature_set="connectivity",
            target_vpns=["1"])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/intrusionPreventionPolicyDefinition:IntrusionPreventionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the policy definition
        :param pulumi.Input[str] inspection_mode: The inspection mode - Choices: `protection`, `detection`
        :param pulumi.Input[str] ips_signature_list_id: IPS signature list ID
        :param pulumi.Input[int] ips_signature_list_version: IPS signature list version
        :param pulumi.Input[str] log_level: Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition
        :param pulumi.Input[str] signature_set: Signature set - Choices: `balanced`, `connectivity`, `security`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_vpns: List of VPN IDs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntrusionPreventionPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Intrusion Prevention Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.IntrusionPreventionPolicyDefinition("example",
            name="Example",
            description="My description",
            mode="security",
            inspection_mode="protection",
            log_level="alert",
            signature_set="connectivity",
            target_vpns=["1"])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/intrusionPreventionPolicyDefinition:IntrusionPreventionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param IntrusionPreventionPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntrusionPreventionPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_id: Optional[pulumi.Input[str]] = None,
                 ips_signature_list_version: Optional[pulumi.Input[int]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signature_set: Optional[pulumi.Input[str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntrusionPreventionPolicyDefinitionArgs.__new__(IntrusionPreventionPolicyDefinitionArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["inspection_mode"] = inspection_mode
            __props__.__dict__["ips_signature_list_id"] = ips_signature_list_id
            __props__.__dict__["ips_signature_list_version"] = ips_signature_list_version
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["signature_set"] = signature_set
            __props__.__dict__["target_vpns"] = target_vpns
            __props__.__dict__["version"] = None
        super(IntrusionPreventionPolicyDefinition, __self__).__init__(
            'sdwan:index/intrusionPreventionPolicyDefinition:IntrusionPreventionPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            inspection_mode: Optional[pulumi.Input[str]] = None,
            ips_signature_list_id: Optional[pulumi.Input[str]] = None,
            ips_signature_list_version: Optional[pulumi.Input[int]] = None,
            log_level: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            signature_set: Optional[pulumi.Input[str]] = None,
            target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'IntrusionPreventionPolicyDefinition':
        """
        Get an existing IntrusionPreventionPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the policy definition
        :param pulumi.Input[str] inspection_mode: The inspection mode - Choices: `protection`, `detection`
        :param pulumi.Input[str] ips_signature_list_id: IPS signature list ID
        :param pulumi.Input[int] ips_signature_list_version: IPS signature list version
        :param pulumi.Input[str] log_level: Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition
        :param pulumi.Input[str] signature_set: Signature set - Choices: `balanced`, `connectivity`, `security`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_vpns: List of VPN IDs
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntrusionPreventionPolicyDefinitionState.__new__(_IntrusionPreventionPolicyDefinitionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["inspection_mode"] = inspection_mode
        __props__.__dict__["ips_signature_list_id"] = ips_signature_list_id
        __props__.__dict__["ips_signature_list_version"] = ips_signature_list_version
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["signature_set"] = signature_set
        __props__.__dict__["target_vpns"] = target_vpns
        __props__.__dict__["version"] = version
        return IntrusionPreventionPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the policy definition
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The inspection mode - Choices: `protection`, `detection`
        """
        return pulumi.get(self, "inspection_mode")

    @property
    @pulumi.getter(name="ipsSignatureListId")
    def ips_signature_list_id(self) -> pulumi.Output[Optional[str]]:
        """
        IPS signature list ID
        """
        return pulumi.get(self, "ips_signature_list_id")

    @property
    @pulumi.getter(name="ipsSignatureListVersion")
    def ips_signature_list_version(self) -> pulumi.Output[Optional[int]]:
        """
        IPS signature list version
        """
        return pulumi.get(self, "ips_signature_list_version")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[Optional[str]]:
        """
        Log level - Choices: `emergency`, `alert`, `critical`, `error`, `warning`, `notice`, `info`, `debug`
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="signatureSet")
    def signature_set(self) -> pulumi.Output[Optional[str]]:
        """
        Signature set - Choices: `balanced`, `connectivity`, `security`
        """
        return pulumi.get(self, "signature_set")

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of VPN IDs
        """
        return pulumi.get(self, "target_vpns")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

