# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceLanVpnFeatureArgs', 'ServiceLanVpnFeature']

@pulumi.input_type
class ServiceLanVpnFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 advertise_omp_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]] = None,
                 advertise_omp_ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]] = None,
                 config_description: Optional[pulumi.Input[str]] = None,
                 config_description_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sdwan_remote_access: Optional[pulumi.Input[bool]] = None,
                 gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]] = None,
                 host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]] = None,
                 ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]] = None,
                 ipv4_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]] = None,
                 ipv4_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]] = None,
                 ipv6_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]] = None,
                 ipv6_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]] = None,
                 nat_port_forwards: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 route_leak_from_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]] = None,
                 route_leak_from_other_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]] = None,
                 route_leak_to_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 service_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]] = None,
                 static_nats: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]] = None,
                 vpn: Optional[pulumi.Input[int]] = None,
                 vpn_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceLanVpnFeature resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]] advertise_omp_ipv4s: OMP Advertise IPv4
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]] advertise_omp_ipv6s: OMP Advertise IPv6
        :param pulumi.Input[str] config_description: Name
        :param pulumi.Input[str] config_description_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[bool] enable_sdwan_remote_access: Enable SDWAN Remote Access - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]] gre_routes: IPv4 Static GRE Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]] ipsec_routes: IPv4 Static IPSEC Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]] nat_pools: NAT Pool
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]] nat_port_forwards: NAT Port Forward
        :param pulumi.Input[int] omp_admin_distance_ipv4: OMP Admin Distance IPv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: OMP Admin Distance IPv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]] route_leak_from_global_vpns: Enable route leaking from Global to Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]] route_leak_from_other_services: Enable route leak from another Service VPN to current Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]] route_leak_to_global_vpns: Enable route leaking from Service to Global VPN
        :param pulumi.Input[str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]] service_routes: Service
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]] services: Service
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]] static_nats: Static NAT Rules
        :param pulumi.Input[int] vpn: VPN - Range: `1`-`65527` - Default value: `0`
        :param pulumi.Input[str] vpn_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if advertise_omp_ipv4s is not None:
            pulumi.set(__self__, "advertise_omp_ipv4s", advertise_omp_ipv4s)
        if advertise_omp_ipv6s is not None:
            pulumi.set(__self__, "advertise_omp_ipv6s", advertise_omp_ipv6s)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_description_variable is not None:
            pulumi.set(__self__, "config_description_variable", config_description_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_sdwan_remote_access is not None:
            pulumi.set(__self__, "enable_sdwan_remote_access", enable_sdwan_remote_access)
        if gre_routes is not None:
            pulumi.set(__self__, "gre_routes", gre_routes)
        if host_mappings is not None:
            pulumi.set(__self__, "host_mappings", host_mappings)
        if ipsec_routes is not None:
            pulumi.set(__self__, "ipsec_routes", ipsec_routes)
        if ipv4_export_route_targets is not None:
            pulumi.set(__self__, "ipv4_export_route_targets", ipv4_export_route_targets)
        if ipv4_import_route_targets is not None:
            pulumi.set(__self__, "ipv4_import_route_targets", ipv4_import_route_targets)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv6_export_route_targets is not None:
            pulumi.set(__self__, "ipv6_export_route_targets", ipv6_export_route_targets)
        if ipv6_import_route_targets is not None:
            pulumi.set(__self__, "ipv6_import_route_targets", ipv6_import_route_targets)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_v4_pools is not None:
            pulumi.set(__self__, "nat64_v4_pools", nat64_v4_pools)
        if nat_pools is not None:
            pulumi.set(__self__, "nat_pools", nat_pools)
        if nat_port_forwards is not None:
            pulumi.set(__self__, "nat_port_forwards", nat_port_forwards)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if primary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4", primary_dns_address_ipv4)
        if primary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4_variable", primary_dns_address_ipv4_variable)
        if primary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6", primary_dns_address_ipv6)
        if primary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6_variable", primary_dns_address_ipv6_variable)
        if route_leak_from_global_vpns is not None:
            pulumi.set(__self__, "route_leak_from_global_vpns", route_leak_from_global_vpns)
        if route_leak_from_other_services is not None:
            pulumi.set(__self__, "route_leak_from_other_services", route_leak_from_other_services)
        if route_leak_to_global_vpns is not None:
            pulumi.set(__self__, "route_leak_to_global_vpns", route_leak_to_global_vpns)
        if secondary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4", secondary_dns_address_ipv4)
        if secondary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4_variable", secondary_dns_address_ipv4_variable)
        if secondary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6", secondary_dns_address_ipv6)
        if secondary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6_variable", secondary_dns_address_ipv6_variable)
        if service_routes is not None:
            pulumi.set(__self__, "service_routes", service_routes)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_nats is not None:
            pulumi.set(__self__, "static_nats", static_nats)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)
        if vpn_variable is not None:
            pulumi.set(__self__, "vpn_variable", vpn_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="advertiseOmpIpv4s")
    def advertise_omp_ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]]:
        """
        OMP Advertise IPv4
        """
        return pulumi.get(self, "advertise_omp_ipv4s")

    @advertise_omp_ipv4s.setter
    def advertise_omp_ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]]):
        pulumi.set(self, "advertise_omp_ipv4s", value)

    @property
    @pulumi.getter(name="advertiseOmpIpv6s")
    def advertise_omp_ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]]:
        """
        OMP Advertise IPv6
        """
        return pulumi.get(self, "advertise_omp_ipv6s")

    @advertise_omp_ipv6s.setter
    def advertise_omp_ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]]):
        pulumi.set(self, "advertise_omp_ipv6s", value)

    @property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "config_description")

    @config_description.setter
    def config_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_description", value)

    @property
    @pulumi.getter(name="configDescriptionVariable")
    def config_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "config_description_variable")

    @config_description_variable.setter
    def config_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_description_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSdwanRemoteAccess")
    def enable_sdwan_remote_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable SDWAN Remote Access - Default value: `false`
        """
        return pulumi.get(self, "enable_sdwan_remote_access")

    @enable_sdwan_remote_access.setter
    def enable_sdwan_remote_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sdwan_remote_access", value)

    @property
    @pulumi.getter(name="greRoutes")
    def gre_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]]:
        """
        IPv4 Static GRE Route
        """
        return pulumi.get(self, "gre_routes")

    @gre_routes.setter
    def gre_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]]):
        pulumi.set(self, "gre_routes", value)

    @property
    @pulumi.getter(name="hostMappings")
    def host_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]]:
        return pulumi.get(self, "host_mappings")

    @host_mappings.setter
    def host_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]]):
        pulumi.set(self, "host_mappings", value)

    @property
    @pulumi.getter(name="ipsecRoutes")
    def ipsec_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]]:
        """
        IPv4 Static IPSEC Route
        """
        return pulumi.get(self, "ipsec_routes")

    @ipsec_routes.setter
    def ipsec_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]]):
        pulumi.set(self, "ipsec_routes", value)

    @property
    @pulumi.getter(name="ipv4ExportRouteTargets")
    def ipv4_export_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv4_export_route_targets")

    @ipv4_export_route_targets.setter
    def ipv4_export_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_export_route_targets", value)

    @property
    @pulumi.getter(name="ipv4ImportRouteTargets")
    def ipv4_import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv4_import_route_targets")

    @ipv4_import_route_targets.setter
    def ipv4_import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_import_route_targets", value)

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @property
    @pulumi.getter(name="ipv6ExportRouteTargets")
    def ipv6_export_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv6_export_route_targets")

    @ipv6_export_route_targets.setter
    def ipv6_export_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_export_route_targets", value)

    @property
    @pulumi.getter(name="ipv6ImportRouteTargets")
    def ipv6_import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv6_import_route_targets")

    @ipv6_import_route_targets.setter
    def ipv6_import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_import_route_targets", value)

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @nat64_v4_pools.setter
    def nat64_v4_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]]):
        pulumi.set(self, "nat64_v4_pools", value)

    @property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]]:
        """
        NAT Pool
        """
        return pulumi.get(self, "nat_pools")

    @nat_pools.setter
    def nat_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]]):
        pulumi.set(self, "nat_pools", value)

    @property
    @pulumi.getter(name="natPortForwards")
    def nat_port_forwards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]]:
        """
        NAT Port Forward
        """
        return pulumi.get(self, "nat_port_forwards")

    @nat_port_forwards.setter
    def nat_port_forwards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]]):
        pulumi.set(self, "nat_port_forwards", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Admin Distance IPv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Admin Distance IPv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @primary_dns_address_ipv4.setter
    def primary_dns_address_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @primary_dns_address_ipv4_variable.setter
    def primary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @primary_dns_address_ipv6.setter
    def primary_dns_address_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @primary_dns_address_ipv6_variable.setter
    def primary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="routeLeakFromGlobalVpns")
    def route_leak_from_global_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]]:
        """
        Enable route leaking from Global to Service VPN
        """
        return pulumi.get(self, "route_leak_from_global_vpns")

    @route_leak_from_global_vpns.setter
    def route_leak_from_global_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]]):
        pulumi.set(self, "route_leak_from_global_vpns", value)

    @property
    @pulumi.getter(name="routeLeakFromOtherServices")
    def route_leak_from_other_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]]:
        """
        Enable route leak from another Service VPN to current Service VPN
        """
        return pulumi.get(self, "route_leak_from_other_services")

    @route_leak_from_other_services.setter
    def route_leak_from_other_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]]):
        pulumi.set(self, "route_leak_from_other_services", value)

    @property
    @pulumi.getter(name="routeLeakToGlobalVpns")
    def route_leak_to_global_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]]:
        """
        Enable route leaking from Service to Global VPN
        """
        return pulumi.get(self, "route_leak_to_global_vpns")

    @route_leak_to_global_vpns.setter
    def route_leak_to_global_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]]):
        pulumi.set(self, "route_leak_to_global_vpns", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @secondary_dns_address_ipv4.setter
    def secondary_dns_address_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @secondary_dns_address_ipv4_variable.setter
    def secondary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @secondary_dns_address_ipv6.setter
    def secondary_dns_address_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @secondary_dns_address_ipv6_variable.setter
    def secondary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="serviceRoutes")
    def service_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "service_routes")

    @service_routes.setter
    def service_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]]):
        pulumi.set(self, "service_routes", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="staticNats")
    def static_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]]:
        """
        Static NAT Rules
        """
        return pulumi.get(self, "static_nats")

    @static_nats.setter
    def static_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]]):
        pulumi.set(self, "static_nats", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[int]]:
        """
        VPN - Range: `1`-`65527` - Default value: `0`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vpn", value)

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

    @vpn_variable.setter
    def vpn_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_variable", value)


@pulumi.input_type
class _ServiceLanVpnFeatureState:
    def __init__(__self__, *,
                 advertise_omp_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]] = None,
                 advertise_omp_ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]] = None,
                 config_description: Optional[pulumi.Input[str]] = None,
                 config_description_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sdwan_remote_access: Optional[pulumi.Input[bool]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]] = None,
                 host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]] = None,
                 ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]] = None,
                 ipv4_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]] = None,
                 ipv4_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]] = None,
                 ipv6_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]] = None,
                 ipv6_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]] = None,
                 nat_port_forwards: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 route_leak_from_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]] = None,
                 route_leak_from_other_services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]] = None,
                 route_leak_to_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 service_routes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]] = None,
                 static_nats: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 vpn: Optional[pulumi.Input[int]] = None,
                 vpn_variable: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceLanVpnFeature resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]] advertise_omp_ipv4s: OMP Advertise IPv4
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]] advertise_omp_ipv6s: OMP Advertise IPv6
        :param pulumi.Input[str] config_description: Name
        :param pulumi.Input[str] config_description_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[bool] enable_sdwan_remote_access: Enable SDWAN Remote Access - Default value: `false`
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]] gre_routes: IPv4 Static GRE Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]] ipsec_routes: IPv4 Static IPSEC Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]] nat_pools: NAT Pool
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]] nat_port_forwards: NAT Port Forward
        :param pulumi.Input[int] omp_admin_distance_ipv4: OMP Admin Distance IPv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: OMP Admin Distance IPv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]] route_leak_from_global_vpns: Enable route leaking from Global to Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]] route_leak_from_other_services: Enable route leak from another Service VPN to current Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]] route_leak_to_global_vpns: Enable route leaking from Service to Global VPN
        :param pulumi.Input[str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]] service_routes: Service
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]] services: Service
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]] static_nats: Static NAT Rules
        :param pulumi.Input[int] version: The version of the Feature
        :param pulumi.Input[int] vpn: VPN - Range: `1`-`65527` - Default value: `0`
        :param pulumi.Input[str] vpn_variable: Variable name
        """
        if advertise_omp_ipv4s is not None:
            pulumi.set(__self__, "advertise_omp_ipv4s", advertise_omp_ipv4s)
        if advertise_omp_ipv6s is not None:
            pulumi.set(__self__, "advertise_omp_ipv6s", advertise_omp_ipv6s)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_description_variable is not None:
            pulumi.set(__self__, "config_description_variable", config_description_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_sdwan_remote_access is not None:
            pulumi.set(__self__, "enable_sdwan_remote_access", enable_sdwan_remote_access)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if gre_routes is not None:
            pulumi.set(__self__, "gre_routes", gre_routes)
        if host_mappings is not None:
            pulumi.set(__self__, "host_mappings", host_mappings)
        if ipsec_routes is not None:
            pulumi.set(__self__, "ipsec_routes", ipsec_routes)
        if ipv4_export_route_targets is not None:
            pulumi.set(__self__, "ipv4_export_route_targets", ipv4_export_route_targets)
        if ipv4_import_route_targets is not None:
            pulumi.set(__self__, "ipv4_import_route_targets", ipv4_import_route_targets)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv6_export_route_targets is not None:
            pulumi.set(__self__, "ipv6_export_route_targets", ipv6_export_route_targets)
        if ipv6_import_route_targets is not None:
            pulumi.set(__self__, "ipv6_import_route_targets", ipv6_import_route_targets)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_v4_pools is not None:
            pulumi.set(__self__, "nat64_v4_pools", nat64_v4_pools)
        if nat_pools is not None:
            pulumi.set(__self__, "nat_pools", nat_pools)
        if nat_port_forwards is not None:
            pulumi.set(__self__, "nat_port_forwards", nat_port_forwards)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if primary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4", primary_dns_address_ipv4)
        if primary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv4_variable", primary_dns_address_ipv4_variable)
        if primary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6", primary_dns_address_ipv6)
        if primary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "primary_dns_address_ipv6_variable", primary_dns_address_ipv6_variable)
        if route_leak_from_global_vpns is not None:
            pulumi.set(__self__, "route_leak_from_global_vpns", route_leak_from_global_vpns)
        if route_leak_from_other_services is not None:
            pulumi.set(__self__, "route_leak_from_other_services", route_leak_from_other_services)
        if route_leak_to_global_vpns is not None:
            pulumi.set(__self__, "route_leak_to_global_vpns", route_leak_to_global_vpns)
        if secondary_dns_address_ipv4 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4", secondary_dns_address_ipv4)
        if secondary_dns_address_ipv4_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv4_variable", secondary_dns_address_ipv4_variable)
        if secondary_dns_address_ipv6 is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6", secondary_dns_address_ipv6)
        if secondary_dns_address_ipv6_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_ipv6_variable", secondary_dns_address_ipv6_variable)
        if service_routes is not None:
            pulumi.set(__self__, "service_routes", service_routes)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_nats is not None:
            pulumi.set(__self__, "static_nats", static_nats)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpn is not None:
            pulumi.set(__self__, "vpn", vpn)
        if vpn_variable is not None:
            pulumi.set(__self__, "vpn_variable", vpn_variable)

    @property
    @pulumi.getter(name="advertiseOmpIpv4s")
    def advertise_omp_ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]]:
        """
        OMP Advertise IPv4
        """
        return pulumi.get(self, "advertise_omp_ipv4s")

    @advertise_omp_ipv4s.setter
    def advertise_omp_ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv4Args']]]]):
        pulumi.set(self, "advertise_omp_ipv4s", value)

    @property
    @pulumi.getter(name="advertiseOmpIpv6s")
    def advertise_omp_ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]]:
        """
        OMP Advertise IPv6
        """
        return pulumi.get(self, "advertise_omp_ipv6s")

    @advertise_omp_ipv6s.setter
    def advertise_omp_ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureAdvertiseOmpIpv6Args']]]]):
        pulumi.set(self, "advertise_omp_ipv6s", value)

    @property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "config_description")

    @config_description.setter
    def config_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_description", value)

    @property
    @pulumi.getter(name="configDescriptionVariable")
    def config_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "config_description_variable")

    @config_description_variable.setter
    def config_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_description_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSdwanRemoteAccess")
    def enable_sdwan_remote_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable SDWAN Remote Access - Default value: `false`
        """
        return pulumi.get(self, "enable_sdwan_remote_access")

    @enable_sdwan_remote_access.setter
    def enable_sdwan_remote_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sdwan_remote_access", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="greRoutes")
    def gre_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]]:
        """
        IPv4 Static GRE Route
        """
        return pulumi.get(self, "gre_routes")

    @gre_routes.setter
    def gre_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureGreRouteArgs']]]]):
        pulumi.set(self, "gre_routes", value)

    @property
    @pulumi.getter(name="hostMappings")
    def host_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]]:
        return pulumi.get(self, "host_mappings")

    @host_mappings.setter
    def host_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureHostMappingArgs']]]]):
        pulumi.set(self, "host_mappings", value)

    @property
    @pulumi.getter(name="ipsecRoutes")
    def ipsec_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]]:
        """
        IPv4 Static IPSEC Route
        """
        return pulumi.get(self, "ipsec_routes")

    @ipsec_routes.setter
    def ipsec_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpsecRouteArgs']]]]):
        pulumi.set(self, "ipsec_routes", value)

    @property
    @pulumi.getter(name="ipv4ExportRouteTargets")
    def ipv4_export_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv4_export_route_targets")

    @ipv4_export_route_targets.setter
    def ipv4_export_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_export_route_targets", value)

    @property
    @pulumi.getter(name="ipv4ImportRouteTargets")
    def ipv4_import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv4_import_route_targets")

    @ipv4_import_route_targets.setter
    def ipv4_import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_import_route_targets", value)

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @property
    @pulumi.getter(name="ipv6ExportRouteTargets")
    def ipv6_export_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv6_export_route_targets")

    @ipv6_export_route_targets.setter
    def ipv6_export_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_export_route_targets", value)

    @property
    @pulumi.getter(name="ipv6ImportRouteTargets")
    def ipv6_import_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]]:
        return pulumi.get(self, "ipv6_import_route_targets")

    @ipv6_import_route_targets.setter
    def ipv6_import_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_import_route_targets", value)

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @nat64_v4_pools.setter
    def nat64_v4_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNat64V4PoolArgs']]]]):
        pulumi.set(self, "nat64_v4_pools", value)

    @property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]]:
        """
        NAT Pool
        """
        return pulumi.get(self, "nat_pools")

    @nat_pools.setter
    def nat_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPoolArgs']]]]):
        pulumi.set(self, "nat_pools", value)

    @property
    @pulumi.getter(name="natPortForwards")
    def nat_port_forwards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]]:
        """
        NAT Port Forward
        """
        return pulumi.get(self, "nat_port_forwards")

    @nat_port_forwards.setter
    def nat_port_forwards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureNatPortForwardArgs']]]]):
        pulumi.set(self, "nat_port_forwards", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Admin Distance IPv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Admin Distance IPv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @primary_dns_address_ipv4.setter
    def primary_dns_address_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @primary_dns_address_ipv4_variable.setter
    def primary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @primary_dns_address_ipv6.setter
    def primary_dns_address_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @primary_dns_address_ipv6_variable.setter
    def primary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="routeLeakFromGlobalVpns")
    def route_leak_from_global_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]]:
        """
        Enable route leaking from Global to Service VPN
        """
        return pulumi.get(self, "route_leak_from_global_vpns")

    @route_leak_from_global_vpns.setter
    def route_leak_from_global_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs']]]]):
        pulumi.set(self, "route_leak_from_global_vpns", value)

    @property
    @pulumi.getter(name="routeLeakFromOtherServices")
    def route_leak_from_other_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]]:
        """
        Enable route leak from another Service VPN to current Service VPN
        """
        return pulumi.get(self, "route_leak_from_other_services")

    @route_leak_from_other_services.setter
    def route_leak_from_other_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs']]]]):
        pulumi.set(self, "route_leak_from_other_services", value)

    @property
    @pulumi.getter(name="routeLeakToGlobalVpns")
    def route_leak_to_global_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]]:
        """
        Enable route leaking from Service to Global VPN
        """
        return pulumi.get(self, "route_leak_to_global_vpns")

    @route_leak_to_global_vpns.setter
    def route_leak_to_global_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs']]]]):
        pulumi.set(self, "route_leak_to_global_vpns", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @secondary_dns_address_ipv4.setter
    def secondary_dns_address_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv4", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @secondary_dns_address_ipv4_variable.setter
    def secondary_dns_address_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv4_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @secondary_dns_address_ipv6.setter
    def secondary_dns_address_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv6", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @secondary_dns_address_ipv6_variable.setter
    def secondary_dns_address_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_address_ipv6_variable", value)

    @property
    @pulumi.getter(name="serviceRoutes")
    def service_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "service_routes")

    @service_routes.setter
    def service_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceRouteArgs']]]]):
        pulumi.set(self, "service_routes", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="staticNats")
    def static_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]]:
        """
        Static NAT Rules
        """
        return pulumi.get(self, "static_nats")

    @static_nats.setter
    def static_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnFeatureStaticNatArgs']]]]):
        pulumi.set(self, "static_nats", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def vpn(self) -> Optional[pulumi.Input[int]]:
        """
        VPN - Range: `1`-`65527` - Default value: `0`
        """
        return pulumi.get(self, "vpn")

    @vpn.setter
    def vpn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vpn", value)

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

    @vpn_variable.setter
    def vpn_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_variable", value)


class ServiceLanVpnFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_omp_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv4Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv4ArgsDict']]]]] = None,
                 advertise_omp_ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv6Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv6ArgsDict']]]]] = None,
                 config_description: Optional[pulumi.Input[str]] = None,
                 config_description_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sdwan_remote_access: Optional[pulumi.Input[bool]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureGreRouteArgs', 'ServiceLanVpnFeatureGreRouteArgsDict']]]]] = None,
                 host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureHostMappingArgs', 'ServiceLanVpnFeatureHostMappingArgsDict']]]]] = None,
                 ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpsecRouteArgs', 'ServiceLanVpnFeatureIpsecRouteArgsDict']]]]] = None,
                 ipv4_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ExportRouteTargetArgsDict']]]]] = None,
                 ipv4_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ImportRouteTargetArgsDict']]]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4StaticRouteArgs', 'ServiceLanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
                 ipv6_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ExportRouteTargetArgsDict']]]]] = None,
                 ipv6_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ImportRouteTargetArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6StaticRouteArgs', 'ServiceLanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNat64V4PoolArgs', 'ServiceLanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPoolArgs', 'ServiceLanVpnFeatureNatPoolArgsDict']]]]] = None,
                 nat_port_forwards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPortForwardArgs', 'ServiceLanVpnFeatureNatPortForwardArgsDict']]]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 route_leak_from_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgsDict']]]]] = None,
                 route_leak_from_other_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs', 'ServiceLanVpnFeatureRouteLeakFromOtherServiceArgsDict']]]]] = None,
                 route_leak_to_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakToGlobalVpnArgsDict']]]]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceRouteArgs', 'ServiceLanVpnFeatureServiceRouteArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceArgs', 'ServiceLanVpnFeatureServiceArgsDict']]]]] = None,
                 static_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureStaticNatArgs', 'ServiceLanVpnFeatureStaticNatArgsDict']]]]] = None,
                 vpn: Optional[pulumi.Input[int]] = None,
                 vpn_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Service LAN VPN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_lan_vpn_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnFeature:ServiceLanVpnFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv4Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv4ArgsDict']]]] advertise_omp_ipv4s: OMP Advertise IPv4
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv6Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv6ArgsDict']]]] advertise_omp_ipv6s: OMP Advertise IPv6
        :param pulumi.Input[str] config_description: Name
        :param pulumi.Input[str] config_description_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[bool] enable_sdwan_remote_access: Enable SDWAN Remote Access - Default value: `false`
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureGreRouteArgs', 'ServiceLanVpnFeatureGreRouteArgsDict']]]] gre_routes: IPv4 Static GRE Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpsecRouteArgs', 'ServiceLanVpnFeatureIpsecRouteArgsDict']]]] ipsec_routes: IPv4 Static IPSEC Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4StaticRouteArgs', 'ServiceLanVpnFeatureIpv4StaticRouteArgsDict']]]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6StaticRouteArgs', 'ServiceLanVpnFeatureIpv6StaticRouteArgsDict']]]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNat64V4PoolArgs', 'ServiceLanVpnFeatureNat64V4PoolArgsDict']]]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPoolArgs', 'ServiceLanVpnFeatureNatPoolArgsDict']]]] nat_pools: NAT Pool
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPortForwardArgs', 'ServiceLanVpnFeatureNatPortForwardArgsDict']]]] nat_port_forwards: NAT Port Forward
        :param pulumi.Input[int] omp_admin_distance_ipv4: OMP Admin Distance IPv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: OMP Admin Distance IPv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgsDict']]]] route_leak_from_global_vpns: Enable route leaking from Global to Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs', 'ServiceLanVpnFeatureRouteLeakFromOtherServiceArgsDict']]]] route_leak_from_other_services: Enable route leak from another Service VPN to current Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakToGlobalVpnArgsDict']]]] route_leak_to_global_vpns: Enable route leaking from Service to Global VPN
        :param pulumi.Input[str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceRouteArgs', 'ServiceLanVpnFeatureServiceRouteArgsDict']]]] service_routes: Service
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceArgs', 'ServiceLanVpnFeatureServiceArgsDict']]]] services: Service
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureStaticNatArgs', 'ServiceLanVpnFeatureStaticNatArgsDict']]]] static_nats: Static NAT Rules
        :param pulumi.Input[int] vpn: VPN - Range: `1`-`65527` - Default value: `0`
        :param pulumi.Input[str] vpn_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceLanVpnFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service LAN VPN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_lan_vpn_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnFeature:ServiceLanVpnFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceLanVpnFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLanVpnFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_omp_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv4Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv4ArgsDict']]]]] = None,
                 advertise_omp_ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv6Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv6ArgsDict']]]]] = None,
                 config_description: Optional[pulumi.Input[str]] = None,
                 config_description_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sdwan_remote_access: Optional[pulumi.Input[bool]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureGreRouteArgs', 'ServiceLanVpnFeatureGreRouteArgsDict']]]]] = None,
                 host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureHostMappingArgs', 'ServiceLanVpnFeatureHostMappingArgsDict']]]]] = None,
                 ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpsecRouteArgs', 'ServiceLanVpnFeatureIpsecRouteArgsDict']]]]] = None,
                 ipv4_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ExportRouteTargetArgsDict']]]]] = None,
                 ipv4_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ImportRouteTargetArgsDict']]]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4StaticRouteArgs', 'ServiceLanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
                 ipv6_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ExportRouteTargetArgsDict']]]]] = None,
                 ipv6_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ImportRouteTargetArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6StaticRouteArgs', 'ServiceLanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNat64V4PoolArgs', 'ServiceLanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPoolArgs', 'ServiceLanVpnFeatureNatPoolArgsDict']]]]] = None,
                 nat_port_forwards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPortForwardArgs', 'ServiceLanVpnFeatureNatPortForwardArgsDict']]]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 primary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 route_leak_from_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgsDict']]]]] = None,
                 route_leak_from_other_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs', 'ServiceLanVpnFeatureRouteLeakFromOtherServiceArgsDict']]]]] = None,
                 route_leak_to_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakToGlobalVpnArgsDict']]]]] = None,
                 secondary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
                 secondary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceRouteArgs', 'ServiceLanVpnFeatureServiceRouteArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceArgs', 'ServiceLanVpnFeatureServiceArgsDict']]]]] = None,
                 static_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureStaticNatArgs', 'ServiceLanVpnFeatureStaticNatArgsDict']]]]] = None,
                 vpn: Optional[pulumi.Input[int]] = None,
                 vpn_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLanVpnFeatureArgs.__new__(ServiceLanVpnFeatureArgs)

            __props__.__dict__["advertise_omp_ipv4s"] = advertise_omp_ipv4s
            __props__.__dict__["advertise_omp_ipv6s"] = advertise_omp_ipv6s
            __props__.__dict__["config_description"] = config_description
            __props__.__dict__["config_description_variable"] = config_description_variable
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_sdwan_remote_access"] = enable_sdwan_remote_access
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["gre_routes"] = gre_routes
            __props__.__dict__["host_mappings"] = host_mappings
            __props__.__dict__["ipsec_routes"] = ipsec_routes
            __props__.__dict__["ipv4_export_route_targets"] = ipv4_export_route_targets
            __props__.__dict__["ipv4_import_route_targets"] = ipv4_import_route_targets
            __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
            __props__.__dict__["ipv6_export_route_targets"] = ipv6_export_route_targets
            __props__.__dict__["ipv6_import_route_targets"] = ipv6_import_route_targets
            __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
            __props__.__dict__["name"] = name
            __props__.__dict__["nat64_v4_pools"] = nat64_v4_pools
            __props__.__dict__["nat_pools"] = nat_pools
            __props__.__dict__["nat_port_forwards"] = nat_port_forwards
            __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
            __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
            __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
            __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
            __props__.__dict__["primary_dns_address_ipv4"] = primary_dns_address_ipv4
            __props__.__dict__["primary_dns_address_ipv4_variable"] = primary_dns_address_ipv4_variable
            __props__.__dict__["primary_dns_address_ipv6"] = primary_dns_address_ipv6
            __props__.__dict__["primary_dns_address_ipv6_variable"] = primary_dns_address_ipv6_variable
            __props__.__dict__["route_leak_from_global_vpns"] = route_leak_from_global_vpns
            __props__.__dict__["route_leak_from_other_services"] = route_leak_from_other_services
            __props__.__dict__["route_leak_to_global_vpns"] = route_leak_to_global_vpns
            __props__.__dict__["secondary_dns_address_ipv4"] = secondary_dns_address_ipv4
            __props__.__dict__["secondary_dns_address_ipv4_variable"] = secondary_dns_address_ipv4_variable
            __props__.__dict__["secondary_dns_address_ipv6"] = secondary_dns_address_ipv6
            __props__.__dict__["secondary_dns_address_ipv6_variable"] = secondary_dns_address_ipv6_variable
            __props__.__dict__["service_routes"] = service_routes
            __props__.__dict__["services"] = services
            __props__.__dict__["static_nats"] = static_nats
            __props__.__dict__["vpn"] = vpn
            __props__.__dict__["vpn_variable"] = vpn_variable
            __props__.__dict__["version"] = None
        super(ServiceLanVpnFeature, __self__).__init__(
            'sdwan:index/serviceLanVpnFeature:ServiceLanVpnFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_omp_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv4Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv4ArgsDict']]]]] = None,
            advertise_omp_ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv6Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv6ArgsDict']]]]] = None,
            config_description: Optional[pulumi.Input[str]] = None,
            config_description_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_sdwan_remote_access: Optional[pulumi.Input[bool]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureGreRouteArgs', 'ServiceLanVpnFeatureGreRouteArgsDict']]]]] = None,
            host_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureHostMappingArgs', 'ServiceLanVpnFeatureHostMappingArgsDict']]]]] = None,
            ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpsecRouteArgs', 'ServiceLanVpnFeatureIpsecRouteArgsDict']]]]] = None,
            ipv4_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ExportRouteTargetArgsDict']]]]] = None,
            ipv4_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv4ImportRouteTargetArgsDict']]]]] = None,
            ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4StaticRouteArgs', 'ServiceLanVpnFeatureIpv4StaticRouteArgsDict']]]]] = None,
            ipv6_export_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ExportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ExportRouteTargetArgsDict']]]]] = None,
            ipv6_import_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6ImportRouteTargetArgs', 'ServiceLanVpnFeatureIpv6ImportRouteTargetArgsDict']]]]] = None,
            ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6StaticRouteArgs', 'ServiceLanVpnFeatureIpv6StaticRouteArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nat64_v4_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNat64V4PoolArgs', 'ServiceLanVpnFeatureNat64V4PoolArgsDict']]]]] = None,
            nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPoolArgs', 'ServiceLanVpnFeatureNatPoolArgsDict']]]]] = None,
            nat_port_forwards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPortForwardArgs', 'ServiceLanVpnFeatureNatPortForwardArgsDict']]]]] = None,
            omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
            omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
            omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
            omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
            primary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
            primary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
            primary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
            primary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
            route_leak_from_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgsDict']]]]] = None,
            route_leak_from_other_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs', 'ServiceLanVpnFeatureRouteLeakFromOtherServiceArgsDict']]]]] = None,
            route_leak_to_global_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakToGlobalVpnArgsDict']]]]] = None,
            secondary_dns_address_ipv4: Optional[pulumi.Input[str]] = None,
            secondary_dns_address_ipv4_variable: Optional[pulumi.Input[str]] = None,
            secondary_dns_address_ipv6: Optional[pulumi.Input[str]] = None,
            secondary_dns_address_ipv6_variable: Optional[pulumi.Input[str]] = None,
            service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceRouteArgs', 'ServiceLanVpnFeatureServiceRouteArgsDict']]]]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceArgs', 'ServiceLanVpnFeatureServiceArgsDict']]]]] = None,
            static_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureStaticNatArgs', 'ServiceLanVpnFeatureStaticNatArgsDict']]]]] = None,
            version: Optional[pulumi.Input[int]] = None,
            vpn: Optional[pulumi.Input[int]] = None,
            vpn_variable: Optional[pulumi.Input[str]] = None) -> 'ServiceLanVpnFeature':
        """
        Get an existing ServiceLanVpnFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv4Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv4ArgsDict']]]] advertise_omp_ipv4s: OMP Advertise IPv4
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureAdvertiseOmpIpv6Args', 'ServiceLanVpnFeatureAdvertiseOmpIpv6ArgsDict']]]] advertise_omp_ipv6s: OMP Advertise IPv6
        :param pulumi.Input[str] config_description: Name
        :param pulumi.Input[str] config_description_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[bool] enable_sdwan_remote_access: Enable SDWAN Remote Access - Default value: `false`
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureGreRouteArgs', 'ServiceLanVpnFeatureGreRouteArgsDict']]]] gre_routes: IPv4 Static GRE Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpsecRouteArgs', 'ServiceLanVpnFeatureIpsecRouteArgsDict']]]] ipsec_routes: IPv4 Static IPSEC Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv4StaticRouteArgs', 'ServiceLanVpnFeatureIpv4StaticRouteArgsDict']]]] ipv4_static_routes: IPv4 Static Route
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureIpv6StaticRouteArgs', 'ServiceLanVpnFeatureIpv6StaticRouteArgsDict']]]] ipv6_static_routes: IPv6 Static Route
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNat64V4PoolArgs', 'ServiceLanVpnFeatureNat64V4PoolArgsDict']]]] nat64_v4_pools: NAT64 V4 Pool
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPoolArgs', 'ServiceLanVpnFeatureNatPoolArgsDict']]]] nat_pools: NAT Pool
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureNatPortForwardArgs', 'ServiceLanVpnFeatureNatPortForwardArgsDict']]]] nat_port_forwards: NAT Port Forward
        :param pulumi.Input[int] omp_admin_distance_ipv4: OMP Admin Distance IPv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: OMP Admin Distance IPv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv4: Primary DNS Address (IPv4)
        :param pulumi.Input[str] primary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] primary_dns_address_ipv6: Primary DNS Address (IPv6)
        :param pulumi.Input[str] primary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakFromGlobalVpnArgsDict']]]] route_leak_from_global_vpns: Enable route leaking from Global to Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakFromOtherServiceArgs', 'ServiceLanVpnFeatureRouteLeakFromOtherServiceArgsDict']]]] route_leak_from_other_services: Enable route leak from another Service VPN to current Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureRouteLeakToGlobalVpnArgs', 'ServiceLanVpnFeatureRouteLeakToGlobalVpnArgsDict']]]] route_leak_to_global_vpns: Enable route leaking from Service to Global VPN
        :param pulumi.Input[str] secondary_dns_address_ipv4: Secondary DNS Address (IPv4)
        :param pulumi.Input[str] secondary_dns_address_ipv4_variable: Variable name
        :param pulumi.Input[str] secondary_dns_address_ipv6: Secondary DNS Address (IPv6)
        :param pulumi.Input[str] secondary_dns_address_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceRouteArgs', 'ServiceLanVpnFeatureServiceRouteArgsDict']]]] service_routes: Service
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureServiceArgs', 'ServiceLanVpnFeatureServiceArgsDict']]]] services: Service
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnFeatureStaticNatArgs', 'ServiceLanVpnFeatureStaticNatArgsDict']]]] static_nats: Static NAT Rules
        :param pulumi.Input[int] version: The version of the Feature
        :param pulumi.Input[int] vpn: VPN - Range: `1`-`65527` - Default value: `0`
        :param pulumi.Input[str] vpn_variable: Variable name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceLanVpnFeatureState.__new__(_ServiceLanVpnFeatureState)

        __props__.__dict__["advertise_omp_ipv4s"] = advertise_omp_ipv4s
        __props__.__dict__["advertise_omp_ipv6s"] = advertise_omp_ipv6s
        __props__.__dict__["config_description"] = config_description
        __props__.__dict__["config_description_variable"] = config_description_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_sdwan_remote_access"] = enable_sdwan_remote_access
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["gre_routes"] = gre_routes
        __props__.__dict__["host_mappings"] = host_mappings
        __props__.__dict__["ipsec_routes"] = ipsec_routes
        __props__.__dict__["ipv4_export_route_targets"] = ipv4_export_route_targets
        __props__.__dict__["ipv4_import_route_targets"] = ipv4_import_route_targets
        __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
        __props__.__dict__["ipv6_export_route_targets"] = ipv6_export_route_targets
        __props__.__dict__["ipv6_import_route_targets"] = ipv6_import_route_targets
        __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
        __props__.__dict__["name"] = name
        __props__.__dict__["nat64_v4_pools"] = nat64_v4_pools
        __props__.__dict__["nat_pools"] = nat_pools
        __props__.__dict__["nat_port_forwards"] = nat_port_forwards
        __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
        __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
        __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
        __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
        __props__.__dict__["primary_dns_address_ipv4"] = primary_dns_address_ipv4
        __props__.__dict__["primary_dns_address_ipv4_variable"] = primary_dns_address_ipv4_variable
        __props__.__dict__["primary_dns_address_ipv6"] = primary_dns_address_ipv6
        __props__.__dict__["primary_dns_address_ipv6_variable"] = primary_dns_address_ipv6_variable
        __props__.__dict__["route_leak_from_global_vpns"] = route_leak_from_global_vpns
        __props__.__dict__["route_leak_from_other_services"] = route_leak_from_other_services
        __props__.__dict__["route_leak_to_global_vpns"] = route_leak_to_global_vpns
        __props__.__dict__["secondary_dns_address_ipv4"] = secondary_dns_address_ipv4
        __props__.__dict__["secondary_dns_address_ipv4_variable"] = secondary_dns_address_ipv4_variable
        __props__.__dict__["secondary_dns_address_ipv6"] = secondary_dns_address_ipv6
        __props__.__dict__["secondary_dns_address_ipv6_variable"] = secondary_dns_address_ipv6_variable
        __props__.__dict__["service_routes"] = service_routes
        __props__.__dict__["services"] = services
        __props__.__dict__["static_nats"] = static_nats
        __props__.__dict__["version"] = version
        __props__.__dict__["vpn"] = vpn
        __props__.__dict__["vpn_variable"] = vpn_variable
        return ServiceLanVpnFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advertiseOmpIpv4s")
    def advertise_omp_ipv4s(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureAdvertiseOmpIpv4']]]:
        """
        OMP Advertise IPv4
        """
        return pulumi.get(self, "advertise_omp_ipv4s")

    @property
    @pulumi.getter(name="advertiseOmpIpv6s")
    def advertise_omp_ipv6s(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureAdvertiseOmpIpv6']]]:
        """
        OMP Advertise IPv6
        """
        return pulumi.get(self, "advertise_omp_ipv6s")

    @property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> pulumi.Output[Optional[str]]:
        """
        Name
        """
        return pulumi.get(self, "config_description")

    @property
    @pulumi.getter(name="configDescriptionVariable")
    def config_description_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "config_description_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableSdwanRemoteAccess")
    def enable_sdwan_remote_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable SDWAN Remote Access - Default value: `false`
        """
        return pulumi.get(self, "enable_sdwan_remote_access")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="greRoutes")
    def gre_routes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureGreRoute']]]:
        """
        IPv4 Static GRE Route
        """
        return pulumi.get(self, "gre_routes")

    @property
    @pulumi.getter(name="hostMappings")
    def host_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureHostMapping']]]:
        return pulumi.get(self, "host_mappings")

    @property
    @pulumi.getter(name="ipsecRoutes")
    def ipsec_routes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpsecRoute']]]:
        """
        IPv4 Static IPSEC Route
        """
        return pulumi.get(self, "ipsec_routes")

    @property
    @pulumi.getter(name="ipv4ExportRouteTargets")
    def ipv4_export_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv4ExportRouteTarget']]]:
        return pulumi.get(self, "ipv4_export_route_targets")

    @property
    @pulumi.getter(name="ipv4ImportRouteTargets")
    def ipv4_import_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv4ImportRouteTarget']]]:
        return pulumi.get(self, "ipv4_import_route_targets")

    @property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv4StaticRoute']]]:
        """
        IPv4 Static Route
        """
        return pulumi.get(self, "ipv4_static_routes")

    @property
    @pulumi.getter(name="ipv6ExportRouteTargets")
    def ipv6_export_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv6ExportRouteTarget']]]:
        return pulumi.get(self, "ipv6_export_route_targets")

    @property
    @pulumi.getter(name="ipv6ImportRouteTargets")
    def ipv6_import_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv6ImportRouteTarget']]]:
        return pulumi.get(self, "ipv6_import_route_targets")

    @property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureIpv6StaticRoute']]]:
        """
        IPv6 Static Route
        """
        return pulumi.get(self, "ipv6_static_routes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nat64V4Pools")
    def nat64_v4_pools(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureNat64V4Pool']]]:
        """
        NAT64 V4 Pool
        """
        return pulumi.get(self, "nat64_v4_pools")

    @property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureNatPool']]]:
        """
        NAT Pool
        """
        return pulumi.get(self, "nat_pools")

    @property
    @pulumi.getter(name="natPortForwards")
    def nat_port_forwards(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureNatPortForward']]]:
        """
        NAT Port Forward
        """
        return pulumi.get(self, "nat_port_forwards")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> pulumi.Output[Optional[int]]:
        """
        OMP Admin Distance IPv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> pulumi.Output[Optional[int]]:
        """
        OMP Admin Distance IPv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4")
    def primary_dns_address_ipv4(self) -> pulumi.Output[Optional[str]]:
        """
        Primary DNS Address (IPv4)
        """
        return pulumi.get(self, "primary_dns_address_ipv4")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv4Variable")
    def primary_dns_address_ipv4_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv4_variable")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6")
    def primary_dns_address_ipv6(self) -> pulumi.Output[Optional[str]]:
        """
        Primary DNS Address (IPv6)
        """
        return pulumi.get(self, "primary_dns_address_ipv6")

    @property
    @pulumi.getter(name="primaryDnsAddressIpv6Variable")
    def primary_dns_address_ipv6_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_ipv6_variable")

    @property
    @pulumi.getter(name="routeLeakFromGlobalVpns")
    def route_leak_from_global_vpns(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureRouteLeakFromGlobalVpn']]]:
        """
        Enable route leaking from Global to Service VPN
        """
        return pulumi.get(self, "route_leak_from_global_vpns")

    @property
    @pulumi.getter(name="routeLeakFromOtherServices")
    def route_leak_from_other_services(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureRouteLeakFromOtherService']]]:
        """
        Enable route leak from another Service VPN to current Service VPN
        """
        return pulumi.get(self, "route_leak_from_other_services")

    @property
    @pulumi.getter(name="routeLeakToGlobalVpns")
    def route_leak_to_global_vpns(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureRouteLeakToGlobalVpn']]]:
        """
        Enable route leaking from Service to Global VPN
        """
        return pulumi.get(self, "route_leak_to_global_vpns")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4")
    def secondary_dns_address_ipv4(self) -> pulumi.Output[Optional[str]]:
        """
        Secondary DNS Address (IPv4)
        """
        return pulumi.get(self, "secondary_dns_address_ipv4")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv4Variable")
    def secondary_dns_address_ipv4_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv4_variable")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6")
    def secondary_dns_address_ipv6(self) -> pulumi.Output[Optional[str]]:
        """
        Secondary DNS Address (IPv6)
        """
        return pulumi.get(self, "secondary_dns_address_ipv6")

    @property
    @pulumi.getter(name="secondaryDnsAddressIpv6Variable")
    def secondary_dns_address_ipv6_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_ipv6_variable")

    @property
    @pulumi.getter(name="serviceRoutes")
    def service_routes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureServiceRoute']]]:
        """
        Service
        """
        return pulumi.get(self, "service_routes")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureService']]]:
        """
        Service
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticNats")
    def static_nats(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnFeatureStaticNat']]]:
        """
        Static NAT Rules
        """
        return pulumi.get(self, "static_nats")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vpn(self) -> pulumi.Output[Optional[int]]:
        """
        VPN - Range: `1`-`65527` - Default value: `0`
        """
        return pulumi.get(self, "vpn")

    @property
    @pulumi.getter(name="vpnVariable")
    def vpn_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_variable")

