# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SystemBannerFeatureArgs', 'SystemBannerFeature']

@pulumi.input_type
class SystemBannerFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 login_variable: Optional[pulumi.Input[str]] = None,
                 motd: Optional[pulumi.Input[str]] = None,
                 motd_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SystemBannerFeature resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] login_variable: Variable name
        :param pulumi.Input[str] motd_variable: Variable name
        :param pulumi.Input[str] name: The name of the Feature
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if login_variable is not None:
            pulumi.set(__self__, "login_variable", login_variable)
        if motd is not None:
            pulumi.set(__self__, "motd", motd)
        if motd_variable is not None:
            pulumi.set(__self__, "motd_variable", motd_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter(name="loginVariable")
    def login_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "login_variable")

    @login_variable.setter
    def login_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_variable", value)

    @property
    @pulumi.getter
    def motd(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "motd")

    @motd.setter
    def motd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "motd", value)

    @property
    @pulumi.getter(name="motdVariable")
    def motd_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "motd_variable")

    @motd_variable.setter
    def motd_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "motd_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SystemBannerFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 login_variable: Optional[pulumi.Input[str]] = None,
                 motd: Optional[pulumi.Input[str]] = None,
                 motd_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SystemBannerFeature resources.
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] login_variable: Variable name
        :param pulumi.Input[str] motd_variable: Variable name
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[int] version: The version of the Feature
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if login_variable is not None:
            pulumi.set(__self__, "login_variable", login_variable)
        if motd is not None:
            pulumi.set(__self__, "motd", motd)
        if motd_variable is not None:
            pulumi.set(__self__, "motd_variable", motd_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter(name="loginVariable")
    def login_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "login_variable")

    @login_variable.setter
    def login_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_variable", value)

    @property
    @pulumi.getter
    def motd(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "motd")

    @motd.setter
    def motd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "motd", value)

    @property
    @pulumi.getter(name="motdVariable")
    def motd_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "motd_variable")

    @motd_variable.setter
    def motd_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "motd_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class SystemBannerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 login_variable: Optional[pulumi.Input[str]] = None,
                 motd: Optional[pulumi.Input[str]] = None,
                 motd_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a System Banner Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.SystemBannerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            login="My login banner",
            motd="My motd banner")
        ```

        ## Import

        Expected import identifier with the format: "system_banner_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemBannerFeature:SystemBannerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] login_variable: Variable name
        :param pulumi.Input[str] motd_variable: Variable name
        :param pulumi.Input[str] name: The name of the Feature
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemBannerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System Banner Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.SystemBannerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            login="My login banner",
            motd="My motd banner")
        ```

        ## Import

        Expected import identifier with the format: "system_banner_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemBannerFeature:SystemBannerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemBannerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemBannerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 login_variable: Optional[pulumi.Input[str]] = None,
                 motd: Optional[pulumi.Input[str]] = None,
                 motd_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemBannerFeatureArgs.__new__(SystemBannerFeatureArgs)

            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["login"] = login
            __props__.__dict__["login_variable"] = login_variable
            __props__.__dict__["motd"] = motd
            __props__.__dict__["motd_variable"] = motd_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(SystemBannerFeature, __self__).__init__(
            'sdwan:index/systemBannerFeature:SystemBannerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            login: Optional[pulumi.Input[str]] = None,
            login_variable: Optional[pulumi.Input[str]] = None,
            motd: Optional[pulumi.Input[str]] = None,
            motd_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'SystemBannerFeature':
        """
        Get an existing SystemBannerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] login_variable: Variable name
        :param pulumi.Input[str] motd_variable: Variable name
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemBannerFeatureState.__new__(_SystemBannerFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["login"] = login
        __props__.__dict__["login_variable"] = login_variable
        __props__.__dict__["motd"] = motd
        __props__.__dict__["motd_variable"] = motd_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return SystemBannerFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="loginVariable")
    def login_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "login_variable")

    @property
    @pulumi.getter
    def motd(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "motd")

    @property
    @pulumi.getter(name="motdVariable")
    def motd_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "motd_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

