# Generated by ariadne-codegen
# Source: src/aiware/graphql/operations

from typing import Any, Dict, List, Optional, Union

from aiware.common.schemas import JSONData, serialize_jsondata

from .base_client_ref import BaseClient
from .base_model_ref import UNSET, UnsetType
from .create_sdo import CreateSDO
from .get_schema import GetSchema
from .get_sd_os import GetSDOs
from .get_sdo import GetSDO
from .update_sdo import UpdateSDO


def gql(q: str) -> str:
    return q


class GeneratedAiwareGraphQL(BaseClient):
    def create_sdo(
        self, id: str, schemaId: str, data: JSONData, **kwargs: Any
    ) -> CreateSDO:
        query = gql(
            """
            mutation CreateSDO($id: ID!, $schemaId: ID!, $data: JSONData!) {
              createStructuredData(input: {schemaId: $schemaId, id: $id, data: $data}) {
                ...SDO
              }
            }

            fragment SDO on StructuredData {
              id
              schemaId
              createdDateTime
              modifiedDateTime
              data
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "schemaId": schemaId,
            "data": serialize_jsondata(data),
        }
        response = self.execute(
            query=query, operation_name="CreateSDO", variables=variables, **kwargs
        )
        _data = self.get_data(response)
        return CreateSDO.model_validate(_data)

    def get_sdo(self, id: str, schemaId: str, **kwargs: Any) -> GetSDO:
        query = gql(
            """
            query GetSDO($id: ID!, $schemaId: ID!) {
              structuredDataObject(id: $id, schemaId: $schemaId) {
                ...SDO
              }
            }

            fragment SDO on StructuredData {
              id
              schemaId
              createdDateTime
              modifiedDateTime
              data
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "schemaId": schemaId}
        response = self.execute(
            query=query, operation_name="GetSDO", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetSDO.model_validate(data)

    def get_sd_os(
        self,
        schemaId: str,
        ids: Union[Optional[List[str]], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetSDOs:
        query = gql(
            """
            query GetSDOs($schemaId: ID!, $ids: [ID!], $limit: Int, $offset: Int) {
              structuredDataObjects(
                schemaId: $schemaId
                ids: $ids
                limit: $limit
                offset: $offset
                orderBy: [{direction: asc, field: createdDateTime}]
              ) {
                ...SDOPage
              }
            }

            fragment SDO on StructuredData {
              id
              schemaId
              createdDateTime
              modifiedDateTime
              data
            }

            fragment SDOPage on StructuredDataList {
              records {
                ...SDO
              }
              count
              offset
              limit
            }
            """
        )
        variables: Dict[str, object] = {
            "schemaId": schemaId,
            "ids": ids,
            "limit": limit,
            "offset": offset,
        }
        response = self.execute(
            query=query, operation_name="GetSDOs", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetSDOs.model_validate(data)

    def update_sdo(
        self, id: str, schemaId: str, data: JSONData, **kwargs: Any
    ) -> UpdateSDO:
        query = gql(
            """
            mutation UpdateSDO($id: ID!, $schemaId: ID!, $data: JSONData!) {
              createStructuredData(input: {schemaId: $schemaId, id: $id, data: $data}) {
                ...SDO
              }
            }

            fragment SDO on StructuredData {
              id
              schemaId
              createdDateTime
              modifiedDateTime
              data
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "schemaId": schemaId,
            "data": serialize_jsondata(data),
        }
        response = self.execute(
            query=query, operation_name="UpdateSDO", variables=variables, **kwargs
        )
        _data = self.get_data(response)
        return UpdateSDO.model_validate(_data)

    def get_schema(self, id: str, **kwargs: Any) -> GetSchema:
        query = gql(
            """
            query _GetSchema($id: ID!) {
              sdoSchema: schema(id: $id) {
                ...SchemaForCodegen
              }
            }

            fragment SchemaForCodegen on Schema {
              id
              dataRegistryId
              majorVersion
              minorVersion
              definition
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = self.execute(
            query=query, operation_name="_GetSchema", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetSchema.model_validate(data)
