# Generated by ariadne-codegen
# Source: src/aiware/graphql/operations

from datetime import datetime
from typing import Annotated, List, Optional

from pydantic import BeforeValidator

from aiware.common.schemas import JSONData, parse_jsondata

from .base_model_ref import BaseModel
from .enums import TaskStatus


class DocumentIngestProcess(BaseModel):
    id: str
    createdDateTime: Optional[datetime]
    modifiedDateTime: Optional[datetime]
    status: Optional[TaskStatus]


class DocumentTDO(BaseModel):
    id: str
    createdDateTime: Optional[datetime]
    modifiedDateTime: Optional[datetime]
    name: Optional[str]
    primaryAsset: Optional["DocumentTDOPrimaryAsset"]


class DocumentTDOPrimaryAsset(BaseModel):
    id: str
    contentType: Optional[str]


class DocumentTDOPage(BaseModel):
    records: Optional[List[Optional["DocumentTDOPageRecords"]]]
    count: Optional[int]
    offset: int
    limit: int


class DocumentTDOPageRecords(DocumentTDO):
    pass


class SDO(BaseModel):
    id: str
    schemaId: str
    createdDateTime: Optional[datetime]
    modifiedDateTime: Optional[datetime]
    data: Optional[Annotated[JSONData, BeforeValidator(parse_jsondata)]]


class SDOPage(BaseModel):
    records: Optional[List[Optional["SDOPageRecords"]]]
    count: Optional[int]
    offset: int
    limit: int


class SDOPageRecords(SDO):
    pass


class SchemaForCodegen(BaseModel):
    id: str
    dataRegistryId: str
    majorVersion: int
    minorVersion: int
    definition: Optional[Annotated[JSONData, BeforeValidator(parse_jsondata)]]


DocumentIngestProcess.model_rebuild()
DocumentTDO.model_rebuild()
DocumentTDOPage.model_rebuild()
SDO.model_rebuild()
SDOPage.model_rebuild()
SchemaForCodegen.model_rebuild()
