# generated by datamodel-codegen:
#   filename:  <stdin>

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated, Any, Dict, List, Optional
from uuid import UUID

from pydantic import Field, RootModel

from aiware.common.schemas import BaseSchema


class SearchRequest(BaseSchema):
    index: Annotated[
        List[str],
        Field(
            description='There are two pre-defined indexes called "global" and "mine", where "global" is the global index while "mine" is the index associated with your application.'
        ),
    ]
    query: Annotated[
        Dict[str, Any],
        Field(
            description='See https://github.com/veritone/core-search-server#query-statements.'
        ),
    ]
    select: Annotated[
        Optional[List[Dict[str, Any]]],
        Field(
            description='See https://github.com/veritone/core-search-server#select-statements.'
        ),
    ] = None
    sort: Annotated[
        Optional[List[Dict[str, Any]]],
        Field(
            description='See https://github.com/veritone/core-search-server#sort-statements.'
        ),
    ] = None
    offset: Annotated[
        Optional[float],
        Field(
            description='Used for paging, indicates the zero-base index of the first result. If not provided, defaults to 0.'
        ),
    ] = None
    limit: Annotated[
        Optional[float],
        Field(
            description='Maxiumum of results to return. Cannot exceed 100. Defaults to 10.'
        ),
    ] = None


class SearchAggregationRequest(SearchRequest):
    aggregate: Optional[List[Dict[str, Any]]] = None


class SearchScrollRequest(BaseSchema):
    searchToken: str
    page: Optional[float] = None


class SearchAutoCompleteRequest(BaseSchema):
    text: Annotated[Optional[str], Field(description='prefix query string')] = None
    fields: Annotated[
        Optional[List[str]], Field(description='type qualified field names to match on')
    ] = None
    limit: Optional[float] = None
    order: Optional[str] = None
    returnContext: Optional[bool] = None
    index: Annotated[
        Optional[List[str]],
        Field(
            description='There are two pre-defined indexes called "global" and "mine", where "global" is the global index while "mine" is the index associated with your application.'
        ),
    ] = None
    query: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description='See https://github.com/veritone/core-search-server#query-statements.'
        ),
    ] = None


class SearchMentionsRequest(BaseSchema):
    index: Annotated[
        Optional[List[str]], Field(description='Must be equal to ["mine"].')
    ] = None
    query: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description='Requires at least one statement. See https://github.com/veritone/core-search-server#query-statements.'
        ),
    ] = None
    offset: Annotated[
        Optional[float],
        Field(
            description='Used for paging, indicates the zero-base index of the first result. If not provided, defaults to 0.'
        ),
    ] = None
    limit: Annotated[
        Optional[float],
        Field(
            description='Maximum of results to return. Cannot exceed 100. Defaults to 10.'
        ),
    ] = None
    aggregate: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description='Used to specific which values to aggregate. Required for aggregate endpoint. (Superset of the normal request body)'
        ),
    ] = None


class DetailedError(BaseSchema):
    message: Annotated[Optional[str], Field(description='Detailed error message.')] = (
        None
    )
    reason: Annotated[Optional[str], Field(description='Error category.')] = None
    domain: Annotated[
        Optional[str],
        Field(description='Indicates which subsystem in returned the error.'),
    ] = None


class SearchResultsPage(BaseSchema):
    totalResults: Annotated[
        Optional[int], Field(description='Total number of results.', examples=[100])
    ] = None
    from_: Annotated[
        Optional[int],
        Field(alias='from', description='Results from this index.', examples=[20]),
    ] = None
    to: Annotated[
        Optional[int], Field(description='Results to this index.', examples=[30])
    ] = None
    limit: Annotated[
        Optional[int], Field(description='Number of limit results.', examples=[10])
    ] = None
    timestamp: Annotated[
        Optional[int],
        Field(description='Timestamp in Unix epoch time.', examples=[1623719032]),
    ] = None
    searchToken: Annotated[
        Optional[UUID], Field(description='Search token for this search.')
    ] = None


class SearchAggregateResults(BaseSchema):
    aggregate: Annotated[
        Optional[Dict[str, Any]], Field(description='Aggregate results.')
    ] = None


class TdoMetadata(BaseSchema):
    absoluteStartTimeMs: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    absoluteStopTimeMs: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    recordingId: Annotated[Optional[str], Field(examples=['1490336702'])] = None
    fileType: Annotated[Optional[str], Field(examples=['video/mp4'])] = None
    fileLocation: Annotated[
        Optional[str],
        Field(
            examples=[
                '"https://api.veritone.com/media-streamer/download/tdo/1490336702'
            ]
        ),
    ] = None
    createdTime: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    modifiedTme: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None


class TdoSliceMetadata(TdoMetadata):
    relativeStartTimeMs: Annotated[Optional[float], Field(examples=[1000])] = None
    relativeStopTimeMs: Annotated[Optional[float], Field(examples=[1000])] = None


class TdoResult(BaseSchema):
    recording: Optional[TdoMetadata] = None
    context: Optional[List[Dict[str, Any]]] = None
    hits: Optional[List[Dict[str, Any]]] = None


class TdoSliceResult(BaseSchema):
    recording: Optional[TdoMetadata] = None
    context: Optional[List[Dict[str, Any]]] = None
    hits: Optional[List[Dict[str, Any]]] = None


class SliceResult(BaseSchema):
    recording: Optional[TdoSliceMetadata] = None
    context: Optional[List[Dict[str, Any]]] = None
    hits: Optional[List[Dict[str, Any]]] = None


class TdoSearchResult(SearchResultsPage):
    results: Optional[List[TdoResult]] = None


class TdoMetadataSearchResult(SearchResultsPage):
    results: Optional[List[TdoMetadata]] = None


class SliceSearchResult(SearchResultsPage):
    results: Optional[List[SliceResult]] = None


class CountSearchResult(BaseSchema):
    totalRecords: Optional[float] = None


class AutocompleteFieldResult(BaseSchema):
    key: Annotated[
        Optional[str],
        Field(
            description='the keyword matching the autocomplete query for the requested field',
            examples=['weather'],
        ),
    ] = None
    doc_count: Annotated[Optional[float], Field(examples=[100])] = None
    doc: Annotated[
        Optional[Dict[str, Any]],
        Field(description='sample data containing the key match'),
    ] = None


class AutocompleteFieldResults(RootModel[List[AutocompleteFieldResult]]):
    root: List[AutocompleteFieldResult]


class AutocompleteResult(BaseSchema):
    fields: Optional[Dict[str, AutocompleteFieldResults]] = None


class TextSnippet(BaseSchema):
    startTime: Annotated[Optional[float], Field(examples=[23.7])] = None
    stoptTime: Annotated[Optional[float], Field(examples=[53.7])] = None
    text: Annotated[Optional[str], Field(examples=['mention transcript text body'])] = (
        None
    )


class MentionResult(BaseSchema):
    id: Annotated[
        Optional[str], Field(description='unique mention id', examples=['441914472'])
    ] = None
    mediaId: Annotated[
        Optional[float],
        Field(
            description='id of the tdo from which the mention was created',
            examples=[1411340879],
        ),
    ] = None
    mentionDate: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    mediaStartTime: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    hitStartTime: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    hitEndTime: Annotated[
        Optional[datetime], Field(examples=['2021-04-13T11:40:00.000Z'])
    ] = None
    metadata: Optional[Dict[str, Any]] = None
    cognitiveEngineResults: Annotated[
        Optional[Dict[str, Any]], Field(description='search hit cognitive data')
    ] = None
    snippets: Optional[List[TextSnippet]] = None
    userSnippets: Optional[List[TextSnippet]] = None
    trackingUnitId: Annotated[
        Optional[float],
        Field(description='watchlist id the mention belongs to', examples=[252514]),
    ] = None
    trackingUnitName: Annotated[Optional[str], Field(examples=['Q1 tracking'])] = None
    mentionStatusId: Annotated[
        Optional[float],
        Field(description='the watchlist or user assigned status', examples=[2]),
    ] = None
    mentionStatusName: Annotated[Optional[str], Field(examples=['Verified'])] = None
    mediaSourceTypeId: Annotated[Optional[float], Field(examples=[2])] = None
    mediaSourceTypeName: Annotated[Optional[str], Field(examples=['Audio'])] = None
    mediaSourceId: Annotated[Optional[float], Field(examples=[67016])] = None
    mediaSourceName: Annotated[
        Optional[str], Field(examples=['WSDV-AM - iHeart Sarasota'])
    ] = None
    programId: Annotated[Optional[float], Field(examples=[83902])] = None
    programName: Annotated[
        Optional[str], Field(examples=['MF 10:00-12:00 WSDV-AM'])
    ] = None
    hourOfDay: Annotated[Optional[float], Field(examples=[12])] = None
    dayOfWeek: Annotated[Optional[float], Field(examples=[3])] = None
    dayOfMonth: Annotated[Optional[float], Field(examples=[15])] = None
    month: Annotated[Optional[float], Field(examples=[3])] = None
    year: Annotated[Optional[float], Field(examples=[2020])] = None
    audience: Optional[Dict[str, Any]] = None
    targetAudience: Optional[Dict[str, Any]] = None
    markets: Optional[List[Dict[str, Any]]] = None


class MentionsSearchResults(SearchResultsPage):
    results: Optional[List[MentionResult]] = None


class AuditLogSearchRequest(BaseSchema):
    index: Annotated[
        Optional[List[str]], Field(description='Must be equal to ["audit_log"].')
    ] = None
    query: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description='Requires at least one statement. See https://github.com/veritone/core-search-server#query-statements.'
        ),
    ] = None
    offset: Annotated[
        Optional[float],
        Field(
            description='Used for paging, indicates the zero-base index of the first result. If not provided, defaults to 0.'
        ),
    ] = None
    limit: Annotated[
        Optional[float],
        Field(
            description='Maximum of results to return. Cannot exceed 100. Defaults to 10.'
        ),
    ] = None
    aggregate: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description='Used to specific which values to aggregate. Required for aggregate endpoint. (Superset of the normal request body)'
        ),
    ] = None


class AuditLogResult(BaseSchema):
    event_id: Annotated[
        Optional[str],
        Field(description='unique audit log id', examples=['73WakrfVbNJBaAmhQtEeDv']),
    ] = None
    timestamp: Annotated[
        Optional[datetime], Field(examples=['2023-12-19T22:03:21.021Z'])
    ] = None
    userID: Annotated[
        Optional[str], Field(examples=['64fb3ddd-6b14-4fd8-94b5-fc4ebc732c37'])
    ] = None
    requestIP: Annotated[Optional[str], Field(examples=['23.185.0.4'])] = None
    organizationGuid: Annotated[
        Optional[str], Field(examples=['11a5a739-1fba-49a5-8afb-4373f8728cc6'])
    ] = None
    organizationName: Annotated[Optional[str], Field(examples=['Veritone Inc.'])] = None
    originatorApplication: Annotated[
        Optional[str], Field(examples=['developer app'])
    ] = None
    originatorService: Annotated[
        Optional[str], Field(examples=['core-graphql-server'])
    ] = None
    requestUserAgent: Annotated[
        Optional[str], Field(examples=['Mozilla/5.0 (Windows NT 10.0...)'])
    ] = None
    targetType: Annotated[Optional[str], Field(examples=['temporalDataObject'])] = None
    targetId: Annotated[Optional[str], Field(examples=['1232812328'])] = None
    actionName: Annotated[Optional[str], Field(examples=['RecordingCreated'])] = None
    actionResult: Annotated[Optional[str], Field(examples=['success'])] = None
    actionDetails: Annotated[
        Optional[str], Field(examples=['Created temporal data object'])
    ] = None


class VectorSearchRequestSemanticSearchVectorSimilarity(BaseSchema):
    rawData: Optional[List[float]] = None


class VectorSearchRequestSemanticSearchTextSimilarity(BaseSchema):
    rawData: Optional[str] = None


class VectorSearchRequestSemanticSearchImageSimilarity(BaseSchema):
    rawData: Optional[str] = None


class VectorSearchRequestSemanticSearchAudioSimilarity(BaseSchema):
    rawData: Optional[str] = None


class VectorSearchRequestSemanticSearchRescoringInputRescoringOperation(Enum):
    field_ = '+'
    field__1 = '-'
    field__2 = '*'
    field__3 = '/'


class VectorSearchRequestSemanticSearchRescoringInputMatchType(Enum):
    exact = 'exact'
    partial = 'partial'


class VectorSearchRequestSemanticSearchRescoringInput(BaseSchema):
    fieldPath: Optional[str] = None
    value: Optional[str] = None
    customScore: Optional[float] = None
    rescoringOperation: Optional[
        VectorSearchRequestSemanticSearchRescoringInputRescoringOperation
    ] = None
    matchType: Optional[VectorSearchRequestSemanticSearchRescoringInputMatchType] = None


class VectorSearchRequestSemanticSearchOptimization(BaseSchema):
    num_candidates: Optional[float] = None
    min_score: Optional[float] = None


class VectorSearchRequestSemanticSearch(BaseSchema):
    vectorSimilarity: Optional[VectorSearchRequestSemanticSearchVectorSimilarity] = None
    textSimilarity: Optional[VectorSearchRequestSemanticSearchTextSimilarity] = None
    imageSimilarity: Optional[VectorSearchRequestSemanticSearchImageSimilarity] = None
    audioSimilarity: Optional[VectorSearchRequestSemanticSearchAudioSimilarity] = None
    rescoringInput: Optional[VectorSearchRequestSemanticSearchRescoringInput] = None
    engineIds: Optional[List[str]] = None
    k: Optional[float] = None
    optimization: Optional[VectorSearchRequestSemanticSearchOptimization] = None
    aggregationsToReturn: Optional[float] = None


class VectorSearchRequestFilterOperator(Enum):
    query_string = 'query_string'
    term = 'term'
    terms = 'terms'
    range = 'range'
    exists = 'exists'
    or_ = 'or'
    and_ = 'and'


class Components(RootModel[Any]):
    root: Any


class VectorSearchResultsResultMetaData(BaseSchema):
    recordingId: Optional[str] = None
    fileType: Optional[str] = None


class VectorSearchResultsResultSery(BaseSchema):
    startTime: Optional[float] = None
    stopTime: Optional[float] = None


class VectorSearchResultsResult(BaseSchema):
    recordingId: Optional[str] = None
    metaData: Optional[VectorSearchResultsResultMetaData] = None
    series: Optional[List[VectorSearchResultsResultSery]] = None


class VectorSearchResults(BaseSchema):
    results: Optional[List[VectorSearchResultsResult]] = None
    totalCount: Optional[float] = None


class Filter(RootModel[Any]):
    root: Any


class Error(BaseSchema):
    code: Annotated[Optional[int], Field(description='HTTP error code.')] = None
    message: Annotated[
        Optional[str], Field(description='High level error description.')
    ] = None
    errors: Annotated[
        Optional[List[DetailedError]], Field(description='Detailed error chain.')
    ] = None


class AuditLogSearchResults(SearchResultsPage):
    results: Optional[List[AuditLogResult]] = None


class VectorSearchRequestFilter(BaseSchema):
    operator: Optional[VectorSearchRequestFilterOperator] = None
    conditions: Optional[Filter] = None
    field: Optional[str] = None
    value: Optional[str] = None
    gt: Optional[str] = None
    gte: Optional[str] = None
    lt: Optional[str] = None
    lte: Optional[str] = None
    not_: Annotated[Optional[bool], Field(alias='not')] = None


class VectorSearchRequest(BaseSchema):
    semanticSearch: Optional[VectorSearchRequestSemanticSearch] = None
    filters: Optional[List[VectorSearchRequestFilter]] = None
