# Copyright (C) 2021  The LFCNN Authors
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.


"""The LFCNN mask layers.
"""

from .neural_fractal import NeuralFractal


def get(mask: str) -> callable:
    """Given a mask name, returns an lfcnn mask layer.

    Args:
        mask: Name of the mask.

    Returns:
        Mask layer callable.
    """
    # Available mask classes
    classes = {
        "neuralfractal": NeuralFractal,
    }
    try:
        return classes[mask.lower().replace("_", "")]
    except KeyError:
        raise ValueError(f"Unknown mask layer '{mask}'.")
