(self["webpackChunkunderstory_js"] = self["webpackChunkunderstory_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_vb_vb_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/vb/vb.js":
/*!********************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/vb/vb.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/vb/vb.ts
var conf = {
  comments: {
    lineComment: "'",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"],
    ["<", ">"],
    ["addhandler", "end addhandler"],
    ["class", "end class"],
    ["enum", "end enum"],
    ["event", "end event"],
    ["function", "end function"],
    ["get", "end get"],
    ["if", "end if"],
    ["interface", "end interface"],
    ["module", "end module"],
    ["namespace", "end namespace"],
    ["operator", "end operator"],
    ["property", "end property"],
    ["raiseevent", "end raiseevent"],
    ["removehandler", "end removehandler"],
    ["select", "end select"],
    ["set", "end set"],
    ["structure", "end structure"],
    ["sub", "end sub"],
    ["synclock", "end synclock"],
    ["try", "end try"],
    ["while", "end while"],
    ["with", "end with"],
    ["using", "end using"],
    ["do", "loop"],
    ["for", "next"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}", notIn: ["string", "comment"] },
    { open: "[", close: "]", notIn: ["string", "comment"] },
    { open: "(", close: ")", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["string", "comment"] },
    { open: "<", close: ">", notIn: ["string", "comment"] }
  ],
  folding: {
    markers: {
      start: new RegExp("^\\s*#Region\\b"),
      end: new RegExp("^\\s*#End Region\\b")
    }
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".vb",
  ignoreCase: true,
  brackets: [
    { token: "delimiter.bracket", open: "{", close: "}" },
    { token: "delimiter.array", open: "[", close: "]" },
    { token: "delimiter.parenthesis", open: "(", close: ")" },
    { token: "delimiter.angle", open: "<", close: ">" },
    {
      token: "keyword.tag-addhandler",
      open: "addhandler",
      close: "end addhandler"
    },
    { token: "keyword.tag-class", open: "class", close: "end class" },
    { token: "keyword.tag-enum", open: "enum", close: "end enum" },
    { token: "keyword.tag-event", open: "event", close: "end event" },
    {
      token: "keyword.tag-function",
      open: "function",
      close: "end function"
    },
    { token: "keyword.tag-get", open: "get", close: "end get" },
    { token: "keyword.tag-if", open: "if", close: "end if" },
    {
      token: "keyword.tag-interface",
      open: "interface",
      close: "end interface"
    },
    { token: "keyword.tag-module", open: "module", close: "end module" },
    {
      token: "keyword.tag-namespace",
      open: "namespace",
      close: "end namespace"
    },
    {
      token: "keyword.tag-operator",
      open: "operator",
      close: "end operator"
    },
    {
      token: "keyword.tag-property",
      open: "property",
      close: "end property"
    },
    {
      token: "keyword.tag-raiseevent",
      open: "raiseevent",
      close: "end raiseevent"
    },
    {
      token: "keyword.tag-removehandler",
      open: "removehandler",
      close: "end removehandler"
    },
    { token: "keyword.tag-select", open: "select", close: "end select" },
    { token: "keyword.tag-set", open: "set", close: "end set" },
    {
      token: "keyword.tag-structure",
      open: "structure",
      close: "end structure"
    },
    { token: "keyword.tag-sub", open: "sub", close: "end sub" },
    {
      token: "keyword.tag-synclock",
      open: "synclock",
      close: "end synclock"
    },
    { token: "keyword.tag-try", open: "try", close: "end try" },
    { token: "keyword.tag-while", open: "while", close: "end while" },
    { token: "keyword.tag-with", open: "with", close: "end with" },
    { token: "keyword.tag-using", open: "using", close: "end using" },
    { token: "keyword.tag-do", open: "do", close: "loop" },
    { token: "keyword.tag-for", open: "for", close: "next" }
  ],
  keywords: [
    "AddHandler",
    "AddressOf",
    "Alias",
    "And",
    "AndAlso",
    "As",
    "Async",
    "Boolean",
    "ByRef",
    "Byte",
    "ByVal",
    "Call",
    "Case",
    "Catch",
    "CBool",
    "CByte",
    "CChar",
    "CDate",
    "CDbl",
    "CDec",
    "Char",
    "CInt",
    "Class",
    "CLng",
    "CObj",
    "Const",
    "Continue",
    "CSByte",
    "CShort",
    "CSng",
    "CStr",
    "CType",
    "CUInt",
    "CULng",
    "CUShort",
    "Date",
    "Decimal",
    "Declare",
    "Default",
    "Delegate",
    "Dim",
    "DirectCast",
    "Do",
    "Double",
    "Each",
    "Else",
    "ElseIf",
    "End",
    "EndIf",
    "Enum",
    "Erase",
    "Error",
    "Event",
    "Exit",
    "False",
    "Finally",
    "For",
    "Friend",
    "Function",
    "Get",
    "GetType",
    "GetXMLNamespace",
    "Global",
    "GoSub",
    "GoTo",
    "Handles",
    "If",
    "Implements",
    "Imports",
    "In",
    "Inherits",
    "Integer",
    "Interface",
    "Is",
    "IsNot",
    "Let",
    "Lib",
    "Like",
    "Long",
    "Loop",
    "Me",
    "Mod",
    "Module",
    "MustInherit",
    "MustOverride",
    "MyBase",
    "MyClass",
    "NameOf",
    "Namespace",
    "Narrowing",
    "New",
    "Next",
    "Not",
    "Nothing",
    "NotInheritable",
    "NotOverridable",
    "Object",
    "Of",
    "On",
    "Operator",
    "Option",
    "Optional",
    "Or",
    "OrElse",
    "Out",
    "Overloads",
    "Overridable",
    "Overrides",
    "ParamArray",
    "Partial",
    "Private",
    "Property",
    "Protected",
    "Public",
    "RaiseEvent",
    "ReadOnly",
    "ReDim",
    "RemoveHandler",
    "Resume",
    "Return",
    "SByte",
    "Select",
    "Set",
    "Shadows",
    "Shared",
    "Short",
    "Single",
    "Static",
    "Step",
    "Stop",
    "String",
    "Structure",
    "Sub",
    "SyncLock",
    "Then",
    "Throw",
    "To",
    "True",
    "Try",
    "TryCast",
    "TypeOf",
    "UInteger",
    "ULong",
    "UShort",
    "Using",
    "Variant",
    "Wend",
    "When",
    "While",
    "Widening",
    "With",
    "WithEvents",
    "WriteOnly",
    "Xor"
  ],
  tagwords: [
    "If",
    "Sub",
    "Select",
    "Try",
    "Class",
    "Enum",
    "Function",
    "Get",
    "Interface",
    "Module",
    "Namespace",
    "Operator",
    "Set",
    "Structure",
    "Using",
    "While",
    "With",
    "Do",
    "Loop",
    "For",
    "Next",
    "Property",
    "Continue",
    "AddHandler",
    "RemoveHandler",
    "Event",
    "RaiseEvent",
    "SyncLock"
  ],
  symbols: /[=><!~?;\.,:&|+\-*\/\^%]+/,
  integersuffix: /U?[DI%L&S@]?/,
  floatsuffix: /[R#F!]?/,
  tokenizer: {
    root: [
      { include: "@whitespace" },
      [/next(?!\w)/, { token: "keyword.tag-for" }],
      [/loop(?!\w)/, { token: "keyword.tag-do" }],
      [
        /end\s+(?!for|do)(addhandler|class|enum|event|function|get|if|interface|module|namespace|operator|property|raiseevent|removehandler|select|set|structure|sub|synclock|try|while|with|using)/,
        { token: "keyword.tag-$1" }
      ],
      [
        /[a-zA-Z_]\w*/,
        {
          cases: {
            "@tagwords": { token: "keyword.tag-$0" },
            "@keywords": { token: "keyword.$0" },
            "@default": "identifier"
          }
        }
      ],
      [/^\s*#\w+/, "keyword"],
      [/\d*\d+e([\-+]?\d+)?(@floatsuffix)/, "number.float"],
      [/\d*\.\d+(e[\-+]?\d+)?(@floatsuffix)/, "number.float"],
      [/&H[0-9a-f]+(@integersuffix)/, "number.hex"],
      [/&0[0-7]+(@integersuffix)/, "number.octal"],
      [/\d+(@integersuffix)/, "number"],
      [/#.*#/, "number"],
      [/[{}()\[\]]/, "@brackets"],
      [/@symbols/, "delimiter"],
      [/["\u201c\u201d]/, { token: "string.quote", next: "@string" }]
    ],
    whitespace: [
      [/[ \t\r\n]+/, ""],
      [/(\'|REM(?!\w)).*$/, "comment"]
    ],
    string: [
      [/[^"\u201c\u201d]+/, "string"],
      [/["\u201c\u201d]{2}/, "string.escape"],
      [/["\u201c\u201d]C?/, { token: "string.quote", next: "@pop" }]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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