(self["webpackChunkunderstory_js"] = self["webpackChunkunderstory_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_yaml_yaml_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/yaml/yaml.js":
/*!************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/yaml/yaml.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/yaml/yaml.ts
var conf = {
  comments: {
    lineComment: "#"
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  folding: {
    offSide: true
  }
};
var language = {
  tokenPostfix: ".yaml",
  brackets: [
    { token: "delimiter.bracket", open: "{", close: "}" },
    { token: "delimiter.square", open: "[", close: "]" }
  ],
  keywords: ["true", "True", "TRUE", "false", "False", "FALSE", "null", "Null", "Null", "~"],
  numberInteger: /(?:0|[+-]?[0-9]+)/,
  numberFloat: /(?:0|[+-]?[0-9]+)(?:\.[0-9]+)?(?:e[-+][1-9][0-9]*)?/,
  numberOctal: /0o[0-7]+/,
  numberHex: /0x[0-9a-fA-F]+/,
  numberInfinity: /[+-]?\.(?:inf|Inf|INF)/,
  numberNaN: /\.(?:nan|Nan|NAN)/,
  numberDate: /\d{4}-\d\d-\d\d([Tt ]\d\d:\d\d:\d\d(\.\d+)?(( ?[+-]\d\d?(:\d\d)?)|Z)?)?/,
  escapes: /\\(?:[btnfr\\"']|[0-7][0-7]?|[0-3][0-7]{2})/,
  tokenizer: {
    root: [
      { include: "@whitespace" },
      { include: "@comment" },
      [/%[^ ]+.*$/, "meta.directive"],
      [/---/, "operators.directivesEnd"],
      [/\.{3}/, "operators.documentEnd"],
      [/[-?:](?= )/, "operators"],
      { include: "@anchor" },
      { include: "@tagHandle" },
      { include: "@flowCollections" },
      { include: "@blockStyle" },
      [/@numberInteger(?![ \t]*\S+)/, "number"],
      [/@numberFloat(?![ \t]*\S+)/, "number.float"],
      [/@numberOctal(?![ \t]*\S+)/, "number.octal"],
      [/@numberHex(?![ \t]*\S+)/, "number.hex"],
      [/@numberInfinity(?![ \t]*\S+)/, "number.infinity"],
      [/@numberNaN(?![ \t]*\S+)/, "number.nan"],
      [/@numberDate(?![ \t]*\S+)/, "number.date"],
      [/(".*?"|'.*?'|.*?)([ \t]*)(:)( |$)/, ["type", "white", "operators", "white"]],
      { include: "@flowScalars" },
      [
        /[^#]+/,
        {
          cases: {
            "@keywords": "keyword",
            "@default": "string"
          }
        }
      ]
    ],
    object: [
      { include: "@whitespace" },
      { include: "@comment" },
      [/\}/, "@brackets", "@pop"],
      [/,/, "delimiter.comma"],
      [/:(?= )/, "operators"],
      [/(?:".*?"|'.*?'|[^,\{\[]+?)(?=: )/, "type"],
      { include: "@flowCollections" },
      { include: "@flowScalars" },
      { include: "@tagHandle" },
      { include: "@anchor" },
      { include: "@flowNumber" },
      [
        /[^\},]+/,
        {
          cases: {
            "@keywords": "keyword",
            "@default": "string"
          }
        }
      ]
    ],
    array: [
      { include: "@whitespace" },
      { include: "@comment" },
      [/\]/, "@brackets", "@pop"],
      [/,/, "delimiter.comma"],
      { include: "@flowCollections" },
      { include: "@flowScalars" },
      { include: "@tagHandle" },
      { include: "@anchor" },
      { include: "@flowNumber" },
      [
        /[^\],]+/,
        {
          cases: {
            "@keywords": "keyword",
            "@default": "string"
          }
        }
      ]
    ],
    multiString: [[/^( +).+$/, "string", "@multiStringContinued.$1"]],
    multiStringContinued: [
      [
        /^( *).+$/,
        {
          cases: {
            "$1==$S2": "string",
            "@default": { token: "@rematch", next: "@popall" }
          }
        }
      ]
    ],
    whitespace: [[/[ \t\r\n]+/, "white"]],
    comment: [[/#.*$/, "comment"]],
    flowCollections: [
      [/\[/, "@brackets", "@array"],
      [/\{/, "@brackets", "@object"]
    ],
    flowScalars: [
      [/"([^"\\]|\\.)*$/, "string.invalid"],
      [/'([^'\\]|\\.)*$/, "string.invalid"],
      [/'[^']*'/, "string"],
      [/"/, "string", "@doubleQuotedString"]
    ],
    doubleQuotedString: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, "string", "@pop"]
    ],
    blockStyle: [[/[>|][0-9]*[+-]?$/, "operators", "@multiString"]],
    flowNumber: [
      [/@numberInteger(?=[ \t]*[,\]\}])/, "number"],
      [/@numberFloat(?=[ \t]*[,\]\}])/, "number.float"],
      [/@numberOctal(?=[ \t]*[,\]\}])/, "number.octal"],
      [/@numberHex(?=[ \t]*[,\]\}])/, "number.hex"],
      [/@numberInfinity(?=[ \t]*[,\]\}])/, "number.infinity"],
      [/@numberNaN(?=[ \t]*[,\]\}])/, "number.nan"],
      [/@numberDate(?=[ \t]*[,\]\}])/, "number.date"]
    ],
    tagHandle: [[/\![^ ]*/, "tag"]],
    anchor: [[/[&*][^ ]+/, "namespace"]]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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