(self["webpackChunkunderstory_js"] = self["webpackChunkunderstory_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_elixir_elixir_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/elixir/elixir.js":
/*!****************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/elixir/elixir.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/elixir/elixir.ts
var conf = {
  comments: {
    lineComment: "#"
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "'", close: "'" },
    { open: '"', close: '"' }
  ],
  autoClosingPairs: [
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["comment"] },
    { open: '"""', close: '"""' },
    { open: "`", close: "`", notIn: ["string", "comment"] },
    { open: "(", close: ")" },
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "<<", close: ">>" }
  ],
  indentationRules: {
    increaseIndentPattern: /^\s*(after|else|catch|rescue|fn|[^#]*(do|<\-|\->|\{|\[|\=))\s*$/,
    decreaseIndentPattern: /^\s*((\}|\])\s*$|(after|else|catch|rescue|end)\b)/
  }
};
var language = {
  defaultToken: "source",
  tokenPostfix: ".elixir",
  brackets: [
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "<<", close: ">>", token: "delimiter.angle.special" }
  ],
  declarationKeywords: [
    "def",
    "defp",
    "defn",
    "defnp",
    "defguard",
    "defguardp",
    "defmacro",
    "defmacrop",
    "defdelegate",
    "defcallback",
    "defmacrocallback",
    "defmodule",
    "defprotocol",
    "defexception",
    "defimpl",
    "defstruct"
  ],
  operatorKeywords: ["and", "in", "not", "or", "when"],
  namespaceKeywords: ["alias", "import", "require", "use"],
  otherKeywords: [
    "after",
    "case",
    "catch",
    "cond",
    "do",
    "else",
    "end",
    "fn",
    "for",
    "if",
    "quote",
    "raise",
    "receive",
    "rescue",
    "super",
    "throw",
    "try",
    "unless",
    "unquote_splicing",
    "unquote",
    "with"
  ],
  constants: ["true", "false", "nil"],
  nameBuiltin: ["__MODULE__", "__DIR__", "__ENV__", "__CALLER__", "__STACKTRACE__"],
  operator: /-[->]?|!={0,2}|\*{1,2}|\/|\\\\|&{1,3}|\.\.?|\^(?:\^\^)?|\+\+?|<(?:-|<<|=|>|\|>|~>?)?|=~|={1,3}|>(?:=|>>)?|\|~>|\|>|\|{1,3}|~>>?|~~~|::/,
  variableName: /[a-z_][a-zA-Z0-9_]*[?!]?/,
  atomName: /[a-zA-Z_][a-zA-Z0-9_@]*[?!]?|@specialAtomName|@operator/,
  specialAtomName: /\.\.\.|<<>>|%\{\}|%|\{\}/,
  aliasPart: /[A-Z][a-zA-Z0-9_]*/,
  moduleName: /@aliasPart(?:\.@aliasPart)*/,
  sigilSymmetricDelimiter: /"""|'''|"|'|\/|\|/,
  sigilStartDelimiter: /@sigilSymmetricDelimiter|<|\{|\[|\(/,
  sigilEndDelimiter: /@sigilSymmetricDelimiter|>|\}|\]|\)/,
  sigilModifiers: /[a-zA-Z0-9]*/,
  decimal: /\d(?:_?\d)*/,
  hex: /[0-9a-fA-F](_?[0-9a-fA-F])*/,
  octal: /[0-7](_?[0-7])*/,
  binary: /[01](_?[01])*/,
  escape: /\\u[0-9a-fA-F]{4}|\\x[0-9a-fA-F]{2}|\\./,
  tokenizer: {
    root: [
      { include: "@whitespace" },
      { include: "@comments" },
      { include: "@keywordsShorthand" },
      { include: "@numbers" },
      { include: "@identifiers" },
      { include: "@strings" },
      { include: "@atoms" },
      { include: "@sigils" },
      { include: "@attributes" },
      { include: "@symbols" }
    ],
    whitespace: [[/\s+/, "white"]],
    comments: [[/(#)(.*)/, ["comment.punctuation", "comment"]]],
    keywordsShorthand: [
      [/(@atomName)(:)/, ["constant", "constant.punctuation"]],
      [
        /"(?=([^"]|#\{.*?\}|\\")*":)/,
        { token: "constant.delimiter", next: "@doubleQuotedStringKeyword" }
      ],
      [
        /'(?=([^']|#\{.*?\}|\\')*':)/,
        { token: "constant.delimiter", next: "@singleQuotedStringKeyword" }
      ]
    ],
    doubleQuotedStringKeyword: [
      [/":/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    singleQuotedStringKeyword: [
      [/':/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    numbers: [
      [/0b@binary/, "number.binary"],
      [/0o@octal/, "number.octal"],
      [/0x@hex/, "number.hex"],
      [/@decimal\.@decimal([eE]-?@decimal)?/, "number.float"],
      [/@decimal/, "number"]
    ],
    identifiers: [
      [
        /\b(defp?|defnp?|defmacrop?|defguardp?|defdelegate)(\s+)(@variableName)(?!\s+@operator)/,
        [
          "keyword.declaration",
          "white",
          {
            cases: {
              unquote: "keyword",
              "@default": "function"
            }
          }
        ]
      ],
      [
        /(@variableName)(?=\s*\.?\s*\()/,
        {
          cases: {
            "@declarationKeywords": "keyword.declaration",
            "@namespaceKeywords": "keyword",
            "@otherKeywords": "keyword",
            "@default": "function.call"
          }
        }
      ],
      [
        /(@moduleName)(\s*)(\.)(\s*)(@variableName)/,
        ["type.identifier", "white", "operator", "white", "function.call"]
      ],
      [
        /(:)(@atomName)(\s*)(\.)(\s*)(@variableName)/,
        ["constant.punctuation", "constant", "white", "operator", "white", "function.call"]
      ],
      [
        /(\|>)(\s*)(@variableName)/,
        [
          "operator",
          "white",
          {
            cases: {
              "@otherKeywords": "keyword",
              "@default": "function.call"
            }
          }
        ]
      ],
      [
        /(&)(\s*)(@variableName)/,
        ["operator", "white", "function.call"]
      ],
      [
        /@variableName/,
        {
          cases: {
            "@declarationKeywords": "keyword.declaration",
            "@operatorKeywords": "keyword.operator",
            "@namespaceKeywords": "keyword",
            "@otherKeywords": "keyword",
            "@constants": "constant.language",
            "@nameBuiltin": "variable.language",
            "_.*": "comment.unused",
            "@default": "identifier"
          }
        }
      ],
      [/@moduleName/, "type.identifier"]
    ],
    strings: [
      [/"""/, { token: "string.delimiter", next: "@doubleQuotedHeredoc" }],
      [/'''/, { token: "string.delimiter", next: "@singleQuotedHeredoc" }],
      [/"/, { token: "string.delimiter", next: "@doubleQuotedString" }],
      [/'/, { token: "string.delimiter", next: "@singleQuotedString" }]
    ],
    doubleQuotedHeredoc: [
      [/"""/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    singleQuotedHeredoc: [
      [/'''/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    doubleQuotedString: [
      [/"/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    singleQuotedString: [
      [/'/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    atoms: [
      [/(:)(@atomName)/, ["constant.punctuation", "constant"]],
      [/:"/, { token: "constant.delimiter", next: "@doubleQuotedStringAtom" }],
      [/:'/, { token: "constant.delimiter", next: "@singleQuotedStringAtom" }]
    ],
    doubleQuotedStringAtom: [
      [/"/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    singleQuotedStringAtom: [
      [/'/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    sigils: [
      [/~[a-z]@sigilStartDelimiter/, { token: "@rematch", next: "@sigil.interpol" }],
      [/~[A-Z]@sigilStartDelimiter/, { token: "@rematch", next: "@sigil.noInterpol" }]
    ],
    sigil: [
      [/~([a-zA-Z])\{/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.{.}" }],
      [/~([a-zA-Z])\[/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.[.]" }],
      [/~([a-zA-Z])\(/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.(.)" }],
      [/~([a-zA-Z])\</, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.<.>" }],
      [
        /~([a-zA-Z])(@sigilSymmetricDelimiter)/,
        { token: "@rematch", switchTo: "@sigilStart.$S2.$1.$2.$2" }
      ]
    ],
    "sigilStart.interpol.s": [
      [
        /~s@sigilStartDelimiter/,
        {
          token: "string.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol.s": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "string.delimiter", next: "@pop" },
            "@default": "string"
          }
        }
      ],
      { include: "@stringContentInterpol" }
    ],
    "sigilStart.noInterpol.S": [
      [
        /~S@sigilStartDelimiter/,
        {
          token: "string.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol.S": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "string"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "string.delimiter", next: "@pop" },
            "@default": "string"
          }
        }
      ],
      { include: "@stringContent" }
    ],
    "sigilStart.interpol.r": [
      [
        /~r@sigilStartDelimiter/,
        {
          token: "regexp.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol.r": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "regexp.delimiter", next: "@pop" },
            "@default": "regexp"
          }
        }
      ],
      { include: "@regexpContentInterpol" }
    ],
    "sigilStart.noInterpol.R": [
      [
        /~R@sigilStartDelimiter/,
        {
          token: "regexp.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol.R": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "regexp"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "regexp.delimiter", next: "@pop" },
            "@default": "regexp"
          }
        }
      ],
      { include: "@regexpContent" }
    ],
    "sigilStart.interpol": [
      [
        /~([a-zA-Z])@sigilStartDelimiter/,
        {
          token: "sigil.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "sigil.delimiter", next: "@pop" },
            "@default": "sigil"
          }
        }
      ],
      { include: "@sigilContentInterpol" }
    ],
    "sigilStart.noInterpol": [
      [
        /~([a-zA-Z])@sigilStartDelimiter/,
        {
          token: "sigil.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "sigil"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "sigil.delimiter", next: "@pop" },
            "@default": "sigil"
          }
        }
      ],
      { include: "@sigilContent" }
    ],
    attributes: [
      [
        /\@(module|type)?doc (~[sS])?"""/,
        {
          token: "comment.block.documentation",
          next: "@doubleQuotedHeredocDocstring"
        }
      ],
      [
        /\@(module|type)?doc (~[sS])?"/,
        {
          token: "comment.block.documentation",
          next: "@doubleQuotedStringDocstring"
        }
      ],
      [/\@(module|type)?doc false/, "comment.block.documentation"],
      [/\@(@variableName)/, "variable"]
    ],
    doubleQuotedHeredocDocstring: [
      [/"""/, { token: "comment.block.documentation", next: "@pop" }],
      { include: "@docstringContent" }
    ],
    doubleQuotedStringDocstring: [
      [/"/, { token: "comment.block.documentation", next: "@pop" }],
      { include: "@docstringContent" }
    ],
    symbols: [
      [/\?(\\.|[^\\\s])/, "number.constant"],
      [/&\d+/, "operator"],
      [/<<<|>>>/, "operator"],
      [/[()\[\]\{\}]|<<|>>/, "@brackets"],
      [/\.\.\./, "identifier"],
      [/=>/, "punctuation"],
      [/@operator/, "operator"],
      [/[:;,.%]/, "punctuation"]
    ],
    stringContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@stringContent" }
    ],
    stringContent: [[/./, "string"]],
    stringConstantContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@stringConstantContent" }
    ],
    stringConstantContent: [[/./, "constant"]],
    regexpContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@regexpContent" }
    ],
    regexpContent: [
      [/(\s)(#)(\s.*)$/, ["white", "comment.punctuation", "comment"]],
      [/./, "regexp"]
    ],
    sigilContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@sigilContent" }
    ],
    sigilContent: [[/./, "sigil"]],
    docstringContent: [[/./, "comment.block.documentation"]],
    escapeChar: [[/@escape/, "constant.character.escape"]],
    interpolation: [[/#{/, { token: "delimiter.bracket.embed", next: "@interpolationContinue" }]],
    interpolationContinue: [
      [/}/, { token: "delimiter.bracket.embed", next: "@pop" }],
      { include: "@root" }
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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