(self["webpackChunkunderstory_js"] = self["webpackChunkunderstory_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_systemverilog_systemverilog_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/systemverilog/systemverilog.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/systemverilog/systemverilog.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/systemverilog/systemverilog.ts
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"],
    ["begin", "end"],
    ["case", "endcase"],
    ["casex", "endcase"],
    ["casez", "endcase"],
    ["checker", "endchecker"],
    ["class", "endclass"],
    ["clocking", "endclocking"],
    ["config", "endconfig"],
    ["function", "endfunction"],
    ["generate", "endgenerate"],
    ["group", "endgroup"],
    ["interface", "endinterface"],
    ["module", "endmodule"],
    ["package", "endpackage"],
    ["primitive", "endprimitive"],
    ["program", "endprogram"],
    ["property", "endproperty"],
    ["specify", "endspecify"],
    ["sequence", "endsequence"],
    ["table", "endtable"],
    ["task", "endtask"]
  ],
  autoClosingPairs: [
    { open: "[", close: "]" },
    { open: "{", close: "}" },
    { open: "(", close: ")" },
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["string"] }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  folding: {
    offSide: false,
    markers: {
      start: new RegExp("^(?:\\s*|.*(?!\\/[\\/\\*])[^\\w])(?:begin|case(x|z)?|class|clocking|config|covergroup|function|generate|interface|module|package|primitive|property|program|sequence|specify|table|task)\\b"),
      end: new RegExp("^(?:\\s*|.*(?!\\/[\\/\\*])[^\\w])(?:end|endcase|endclass|endclocking|endconfig|endgroup|endfunction|endgenerate|endinterface|endmodule|endpackage|endprimitive|endproperty|endprogram|endsequence|endspecify|endtable|endtask)\\b")
    }
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".sv",
  brackets: [
    { token: "delimiter.curly", open: "{", close: "}" },
    { token: "delimiter.parenthesis", open: "(", close: ")" },
    { token: "delimiter.square", open: "[", close: "]" },
    { token: "delimiter.angle", open: "<", close: ">" }
  ],
  keywords: [
    "accept_on",
    "alias",
    "always",
    "always_comb",
    "always_ff",
    "always_latch",
    "and",
    "assert",
    "assign",
    "assume",
    "automatic",
    "before",
    "begin",
    "bind",
    "bins",
    "binsof",
    "bit",
    "break",
    "buf",
    "bufif0",
    "bufif1",
    "byte",
    "case",
    "casex",
    "casez",
    "cell",
    "chandle",
    "checker",
    "class",
    "clocking",
    "cmos",
    "config",
    "const",
    "constraint",
    "context",
    "continue",
    "cover",
    "covergroup",
    "coverpoint",
    "cross",
    "deassign",
    "default",
    "defparam",
    "design",
    "disable",
    "dist",
    "do",
    "edge",
    "else",
    "end",
    "endcase",
    "endchecker",
    "endclass",
    "endclocking",
    "endconfig",
    "endfunction",
    "endgenerate",
    "endgroup",
    "endinterface",
    "endmodule",
    "endpackage",
    "endprimitive",
    "endprogram",
    "endproperty",
    "endspecify",
    "endsequence",
    "endtable",
    "endtask",
    "enum",
    "event",
    "eventually",
    "expect",
    "export",
    "extends",
    "extern",
    "final",
    "first_match",
    "for",
    "force",
    "foreach",
    "forever",
    "fork",
    "forkjoin",
    "function",
    "generate",
    "genvar",
    "global",
    "highz0",
    "highz1",
    "if",
    "iff",
    "ifnone",
    "ignore_bins",
    "illegal_bins",
    "implements",
    "implies",
    "import",
    "incdir",
    "include",
    "initial",
    "inout",
    "input",
    "inside",
    "instance",
    "int",
    "integer",
    "interconnect",
    "interface",
    "intersect",
    "join",
    "join_any",
    "join_none",
    "large",
    "let",
    "liblist",
    "library",
    "local",
    "localparam",
    "logic",
    "longint",
    "macromodule",
    "matches",
    "medium",
    "modport",
    "module",
    "nand",
    "negedge",
    "nettype",
    "new",
    "nexttime",
    "nmos",
    "nor",
    "noshowcancelled",
    "not",
    "notif0",
    "notif1",
    "null",
    "or",
    "output",
    "package",
    "packed",
    "parameter",
    "pmos",
    "posedge",
    "primitive",
    "priority",
    "program",
    "property",
    "protected",
    "pull0",
    "pull1",
    "pulldown",
    "pullup",
    "pulsestyle_ondetect",
    "pulsestyle_onevent",
    "pure",
    "rand",
    "randc",
    "randcase",
    "randsequence",
    "rcmos",
    "real",
    "realtime",
    "ref",
    "reg",
    "reject_on",
    "release",
    "repeat",
    "restrict",
    "return",
    "rnmos",
    "rpmos",
    "rtran",
    "rtranif0",
    "rtranif1",
    "s_always",
    "s_eventually",
    "s_nexttime",
    "s_until",
    "s_until_with",
    "scalared",
    "sequence",
    "shortint",
    "shortreal",
    "showcancelled",
    "signed",
    "small",
    "soft",
    "solve",
    "specify",
    "specparam",
    "static",
    "string",
    "strong",
    "strong0",
    "strong1",
    "struct",
    "super",
    "supply0",
    "supply1",
    "sync_accept_on",
    "sync_reject_on",
    "table",
    "tagged",
    "task",
    "this",
    "throughout",
    "time",
    "timeprecision",
    "timeunit",
    "tran",
    "tranif0",
    "tranif1",
    "tri",
    "tri0",
    "tri1",
    "triand",
    "trior",
    "trireg",
    "type",
    "typedef",
    "union",
    "unique",
    "unique0",
    "unsigned",
    "until",
    "until_with",
    "untyped",
    "use",
    "uwire",
    "var",
    "vectored",
    "virtual",
    "void",
    "wait",
    "wait_order",
    "wand",
    "weak",
    "weak0",
    "weak1",
    "while",
    "wildcard",
    "wire",
    "with",
    "within",
    "wor",
    "xnor",
    "xor"
  ],
  builtin_gates: [
    "and",
    "nand",
    "nor",
    "or",
    "xor",
    "xnor",
    "buf",
    "not",
    "bufif0",
    "bufif1",
    "notif1",
    "notif0",
    "cmos",
    "nmos",
    "pmos",
    "rcmos",
    "rnmos",
    "rpmos",
    "tran",
    "tranif1",
    "tranif0",
    "rtran",
    "rtranif1",
    "rtranif0"
  ],
  operators: [
    "=",
    "+=",
    "-=",
    "*=",
    "/=",
    "%=",
    "&=",
    "|=",
    "^=",
    "<<=",
    ">>+",
    "<<<=",
    ">>>=",
    "?",
    ":",
    "+",
    "-",
    "!",
    "~",
    "&",
    "~&",
    "|",
    "~|",
    "^",
    "~^",
    "^~",
    "+",
    "-",
    "*",
    "/",
    "%",
    "==",
    "!=",
    "===",
    "!==",
    "==?",
    "!=?",
    "&&",
    "||",
    "**",
    "<",
    "<=",
    ">",
    ">=",
    "&",
    "|",
    "^",
    ">>",
    "<<",
    ">>>",
    "<<<",
    "++",
    "--",
    "->",
    "<->",
    "inside",
    "dist",
    "::",
    "+:",
    "-:",
    "*>",
    "&&&",
    "|->",
    "|=>",
    "#=#"
  ],
  symbols: /[=><!~?:&|+\-*\/\^%#]+/,
  escapes: /%%|\\(?:[antvf\\"']|x[0-9A-Fa-f]{1,2}|[0-7]{1,3})/,
  identifier: /(?:[a-zA-Z_][a-zA-Z0-9_$\.]*|\\\S+ )/,
  systemcall: /[$][a-zA-Z0-9_]+/,
  timeunits: /s|ms|us|ns|ps|fs/,
  tokenizer: {
    root: [
      [
        /^(\s*)(@identifier)/,
        [
          "",
          {
            cases: {
              "@builtin_gates": {
                token: "keyword.$2",
                next: "@module_instance"
              },
              table: {
                token: "keyword.$2",
                next: "@table"
              },
              "@keywords": { token: "keyword.$2" },
              "@default": {
                token: "identifier",
                next: "@module_instance"
              }
            }
          }
        ]
      ],
      [/^\s*`include/, { token: "keyword.directive.include", next: "@include" }],
      [/^\s*`\s*\w+/, "keyword"],
      { include: "@identifier_or_keyword" },
      { include: "@whitespace" },
      [/\(\*.*\*\)/, "annotation"],
      [/@systemcall/, "variable.predefined"],
      [/[{}()\[\]]/, "@brackets"],
      [/[<>](?!@symbols)/, "@brackets"],
      [
        /@symbols/,
        {
          cases: {
            "@operators": "delimiter",
            "@default": ""
          }
        }
      ],
      { include: "@numbers" },
      [/[;,.]/, "delimiter"],
      { include: "@strings" }
    ],
    identifier_or_keyword: [
      [
        /@identifier/,
        {
          cases: {
            "@keywords": { token: "keyword.$0" },
            "@default": "identifier"
          }
        }
      ]
    ],
    numbers: [
      [/\d+?[\d_]*(?:\.[\d_]+)?[eE][\-+]?\d+/, "number.float"],
      [/\d+?[\d_]*\.[\d_]+(?:\s*@timeunits)?/, "number.float"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[dD]\s*[0-9xXzZ?]+?[0-9xXzZ?_]*/, "number"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[bB]\s*[0-1xXzZ?]+?[0-1xXzZ?_]*/, "number.binary"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[oO]\s*[0-7xXzZ?]+?[0-7xXzZ?_]*/, "number.octal"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[hH]\s*[0-9a-fA-FxXzZ?]+?[0-9a-fA-FxXzZ?_]*/, "number.hex"],
      [/1step/, "number"],
      [/[\dxXzZ]+?[\dxXzZ_]*(?:\s*@timeunits)?/, "number"],
      [/'[01xXzZ]+/, "number"]
    ],
    module_instance: [
      { include: "@whitespace" },
      [/(#?)(\()/, ["", { token: "@brackets", next: "@port_connection" }]],
      [/@identifier\s*[;={}\[\],]/, { token: "@rematch", next: "@pop" }],
      [/@symbols|[;={}\[\],]/, { token: "@rematch", next: "@pop" }],
      [/@identifier/, "type"],
      [/;/, "delimiter", "@pop"]
    ],
    port_connection: [
      { include: "@identifier_or_keyword" },
      { include: "@whitespace" },
      [/@systemcall/, "variable.predefined"],
      { include: "@numbers" },
      { include: "@strings" },
      [/[,]/, "delimiter"],
      [/\(/, "@brackets", "@port_connection"],
      [/\)/, "@brackets", "@pop"]
    ],
    whitespace: [
      [/[ \t\r\n]+/, ""],
      [/\/\*/, "comment", "@comment"],
      [/\/\/.*$/, "comment"]
    ],
    comment: [
      [/[^\/*]+/, "comment"],
      [/\*\//, "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    strings: [
      [/"([^"\\]|\\.)*$/, "string.invalid"],
      [/"/, "string", "@string"]
    ],
    string: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, "string", "@pop"]
    ],
    include: [
      [
        /(\s*)(")([\w*\/*]*)(.\w*)(")/,
        [
          "",
          "string.include.identifier",
          "string.include.identifier",
          "string.include.identifier",
          { token: "string.include.identifier", next: "@pop" }
        ]
      ],
      [
        /(\s*)(<)([\w*\/*]*)(.\w*)(>)/,
        [
          "",
          "string.include.identifier",
          "string.include.identifier",
          "string.include.identifier",
          { token: "string.include.identifier", next: "@pop" }
        ]
      ]
    ],
    table: [
      { include: "@whitespace" },
      [/[()]/, "@brackets"],
      [/[:;]/, "delimiter"],
      [/[01\-*?xXbBrRfFpPnN]/, "variable.predefined"],
      ["endtable", "keyword.endtable", "@pop"]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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