(self["webpackChunkunderstory_js"] = self["webpackChunkunderstory_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_language_typescript_tsMode_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/language/typescript/tsMode.js":
/*!*************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/language/typescript/tsMode.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Adapter": () => (/* binding */ Adapter),
/* harmony export */   "CodeActionAdaptor": () => (/* binding */ CodeActionAdaptor),
/* harmony export */   "DefinitionAdapter": () => (/* binding */ DefinitionAdapter),
/* harmony export */   "DiagnosticsAdapter": () => (/* binding */ DiagnosticsAdapter),
/* harmony export */   "FormatAdapter": () => (/* binding */ FormatAdapter),
/* harmony export */   "FormatHelper": () => (/* binding */ FormatHelper),
/* harmony export */   "FormatOnTypeAdapter": () => (/* binding */ FormatOnTypeAdapter),
/* harmony export */   "InlayHintsAdapter": () => (/* binding */ InlayHintsAdapter),
/* harmony export */   "Kind": () => (/* binding */ Kind),
/* harmony export */   "LibFiles": () => (/* binding */ LibFiles),
/* harmony export */   "OccurrencesAdapter": () => (/* binding */ OccurrencesAdapter),
/* harmony export */   "OutlineAdapter": () => (/* binding */ OutlineAdapter),
/* harmony export */   "QuickInfoAdapter": () => (/* binding */ QuickInfoAdapter),
/* harmony export */   "ReferenceAdapter": () => (/* binding */ ReferenceAdapter),
/* harmony export */   "RenameAdapter": () => (/* binding */ RenameAdapter),
/* harmony export */   "SignatureHelpAdapter": () => (/* binding */ SignatureHelpAdapter),
/* harmony export */   "SuggestAdapter": () => (/* binding */ SuggestAdapter),
/* harmony export */   "WorkerManager": () => (/* binding */ WorkerManager),
/* harmony export */   "flattenDiagnosticMessageText": () => (/* binding */ flattenDiagnosticMessageText),
/* harmony export */   "getJavaScriptWorker": () => (/* binding */ getJavaScriptWorker),
/* harmony export */   "getTypeScriptWorker": () => (/* binding */ getTypeScriptWorker),
/* harmony export */   "setupJavaScript": () => (/* binding */ setupJavaScript),
/* harmony export */   "setupTypeScript": () => (/* binding */ setupTypeScript)
/* harmony export */ });
/* harmony import */ var _editor_editor_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../editor/editor.api.js */ "include-loader!./node_modules/monaco-editor/esm/vs/editor/editor.api.js");
/* harmony import */ var _monaco_contribution_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./monaco.contribution.js */ "./node_modules/monaco-editor/esm/vs/language/typescript/monaco.contribution.js");
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(4b1abad427e58dbedc1215d99a0902ffc885fcd4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __reExport = (target, module, copyDefault, desc) => {
  if (module && typeof module === "object" || typeof module === "function") {
    for (let key of __getOwnPropNames(module))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module[key], enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable });
  }
  return target;
};
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};

// src/fillers/monaco-editor-core.ts
var monaco_editor_core_exports = {};
__reExport(monaco_editor_core_exports, _editor_editor_api_js__WEBPACK_IMPORTED_MODULE_0__);


// src/language/typescript/workerManager.ts
var WorkerManager = class {
  _modeId;
  _defaults;
  _configChangeListener;
  _updateExtraLibsToken;
  _extraLibsChangeListener;
  _worker;
  _client;
  constructor(modeId, defaults) {
    this._modeId = modeId;
    this._defaults = defaults;
    this._worker = null;
    this._client = null;
    this._configChangeListener = this._defaults.onDidChange(() => this._stopWorker());
    this._updateExtraLibsToken = 0;
    this._extraLibsChangeListener = this._defaults.onDidExtraLibsChange(() => this._updateExtraLibs());
  }
  _stopWorker() {
    if (this._worker) {
      this._worker.dispose();
      this._worker = null;
    }
    this._client = null;
  }
  dispose() {
    this._configChangeListener.dispose();
    this._extraLibsChangeListener.dispose();
    this._stopWorker();
  }
  async _updateExtraLibs() {
    if (!this._worker) {
      return;
    }
    const myToken = ++this._updateExtraLibsToken;
    const proxy = await this._worker.getProxy();
    if (this._updateExtraLibsToken !== myToken) {
      return;
    }
    proxy.updateExtraLibs(this._defaults.getExtraLibs());
  }
  _getClient() {
    if (!this._client) {
      this._worker = monaco_editor_core_exports.editor.createWebWorker({
        moduleId: "vs/language/typescript/tsWorker",
        label: this._modeId,
        keepIdleModels: true,
        createData: {
          compilerOptions: this._defaults.getCompilerOptions(),
          extraLibs: this._defaults.getExtraLibs(),
          customWorkerPath: this._defaults.workerOptions.customWorkerPath,
          inlayHintsOptions: this._defaults.inlayHintsOptions
        }
      });
      let p = this._worker.getProxy();
      if (this._defaults.getEagerModelSync()) {
        p = p.then((worker) => {
          if (this._worker) {
            return this._worker.withSyncedResources(monaco_editor_core_exports.editor.getModels().filter((model) => model.getLanguageId() === this._modeId).map((model) => model.uri));
          }
          return worker;
        });
      }
      this._client = p;
    }
    return this._client;
  }
  getLanguageServiceWorker(...resources) {
    let _client;
    return this._getClient().then((client) => {
      _client = client;
    }).then((_) => {
      if (this._worker) {
        return this._worker.withSyncedResources(resources);
      }
    }).then((_) => _client);
  }
};

// src/language/typescript/languageFeatures.ts


// src/language/typescript/lib/lib.index.ts
var libFileSet = {};
libFileSet["lib.d.ts"] = true;
libFileSet["lib.dom.d.ts"] = true;
libFileSet["lib.dom.iterable.d.ts"] = true;
libFileSet["lib.es2015.collection.d.ts"] = true;
libFileSet["lib.es2015.core.d.ts"] = true;
libFileSet["lib.es2015.d.ts"] = true;
libFileSet["lib.es2015.generator.d.ts"] = true;
libFileSet["lib.es2015.iterable.d.ts"] = true;
libFileSet["lib.es2015.promise.d.ts"] = true;
libFileSet["lib.es2015.proxy.d.ts"] = true;
libFileSet["lib.es2015.reflect.d.ts"] = true;
libFileSet["lib.es2015.symbol.d.ts"] = true;
libFileSet["lib.es2015.symbol.wellknown.d.ts"] = true;
libFileSet["lib.es2016.array.include.d.ts"] = true;
libFileSet["lib.es2016.d.ts"] = true;
libFileSet["lib.es2016.full.d.ts"] = true;
libFileSet["lib.es2017.d.ts"] = true;
libFileSet["lib.es2017.full.d.ts"] = true;
libFileSet["lib.es2017.intl.d.ts"] = true;
libFileSet["lib.es2017.object.d.ts"] = true;
libFileSet["lib.es2017.sharedmemory.d.ts"] = true;
libFileSet["lib.es2017.string.d.ts"] = true;
libFileSet["lib.es2017.typedarrays.d.ts"] = true;
libFileSet["lib.es2018.asyncgenerator.d.ts"] = true;
libFileSet["lib.es2018.asynciterable.d.ts"] = true;
libFileSet["lib.es2018.d.ts"] = true;
libFileSet["lib.es2018.full.d.ts"] = true;
libFileSet["lib.es2018.intl.d.ts"] = true;
libFileSet["lib.es2018.promise.d.ts"] = true;
libFileSet["lib.es2018.regexp.d.ts"] = true;
libFileSet["lib.es2019.array.d.ts"] = true;
libFileSet["lib.es2019.d.ts"] = true;
libFileSet["lib.es2019.full.d.ts"] = true;
libFileSet["lib.es2019.object.d.ts"] = true;
libFileSet["lib.es2019.string.d.ts"] = true;
libFileSet["lib.es2019.symbol.d.ts"] = true;
libFileSet["lib.es2020.bigint.d.ts"] = true;
libFileSet["lib.es2020.d.ts"] = true;
libFileSet["lib.es2020.full.d.ts"] = true;
libFileSet["lib.es2020.intl.d.ts"] = true;
libFileSet["lib.es2020.promise.d.ts"] = true;
libFileSet["lib.es2020.sharedmemory.d.ts"] = true;
libFileSet["lib.es2020.string.d.ts"] = true;
libFileSet["lib.es2020.symbol.wellknown.d.ts"] = true;
libFileSet["lib.es2021.d.ts"] = true;
libFileSet["lib.es2021.full.d.ts"] = true;
libFileSet["lib.es2021.intl.d.ts"] = true;
libFileSet["lib.es2021.promise.d.ts"] = true;
libFileSet["lib.es2021.string.d.ts"] = true;
libFileSet["lib.es2021.weakref.d.ts"] = true;
libFileSet["lib.es5.d.ts"] = true;
libFileSet["lib.es6.d.ts"] = true;
libFileSet["lib.esnext.d.ts"] = true;
libFileSet["lib.esnext.full.d.ts"] = true;
libFileSet["lib.esnext.intl.d.ts"] = true;
libFileSet["lib.esnext.promise.d.ts"] = true;
libFileSet["lib.esnext.string.d.ts"] = true;
libFileSet["lib.esnext.weakref.d.ts"] = true;
libFileSet["lib.scripthost.d.ts"] = true;
libFileSet["lib.webworker.d.ts"] = true;
libFileSet["lib.webworker.importscripts.d.ts"] = true;
libFileSet["lib.webworker.iterable.d.ts"] = true;

// src/language/typescript/languageFeatures.ts
function flattenDiagnosticMessageText(diag, newLine, indent = 0) {
  if (typeof diag === "string") {
    return diag;
  } else if (diag === void 0) {
    return "";
  }
  let result = "";
  if (indent) {
    result += newLine;
    for (let i = 0; i < indent; i++) {
      result += "  ";
    }
  }
  result += diag.messageText;
  indent++;
  if (diag.next) {
    for (const kid of diag.next) {
      result += flattenDiagnosticMessageText(kid, newLine, indent);
    }
  }
  return result;
}
function displayPartsToString(displayParts) {
  if (displayParts) {
    return displayParts.map((displayPart) => displayPart.text).join("");
  }
  return "";
}
var Adapter = class {
  constructor(_worker) {
    this._worker = _worker;
  }
  _textSpanToRange(model, span) {
    let p1 = model.getPositionAt(span.start);
    let p2 = model.getPositionAt(span.start + span.length);
    let { lineNumber: startLineNumber, column: startColumn } = p1;
    let { lineNumber: endLineNumber, column: endColumn } = p2;
    return { startLineNumber, startColumn, endLineNumber, endColumn };
  }
};
var LibFiles = class {
  constructor(_worker) {
    this._worker = _worker;
    this._libFiles = {};
    this._hasFetchedLibFiles = false;
    this._fetchLibFilesPromise = null;
  }
  _libFiles;
  _hasFetchedLibFiles;
  _fetchLibFilesPromise;
  isLibFile(uri) {
    if (!uri) {
      return false;
    }
    if (uri.path.indexOf("/lib.") === 0) {
      return !!libFileSet[uri.path.slice(1)];
    }
    return false;
  }
  getOrCreateModel(fileName) {
    const uri = monaco_editor_core_exports.Uri.parse(fileName);
    const model = monaco_editor_core_exports.editor.getModel(uri);
    if (model) {
      return model;
    }
    if (this.isLibFile(uri) && this._hasFetchedLibFiles) {
      return monaco_editor_core_exports.editor.createModel(this._libFiles[uri.path.slice(1)], "typescript", uri);
    }
    const matchedLibFile = _monaco_contribution_js__WEBPACK_IMPORTED_MODULE_1__.typescriptDefaults.getExtraLibs()[fileName];
    if (matchedLibFile) {
      return monaco_editor_core_exports.editor.createModel(matchedLibFile.content, "typescript", uri);
    }
    return null;
  }
  _containsLibFile(uris) {
    for (let uri of uris) {
      if (this.isLibFile(uri)) {
        return true;
      }
    }
    return false;
  }
  async fetchLibFilesIfNecessary(uris) {
    if (!this._containsLibFile(uris)) {
      return;
    }
    await this._fetchLibFiles();
  }
  _fetchLibFiles() {
    if (!this._fetchLibFilesPromise) {
      this._fetchLibFilesPromise = this._worker().then((w) => w.getLibFiles()).then((libFiles) => {
        this._hasFetchedLibFiles = true;
        this._libFiles = libFiles;
      });
    }
    return this._fetchLibFilesPromise;
  }
};
var DiagnosticsAdapter = class extends Adapter {
  constructor(_libFiles, _defaults, _selector, worker) {
    super(worker);
    this._libFiles = _libFiles;
    this._defaults = _defaults;
    this._selector = _selector;
    const onModelAdd = (model) => {
      if (model.getLanguageId() !== _selector) {
        return;
      }
      const maybeValidate = () => {
        const { onlyVisible } = this._defaults.getDiagnosticsOptions();
        if (onlyVisible) {
          if (model.isAttachedToEditor()) {
            this._doValidate(model);
          }
        } else {
          this._doValidate(model);
        }
      };
      let handle;
      const changeSubscription = model.onDidChangeContent(() => {
        clearTimeout(handle);
        handle = window.setTimeout(maybeValidate, 500);
      });
      const visibleSubscription = model.onDidChangeAttached(() => {
        const { onlyVisible } = this._defaults.getDiagnosticsOptions();
        if (onlyVisible) {
          if (model.isAttachedToEditor()) {
            maybeValidate();
          } else {
            monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
          }
        }
      });
      this._listener[model.uri.toString()] = {
        dispose() {
          changeSubscription.dispose();
          visibleSubscription.dispose();
          clearTimeout(handle);
        }
      };
      maybeValidate();
    };
    const onModelRemoved = (model) => {
      monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
      const key = model.uri.toString();
      if (this._listener[key]) {
        this._listener[key].dispose();
        delete this._listener[key];
      }
    };
    this._disposables.push(monaco_editor_core_exports.editor.onDidCreateModel((model) => onModelAdd(model)));
    this._disposables.push(monaco_editor_core_exports.editor.onWillDisposeModel(onModelRemoved));
    this._disposables.push(monaco_editor_core_exports.editor.onDidChangeModelLanguage((event) => {
      onModelRemoved(event.model);
      onModelAdd(event.model);
    }));
    this._disposables.push({
      dispose() {
        for (const model of monaco_editor_core_exports.editor.getModels()) {
          onModelRemoved(model);
        }
      }
    });
    const recomputeDiagostics = () => {
      for (const model of monaco_editor_core_exports.editor.getModels()) {
        onModelRemoved(model);
        onModelAdd(model);
      }
    };
    this._disposables.push(this._defaults.onDidChange(recomputeDiagostics));
    this._disposables.push(this._defaults.onDidExtraLibsChange(recomputeDiagostics));
    monaco_editor_core_exports.editor.getModels().forEach((model) => onModelAdd(model));
  }
  _disposables = [];
  _listener = /* @__PURE__ */ Object.create(null);
  dispose() {
    this._disposables.forEach((d) => d && d.dispose());
    this._disposables = [];
  }
  async _doValidate(model) {
    const worker = await this._worker(model.uri);
    if (model.isDisposed()) {
      return;
    }
    const promises = [];
    const { noSyntaxValidation, noSemanticValidation, noSuggestionDiagnostics } = this._defaults.getDiagnosticsOptions();
    if (!noSyntaxValidation) {
      promises.push(worker.getSyntacticDiagnostics(model.uri.toString()));
    }
    if (!noSemanticValidation) {
      promises.push(worker.getSemanticDiagnostics(model.uri.toString()));
    }
    if (!noSuggestionDiagnostics) {
      promises.push(worker.getSuggestionDiagnostics(model.uri.toString()));
    }
    const allDiagnostics = await Promise.all(promises);
    if (!allDiagnostics || model.isDisposed()) {
      return;
    }
    const diagnostics = allDiagnostics.reduce((p, c) => c.concat(p), []).filter((d) => (this._defaults.getDiagnosticsOptions().diagnosticCodesToIgnore || []).indexOf(d.code) === -1);
    const relatedUris = diagnostics.map((d) => d.relatedInformation || []).reduce((p, c) => c.concat(p), []).map((relatedInformation) => relatedInformation.file ? monaco_editor_core_exports.Uri.parse(relatedInformation.file.fileName) : null);
    await this._libFiles.fetchLibFilesIfNecessary(relatedUris);
    if (model.isDisposed()) {
      return;
    }
    monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, diagnostics.map((d) => this._convertDiagnostics(model, d)));
  }
  _convertDiagnostics(model, diag) {
    const diagStart = diag.start || 0;
    const diagLength = diag.length || 1;
    const { lineNumber: startLineNumber, column: startColumn } = model.getPositionAt(diagStart);
    const { lineNumber: endLineNumber, column: endColumn } = model.getPositionAt(diagStart + diagLength);
    const tags = [];
    if (diag.reportsUnnecessary) {
      tags.push(monaco_editor_core_exports.MarkerTag.Unnecessary);
    }
    if (diag.reportsDeprecated) {
      tags.push(monaco_editor_core_exports.MarkerTag.Deprecated);
    }
    return {
      severity: this._tsDiagnosticCategoryToMarkerSeverity(diag.category),
      startLineNumber,
      startColumn,
      endLineNumber,
      endColumn,
      message: flattenDiagnosticMessageText(diag.messageText, "\n"),
      code: diag.code.toString(),
      tags,
      relatedInformation: this._convertRelatedInformation(model, diag.relatedInformation)
    };
  }
  _convertRelatedInformation(model, relatedInformation) {
    if (!relatedInformation) {
      return [];
    }
    const result = [];
    relatedInformation.forEach((info) => {
      let relatedResource = model;
      if (info.file) {
        relatedResource = this._libFiles.getOrCreateModel(info.file.fileName);
      }
      if (!relatedResource) {
        return;
      }
      const infoStart = info.start || 0;
      const infoLength = info.length || 1;
      const { lineNumber: startLineNumber, column: startColumn } = relatedResource.getPositionAt(infoStart);
      const { lineNumber: endLineNumber, column: endColumn } = relatedResource.getPositionAt(infoStart + infoLength);
      result.push({
        resource: relatedResource.uri,
        startLineNumber,
        startColumn,
        endLineNumber,
        endColumn,
        message: flattenDiagnosticMessageText(info.messageText, "\n")
      });
    });
    return result;
  }
  _tsDiagnosticCategoryToMarkerSeverity(category) {
    switch (category) {
      case 1 /* Error */:
        return monaco_editor_core_exports.MarkerSeverity.Error;
      case 3 /* Message */:
        return monaco_editor_core_exports.MarkerSeverity.Info;
      case 0 /* Warning */:
        return monaco_editor_core_exports.MarkerSeverity.Warning;
      case 2 /* Suggestion */:
        return monaco_editor_core_exports.MarkerSeverity.Hint;
    }
    return monaco_editor_core_exports.MarkerSeverity.Info;
  }
};
var SuggestAdapter = class extends Adapter {
  get triggerCharacters() {
    return ["."];
  }
  async provideCompletionItems(model, position, _context, token) {
    const wordInfo = model.getWordUntilPosition(position);
    const wordRange = new monaco_editor_core_exports.Range(position.lineNumber, wordInfo.startColumn, position.lineNumber, wordInfo.endColumn);
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getCompletionsAtPosition(resource.toString(), offset);
    if (!info || model.isDisposed()) {
      return;
    }
    const suggestions = info.entries.map((entry) => {
      let range = wordRange;
      if (entry.replacementSpan) {
        const p1 = model.getPositionAt(entry.replacementSpan.start);
        const p2 = model.getPositionAt(entry.replacementSpan.start + entry.replacementSpan.length);
        range = new monaco_editor_core_exports.Range(p1.lineNumber, p1.column, p2.lineNumber, p2.column);
      }
      const tags = [];
      if (entry.kindModifiers?.indexOf("deprecated") !== -1) {
        tags.push(monaco_editor_core_exports.languages.CompletionItemTag.Deprecated);
      }
      return {
        uri: resource,
        position,
        offset,
        range,
        label: entry.name,
        insertText: entry.name,
        sortText: entry.sortText,
        kind: SuggestAdapter.convertKind(entry.kind),
        tags
      };
    });
    return {
      suggestions
    };
  }
  async resolveCompletionItem(item, token) {
    const myItem = item;
    const resource = myItem.uri;
    const position = myItem.position;
    const offset = myItem.offset;
    const worker = await this._worker(resource);
    const details = await worker.getCompletionEntryDetails(resource.toString(), offset, myItem.label);
    if (!details) {
      return myItem;
    }
    return {
      uri: resource,
      position,
      label: details.name,
      kind: SuggestAdapter.convertKind(details.kind),
      detail: displayPartsToString(details.displayParts),
      documentation: {
        value: SuggestAdapter.createDocumentationString(details)
      }
    };
  }
  static convertKind(kind) {
    switch (kind) {
      case Kind.primitiveType:
      case Kind.keyword:
        return monaco_editor_core_exports.languages.CompletionItemKind.Keyword;
      case Kind.variable:
      case Kind.localVariable:
        return monaco_editor_core_exports.languages.CompletionItemKind.Variable;
      case Kind.memberVariable:
      case Kind.memberGetAccessor:
      case Kind.memberSetAccessor:
        return monaco_editor_core_exports.languages.CompletionItemKind.Field;
      case Kind.function:
      case Kind.memberFunction:
      case Kind.constructSignature:
      case Kind.callSignature:
      case Kind.indexSignature:
        return monaco_editor_core_exports.languages.CompletionItemKind.Function;
      case Kind.enum:
        return monaco_editor_core_exports.languages.CompletionItemKind.Enum;
      case Kind.module:
        return monaco_editor_core_exports.languages.CompletionItemKind.Module;
      case Kind.class:
        return monaco_editor_core_exports.languages.CompletionItemKind.Class;
      case Kind.interface:
        return monaco_editor_core_exports.languages.CompletionItemKind.Interface;
      case Kind.warning:
        return monaco_editor_core_exports.languages.CompletionItemKind.File;
    }
    return monaco_editor_core_exports.languages.CompletionItemKind.Property;
  }
  static createDocumentationString(details) {
    let documentationString = displayPartsToString(details.documentation);
    if (details.tags) {
      for (const tag of details.tags) {
        documentationString += `

${tagToString(tag)}`;
      }
    }
    return documentationString;
  }
};
function tagToString(tag) {
  let tagLabel = `*@${tag.name}*`;
  if (tag.name === "param" && tag.text) {
    const [paramName, ...rest] = tag.text;
    tagLabel += `\`${paramName.text}\``;
    if (rest.length > 0)
      tagLabel += ` \u2014 ${rest.map((r) => r.text).join(" ")}`;
  } else if (Array.isArray(tag.text)) {
    tagLabel += ` \u2014 ${tag.text.map((r) => r.text).join(" ")}`;
  } else if (tag.text) {
    tagLabel += ` \u2014 ${tag.text}`;
  }
  return tagLabel;
}
var SignatureHelpAdapter = class extends Adapter {
  signatureHelpTriggerCharacters = ["(", ","];
  static _toSignatureHelpTriggerReason(context) {
    switch (context.triggerKind) {
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.TriggerCharacter:
        if (context.triggerCharacter) {
          if (context.isRetrigger) {
            return { kind: "retrigger", triggerCharacter: context.triggerCharacter };
          } else {
            return { kind: "characterTyped", triggerCharacter: context.triggerCharacter };
          }
        } else {
          return { kind: "invoked" };
        }
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.ContentChange:
        return context.isRetrigger ? { kind: "retrigger" } : { kind: "invoked" };
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.Invoke:
      default:
        return { kind: "invoked" };
    }
  }
  async provideSignatureHelp(model, position, token, context) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getSignatureHelpItems(resource.toString(), offset, {
      triggerReason: SignatureHelpAdapter._toSignatureHelpTriggerReason(context)
    });
    if (!info || model.isDisposed()) {
      return;
    }
    const ret = {
      activeSignature: info.selectedItemIndex,
      activeParameter: info.argumentIndex,
      signatures: []
    };
    info.items.forEach((item) => {
      const signature = {
        label: "",
        parameters: []
      };
      signature.documentation = {
        value: displayPartsToString(item.documentation)
      };
      signature.label += displayPartsToString(item.prefixDisplayParts);
      item.parameters.forEach((p, i, a) => {
        const label = displayPartsToString(p.displayParts);
        const parameter = {
          label,
          documentation: {
            value: displayPartsToString(p.documentation)
          }
        };
        signature.label += label;
        signature.parameters.push(parameter);
        if (i < a.length - 1) {
          signature.label += displayPartsToString(item.separatorDisplayParts);
        }
      });
      signature.label += displayPartsToString(item.suffixDisplayParts);
      ret.signatures.push(signature);
    });
    return {
      value: ret,
      dispose() {
      }
    };
  }
};
var QuickInfoAdapter = class extends Adapter {
  async provideHover(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getQuickInfoAtPosition(resource.toString(), offset);
    if (!info || model.isDisposed()) {
      return;
    }
    const documentation = displayPartsToString(info.documentation);
    const tags = info.tags ? info.tags.map((tag) => tagToString(tag)).join("  \n\n") : "";
    const contents = displayPartsToString(info.displayParts);
    return {
      range: this._textSpanToRange(model, info.textSpan),
      contents: [
        {
          value: "```typescript\n" + contents + "\n```\n"
        },
        {
          value: documentation + (tags ? "\n\n" + tags : "")
        }
      ]
    };
  }
};
var OccurrencesAdapter = class extends Adapter {
  async provideDocumentHighlights(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getOccurrencesAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    return entries.map((entry) => {
      return {
        range: this._textSpanToRange(model, entry.textSpan),
        kind: entry.isWriteAccess ? monaco_editor_core_exports.languages.DocumentHighlightKind.Write : monaco_editor_core_exports.languages.DocumentHighlightKind.Text
      };
    });
  }
};
var DefinitionAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideDefinition(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getDefinitionAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
    if (model.isDisposed()) {
      return;
    }
    const result = [];
    for (let entry of entries) {
      const refModel = this._libFiles.getOrCreateModel(entry.fileName);
      if (refModel) {
        result.push({
          uri: refModel.uri,
          range: this._textSpanToRange(refModel, entry.textSpan)
        });
      }
    }
    return result;
  }
};
var ReferenceAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideReferences(model, position, context, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getReferencesAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
    if (model.isDisposed()) {
      return;
    }
    const result = [];
    for (let entry of entries) {
      const refModel = this._libFiles.getOrCreateModel(entry.fileName);
      if (refModel) {
        result.push({
          uri: refModel.uri,
          range: this._textSpanToRange(refModel, entry.textSpan)
        });
      }
    }
    return result;
  }
};
var OutlineAdapter = class extends Adapter {
  async provideDocumentSymbols(model, token) {
    const resource = model.uri;
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const items = await worker.getNavigationBarItems(resource.toString());
    if (!items || model.isDisposed()) {
      return;
    }
    const convert = (bucket, item, containerLabel) => {
      let result2 = {
        name: item.text,
        detail: "",
        kind: outlineTypeTable[item.kind] || monaco_editor_core_exports.languages.SymbolKind.Variable,
        range: this._textSpanToRange(model, item.spans[0]),
        selectionRange: this._textSpanToRange(model, item.spans[0]),
        tags: []
      };
      if (containerLabel)
        result2.containerName = containerLabel;
      if (item.childItems && item.childItems.length > 0) {
        for (let child of item.childItems) {
          convert(bucket, child, result2.name);
        }
      }
      bucket.push(result2);
    };
    let result = [];
    items.forEach((item) => convert(result, item));
    return result;
  }
};
var Kind = class {
};
__publicField(Kind, "unknown", "");
__publicField(Kind, "keyword", "keyword");
__publicField(Kind, "script", "script");
__publicField(Kind, "module", "module");
__publicField(Kind, "class", "class");
__publicField(Kind, "interface", "interface");
__publicField(Kind, "type", "type");
__publicField(Kind, "enum", "enum");
__publicField(Kind, "variable", "var");
__publicField(Kind, "localVariable", "local var");
__publicField(Kind, "function", "function");
__publicField(Kind, "localFunction", "local function");
__publicField(Kind, "memberFunction", "method");
__publicField(Kind, "memberGetAccessor", "getter");
__publicField(Kind, "memberSetAccessor", "setter");
__publicField(Kind, "memberVariable", "property");
__publicField(Kind, "constructorImplementation", "constructor");
__publicField(Kind, "callSignature", "call");
__publicField(Kind, "indexSignature", "index");
__publicField(Kind, "constructSignature", "construct");
__publicField(Kind, "parameter", "parameter");
__publicField(Kind, "typeParameter", "type parameter");
__publicField(Kind, "primitiveType", "primitive type");
__publicField(Kind, "label", "label");
__publicField(Kind, "alias", "alias");
__publicField(Kind, "const", "const");
__publicField(Kind, "let", "let");
__publicField(Kind, "warning", "warning");
var outlineTypeTable = /* @__PURE__ */ Object.create(null);
outlineTypeTable[Kind.module] = monaco_editor_core_exports.languages.SymbolKind.Module;
outlineTypeTable[Kind.class] = monaco_editor_core_exports.languages.SymbolKind.Class;
outlineTypeTable[Kind.enum] = monaco_editor_core_exports.languages.SymbolKind.Enum;
outlineTypeTable[Kind.interface] = monaco_editor_core_exports.languages.SymbolKind.Interface;
outlineTypeTable[Kind.memberFunction] = monaco_editor_core_exports.languages.SymbolKind.Method;
outlineTypeTable[Kind.memberVariable] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.memberGetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.memberSetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.const] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.localVariable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.function] = monaco_editor_core_exports.languages.SymbolKind.Function;
outlineTypeTable[Kind.localFunction] = monaco_editor_core_exports.languages.SymbolKind.Function;
var FormatHelper = class extends Adapter {
  static _convertOptions(options) {
    return {
      ConvertTabsToSpaces: options.insertSpaces,
      TabSize: options.tabSize,
      IndentSize: options.tabSize,
      IndentStyle: 2 /* Smart */,
      NewLineCharacter: "\n",
      InsertSpaceAfterCommaDelimiter: true,
      InsertSpaceAfterSemicolonInForStatements: true,
      InsertSpaceBeforeAndAfterBinaryOperators: true,
      InsertSpaceAfterKeywordsInControlFlowStatements: true,
      InsertSpaceAfterFunctionKeywordForAnonymousFunctions: true,
      InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis: false,
      InsertSpaceAfterOpeningAndBeforeClosingNonemptyBrackets: false,
      InsertSpaceAfterOpeningAndBeforeClosingTemplateStringBraces: false,
      PlaceOpenBraceOnNewLineForControlBlocks: false,
      PlaceOpenBraceOnNewLineForFunctions: false
    };
  }
  _convertTextChanges(model, change) {
    return {
      text: change.newText,
      range: this._textSpanToRange(model, change.span)
    };
  }
};
var FormatAdapter = class extends FormatHelper {
  async provideDocumentRangeFormattingEdits(model, range, options, token) {
    const resource = model.uri;
    const startOffset = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const endOffset = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const edits = await worker.getFormattingEditsForRange(resource.toString(), startOffset, endOffset, FormatHelper._convertOptions(options));
    if (!edits || model.isDisposed()) {
      return;
    }
    return edits.map((edit) => this._convertTextChanges(model, edit));
  }
};
var FormatOnTypeAdapter = class extends FormatHelper {
  get autoFormatTriggerCharacters() {
    return [";", "}", "\n"];
  }
  async provideOnTypeFormattingEdits(model, position, ch, options, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const edits = await worker.getFormattingEditsAfterKeystroke(resource.toString(), offset, ch, FormatHelper._convertOptions(options));
    if (!edits || model.isDisposed()) {
      return;
    }
    return edits.map((edit) => this._convertTextChanges(model, edit));
  }
};
var CodeActionAdaptor = class extends FormatHelper {
  async provideCodeActions(model, range, context, token) {
    const resource = model.uri;
    const start = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const end = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const formatOptions = FormatHelper._convertOptions(model.getOptions());
    const errorCodes = context.markers.filter((m) => m.code).map((m) => m.code).map(Number);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const codeFixes = await worker.getCodeFixesAtPosition(resource.toString(), start, end, errorCodes, formatOptions);
    if (!codeFixes || model.isDisposed()) {
      return { actions: [], dispose: () => {
      } };
    }
    const actions = codeFixes.filter((fix) => {
      return fix.changes.filter((change) => change.isNewFile).length === 0;
    }).map((fix) => {
      return this._tsCodeFixActionToMonacoCodeAction(model, context, fix);
    });
    return {
      actions,
      dispose: () => {
      }
    };
  }
  _tsCodeFixActionToMonacoCodeAction(model, context, codeFix) {
    const edits = [];
    for (const change of codeFix.changes) {
      for (const textChange of change.textChanges) {
        edits.push({
          resource: model.uri,
          edit: {
            range: this._textSpanToRange(model, textChange.span),
            text: textChange.newText
          }
        });
      }
    }
    const action = {
      title: codeFix.description,
      edit: { edits },
      diagnostics: context.markers,
      kind: "quickfix"
    };
    return action;
  }
};
var RenameAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideRenameEdits(model, position, newName, token) {
    const resource = model.uri;
    const fileName = resource.toString();
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const renameInfo = await worker.getRenameInfo(fileName, offset, {
      allowRenameOfImportPath: false
    });
    if (renameInfo.canRename === false) {
      return {
        edits: [],
        rejectReason: renameInfo.localizedErrorMessage
      };
    }
    if (renameInfo.fileToRename !== void 0) {
      throw new Error("Renaming files is not supported.");
    }
    const renameLocations = await worker.findRenameLocations(fileName, offset, false, false, false);
    if (!renameLocations || model.isDisposed()) {
      return;
    }
    const edits = [];
    for (const renameLocation of renameLocations) {
      const model2 = this._libFiles.getOrCreateModel(renameLocation.fileName);
      if (model2) {
        edits.push({
          resource: model2.uri,
          edit: {
            range: this._textSpanToRange(model2, renameLocation.textSpan),
            text: newName
          }
        });
      } else {
        throw new Error(`Unknown file ${renameLocation.fileName}.`);
      }
    }
    return { edits };
  }
};
var InlayHintsAdapter = class extends Adapter {
  async provideInlayHints(model, range, token) {
    const resource = model.uri;
    const fileName = resource.toString();
    const start = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const end = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return null;
    }
    const tsHints = await worker.provideInlayHints(fileName, start, end);
    const hints = tsHints.map((hint) => {
      return {
        ...hint,
        label: hint.text,
        position: model.getPositionAt(hint.position),
        kind: this._convertHintKind(hint.kind)
      };
    });
    return { hints, dispose: () => {
    } };
  }
  _convertHintKind(kind) {
    switch (kind) {
      case "Parameter":
        return monaco_editor_core_exports.languages.InlayHintKind.Parameter;
      case "Type":
        return monaco_editor_core_exports.languages.InlayHintKind.Type;
      default:
        return monaco_editor_core_exports.languages.InlayHintKind.Type;
    }
  }
};

// src/language/typescript/tsMode.ts
var javaScriptWorker;
var typeScriptWorker;
function setupTypeScript(defaults) {
  typeScriptWorker = setupMode(defaults, "typescript");
}
function setupJavaScript(defaults) {
  javaScriptWorker = setupMode(defaults, "javascript");
}
function getJavaScriptWorker() {
  return new Promise((resolve, reject) => {
    if (!javaScriptWorker) {
      return reject("JavaScript not registered!");
    }
    resolve(javaScriptWorker);
  });
}
function getTypeScriptWorker() {
  return new Promise((resolve, reject) => {
    if (!typeScriptWorker) {
      return reject("TypeScript not registered!");
    }
    resolve(typeScriptWorker);
  });
}
function setupMode(defaults, modeId) {
  const client = new WorkerManager(modeId, defaults);
  const worker = (...uris) => {
    return client.getLanguageServiceWorker(...uris);
  };
  const libFiles = new LibFiles(worker);
  monaco_editor_core_exports.languages.registerCompletionItemProvider(modeId, new SuggestAdapter(worker));
  monaco_editor_core_exports.languages.registerSignatureHelpProvider(modeId, new SignatureHelpAdapter(worker));
  monaco_editor_core_exports.languages.registerHoverProvider(modeId, new QuickInfoAdapter(worker));
  monaco_editor_core_exports.languages.registerDocumentHighlightProvider(modeId, new OccurrencesAdapter(worker));
  monaco_editor_core_exports.languages.registerDefinitionProvider(modeId, new DefinitionAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerReferenceProvider(modeId, new ReferenceAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerDocumentSymbolProvider(modeId, new OutlineAdapter(worker));
  monaco_editor_core_exports.languages.registerDocumentRangeFormattingEditProvider(modeId, new FormatAdapter(worker));
  monaco_editor_core_exports.languages.registerOnTypeFormattingEditProvider(modeId, new FormatOnTypeAdapter(worker));
  monaco_editor_core_exports.languages.registerCodeActionProvider(modeId, new CodeActionAdaptor(worker));
  monaco_editor_core_exports.languages.registerRenameProvider(modeId, new RenameAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerInlayHintsProvider(modeId, new InlayHintsAdapter(worker));
  new DiagnosticsAdapter(libFiles, defaults, modeId, worker);
  return worker;
}



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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