# mypy-boto3-connect<a id="mypy-boto3-connect"></a>

[![PyPI - mypy-boto3-connect](https://img.shields.io/pypi/v/mypy-boto3-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-connect)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-connect)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-connect?color=blue)](https://pypistats.org/packages/mypy-boto3-connect)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Connect 1.17.74](https://boto3.amazonaws.com/v1/documentation/api/1.17.74/reference/services/connect.html#Connect)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-connect docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_connect/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-connect](#mypy-boto3-connect)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `Connect` service.

```bash
python -m pip install boto3-stubs[connect]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[connect]` in your environment:
  `python -m pip install 'boto3-stubs[connect]'`

Both type checking and auto-complete should work for `Connect` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[connect]` in your environment:
  `python -m pip install 'boto3-stubs[connect]'`

Both type checking and auto-complete should work for `Connect` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[connect]` in your environment:
  `python -m pip install 'boto3-stubs[connect]'`
- Run `mypy` as usual

Type checking should work for `Connect` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[connect]` in your environment:
  `python -m pip install 'boto3-stubs[connect]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Connect` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`ConnectClient` provides annotations for `boto3.client("connect")`.

```python
import boto3

from mypy_boto3_connect import ConnectClient

client: ConnectClient = boto3.client("connect")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ConnectClient = session.client("connect")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_connect.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_connect import ConnectClient
from mypy_boto3_connect.paginator import (
    GetMetricDataPaginator,
    ListApprovedOriginsPaginator,
    ListContactFlowsPaginator,
    ListHoursOfOperationsPaginator,
    ListInstanceAttributesPaginator,
    ListInstanceStorageConfigsPaginator,
    ListInstancesPaginator,
    ListIntegrationAssociationsPaginator,
    ListLambdaFunctionsPaginator,
    ListLexBotsPaginator,
    ListPhoneNumbersPaginator,
    ListPromptsPaginator,
    ListQueueQuickConnectsPaginator,
    ListQueuesPaginator,
    ListQuickConnectsPaginator,
    ListRoutingProfileQueuesPaginator,
    ListRoutingProfilesPaginator,
    ListSecurityKeysPaginator,
    ListSecurityProfilesPaginator,
    ListUseCasesPaginator,
    ListUserHierarchyGroupsPaginator,
    ListUsersPaginator,
)

client: ConnectClient = boto3.client("connect")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_metric_data_paginator: GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_approved_origins_paginator: ListApprovedOriginsPaginator = client.get_paginator("list_approved_origins")
list_contact_flows_paginator: ListContactFlowsPaginator = client.get_paginator("list_contact_flows")
list_hours_of_operations_paginator: ListHoursOfOperationsPaginator = client.get_paginator("list_hours_of_operations")
list_instance_attributes_paginator: ListInstanceAttributesPaginator = client.get_paginator("list_instance_attributes")
list_instance_storage_configs_paginator: ListInstanceStorageConfigsPaginator = client.get_paginator("list_instance_storage_configs")
list_instances_paginator: ListInstancesPaginator = client.get_paginator("list_instances")
list_integration_associations_paginator: ListIntegrationAssociationsPaginator = client.get_paginator("list_integration_associations")
list_lambda_functions_paginator: ListLambdaFunctionsPaginator = client.get_paginator("list_lambda_functions")
list_lex_bots_paginator: ListLexBotsPaginator = client.get_paginator("list_lex_bots")
list_phone_numbers_paginator: ListPhoneNumbersPaginator = client.get_paginator("list_phone_numbers")
list_prompts_paginator: ListPromptsPaginator = client.get_paginator("list_prompts")
list_queue_quick_connects_paginator: ListQueueQuickConnectsPaginator = client.get_paginator("list_queue_quick_connects")
list_queues_paginator: ListQueuesPaginator = client.get_paginator("list_queues")
list_quick_connects_paginator: ListQuickConnectsPaginator = client.get_paginator("list_quick_connects")
list_routing_profile_queues_paginator: ListRoutingProfileQueuesPaginator = client.get_paginator("list_routing_profile_queues")
list_routing_profiles_paginator: ListRoutingProfilesPaginator = client.get_paginator("list_routing_profiles")
list_security_keys_paginator: ListSecurityKeysPaginator = client.get_paginator("list_security_keys")
list_security_profiles_paginator: ListSecurityProfilesPaginator = client.get_paginator("list_security_profiles")
list_use_cases_paginator: ListUseCasesPaginator = client.get_paginator("list_use_cases")
list_user_hierarchy_groups_paginator: ListUserHierarchyGroupsPaginator = client.get_paginator("list_user_hierarchy_groups")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
```

### Literals<a id="literals"></a>

`mypy_boto3_connect.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_connect.literals import (
    ChannelType,
    ComparisonType,
    ContactFlowTypeType,
    CurrentMetricNameType,
    DirectoryTypeType,
    EncryptionTypeType,
    GetMetricDataPaginatorName,
    GroupingType,
    HistoricalMetricNameType,
    HoursOfOperationDaysType,
    InstanceAttributeTypeType,
    InstanceStatusType,
    InstanceStorageResourceTypeType,
    IntegrationTypeType,
    ListApprovedOriginsPaginatorName,
    ListContactFlowsPaginatorName,
    ListHoursOfOperationsPaginatorName,
    ListInstanceAttributesPaginatorName,
    ListInstanceStorageConfigsPaginatorName,
    ListInstancesPaginatorName,
    ListIntegrationAssociationsPaginatorName,
    ListLambdaFunctionsPaginatorName,
    ListLexBotsPaginatorName,
    ListPhoneNumbersPaginatorName,
    ListPromptsPaginatorName,
    ListQueueQuickConnectsPaginatorName,
    ListQueuesPaginatorName,
    ListQuickConnectsPaginatorName,
    ListRoutingProfileQueuesPaginatorName,
    ListRoutingProfilesPaginatorName,
    ListSecurityKeysPaginatorName,
    ListSecurityProfilesPaginatorName,
    ListUseCasesPaginatorName,
    ListUserHierarchyGroupsPaginatorName,
    ListUsersPaginatorName,
    PhoneNumberCountryCodeType,
    PhoneNumberTypeType,
    PhoneTypeType,
    QueueStatusType,
    QueueTypeType,
    QuickConnectTypeType,
    ReferenceTypeType,
    SourceTypeType,
    StatisticType,
    StorageTypeType,
    UnitType,
    UseCaseTypeType,
    VoiceRecordingTrackType,
)

def check_value(value: ChannelType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_connect.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_connect.type_defs import (
    AssociateInstanceStorageConfigResponseTypeDef,
    AssociateSecurityKeyResponseTypeDef,
    AttributeTypeDef,
    ChatMessageTypeDef,
    ContactFlowSummaryTypeDef,
    ContactFlowTypeDef,
    CreateContactFlowResponseTypeDef,
    CreateInstanceResponseTypeDef,
    CreateIntegrationAssociationResponseTypeDef,
    CreateQueueResponseTypeDef,
    CreateQuickConnectResponseTypeDef,
    CreateRoutingProfileResponseTypeDef,
    CreateUseCaseResponseTypeDef,
    CreateUserHierarchyGroupResponseTypeDef,
    CreateUserResponseTypeDef,
    CredentialsTypeDef,
    CurrentMetricDataTypeDef,
    CurrentMetricResultTypeDef,
    CurrentMetricTypeDef,
    DescribeContactFlowResponseTypeDef,
    DescribeHoursOfOperationResponseTypeDef,
    DescribeInstanceAttributeResponseTypeDef,
    DescribeInstanceResponseTypeDef,
    DescribeInstanceStorageConfigResponseTypeDef,
    DescribeQueueResponseTypeDef,
    DescribeQuickConnectResponseTypeDef,
    DescribeRoutingProfileResponseTypeDef,
    DescribeUserHierarchyGroupResponseTypeDef,
    DescribeUserHierarchyStructureResponseTypeDef,
    DescribeUserResponseTypeDef,
    DimensionsTypeDef,
    EncryptionConfigTypeDef,
    FiltersTypeDef,
    GetContactAttributesResponseTypeDef,
    GetCurrentMetricDataResponseTypeDef,
    GetFederationTokenResponseTypeDef,
    GetMetricDataResponseTypeDef,
    HierarchyGroupSummaryTypeDef,
    HierarchyGroupTypeDef,
    HierarchyLevelTypeDef,
    HierarchyLevelUpdateTypeDef,
    HierarchyPathTypeDef,
    HierarchyStructureTypeDef,
    HierarchyStructureUpdateTypeDef,
    HistoricalMetricDataTypeDef,
    HistoricalMetricResultTypeDef,
    HistoricalMetricTypeDef,
    HoursOfOperationConfigTypeDef,
    HoursOfOperationSummaryTypeDef,
    HoursOfOperationTimeSliceTypeDef,
    HoursOfOperationTypeDef,
    InstanceStatusReasonTypeDef,
    InstanceStorageConfigTypeDef,
    InstanceSummaryTypeDef,
    InstanceTypeDef,
    IntegrationAssociationSummaryTypeDef,
    KinesisFirehoseConfigTypeDef,
    KinesisStreamConfigTypeDef,
    KinesisVideoStreamConfigTypeDef,
    LexBotTypeDef,
    ListApprovedOriginsResponseTypeDef,
    ListContactFlowsResponseTypeDef,
    ListHoursOfOperationsResponseTypeDef,
    ListInstanceAttributesResponseTypeDef,
    ListInstanceStorageConfigsResponseTypeDef,
    ListInstancesResponseTypeDef,
    ListIntegrationAssociationsResponseTypeDef,
    ListLambdaFunctionsResponseTypeDef,
    ListLexBotsResponseTypeDef,
    ListPhoneNumbersResponseTypeDef,
    ListPromptsResponseTypeDef,
    ListQueueQuickConnectsResponseTypeDef,
    ListQueuesResponseTypeDef,
    ListQuickConnectsResponseTypeDef,
    ListRoutingProfileQueuesResponseTypeDef,
    ListRoutingProfilesResponseTypeDef,
    ListSecurityKeysResponseTypeDef,
    ListSecurityProfilesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUseCasesResponseTypeDef,
    ListUserHierarchyGroupsResponseTypeDef,
    ListUsersResponseTypeDef,
    MediaConcurrencyTypeDef,
    OutboundCallerConfigTypeDef,
    PaginatorConfigTypeDef,
    ParticipantDetailsTypeDef,
    PhoneNumberQuickConnectConfigTypeDef,
    PhoneNumberSummaryTypeDef,
    PromptSummaryTypeDef,
    QueueQuickConnectConfigTypeDef,
    QueueReferenceTypeDef,
    QueueSummaryTypeDef,
    QueueTypeDef,
    QuickConnectConfigTypeDef,
    QuickConnectSummaryTypeDef,
    QuickConnectTypeDef,
    ReferenceTypeDef,
    RoutingProfileQueueConfigSummaryTypeDef,
    RoutingProfileQueueConfigTypeDef,
    RoutingProfileQueueReferenceTypeDef,
    RoutingProfileSummaryTypeDef,
    RoutingProfileTypeDef,
    S3ConfigTypeDef,
    SecurityKeyTypeDef,
    SecurityProfileSummaryTypeDef,
    StartChatContactResponseTypeDef,
    StartOutboundVoiceContactResponseTypeDef,
    StartTaskContactResponseTypeDef,
    ThresholdTypeDef,
    UseCaseTypeDef,
    UserIdentityInfoTypeDef,
    UserPhoneConfigTypeDef,
    UserQuickConnectConfigTypeDef,
    UserSummaryTypeDef,
    UserTypeDef,
    VoiceRecordingConfigurationTypeDef,
)

def get_structure() -> AssociateInstanceStorageConfigResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-connect` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-connect docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_connect/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
