"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return amqp_generated_1.RosAccount; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AMQP::Account`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAccount`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-account
 */
class Account extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAccount = new amqp_generated_1.RosAccount(this, id, {
            instanceId: props.instanceId,
            accountAccessKey: props.accountAccessKey,
            accountAccessKeySecret: props.accountAccessKeySecret,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountAccessKey = rosAccount.attrAccountAccessKey;
        this.attrCreateTimestamp = rosAccount.attrCreateTimestamp;
        this.attrPassword = rosAccount.attrPassword;
        this.attrUserName = rosAccount.attrUserName;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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