"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosVirtualHost = exports.RosQueue = exports.RosInstance = exports.RosExchange = exports.RosBinding = exports.RosAccount = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAccountProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('accountAccessKey', ros.requiredValidator)(properties.accountAccessKey));
    errors.collect(ros.propertyValidator('accountAccessKey', ros.validateString)(properties.accountAccessKey));
    errors.collect(ros.propertyValidator('accountAccessKeySecret', ros.requiredValidator)(properties.accountAccessKeySecret));
    errors.collect(ros.propertyValidator('accountAccessKeySecret', ros.validateString)(properties.accountAccessKeySecret));
    return errors.wrap('supplied properties not correct for "RosAccountProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Account` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Account` resource.
 */
// @ts-ignore TS6133
function rosAccountPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPropsValidator(properties).assertSuccess();
    }
    return {
        'AccountAccessKey': ros.stringToRosTemplate(properties.accountAccessKey),
        'AccountAccessKeySecret': ros.stringToRosTemplate(properties.accountAccessKeySecret),
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::Account`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Account` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-account
 */
class RosAccount extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccount.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAccountAccessKey = this.getAtt('AccountAccessKey');
        this.attrCreateTimestamp = this.getAtt('CreateTimestamp');
        this.attrPassword = this.getAtt('Password');
        this.attrUserName = this.getAtt('UserName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountAccessKey = props.accountAccessKey;
        this.accountAccessKeySecret = props.accountAccessKeySecret;
        this.instanceId = props.instanceId;
    }
    get rosProperties() {
        return {
            accountAccessKey: this.accountAccessKey,
            accountAccessKeySecret: this.accountAccessKeySecret,
            instanceId: this.instanceId,
        };
    }
    renderProperties(props) {
        return rosAccountPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccount = RosAccount;
/**
 * The resource type name for this resource class.
 */
RosAccount.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Account";
/**
 * Determine whether the given properties match those of a `RosBindingProps`
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the result of the validation.
 */
function RosBindingPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('argument', ros.requiredValidator)(properties.argument));
    errors.collect(ros.propertyValidator('argument', ros.validateString)(properties.argument));
    errors.collect(ros.propertyValidator('sourceExchange', ros.requiredValidator)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('sourceExchange', ros.validateString)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('bindingKey', ros.requiredValidator)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingKey', ros.validateString)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingType', ros.requiredValidator)(properties.bindingType));
    if (properties.bindingType && (typeof properties.bindingType) !== 'object') {
        errors.collect(ros.propertyValidator('bindingType', ros.validateAllowedValues)({
            data: properties.bindingType,
            allowedValues: ["0", "0", "QUEUE", "1", "1", "EXCHANGE"],
        }));
    }
    errors.collect(ros.propertyValidator('bindingType', ros.validateString)(properties.bindingType));
    errors.collect(ros.propertyValidator('destinationName', ros.requiredValidator)(properties.destinationName));
    errors.collect(ros.propertyValidator('destinationName', ros.validateString)(properties.destinationName));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosBindingProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource.
 */
// @ts-ignore TS6133
function rosBindingPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosBindingPropsValidator(properties).assertSuccess();
    }
    return {
        'Argument': ros.stringToRosTemplate(properties.argument),
        'BindingKey': ros.stringToRosTemplate(properties.bindingKey),
        'BindingType': ros.stringToRosTemplate(properties.bindingType),
        'DestinationName': ros.stringToRosTemplate(properties.destinationName),
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'SourceExchange': ros.stringToRosTemplate(properties.sourceExchange),
        'VirtualHost': ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::Binding`, which is used to bind a queue or an exchange to an exchange.
 * @Note This class does not contain additional functions, so it is recommended to use the `Binding` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-binding
 */
class RosBinding extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosBinding.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.argument = props.argument;
        this.bindingKey = props.bindingKey;
        this.bindingType = props.bindingType;
        this.destinationName = props.destinationName;
        this.instanceId = props.instanceId;
        this.sourceExchange = props.sourceExchange;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            argument: this.argument,
            bindingKey: this.bindingKey,
            bindingType: this.bindingType,
            destinationName: this.destinationName,
            instanceId: this.instanceId,
            sourceExchange: this.sourceExchange,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosBindingPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosBinding = RosBinding;
/**
 * The resource type name for this resource class.
 */
RosBinding.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Binding";
/**
 * Determine whether the given properties match those of a `RosExchangeProps`
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the result of the validation.
 */
function RosExchangePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('alternateExchange', ros.validateString)(properties.alternateExchange));
    errors.collect(ros.propertyValidator('internal', ros.requiredValidator)(properties.internal));
    errors.collect(ros.propertyValidator('internal', ros.validateBoolean)(properties.internal));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    if (properties.xDelayedType && (typeof properties.xDelayedType) !== 'object') {
        errors.collect(ros.propertyValidator('xDelayedType', ros.validateAllowedValues)({
            data: properties.xDelayedType,
            allowedValues: ["DIRECT", "TOPIC", "FANOUT", "HEADERS", "X-JMS-TOPIC"],
        }));
    }
    errors.collect(ros.propertyValidator('xDelayedType', ros.validateString)(properties.xDelayedType));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.requiredValidator)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('exchangeName', ros.requiredValidator)(properties.exchangeName));
    if (properties.exchangeName && (Array.isArray(properties.exchangeName) || (typeof properties.exchangeName) === 'string')) {
        errors.collect(ros.propertyValidator('exchangeName', ros.validateLength)({
            data: properties.exchangeName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('exchangeName', ros.validateString)(properties.exchangeName));
    errors.collect(ros.propertyValidator('exchangeType', ros.requiredValidator)(properties.exchangeType));
    if (properties.exchangeType && (typeof properties.exchangeType) !== 'object') {
        errors.collect(ros.propertyValidator('exchangeType', ros.validateAllowedValues)({
            data: properties.exchangeType,
            allowedValues: ["FANOUT", "DIRECT", "TOPIC", "HEADERS"],
        }));
    }
    errors.collect(ros.propertyValidator('exchangeType', ros.validateString)(properties.exchangeType));
    return errors.wrap('supplied properties not correct for "RosExchangeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource.
 */
// @ts-ignore TS6133
function rosExchangePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosExchangePropsValidator(properties).assertSuccess();
    }
    return {
        'AutoDeleteState': ros.booleanToRosTemplate(properties.autoDeleteState),
        'ExchangeName': ros.stringToRosTemplate(properties.exchangeName),
        'ExchangeType': ros.stringToRosTemplate(properties.exchangeType),
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'Internal': ros.booleanToRosTemplate(properties.internal),
        'VirtualHost': ros.stringToRosTemplate(properties.virtualHost),
        'AlternateExchange': ros.stringToRosTemplate(properties.alternateExchange),
        'XDelayedType': ros.stringToRosTemplate(properties.xDelayedType),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::Exchange`, which is used to create an exchange.
 * @Note This class does not contain additional functions, so it is recommended to use the `Exchange` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-exchange
 */
class RosExchange extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosExchange.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrExchangeName = this.getAtt('ExchangeName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.autoDeleteState = props.autoDeleteState;
        this.exchangeName = props.exchangeName;
        this.exchangeType = props.exchangeType;
        this.instanceId = props.instanceId;
        this.internal = props.internal;
        this.virtualHost = props.virtualHost;
        this.alternateExchange = props.alternateExchange;
        this.xDelayedType = props.xDelayedType;
    }
    get rosProperties() {
        return {
            autoDeleteState: this.autoDeleteState,
            exchangeName: this.exchangeName,
            exchangeType: this.exchangeType,
            instanceId: this.instanceId,
            internal: this.internal,
            virtualHost: this.virtualHost,
            alternateExchange: this.alternateExchange,
            xDelayedType: this.xDelayedType,
        };
    }
    renderProperties(props) {
        return rosExchangePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosExchange = RosExchange;
/**
 * The resource type name for this resource class.
 */
RosExchange.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Exchange";
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.maxTps && (typeof properties.maxTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxTps', ros.validateAllowedValues)({
            data: properties.maxTps,
            allowedValues: [1000, 1500, 2000, 2500, 3000, 4000, 5000, 8000, 10000, 15000, 20000, 25000, 30000, 40000, 50000, 100000, 200000, 300000, 500000, 800000, 1000000],
        }));
    }
    errors.collect(ros.propertyValidator('maxTps', ros.validateNumber)(properties.maxTps));
    if (properties.maxEipTps && (typeof properties.maxEipTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxEipTps', ros.validateRange)({
            data: properties.maxEipTps,
            min: 128,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('maxEipTps', ros.validateNumber)(properties.maxEipTps));
    if (properties.supportEip && (typeof properties.supportEip) !== 'object') {
        errors.collect(ros.propertyValidator('supportEip', ros.validateAllowedValues)({
            data: properties.supportEip,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportEip', ros.validateString)(properties.supportEip));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 6, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.storageSize && (typeof properties.storageSize) !== 'object') {
        errors.collect(ros.propertyValidator('storageSize', ros.validateRange)({
            data: properties.storageSize,
            min: 0,
            max: 2800,
        }));
    }
    errors.collect(ros.propertyValidator('storageSize', ros.validateNumber)(properties.storageSize));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    if (properties.queueCapacity && (typeof properties.queueCapacity) !== 'object') {
        errors.collect(ros.propertyValidator('queueCapacity', ros.validateRange)({
            data: properties.queueCapacity,
            min: 50,
            max: 80000,
        }));
    }
    errors.collect(ros.propertyValidator('queueCapacity', ros.validateNumber)(properties.queueCapacity));
    if (properties.tracingStorageTime && (typeof properties.tracingStorageTime) !== 'object') {
        errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateAllowedValues)({
            data: properties.tracingStorageTime,
            allowedValues: [0, 3, 7, 15],
        }));
    }
    errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateNumber)(properties.tracingStorageTime));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.orderNum && (typeof properties.orderNum) !== 'object') {
        errors.collect(ros.propertyValidator('orderNum', ros.validateRange)({
            data: properties.orderNum,
            min: 1,
            max: 9999,
        }));
    }
    errors.collect(ros.propertyValidator('orderNum', ros.validateNumber)(properties.orderNum));
    if (properties.supportTracing && (typeof properties.supportTracing) !== 'object') {
        errors.collect(ros.propertyValidator('supportTracing', ros.validateAllowedValues)({
            data: properties.supportTracing,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportTracing', ros.validateString)(properties.supportTracing));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["professional", "enterprise", "vip"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["month", "year", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'InstanceName': ros.stringToRosTemplate(properties.instanceName),
        'InstanceType': ros.stringToRosTemplate(properties.instanceType),
        'MaxEipTps': ros.numberToRosTemplate(properties.maxEipTps),
        'MaxTps': ros.numberToRosTemplate(properties.maxTps),
        'OrderNum': ros.numberToRosTemplate(properties.orderNum),
        'PayType': ros.stringToRosTemplate(properties.payType),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'QueueCapacity': ros.numberToRosTemplate(properties.queueCapacity),
        'StorageSize': ros.numberToRosTemplate(properties.storageSize),
        'SupportEip': ros.stringToRosTemplate(properties.supportEip),
        'SupportTracing': ros.stringToRosTemplate(properties.supportTracing),
        'TracingStorageTime': ros.numberToRosTemplate(properties.tracingStorageTime),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::Instance`, which is used to create an ApsaraMQ for RabbitMQ instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `Instance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-instance
 */
class RosInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClassicEndpoint = this.getAtt('ClassicEndpoint');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrPrivateEndpoint = this.getAtt('PrivateEndpoint');
        this.attrPublicEndpoint = this.getAtt('PublicEndpoint');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceName = props.instanceName;
        this.instanceType = props.instanceType;
        this.maxEipTps = props.maxEipTps;
        this.maxTps = props.maxTps;
        this.orderNum = props.orderNum;
        this.payType = props.payType;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.queueCapacity = props.queueCapacity;
        this.storageSize = props.storageSize;
        this.supportEip = props.supportEip;
        this.supportTracing = props.supportTracing;
        this.tracingStorageTime = props.tracingStorageTime;
    }
    get rosProperties() {
        return {
            instanceName: this.instanceName,
            instanceType: this.instanceType,
            maxEipTps: this.maxEipTps,
            maxTps: this.maxTps,
            orderNum: this.orderNum,
            payType: this.payType,
            period: this.period,
            periodUnit: this.periodUnit,
            queueCapacity: this.queueCapacity,
            storageSize: this.storageSize,
            supportEip: this.supportEip,
            supportTracing: this.supportTracing,
            tracingStorageTime: this.tracingStorageTime,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Instance";
/**
 * Determine whether the given properties match those of a `RosQueueProps`
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the result of the validation.
 */
function RosQueuePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('deadLetterExchange', ros.validateString)(properties.deadLetterExchange));
    errors.collect(ros.propertyValidator('maximumPriority', ros.validateNumber)(properties.maximumPriority));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('exclusiveState', ros.validateBoolean)(properties.exclusiveState));
    errors.collect(ros.propertyValidator('deadLetterRoutingKey', ros.validateString)(properties.deadLetterRoutingKey));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    errors.collect(ros.propertyValidator('maxLength', ros.validateNumber)(properties.maxLength));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('queueName', ros.requiredValidator)(properties.queueName));
    if (properties.queueName && (Array.isArray(properties.queueName) || (typeof properties.queueName) === 'string')) {
        errors.collect(ros.propertyValidator('queueName', ros.validateLength)({
            data: properties.queueName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('queueName', ros.validateString)(properties.queueName));
    errors.collect(ros.propertyValidator('messageTtl', ros.validateNumber)(properties.messageTtl));
    errors.collect(ros.propertyValidator('autoExpireState', ros.validateNumber)(properties.autoExpireState));
    return errors.wrap('supplied properties not correct for "RosQueueProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource.
 */
// @ts-ignore TS6133
function rosQueuePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosQueuePropsValidator(properties).assertSuccess();
    }
    return {
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'QueueName': ros.stringToRosTemplate(properties.queueName),
        'VirtualHost': ros.stringToRosTemplate(properties.virtualHost),
        'AutoDeleteState': ros.booleanToRosTemplate(properties.autoDeleteState),
        'AutoExpireState': ros.numberToRosTemplate(properties.autoExpireState),
        'DeadLetterExchange': ros.stringToRosTemplate(properties.deadLetterExchange),
        'DeadLetterRoutingKey': ros.stringToRosTemplate(properties.deadLetterRoutingKey),
        'ExclusiveState': ros.booleanToRosTemplate(properties.exclusiveState),
        'MaximumPriority': ros.numberToRosTemplate(properties.maximumPriority),
        'MaxLength': ros.numberToRosTemplate(properties.maxLength),
        'MessageTTL': ros.numberToRosTemplate(properties.messageTtl),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::Queue`, which is used to create a queue.
 * @Note This class does not contain additional functions, so it is recommended to use the `Queue` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-queue
 */
class RosQueue extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosQueue.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrQueueName = this.getAtt('QueueName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.queueName = props.queueName;
        this.virtualHost = props.virtualHost;
        this.autoDeleteState = props.autoDeleteState;
        this.autoExpireState = props.autoExpireState;
        this.deadLetterExchange = props.deadLetterExchange;
        this.deadLetterRoutingKey = props.deadLetterRoutingKey;
        this.exclusiveState = props.exclusiveState;
        this.maximumPriority = props.maximumPriority;
        this.maxLength = props.maxLength;
        this.messageTtl = props.messageTtl;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            queueName: this.queueName,
            virtualHost: this.virtualHost,
            autoDeleteState: this.autoDeleteState,
            autoExpireState: this.autoExpireState,
            deadLetterExchange: this.deadLetterExchange,
            deadLetterRoutingKey: this.deadLetterRoutingKey,
            exclusiveState: this.exclusiveState,
            maximumPriority: this.maximumPriority,
            maxLength: this.maxLength,
            messageTtl: this.messageTtl,
        };
    }
    renderProperties(props) {
        return rosQueuePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosQueue = RosQueue;
/**
 * The resource type name for this resource class.
 */
RosQueue.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Queue";
/**
 * Determine whether the given properties match those of a `RosVirtualHostProps`
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the result of the validation.
 */
function RosVirtualHostPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    if (properties.virtualHost && (Array.isArray(properties.virtualHost) || (typeof properties.virtualHost) === 'string')) {
        errors.collect(ros.propertyValidator('virtualHost', ros.validateLength)({
            data: properties.virtualHost.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosVirtualHostProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource.
 */
// @ts-ignore TS6133
function rosVirtualHostPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosVirtualHostPropsValidator(properties).assertSuccess();
    }
    return {
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'VirtualHost': ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::AMQP::VirtualHost`, which is used to create a vhost.
 * @Note This class does not contain additional functions, so it is recommended to use the `VirtualHost` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-virtualhost
 */
class RosVirtualHost extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosVirtualHost.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrVirtualHost = this.getAtt('VirtualHost');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosVirtualHostPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosVirtualHost = RosVirtualHost;
/**
 * The resource type name for this resource class.
 */
RosVirtualHost.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::VirtualHost";
//# sourceMappingURL=data:application/json;base64,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