"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exchange = exports.ExchangeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "ExchangeProperty", { enumerable: true, get: function () { return amqp_generated_1.RosExchange; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AMQP::Exchange`, which is used to create an exchange.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosExchange`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-exchange
 */
class Exchange extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosExchange = new amqp_generated_1.RosExchange(this, id, {
            instanceId: props.instanceId,
            alternateExchange: props.alternateExchange,
            internal: props.internal,
            virtualHost: props.virtualHost,
            xDelayedType: props.xDelayedType,
            autoDeleteState: props.autoDeleteState,
            exchangeName: props.exchangeName,
            exchangeType: props.exchangeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosExchange;
        this.attrExchangeName = rosExchange.attrExchangeName;
    }
}
exports.Exchange = Exchange;
//# sourceMappingURL=data:application/json;base64,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