"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = exports.QueueProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "QueueProperty", { enumerable: true, get: function () { return amqp_generated_1.RosQueue; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AMQP::Queue`, which is used to create a queue.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosQueue`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-amqp-queue
 */
class Queue extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosQueue = new amqp_generated_1.RosQueue(this, id, {
            deadLetterExchange: props.deadLetterExchange,
            maximumPriority: props.maximumPriority,
            instanceId: props.instanceId,
            exclusiveState: props.exclusiveState,
            deadLetterRoutingKey: props.deadLetterRoutingKey,
            virtualHost: props.virtualHost,
            maxLength: props.maxLength,
            autoDeleteState: props.autoDeleteState,
            queueName: props.queueName,
            messageTtl: props.messageTtl,
            autoExpireState: props.autoExpireState,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosQueue;
        this.attrQueueName = rosQueue.attrQueueName;
    }
}
exports.Queue = Queue;
//# sourceMappingURL=data:application/json;base64,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