# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionsRepositoryPermissionsArgs', 'ActionsRepositoryPermissions']

@pulumi.input_type
class ActionsRepositoryPermissionsArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[builtins.str],
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ActionsRepositoryPermissions resource.
        :param pulumi.Input[builtins.str] repository: The GitHub repository
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs'] allowed_actions_config: Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.bool] enabled: Should GitHub actions be enabled on this repository?
        """
        pulumi.set(__self__, "repository", repository)
        if allowed_actions is not None:
            pulumi.set(__self__, "allowed_actions", allowed_actions)
        if allowed_actions_config is not None:
            pulumi.set(__self__, "allowed_actions_config", allowed_actions_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[builtins.str]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @allowed_actions.setter
    def allowed_actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_actions", value)

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']]:
        """
        Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @allowed_actions_config.setter
    def allowed_actions_config(self, value: Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']]):
        pulumi.set(self, "allowed_actions_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should GitHub actions be enabled on this repository?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _ActionsRepositoryPermissionsState:
    def __init__(__self__, *,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionsRepositoryPermissions resources.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs'] allowed_actions_config: Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.bool] enabled: Should GitHub actions be enabled on this repository?
        :param pulumi.Input[builtins.str] repository: The GitHub repository
        """
        if allowed_actions is not None:
            pulumi.set(__self__, "allowed_actions", allowed_actions)
        if allowed_actions_config is not None:
            pulumi.set(__self__, "allowed_actions_config", allowed_actions_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @allowed_actions.setter
    def allowed_actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_actions", value)

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']]:
        """
        Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @allowed_actions_config.setter
    def allowed_actions_config(self, value: Optional[pulumi.Input['ActionsRepositoryPermissionsAllowedActionsConfigArgs']]):
        pulumi.set(self, "allowed_actions_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should GitHub actions be enabled on this repository?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)


@pulumi.type_token("github:index/actionsRepositoryPermissions:ActionsRepositoryPermissions")
class ActionsRepositoryPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input[Union['ActionsRepositoryPermissionsAllowedActionsConfigArgs', 'ActionsRepositoryPermissionsAllowedActionsConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to enable and manage GitHub Actions permissions for a given repository.
        You must have admin access to an repository to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example", name="my-repository")
        test = github.ActionsRepositoryPermissions("test",
            allowed_actions="selected",
            allowed_actions_config={
                "github_owned_allowed": True,
                "patterns_alloweds": [
                    "actions/cache@*",
                    "actions/checkout@*",
                ],
                "verified_allowed": True,
            },
            repository=example.name)
        ```

        ## Import

        This resource can be imported using the name of the GitHub repository:

        ```sh
        $ pulumi import github:index/actionsRepositoryPermissions:ActionsRepositoryPermissions test my-repository
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input[Union['ActionsRepositoryPermissionsAllowedActionsConfigArgs', 'ActionsRepositoryPermissionsAllowedActionsConfigArgsDict']] allowed_actions_config: Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.bool] enabled: Should GitHub actions be enabled on this repository?
        :param pulumi.Input[builtins.str] repository: The GitHub repository
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionsRepositoryPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to enable and manage GitHub Actions permissions for a given repository.
        You must have admin access to an repository to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example", name="my-repository")
        test = github.ActionsRepositoryPermissions("test",
            allowed_actions="selected",
            allowed_actions_config={
                "github_owned_allowed": True,
                "patterns_alloweds": [
                    "actions/cache@*",
                    "actions/checkout@*",
                ],
                "verified_allowed": True,
            },
            repository=example.name)
        ```

        ## Import

        This resource can be imported using the name of the GitHub repository:

        ```sh
        $ pulumi import github:index/actionsRepositoryPermissions:ActionsRepositoryPermissions test my-repository
        ```

        :param str resource_name: The name of the resource.
        :param ActionsRepositoryPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionsRepositoryPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input[Union['ActionsRepositoryPermissionsAllowedActionsConfigArgs', 'ActionsRepositoryPermissionsAllowedActionsConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionsRepositoryPermissionsArgs.__new__(ActionsRepositoryPermissionsArgs)

            __props__.__dict__["allowed_actions"] = allowed_actions
            __props__.__dict__["allowed_actions_config"] = allowed_actions_config
            __props__.__dict__["enabled"] = enabled
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
        super(ActionsRepositoryPermissions, __self__).__init__(
            'github:index/actionsRepositoryPermissions:ActionsRepositoryPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
            allowed_actions_config: Optional[pulumi.Input[Union['ActionsRepositoryPermissionsAllowedActionsConfigArgs', 'ActionsRepositoryPermissionsAllowedActionsConfigArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            repository: Optional[pulumi.Input[builtins.str]] = None) -> 'ActionsRepositoryPermissions':
        """
        Get an existing ActionsRepositoryPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input[Union['ActionsRepositoryPermissionsAllowedActionsConfigArgs', 'ActionsRepositoryPermissionsAllowedActionsConfigArgsDict']] allowed_actions_config: Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.bool] enabled: Should GitHub actions be enabled on this repository?
        :param pulumi.Input[builtins.str] repository: The GitHub repository
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionsRepositoryPermissionsState.__new__(_ActionsRepositoryPermissionsState)

        __props__.__dict__["allowed_actions"] = allowed_actions
        __props__.__dict__["allowed_actions_config"] = allowed_actions_config
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["repository"] = repository
        return ActionsRepositoryPermissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> pulumi.Output[Optional['outputs.ActionsRepositoryPermissionsAllowedActionsConfig']]:
        """
        Sets the actions that are allowed in an repository. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should GitHub actions be enabled on this repository?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[builtins.str]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

