# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnterpriseActionsPermissionsArgs', 'EnterpriseActionsPermissions']

@pulumi.input_type
class EnterpriseActionsPermissionsArgs:
    def __init__(__self__, *,
                 enabled_organizations: pulumi.Input[builtins.str],
                 enterprise_slug: pulumi.Input[builtins.str],
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']] = None,
                 enabled_organizations_config: Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']] = None):
        """
        The set of arguments for constructing a EnterpriseActionsPermissions resource.
        :param pulumi.Input[builtins.str] enabled_organizations: The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs'] allowed_actions_config: Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs'] enabled_organizations_config: Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        """
        pulumi.set(__self__, "enabled_organizations", enabled_organizations)
        pulumi.set(__self__, "enterprise_slug", enterprise_slug)
        if allowed_actions is not None:
            pulumi.set(__self__, "allowed_actions", allowed_actions)
        if allowed_actions_config is not None:
            pulumi.set(__self__, "allowed_actions_config", allowed_actions_config)
        if enabled_organizations_config is not None:
            pulumi.set(__self__, "enabled_organizations_config", enabled_organizations_config)

    @property
    @pulumi.getter(name="enabledOrganizations")
    def enabled_organizations(self) -> pulumi.Input[builtins.str]:
        """
        The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        """
        return pulumi.get(self, "enabled_organizations")

    @enabled_organizations.setter
    def enabled_organizations(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "enabled_organizations", value)

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> pulumi.Input[builtins.str]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

    @enterprise_slug.setter
    def enterprise_slug(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "enterprise_slug", value)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @allowed_actions.setter
    def allowed_actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_actions", value)

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']]:
        """
        Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @allowed_actions_config.setter
    def allowed_actions_config(self, value: Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']]):
        pulumi.set(self, "allowed_actions_config", value)

    @property
    @pulumi.getter(name="enabledOrganizationsConfig")
    def enabled_organizations_config(self) -> Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']]:
        """
        Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        """
        return pulumi.get(self, "enabled_organizations_config")

    @enabled_organizations_config.setter
    def enabled_organizations_config(self, value: Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']]):
        pulumi.set(self, "enabled_organizations_config", value)


@pulumi.input_type
class _EnterpriseActionsPermissionsState:
    def __init__(__self__, *,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']] = None,
                 enabled_organizations: Optional[pulumi.Input[builtins.str]] = None,
                 enabled_organizations_config: Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnterpriseActionsPermissions resources.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs'] allowed_actions_config: Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.str] enabled_organizations: The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        :param pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs'] enabled_organizations_config: Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        """
        if allowed_actions is not None:
            pulumi.set(__self__, "allowed_actions", allowed_actions)
        if allowed_actions_config is not None:
            pulumi.set(__self__, "allowed_actions_config", allowed_actions_config)
        if enabled_organizations is not None:
            pulumi.set(__self__, "enabled_organizations", enabled_organizations)
        if enabled_organizations_config is not None:
            pulumi.set(__self__, "enabled_organizations_config", enabled_organizations_config)
        if enterprise_slug is not None:
            pulumi.set(__self__, "enterprise_slug", enterprise_slug)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @allowed_actions.setter
    def allowed_actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_actions", value)

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']]:
        """
        Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @allowed_actions_config.setter
    def allowed_actions_config(self, value: Optional[pulumi.Input['EnterpriseActionsPermissionsAllowedActionsConfigArgs']]):
        pulumi.set(self, "allowed_actions_config", value)

    @property
    @pulumi.getter(name="enabledOrganizations")
    def enabled_organizations(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        """
        return pulumi.get(self, "enabled_organizations")

    @enabled_organizations.setter
    def enabled_organizations(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enabled_organizations", value)

    @property
    @pulumi.getter(name="enabledOrganizationsConfig")
    def enabled_organizations_config(self) -> Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']]:
        """
        Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        """
        return pulumi.get(self, "enabled_organizations_config")

    @enabled_organizations_config.setter
    def enabled_organizations_config(self, value: Optional[pulumi.Input['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs']]):
        pulumi.set(self, "enabled_organizations_config", value)

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

    @enterprise_slug.setter
    def enterprise_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_slug", value)


@pulumi.type_token("github:index/enterpriseActionsPermissions:EnterpriseActionsPermissions")
class EnterpriseActionsPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsAllowedActionsConfigArgs', 'EnterpriseActionsPermissionsAllowedActionsConfigArgsDict']]] = None,
                 enabled_organizations: Optional[pulumi.Input[builtins.str]] = None,
                 enabled_organizations_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs', 'EnterpriseActionsPermissionsEnabledOrganizationsConfigArgsDict']]] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage GitHub Actions permissions within your GitHub enterprise.
        You must have admin access to an enterprise to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_org = github.get_organization(name="my-org")
        test = github.EnterpriseActionsPermissions("test",
            enterprise_slug="my-enterprise",
            allowed_actions="selected",
            enabled_organizations="selected",
            allowed_actions_config={
                "github_owned_allowed": True,
                "patterns_alloweds": [
                    "actions/cache@*",
                    "actions/checkout@*",
                ],
                "verified_allowed": True,
            },
            enabled_organizations_config={
                "organization_ids": [example_org.id],
            })
        ```

        ## Import

        This resource can be imported using the name of the GitHub enterprise:

        ```sh
        $ pulumi import github:index/enterpriseActionsPermissions:EnterpriseActionsPermissions test github_enterprise_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input[Union['EnterpriseActionsPermissionsAllowedActionsConfigArgs', 'EnterpriseActionsPermissionsAllowedActionsConfigArgsDict']] allowed_actions_config: Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.str] enabled_organizations: The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        :param pulumi.Input[Union['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs', 'EnterpriseActionsPermissionsEnabledOrganizationsConfigArgsDict']] enabled_organizations_config: Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseActionsPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage GitHub Actions permissions within your GitHub enterprise.
        You must have admin access to an enterprise to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_org = github.get_organization(name="my-org")
        test = github.EnterpriseActionsPermissions("test",
            enterprise_slug="my-enterprise",
            allowed_actions="selected",
            enabled_organizations="selected",
            allowed_actions_config={
                "github_owned_allowed": True,
                "patterns_alloweds": [
                    "actions/cache@*",
                    "actions/checkout@*",
                ],
                "verified_allowed": True,
            },
            enabled_organizations_config={
                "organization_ids": [example_org.id],
            })
        ```

        ## Import

        This resource can be imported using the name of the GitHub enterprise:

        ```sh
        $ pulumi import github:index/enterpriseActionsPermissions:EnterpriseActionsPermissions test github_enterprise_name
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseActionsPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseActionsPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_actions_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsAllowedActionsConfigArgs', 'EnterpriseActionsPermissionsAllowedActionsConfigArgsDict']]] = None,
                 enabled_organizations: Optional[pulumi.Input[builtins.str]] = None,
                 enabled_organizations_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs', 'EnterpriseActionsPermissionsEnabledOrganizationsConfigArgsDict']]] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseActionsPermissionsArgs.__new__(EnterpriseActionsPermissionsArgs)

            __props__.__dict__["allowed_actions"] = allowed_actions
            __props__.__dict__["allowed_actions_config"] = allowed_actions_config
            if enabled_organizations is None and not opts.urn:
                raise TypeError("Missing required property 'enabled_organizations'")
            __props__.__dict__["enabled_organizations"] = enabled_organizations
            __props__.__dict__["enabled_organizations_config"] = enabled_organizations_config
            if enterprise_slug is None and not opts.urn:
                raise TypeError("Missing required property 'enterprise_slug'")
            __props__.__dict__["enterprise_slug"] = enterprise_slug
        super(EnterpriseActionsPermissions, __self__).__init__(
            'github:index/enterpriseActionsPermissions:EnterpriseActionsPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_actions: Optional[pulumi.Input[builtins.str]] = None,
            allowed_actions_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsAllowedActionsConfigArgs', 'EnterpriseActionsPermissionsAllowedActionsConfigArgsDict']]] = None,
            enabled_organizations: Optional[pulumi.Input[builtins.str]] = None,
            enabled_organizations_config: Optional[pulumi.Input[Union['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs', 'EnterpriseActionsPermissionsEnabledOrganizationsConfigArgsDict']]] = None,
            enterprise_slug: Optional[pulumi.Input[builtins.str]] = None) -> 'EnterpriseActionsPermissions':
        """
        Get an existing EnterpriseActionsPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allowed_actions: The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        :param pulumi.Input[Union['EnterpriseActionsPermissionsAllowedActionsConfigArgs', 'EnterpriseActionsPermissionsAllowedActionsConfigArgsDict']] allowed_actions_config: Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        :param pulumi.Input[builtins.str] enabled_organizations: The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        :param pulumi.Input[Union['EnterpriseActionsPermissionsEnabledOrganizationsConfigArgs', 'EnterpriseActionsPermissionsEnabledOrganizationsConfigArgsDict']] enabled_organizations_config: Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseActionsPermissionsState.__new__(_EnterpriseActionsPermissionsState)

        __props__.__dict__["allowed_actions"] = allowed_actions
        __props__.__dict__["allowed_actions_config"] = allowed_actions_config
        __props__.__dict__["enabled_organizations"] = enabled_organizations
        __props__.__dict__["enabled_organizations_config"] = enabled_organizations_config
        __props__.__dict__["enterprise_slug"] = enterprise_slug
        return EnterpriseActionsPermissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedActions")
    def allowed_actions(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
        """
        return pulumi.get(self, "allowed_actions")

    @property
    @pulumi.getter(name="allowedActionsConfig")
    def allowed_actions_config(self) -> pulumi.Output[Optional['outputs.EnterpriseActionsPermissionsAllowedActionsConfig']]:
        """
        Sets the actions that are allowed in an enterprise. Only available when `allowed_actions` = `selected`. See Allowed Actions Config below for details.
        """
        return pulumi.get(self, "allowed_actions_config")

    @property
    @pulumi.getter(name="enabledOrganizations")
    def enabled_organizations(self) -> pulumi.Output[builtins.str]:
        """
        The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
        """
        return pulumi.get(self, "enabled_organizations")

    @property
    @pulumi.getter(name="enabledOrganizationsConfig")
    def enabled_organizations_config(self) -> pulumi.Output[Optional['outputs.EnterpriseActionsPermissionsEnabledOrganizationsConfig']]:
        """
        Sets the list of selected organizations that are enabled for GitHub Actions in an enterprise. Only available when `enabled_organizations` = `selected`. See Enabled Organizations Config below for details.
        """
        return pulumi.get(self, "enabled_organizations_config")

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> pulumi.Output[builtins.str]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

