# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EnterpriseActionsRunnerGroupArgs', 'EnterpriseActionsRunnerGroup']

@pulumi.input_type
class EnterpriseActionsRunnerGroupArgs:
    def __init__(__self__, *,
                 enterprise_slug: pulumi.Input[builtins.str],
                 visibility: pulumi.Input[builtins.str],
                 allows_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_to_workflows: Optional[pulumi.Input[builtins.bool]] = None,
                 selected_organization_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 selected_workflows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a EnterpriseActionsRunnerGroup resource.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        :param pulumi.Input[builtins.str] visibility: Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        :param pulumi.Input[builtins.bool] allows_public_repositories: Whether public repositories can be added to the runner group. Defaults to false.
        :param pulumi.Input[builtins.str] name: Name of the runner group
        :param pulumi.Input[builtins.bool] restricted_to_workflows: If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] selected_organization_ids: IDs of the organizations which should be added to the runner group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_workflows: List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        """
        pulumi.set(__self__, "enterprise_slug", enterprise_slug)
        pulumi.set(__self__, "visibility", visibility)
        if allows_public_repositories is not None:
            pulumi.set(__self__, "allows_public_repositories", allows_public_repositories)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restricted_to_workflows is not None:
            pulumi.set(__self__, "restricted_to_workflows", restricted_to_workflows)
        if selected_organization_ids is not None:
            pulumi.set(__self__, "selected_organization_ids", selected_organization_ids)
        if selected_workflows is not None:
            pulumi.set(__self__, "selected_workflows", selected_workflows)

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> pulumi.Input[builtins.str]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

    @enterprise_slug.setter
    def enterprise_slug(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "enterprise_slug", value)

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Input[builtins.str]:
        """
        Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="allowsPublicRepositories")
    def allows_public_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public repositories can be added to the runner group. Defaults to false.
        """
        return pulumi.get(self, "allows_public_repositories")

    @allows_public_repositories.setter
    def allows_public_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allows_public_repositories", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the runner group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restrictedToWorkflows")
    def restricted_to_workflows(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        """
        return pulumi.get(self, "restricted_to_workflows")

    @restricted_to_workflows.setter
    def restricted_to_workflows(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restricted_to_workflows", value)

    @property
    @pulumi.getter(name="selectedOrganizationIds")
    def selected_organization_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        IDs of the organizations which should be added to the runner group
        """
        return pulumi.get(self, "selected_organization_ids")

    @selected_organization_ids.setter
    def selected_organization_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "selected_organization_ids", value)

    @property
    @pulumi.getter(name="selectedWorkflows")
    def selected_workflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        """
        return pulumi.get(self, "selected_workflows")

    @selected_workflows.setter
    def selected_workflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "selected_workflows", value)


@pulumi.input_type
class _EnterpriseActionsRunnerGroupState:
    def __init__(__self__, *,
                 allows_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_to_workflows: Optional[pulumi.Input[builtins.bool]] = None,
                 runners_url: Optional[pulumi.Input[builtins.str]] = None,
                 selected_organization_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 selected_organizations_url: Optional[pulumi.Input[builtins.str]] = None,
                 selected_workflows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnterpriseActionsRunnerGroup resources.
        :param pulumi.Input[builtins.bool] allows_public_repositories: Whether public repositories can be added to the runner group. Defaults to false.
        :param pulumi.Input[builtins.bool] default: Whether this is the default runner group
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        :param pulumi.Input[builtins.str] etag: An etag representing the runner group object
        :param pulumi.Input[builtins.str] name: Name of the runner group
        :param pulumi.Input[builtins.bool] restricted_to_workflows: If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        :param pulumi.Input[builtins.str] runners_url: The GitHub API URL for the runner group's runners
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] selected_organization_ids: IDs of the organizations which should be added to the runner group
        :param pulumi.Input[builtins.str] selected_organizations_url: The GitHub API URL for the runner group's selected organizations
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_workflows: List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        :param pulumi.Input[builtins.str] visibility: Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        if allows_public_repositories is not None:
            pulumi.set(__self__, "allows_public_repositories", allows_public_repositories)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if enterprise_slug is not None:
            pulumi.set(__self__, "enterprise_slug", enterprise_slug)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restricted_to_workflows is not None:
            pulumi.set(__self__, "restricted_to_workflows", restricted_to_workflows)
        if runners_url is not None:
            pulumi.set(__self__, "runners_url", runners_url)
        if selected_organization_ids is not None:
            pulumi.set(__self__, "selected_organization_ids", selected_organization_ids)
        if selected_organizations_url is not None:
            pulumi.set(__self__, "selected_organizations_url", selected_organizations_url)
        if selected_workflows is not None:
            pulumi.set(__self__, "selected_workflows", selected_workflows)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="allowsPublicRepositories")
    def allows_public_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public repositories can be added to the runner group. Defaults to false.
        """
        return pulumi.get(self, "allows_public_repositories")

    @allows_public_repositories.setter
    def allows_public_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allows_public_repositories", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this is the default runner group
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

    @enterprise_slug.setter
    def enterprise_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_slug", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An etag representing the runner group object
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the runner group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restrictedToWorkflows")
    def restricted_to_workflows(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        """
        return pulumi.get(self, "restricted_to_workflows")

    @restricted_to_workflows.setter
    def restricted_to_workflows(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restricted_to_workflows", value)

    @property
    @pulumi.getter(name="runnersUrl")
    def runners_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GitHub API URL for the runner group's runners
        """
        return pulumi.get(self, "runners_url")

    @runners_url.setter
    def runners_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runners_url", value)

    @property
    @pulumi.getter(name="selectedOrganizationIds")
    def selected_organization_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        IDs of the organizations which should be added to the runner group
        """
        return pulumi.get(self, "selected_organization_ids")

    @selected_organization_ids.setter
    def selected_organization_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "selected_organization_ids", value)

    @property
    @pulumi.getter(name="selectedOrganizationsUrl")
    def selected_organizations_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GitHub API URL for the runner group's selected organizations
        """
        return pulumi.get(self, "selected_organizations_url")

    @selected_organizations_url.setter
    def selected_organizations_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selected_organizations_url", value)

    @property
    @pulumi.getter(name="selectedWorkflows")
    def selected_workflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        """
        return pulumi.get(self, "selected_workflows")

    @selected_workflows.setter
    def selected_workflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "selected_workflows", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.type_token("github:index/enterpriseActionsRunnerGroup:EnterpriseActionsRunnerGroup")
class EnterpriseActionsRunnerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_to_workflows: Optional[pulumi.Input[builtins.bool]] = None,
                 selected_organization_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 selected_workflows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage GitHub Actions runner groups within your GitHub enterprise.
        You must have admin access to an enterprise to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        enterprise = github.get_enterprise(slug="my-enterprise")
        enterprise_organization = github.EnterpriseOrganization("enterprise_organization",
            enterprise_id=enterprise.id,
            name="my-organization",
            billing_email="octocat@octo.cat",
            admin_logins=["octocat"])
        example = github.EnterpriseActionsRunnerGroup("example",
            name="my-awesome-runner-group",
            enterprise_slug=enterprise.slug,
            allows_public_repositories=True,
            visibility="selected",
            selected_organization_ids=[enterprise_organization.database_id],
            restricted_to_workflows=True,
            selected_workflows=["my-organization/my-repo/.github/workflows/cool-workflow.yaml@refs/tags/v1"])
        ```

        ## Import

        This resource can be imported using the enterprise slug and the ID of the runner group:

        ```sh
        $ pulumi import github:index/enterpriseActionsRunnerGroup:EnterpriseActionsRunnerGroup test enterprise-slug/42
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allows_public_repositories: Whether public repositories can be added to the runner group. Defaults to false.
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        :param pulumi.Input[builtins.str] name: Name of the runner group
        :param pulumi.Input[builtins.bool] restricted_to_workflows: If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] selected_organization_ids: IDs of the organizations which should be added to the runner group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_workflows: List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        :param pulumi.Input[builtins.str] visibility: Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseActionsRunnerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage GitHub Actions runner groups within your GitHub enterprise.
        You must have admin access to an enterprise to use this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        enterprise = github.get_enterprise(slug="my-enterprise")
        enterprise_organization = github.EnterpriseOrganization("enterprise_organization",
            enterprise_id=enterprise.id,
            name="my-organization",
            billing_email="octocat@octo.cat",
            admin_logins=["octocat"])
        example = github.EnterpriseActionsRunnerGroup("example",
            name="my-awesome-runner-group",
            enterprise_slug=enterprise.slug,
            allows_public_repositories=True,
            visibility="selected",
            selected_organization_ids=[enterprise_organization.database_id],
            restricted_to_workflows=True,
            selected_workflows=["my-organization/my-repo/.github/workflows/cool-workflow.yaml@refs/tags/v1"])
        ```

        ## Import

        This resource can be imported using the enterprise slug and the ID of the runner group:

        ```sh
        $ pulumi import github:index/enterpriseActionsRunnerGroup:EnterpriseActionsRunnerGroup test enterprise-slug/42
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseActionsRunnerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseActionsRunnerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_to_workflows: Optional[pulumi.Input[builtins.bool]] = None,
                 selected_organization_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 selected_workflows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseActionsRunnerGroupArgs.__new__(EnterpriseActionsRunnerGroupArgs)

            __props__.__dict__["allows_public_repositories"] = allows_public_repositories
            if enterprise_slug is None and not opts.urn:
                raise TypeError("Missing required property 'enterprise_slug'")
            __props__.__dict__["enterprise_slug"] = enterprise_slug
            __props__.__dict__["name"] = name
            __props__.__dict__["restricted_to_workflows"] = restricted_to_workflows
            __props__.__dict__["selected_organization_ids"] = selected_organization_ids
            __props__.__dict__["selected_workflows"] = selected_workflows
            if visibility is None and not opts.urn:
                raise TypeError("Missing required property 'visibility'")
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["default"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["runners_url"] = None
            __props__.__dict__["selected_organizations_url"] = None
        super(EnterpriseActionsRunnerGroup, __self__).__init__(
            'github:index/enterpriseActionsRunnerGroup:EnterpriseActionsRunnerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            enterprise_slug: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            restricted_to_workflows: Optional[pulumi.Input[builtins.bool]] = None,
            runners_url: Optional[pulumi.Input[builtins.str]] = None,
            selected_organization_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            selected_organizations_url: Optional[pulumi.Input[builtins.str]] = None,
            selected_workflows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[builtins.str]] = None) -> 'EnterpriseActionsRunnerGroup':
        """
        Get an existing EnterpriseActionsRunnerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allows_public_repositories: Whether public repositories can be added to the runner group. Defaults to false.
        :param pulumi.Input[builtins.bool] default: Whether this is the default runner group
        :param pulumi.Input[builtins.str] enterprise_slug: The slug of the enterprise.
        :param pulumi.Input[builtins.str] etag: An etag representing the runner group object
        :param pulumi.Input[builtins.str] name: Name of the runner group
        :param pulumi.Input[builtins.bool] restricted_to_workflows: If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        :param pulumi.Input[builtins.str] runners_url: The GitHub API URL for the runner group's runners
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] selected_organization_ids: IDs of the organizations which should be added to the runner group
        :param pulumi.Input[builtins.str] selected_organizations_url: The GitHub API URL for the runner group's selected organizations
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_workflows: List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        :param pulumi.Input[builtins.str] visibility: Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseActionsRunnerGroupState.__new__(_EnterpriseActionsRunnerGroupState)

        __props__.__dict__["allows_public_repositories"] = allows_public_repositories
        __props__.__dict__["default"] = default
        __props__.__dict__["enterprise_slug"] = enterprise_slug
        __props__.__dict__["etag"] = etag
        __props__.__dict__["name"] = name
        __props__.__dict__["restricted_to_workflows"] = restricted_to_workflows
        __props__.__dict__["runners_url"] = runners_url
        __props__.__dict__["selected_organization_ids"] = selected_organization_ids
        __props__.__dict__["selected_organizations_url"] = selected_organizations_url
        __props__.__dict__["selected_workflows"] = selected_workflows
        __props__.__dict__["visibility"] = visibility
        return EnterpriseActionsRunnerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowsPublicRepositories")
    def allows_public_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether public repositories can be added to the runner group. Defaults to false.
        """
        return pulumi.get(self, "allows_public_repositories")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this is the default runner group
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="enterpriseSlug")
    def enterprise_slug(self) -> pulumi.Output[builtins.str]:
        """
        The slug of the enterprise.
        """
        return pulumi.get(self, "enterprise_slug")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        An etag representing the runner group object
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the runner group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restrictedToWorkflows")
    def restricted_to_workflows(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the runner group will be restricted to running only the workflows specified in the selected_workflows array. Defaults to false.
        """
        return pulumi.get(self, "restricted_to_workflows")

    @property
    @pulumi.getter(name="runnersUrl")
    def runners_url(self) -> pulumi.Output[builtins.str]:
        """
        The GitHub API URL for the runner group's runners
        """
        return pulumi.get(self, "runners_url")

    @property
    @pulumi.getter(name="selectedOrganizationIds")
    def selected_organization_ids(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        IDs of the organizations which should be added to the runner group
        """
        return pulumi.get(self, "selected_organization_ids")

    @property
    @pulumi.getter(name="selectedOrganizationsUrl")
    def selected_organizations_url(self) -> pulumi.Output[builtins.str]:
        """
        The GitHub API URL for the runner group's selected organizations
        """
        return pulumi.get(self, "selected_organizations_url")

    @property
    @pulumi.getter(name="selectedWorkflows")
    def selected_workflows(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of workflows the runner group should be allowed to run. This setting will be ignored unless restricted_to_workflows is set to true.
        """
        return pulumi.get(self, "selected_workflows")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[builtins.str]:
        """
        Visibility of a runner group to enterprise organizations. Whether the runner group can include `all` or `selected`
        """
        return pulumi.get(self, "visibility")

