# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMembershipResult',
    'AwaitableGetMembershipResult',
    'get_membership',
    'get_membership_output',
]

@pulumi.output_type
class GetMembershipResult:
    """
    A collection of values returned by getMembership.
    """
    def __init__(__self__, etag=None, id=None, organization=None, role=None, state=None, username=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization and not isinstance(organization, str):
            raise TypeError("Expected argument 'organization' to be a str")
        pulumi.set(__self__, "organization", organization)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        An etag representing the membership object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def organization(self) -> Optional[builtins.str]:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        `admin` or `member` -- the role the user has within the organization.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        `active` or `pending` -- the state of membership within the organization.  `active` if the member has accepted the invite, or `pending` if the invite is still pending.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username.
        """
        return pulumi.get(self, "username")


class AwaitableGetMembershipResult(GetMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMembershipResult(
            etag=self.etag,
            id=self.id,
            organization=self.organization,
            role=self.role,
            state=self.state,
            username=self.username)


def get_membership(organization: Optional[builtins.str] = None,
                   username: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMembershipResult:
    """
    Use this data source to find out if a user is a member of your organization, as well
    as what role they have within it.
    If the user's membership in the organization is pending their acceptance of an invite,
    the role they would have once they accept will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    membership_for_some_user = github.get_membership(username="SomeUser")
    ```


    :param builtins.str organization: The organization to check for the above username.
    :param builtins.str username: The username to lookup in the organization.
    """
    __args__ = dict()
    __args__['organization'] = organization
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getMembership:getMembership', __args__, opts=opts, typ=GetMembershipResult).value

    return AwaitableGetMembershipResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        organization=pulumi.get(__ret__, 'organization'),
        role=pulumi.get(__ret__, 'role'),
        state=pulumi.get(__ret__, 'state'),
        username=pulumi.get(__ret__, 'username'))
def get_membership_output(organization: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          username: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMembershipResult]:
    """
    Use this data source to find out if a user is a member of your organization, as well
    as what role they have within it.
    If the user's membership in the organization is pending their acceptance of an invite,
    the role they would have once they accept will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    membership_for_some_user = github.get_membership(username="SomeUser")
    ```


    :param builtins.str organization: The organization to check for the above username.
    :param builtins.str username: The username to lookup in the organization.
    """
    __args__ = dict()
    __args__['organization'] = organization
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getMembership:getMembership', __args__, opts=opts, typ=GetMembershipResult)
    return __ret__.apply(lambda __response__: GetMembershipResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        organization=pulumi.get(__response__, 'organization'),
        role=pulumi.get(__response__, 'role'),
        state=pulumi.get(__response__, 'state'),
        username=pulumi.get(__response__, 'username')))
