# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationSettingsArgs', 'OrganizationSettings']

@pulumi.input_type
class OrganizationSettingsArgs:
    def __init__(__self__, *,
                 billing_email: pulumi.Input[builtins.str],
                 advanced_security_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 blog: Optional[pulumi.Input[builtins.str]] = None,
                 company: Optional[pulumi.Input[builtins.str]] = None,
                 default_repository_permission: Optional[pulumi.Input[builtins.str]] = None,
                 dependabot_alerts_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependabot_security_updates_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependency_graph_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 has_organization_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 has_repository_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 members_can_create_internal_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_fork_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_scanning_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_scanning_push_protection_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 twitter_username: Optional[pulumi.Input[builtins.str]] = None,
                 web_commit_signoff_required: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a OrganizationSettings resource.
        :param pulumi.Input[builtins.str] billing_email: The billing email address for the organization.
        :param pulumi.Input[builtins.bool] advanced_security_enabled_for_new_repositories: Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] blog: The blog URL for the organization.
        :param pulumi.Input[builtins.str] company: The company name for the organization.
        :param pulumi.Input[builtins.str] default_repository_permission: The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        :param pulumi.Input[builtins.bool] dependabot_alerts_enabled_for_new_repositories: Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependabot_security_updates_enabled_for_new_repositories: Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependency_graph_enabled_for_new_repositories: Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: The description for the organization.
        :param pulumi.Input[builtins.str] email: The email address for the organization.
        :param pulumi.Input[builtins.bool] has_organization_projects: Whether or not organization projects are enabled for the organization.
        :param pulumi.Input[builtins.bool] has_repository_projects: Whether or not repository projects are enabled for the organization.
        :param pulumi.Input[builtins.str] location: The location for the organization.
        :param pulumi.Input[builtins.bool] members_can_create_internal_repositories: Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        :param pulumi.Input[builtins.bool] members_can_create_pages: Whether or not organization members can create new pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_pages: Whether or not organization members can create new private pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_repositories: Whether or not organization members can create new private repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_pages: Whether or not organization members can create new public pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_repositories: Whether or not organization members can create new public repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_repositories: Whether or not organization members can create new repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_fork_private_repositories: Whether or not organization members can fork private repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name for the organization.
        :param pulumi.Input[builtins.bool] secret_scanning_enabled_for_new_repositories: Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] secret_scanning_push_protection_enabled_for_new_repositories: Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] twitter_username: The Twitter username for the organization.
        :param pulumi.Input[builtins.bool] web_commit_signoff_required: Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        pulumi.set(__self__, "billing_email", billing_email)
        if advanced_security_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "advanced_security_enabled_for_new_repositories", advanced_security_enabled_for_new_repositories)
        if blog is not None:
            pulumi.set(__self__, "blog", blog)
        if company is not None:
            pulumi.set(__self__, "company", company)
        if default_repository_permission is not None:
            pulumi.set(__self__, "default_repository_permission", default_repository_permission)
        if dependabot_alerts_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependabot_alerts_enabled_for_new_repositories", dependabot_alerts_enabled_for_new_repositories)
        if dependabot_security_updates_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependabot_security_updates_enabled_for_new_repositories", dependabot_security_updates_enabled_for_new_repositories)
        if dependency_graph_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependency_graph_enabled_for_new_repositories", dependency_graph_enabled_for_new_repositories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if has_organization_projects is not None:
            pulumi.set(__self__, "has_organization_projects", has_organization_projects)
        if has_repository_projects is not None:
            pulumi.set(__self__, "has_repository_projects", has_repository_projects)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if members_can_create_internal_repositories is not None:
            pulumi.set(__self__, "members_can_create_internal_repositories", members_can_create_internal_repositories)
        if members_can_create_pages is not None:
            pulumi.set(__self__, "members_can_create_pages", members_can_create_pages)
        if members_can_create_private_pages is not None:
            pulumi.set(__self__, "members_can_create_private_pages", members_can_create_private_pages)
        if members_can_create_private_repositories is not None:
            pulumi.set(__self__, "members_can_create_private_repositories", members_can_create_private_repositories)
        if members_can_create_public_pages is not None:
            pulumi.set(__self__, "members_can_create_public_pages", members_can_create_public_pages)
        if members_can_create_public_repositories is not None:
            pulumi.set(__self__, "members_can_create_public_repositories", members_can_create_public_repositories)
        if members_can_create_repositories is not None:
            pulumi.set(__self__, "members_can_create_repositories", members_can_create_repositories)
        if members_can_fork_private_repositories is not None:
            pulumi.set(__self__, "members_can_fork_private_repositories", members_can_fork_private_repositories)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_scanning_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "secret_scanning_enabled_for_new_repositories", secret_scanning_enabled_for_new_repositories)
        if secret_scanning_push_protection_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "secret_scanning_push_protection_enabled_for_new_repositories", secret_scanning_push_protection_enabled_for_new_repositories)
        if twitter_username is not None:
            pulumi.set(__self__, "twitter_username", twitter_username)
        if web_commit_signoff_required is not None:
            pulumi.set(__self__, "web_commit_signoff_required", web_commit_signoff_required)

    @property
    @pulumi.getter(name="billingEmail")
    def billing_email(self) -> pulumi.Input[builtins.str]:
        """
        The billing email address for the organization.
        """
        return pulumi.get(self, "billing_email")

    @billing_email.setter
    def billing_email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "billing_email", value)

    @property
    @pulumi.getter(name="advancedSecurityEnabledForNewRepositories")
    def advanced_security_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_security_enabled_for_new_repositories")

    @advanced_security_enabled_for_new_repositories.setter
    def advanced_security_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "advanced_security_enabled_for_new_repositories", value)

    @property
    @pulumi.getter
    def blog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The blog URL for the organization.
        """
        return pulumi.get(self, "blog")

    @blog.setter
    def blog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blog", value)

    @property
    @pulumi.getter
    def company(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The company name for the organization.
        """
        return pulumi.get(self, "company")

    @company.setter
    def company(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "company", value)

    @property
    @pulumi.getter(name="defaultRepositoryPermission")
    def default_repository_permission(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        """
        return pulumi.get(self, "default_repository_permission")

    @default_repository_permission.setter
    def default_repository_permission(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_repository_permission", value)

    @property
    @pulumi.getter(name="dependabotAlertsEnabledForNewRepositories")
    def dependabot_alerts_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_alerts_enabled_for_new_repositories")

    @dependabot_alerts_enabled_for_new_repositories.setter
    def dependabot_alerts_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependabot_alerts_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="dependabotSecurityUpdatesEnabledForNewRepositories")
    def dependabot_security_updates_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_security_updates_enabled_for_new_repositories")

    @dependabot_security_updates_enabled_for_new_repositories.setter
    def dependabot_security_updates_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependabot_security_updates_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="dependencyGraphEnabledForNewRepositories")
    def dependency_graph_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependency_graph_enabled_for_new_repositories")

    @dependency_graph_enabled_for_new_repositories.setter
    def dependency_graph_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependency_graph_enabled_for_new_repositories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address for the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="hasOrganizationProjects")
    def has_organization_projects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization projects are enabled for the organization.
        """
        return pulumi.get(self, "has_organization_projects")

    @has_organization_projects.setter
    def has_organization_projects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_organization_projects", value)

    @property
    @pulumi.getter(name="hasRepositoryProjects")
    def has_repository_projects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not repository projects are enabled for the organization.
        """
        return pulumi.get(self, "has_repository_projects")

    @has_repository_projects.setter
    def has_repository_projects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_repository_projects", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the organization.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="membersCanCreateInternalRepositories")
    def members_can_create_internal_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        """
        return pulumi.get(self, "members_can_create_internal_repositories")

    @members_can_create_internal_repositories.setter
    def members_can_create_internal_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_internal_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreatePages")
    def members_can_create_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_pages")

    @members_can_create_pages.setter
    def members_can_create_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePrivatePages")
    def members_can_create_private_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new private pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_pages")

    @members_can_create_private_pages.setter
    def members_can_create_private_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_private_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePrivateRepositories")
    def members_can_create_private_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new private repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_repositories")

    @members_can_create_private_repositories.setter
    def members_can_create_private_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_private_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreatePublicPages")
    def members_can_create_public_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new public pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_pages")

    @members_can_create_public_pages.setter
    def members_can_create_public_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_public_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePublicRepositories")
    def members_can_create_public_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new public repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_repositories")

    @members_can_create_public_repositories.setter
    def members_can_create_public_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_public_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreateRepositories")
    def members_can_create_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_repositories")

    @members_can_create_repositories.setter
    def members_can_create_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_repositories", value)

    @property
    @pulumi.getter(name="membersCanForkPrivateRepositories")
    def members_can_fork_private_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can fork private repositories. Defaults to `false`.
        """
        return pulumi.get(self, "members_can_fork_private_repositories")

    @members_can_fork_private_repositories.setter
    def members_can_fork_private_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_fork_private_repositories", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretScanningEnabledForNewRepositories")
    def secret_scanning_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_enabled_for_new_repositories")

    @secret_scanning_enabled_for_new_repositories.setter
    def secret_scanning_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secret_scanning_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="secretScanningPushProtectionEnabledForNewRepositories")
    def secret_scanning_push_protection_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_push_protection_enabled_for_new_repositories")

    @secret_scanning_push_protection_enabled_for_new_repositories.setter
    def secret_scanning_push_protection_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secret_scanning_push_protection_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="twitterUsername")
    def twitter_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Twitter username for the organization.
        """
        return pulumi.get(self, "twitter_username")

    @twitter_username.setter
    def twitter_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "twitter_username", value)

    @property
    @pulumi.getter(name="webCommitSignoffRequired")
    def web_commit_signoff_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        return pulumi.get(self, "web_commit_signoff_required")

    @web_commit_signoff_required.setter
    def web_commit_signoff_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_commit_signoff_required", value)


@pulumi.input_type
class _OrganizationSettingsState:
    def __init__(__self__, *,
                 advanced_security_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_email: Optional[pulumi.Input[builtins.str]] = None,
                 blog: Optional[pulumi.Input[builtins.str]] = None,
                 company: Optional[pulumi.Input[builtins.str]] = None,
                 default_repository_permission: Optional[pulumi.Input[builtins.str]] = None,
                 dependabot_alerts_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependabot_security_updates_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependency_graph_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 has_organization_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 has_repository_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 members_can_create_internal_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_fork_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_scanning_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_scanning_push_protection_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 twitter_username: Optional[pulumi.Input[builtins.str]] = None,
                 web_commit_signoff_required: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering OrganizationSettings resources.
        :param pulumi.Input[builtins.bool] advanced_security_enabled_for_new_repositories: Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] billing_email: The billing email address for the organization.
        :param pulumi.Input[builtins.str] blog: The blog URL for the organization.
        :param pulumi.Input[builtins.str] company: The company name for the organization.
        :param pulumi.Input[builtins.str] default_repository_permission: The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        :param pulumi.Input[builtins.bool] dependabot_alerts_enabled_for_new_repositories: Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependabot_security_updates_enabled_for_new_repositories: Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependency_graph_enabled_for_new_repositories: Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: The description for the organization.
        :param pulumi.Input[builtins.str] email: The email address for the organization.
        :param pulumi.Input[builtins.bool] has_organization_projects: Whether or not organization projects are enabled for the organization.
        :param pulumi.Input[builtins.bool] has_repository_projects: Whether or not repository projects are enabled for the organization.
        :param pulumi.Input[builtins.str] location: The location for the organization.
        :param pulumi.Input[builtins.bool] members_can_create_internal_repositories: Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        :param pulumi.Input[builtins.bool] members_can_create_pages: Whether or not organization members can create new pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_pages: Whether or not organization members can create new private pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_repositories: Whether or not organization members can create new private repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_pages: Whether or not organization members can create new public pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_repositories: Whether or not organization members can create new public repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_repositories: Whether or not organization members can create new repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_fork_private_repositories: Whether or not organization members can fork private repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name for the organization.
        :param pulumi.Input[builtins.bool] secret_scanning_enabled_for_new_repositories: Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] secret_scanning_push_protection_enabled_for_new_repositories: Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] twitter_username: The Twitter username for the organization.
        :param pulumi.Input[builtins.bool] web_commit_signoff_required: Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        if advanced_security_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "advanced_security_enabled_for_new_repositories", advanced_security_enabled_for_new_repositories)
        if billing_email is not None:
            pulumi.set(__self__, "billing_email", billing_email)
        if blog is not None:
            pulumi.set(__self__, "blog", blog)
        if company is not None:
            pulumi.set(__self__, "company", company)
        if default_repository_permission is not None:
            pulumi.set(__self__, "default_repository_permission", default_repository_permission)
        if dependabot_alerts_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependabot_alerts_enabled_for_new_repositories", dependabot_alerts_enabled_for_new_repositories)
        if dependabot_security_updates_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependabot_security_updates_enabled_for_new_repositories", dependabot_security_updates_enabled_for_new_repositories)
        if dependency_graph_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "dependency_graph_enabled_for_new_repositories", dependency_graph_enabled_for_new_repositories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if has_organization_projects is not None:
            pulumi.set(__self__, "has_organization_projects", has_organization_projects)
        if has_repository_projects is not None:
            pulumi.set(__self__, "has_repository_projects", has_repository_projects)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if members_can_create_internal_repositories is not None:
            pulumi.set(__self__, "members_can_create_internal_repositories", members_can_create_internal_repositories)
        if members_can_create_pages is not None:
            pulumi.set(__self__, "members_can_create_pages", members_can_create_pages)
        if members_can_create_private_pages is not None:
            pulumi.set(__self__, "members_can_create_private_pages", members_can_create_private_pages)
        if members_can_create_private_repositories is not None:
            pulumi.set(__self__, "members_can_create_private_repositories", members_can_create_private_repositories)
        if members_can_create_public_pages is not None:
            pulumi.set(__self__, "members_can_create_public_pages", members_can_create_public_pages)
        if members_can_create_public_repositories is not None:
            pulumi.set(__self__, "members_can_create_public_repositories", members_can_create_public_repositories)
        if members_can_create_repositories is not None:
            pulumi.set(__self__, "members_can_create_repositories", members_can_create_repositories)
        if members_can_fork_private_repositories is not None:
            pulumi.set(__self__, "members_can_fork_private_repositories", members_can_fork_private_repositories)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_scanning_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "secret_scanning_enabled_for_new_repositories", secret_scanning_enabled_for_new_repositories)
        if secret_scanning_push_protection_enabled_for_new_repositories is not None:
            pulumi.set(__self__, "secret_scanning_push_protection_enabled_for_new_repositories", secret_scanning_push_protection_enabled_for_new_repositories)
        if twitter_username is not None:
            pulumi.set(__self__, "twitter_username", twitter_username)
        if web_commit_signoff_required is not None:
            pulumi.set(__self__, "web_commit_signoff_required", web_commit_signoff_required)

    @property
    @pulumi.getter(name="advancedSecurityEnabledForNewRepositories")
    def advanced_security_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_security_enabled_for_new_repositories")

    @advanced_security_enabled_for_new_repositories.setter
    def advanced_security_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "advanced_security_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="billingEmail")
    def billing_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing email address for the organization.
        """
        return pulumi.get(self, "billing_email")

    @billing_email.setter
    def billing_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_email", value)

    @property
    @pulumi.getter
    def blog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The blog URL for the organization.
        """
        return pulumi.get(self, "blog")

    @blog.setter
    def blog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blog", value)

    @property
    @pulumi.getter
    def company(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The company name for the organization.
        """
        return pulumi.get(self, "company")

    @company.setter
    def company(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "company", value)

    @property
    @pulumi.getter(name="defaultRepositoryPermission")
    def default_repository_permission(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        """
        return pulumi.get(self, "default_repository_permission")

    @default_repository_permission.setter
    def default_repository_permission(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_repository_permission", value)

    @property
    @pulumi.getter(name="dependabotAlertsEnabledForNewRepositories")
    def dependabot_alerts_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_alerts_enabled_for_new_repositories")

    @dependabot_alerts_enabled_for_new_repositories.setter
    def dependabot_alerts_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependabot_alerts_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="dependabotSecurityUpdatesEnabledForNewRepositories")
    def dependabot_security_updates_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_security_updates_enabled_for_new_repositories")

    @dependabot_security_updates_enabled_for_new_repositories.setter
    def dependabot_security_updates_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependabot_security_updates_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="dependencyGraphEnabledForNewRepositories")
    def dependency_graph_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependency_graph_enabled_for_new_repositories")

    @dependency_graph_enabled_for_new_repositories.setter
    def dependency_graph_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dependency_graph_enabled_for_new_repositories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address for the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="hasOrganizationProjects")
    def has_organization_projects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization projects are enabled for the organization.
        """
        return pulumi.get(self, "has_organization_projects")

    @has_organization_projects.setter
    def has_organization_projects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_organization_projects", value)

    @property
    @pulumi.getter(name="hasRepositoryProjects")
    def has_repository_projects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not repository projects are enabled for the organization.
        """
        return pulumi.get(self, "has_repository_projects")

    @has_repository_projects.setter
    def has_repository_projects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_repository_projects", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the organization.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="membersCanCreateInternalRepositories")
    def members_can_create_internal_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        """
        return pulumi.get(self, "members_can_create_internal_repositories")

    @members_can_create_internal_repositories.setter
    def members_can_create_internal_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_internal_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreatePages")
    def members_can_create_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_pages")

    @members_can_create_pages.setter
    def members_can_create_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePrivatePages")
    def members_can_create_private_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new private pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_pages")

    @members_can_create_private_pages.setter
    def members_can_create_private_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_private_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePrivateRepositories")
    def members_can_create_private_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new private repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_repositories")

    @members_can_create_private_repositories.setter
    def members_can_create_private_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_private_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreatePublicPages")
    def members_can_create_public_pages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new public pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_pages")

    @members_can_create_public_pages.setter
    def members_can_create_public_pages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_public_pages", value)

    @property
    @pulumi.getter(name="membersCanCreatePublicRepositories")
    def members_can_create_public_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new public repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_repositories")

    @members_can_create_public_repositories.setter
    def members_can_create_public_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_public_repositories", value)

    @property
    @pulumi.getter(name="membersCanCreateRepositories")
    def members_can_create_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can create new repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_repositories")

    @members_can_create_repositories.setter
    def members_can_create_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_create_repositories", value)

    @property
    @pulumi.getter(name="membersCanForkPrivateRepositories")
    def members_can_fork_private_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not organization members can fork private repositories. Defaults to `false`.
        """
        return pulumi.get(self, "members_can_fork_private_repositories")

    @members_can_fork_private_repositories.setter
    def members_can_fork_private_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "members_can_fork_private_repositories", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretScanningEnabledForNewRepositories")
    def secret_scanning_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_enabled_for_new_repositories")

    @secret_scanning_enabled_for_new_repositories.setter
    def secret_scanning_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secret_scanning_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="secretScanningPushProtectionEnabledForNewRepositories")
    def secret_scanning_push_protection_enabled_for_new_repositories(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_push_protection_enabled_for_new_repositories")

    @secret_scanning_push_protection_enabled_for_new_repositories.setter
    def secret_scanning_push_protection_enabled_for_new_repositories(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secret_scanning_push_protection_enabled_for_new_repositories", value)

    @property
    @pulumi.getter(name="twitterUsername")
    def twitter_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Twitter username for the organization.
        """
        return pulumi.get(self, "twitter_username")

    @twitter_username.setter
    def twitter_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "twitter_username", value)

    @property
    @pulumi.getter(name="webCommitSignoffRequired")
    def web_commit_signoff_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        return pulumi.get(self, "web_commit_signoff_required")

    @web_commit_signoff_required.setter
    def web_commit_signoff_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_commit_signoff_required", value)


@pulumi.type_token("github:index/organizationSettings:OrganizationSettings")
class OrganizationSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_security_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_email: Optional[pulumi.Input[builtins.str]] = None,
                 blog: Optional[pulumi.Input[builtins.str]] = None,
                 company: Optional[pulumi.Input[builtins.str]] = None,
                 default_repository_permission: Optional[pulumi.Input[builtins.str]] = None,
                 dependabot_alerts_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependabot_security_updates_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependency_graph_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 has_organization_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 has_repository_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 members_can_create_internal_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_fork_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_scanning_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_scanning_push_protection_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 twitter_username: Optional[pulumi.Input[builtins.str]] = None,
                 web_commit_signoff_required: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage settings for a GitHub Organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        test = github.OrganizationSettings("test",
            billing_email="test@example.com",
            company="Test Company",
            blog="https://example.com",
            email="test@example.com",
            twitter_username="Test",
            location="Test Location",
            name="Test Name",
            description="Test Description",
            has_organization_projects=True,
            has_repository_projects=True,
            default_repository_permission="read",
            members_can_create_repositories=True,
            members_can_create_public_repositories=True,
            members_can_create_private_repositories=True,
            members_can_create_internal_repositories=True,
            members_can_create_pages=True,
            members_can_create_public_pages=True,
            members_can_create_private_pages=True,
            members_can_fork_private_repositories=True,
            web_commit_signoff_required=True,
            advanced_security_enabled_for_new_repositories=False,
            dependabot_alerts_enabled_for_new_repositories=False,
            dependabot_security_updates_enabled_for_new_repositories=False,
            dependency_graph_enabled_for_new_repositories=False,
            secret_scanning_enabled_for_new_repositories=False,
            secret_scanning_push_protection_enabled_for_new_repositories=False)
        ```

        ## Import

        Organization settings can be imported using the `id` of the organization.
        The `id` of the organization can be found using the [get an organization](https://docs.github.com/en/rest/orgs/orgs#get-an-organization) API.

        ```sh
        $ pulumi import github:index/organizationSettings:OrganizationSettings test 123456789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] advanced_security_enabled_for_new_repositories: Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] billing_email: The billing email address for the organization.
        :param pulumi.Input[builtins.str] blog: The blog URL for the organization.
        :param pulumi.Input[builtins.str] company: The company name for the organization.
        :param pulumi.Input[builtins.str] default_repository_permission: The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        :param pulumi.Input[builtins.bool] dependabot_alerts_enabled_for_new_repositories: Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependabot_security_updates_enabled_for_new_repositories: Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependency_graph_enabled_for_new_repositories: Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: The description for the organization.
        :param pulumi.Input[builtins.str] email: The email address for the organization.
        :param pulumi.Input[builtins.bool] has_organization_projects: Whether or not organization projects are enabled for the organization.
        :param pulumi.Input[builtins.bool] has_repository_projects: Whether or not repository projects are enabled for the organization.
        :param pulumi.Input[builtins.str] location: The location for the organization.
        :param pulumi.Input[builtins.bool] members_can_create_internal_repositories: Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        :param pulumi.Input[builtins.bool] members_can_create_pages: Whether or not organization members can create new pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_pages: Whether or not organization members can create new private pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_repositories: Whether or not organization members can create new private repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_pages: Whether or not organization members can create new public pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_repositories: Whether or not organization members can create new public repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_repositories: Whether or not organization members can create new repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_fork_private_repositories: Whether or not organization members can fork private repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name for the organization.
        :param pulumi.Input[builtins.bool] secret_scanning_enabled_for_new_repositories: Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] secret_scanning_push_protection_enabled_for_new_repositories: Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] twitter_username: The Twitter username for the organization.
        :param pulumi.Input[builtins.bool] web_commit_signoff_required: Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage settings for a GitHub Organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        test = github.OrganizationSettings("test",
            billing_email="test@example.com",
            company="Test Company",
            blog="https://example.com",
            email="test@example.com",
            twitter_username="Test",
            location="Test Location",
            name="Test Name",
            description="Test Description",
            has_organization_projects=True,
            has_repository_projects=True,
            default_repository_permission="read",
            members_can_create_repositories=True,
            members_can_create_public_repositories=True,
            members_can_create_private_repositories=True,
            members_can_create_internal_repositories=True,
            members_can_create_pages=True,
            members_can_create_public_pages=True,
            members_can_create_private_pages=True,
            members_can_fork_private_repositories=True,
            web_commit_signoff_required=True,
            advanced_security_enabled_for_new_repositories=False,
            dependabot_alerts_enabled_for_new_repositories=False,
            dependabot_security_updates_enabled_for_new_repositories=False,
            dependency_graph_enabled_for_new_repositories=False,
            secret_scanning_enabled_for_new_repositories=False,
            secret_scanning_push_protection_enabled_for_new_repositories=False)
        ```

        ## Import

        Organization settings can be imported using the `id` of the organization.
        The `id` of the organization can be found using the [get an organization](https://docs.github.com/en/rest/orgs/orgs#get-an-organization) API.

        ```sh
        $ pulumi import github:index/organizationSettings:OrganizationSettings test 123456789
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_security_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_email: Optional[pulumi.Input[builtins.str]] = None,
                 blog: Optional[pulumi.Input[builtins.str]] = None,
                 company: Optional[pulumi.Input[builtins.str]] = None,
                 default_repository_permission: Optional[pulumi.Input[builtins.str]] = None,
                 dependabot_alerts_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependabot_security_updates_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 dependency_graph_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 has_organization_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 has_repository_projects: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 members_can_create_internal_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_pages: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_create_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 members_can_fork_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_scanning_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_scanning_push_protection_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
                 twitter_username: Optional[pulumi.Input[builtins.str]] = None,
                 web_commit_signoff_required: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationSettingsArgs.__new__(OrganizationSettingsArgs)

            __props__.__dict__["advanced_security_enabled_for_new_repositories"] = advanced_security_enabled_for_new_repositories
            if billing_email is None and not opts.urn:
                raise TypeError("Missing required property 'billing_email'")
            __props__.__dict__["billing_email"] = billing_email
            __props__.__dict__["blog"] = blog
            __props__.__dict__["company"] = company
            __props__.__dict__["default_repository_permission"] = default_repository_permission
            __props__.__dict__["dependabot_alerts_enabled_for_new_repositories"] = dependabot_alerts_enabled_for_new_repositories
            __props__.__dict__["dependabot_security_updates_enabled_for_new_repositories"] = dependabot_security_updates_enabled_for_new_repositories
            __props__.__dict__["dependency_graph_enabled_for_new_repositories"] = dependency_graph_enabled_for_new_repositories
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["has_organization_projects"] = has_organization_projects
            __props__.__dict__["has_repository_projects"] = has_repository_projects
            __props__.__dict__["location"] = location
            __props__.__dict__["members_can_create_internal_repositories"] = members_can_create_internal_repositories
            __props__.__dict__["members_can_create_pages"] = members_can_create_pages
            __props__.__dict__["members_can_create_private_pages"] = members_can_create_private_pages
            __props__.__dict__["members_can_create_private_repositories"] = members_can_create_private_repositories
            __props__.__dict__["members_can_create_public_pages"] = members_can_create_public_pages
            __props__.__dict__["members_can_create_public_repositories"] = members_can_create_public_repositories
            __props__.__dict__["members_can_create_repositories"] = members_can_create_repositories
            __props__.__dict__["members_can_fork_private_repositories"] = members_can_fork_private_repositories
            __props__.__dict__["name"] = name
            __props__.__dict__["secret_scanning_enabled_for_new_repositories"] = secret_scanning_enabled_for_new_repositories
            __props__.__dict__["secret_scanning_push_protection_enabled_for_new_repositories"] = secret_scanning_push_protection_enabled_for_new_repositories
            __props__.__dict__["twitter_username"] = twitter_username
            __props__.__dict__["web_commit_signoff_required"] = web_commit_signoff_required
        super(OrganizationSettings, __self__).__init__(
            'github:index/organizationSettings:OrganizationSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_security_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            billing_email: Optional[pulumi.Input[builtins.str]] = None,
            blog: Optional[pulumi.Input[builtins.str]] = None,
            company: Optional[pulumi.Input[builtins.str]] = None,
            default_repository_permission: Optional[pulumi.Input[builtins.str]] = None,
            dependabot_alerts_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            dependabot_security_updates_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            dependency_graph_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            has_organization_projects: Optional[pulumi.Input[builtins.bool]] = None,
            has_repository_projects: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            members_can_create_internal_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_pages: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_private_pages: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_public_pages: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_public_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_create_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            members_can_fork_private_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            secret_scanning_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            secret_scanning_push_protection_enabled_for_new_repositories: Optional[pulumi.Input[builtins.bool]] = None,
            twitter_username: Optional[pulumi.Input[builtins.str]] = None,
            web_commit_signoff_required: Optional[pulumi.Input[builtins.bool]] = None) -> 'OrganizationSettings':
        """
        Get an existing OrganizationSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] advanced_security_enabled_for_new_repositories: Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] billing_email: The billing email address for the organization.
        :param pulumi.Input[builtins.str] blog: The blog URL for the organization.
        :param pulumi.Input[builtins.str] company: The company name for the organization.
        :param pulumi.Input[builtins.str] default_repository_permission: The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        :param pulumi.Input[builtins.bool] dependabot_alerts_enabled_for_new_repositories: Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependabot_security_updates_enabled_for_new_repositories: Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] dependency_graph_enabled_for_new_repositories: Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: The description for the organization.
        :param pulumi.Input[builtins.str] email: The email address for the organization.
        :param pulumi.Input[builtins.bool] has_organization_projects: Whether or not organization projects are enabled for the organization.
        :param pulumi.Input[builtins.bool] has_repository_projects: Whether or not repository projects are enabled for the organization.
        :param pulumi.Input[builtins.str] location: The location for the organization.
        :param pulumi.Input[builtins.bool] members_can_create_internal_repositories: Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        :param pulumi.Input[builtins.bool] members_can_create_pages: Whether or not organization members can create new pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_pages: Whether or not organization members can create new private pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_private_repositories: Whether or not organization members can create new private repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_pages: Whether or not organization members can create new public pages. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_public_repositories: Whether or not organization members can create new public repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_create_repositories: Whether or not organization members can create new repositories. Defaults to `true`.
        :param pulumi.Input[builtins.bool] members_can_fork_private_repositories: Whether or not organization members can fork private repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name for the organization.
        :param pulumi.Input[builtins.bool] secret_scanning_enabled_for_new_repositories: Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.bool] secret_scanning_push_protection_enabled_for_new_repositories: Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        :param pulumi.Input[builtins.str] twitter_username: The Twitter username for the organization.
        :param pulumi.Input[builtins.bool] web_commit_signoff_required: Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationSettingsState.__new__(_OrganizationSettingsState)

        __props__.__dict__["advanced_security_enabled_for_new_repositories"] = advanced_security_enabled_for_new_repositories
        __props__.__dict__["billing_email"] = billing_email
        __props__.__dict__["blog"] = blog
        __props__.__dict__["company"] = company
        __props__.__dict__["default_repository_permission"] = default_repository_permission
        __props__.__dict__["dependabot_alerts_enabled_for_new_repositories"] = dependabot_alerts_enabled_for_new_repositories
        __props__.__dict__["dependabot_security_updates_enabled_for_new_repositories"] = dependabot_security_updates_enabled_for_new_repositories
        __props__.__dict__["dependency_graph_enabled_for_new_repositories"] = dependency_graph_enabled_for_new_repositories
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["has_organization_projects"] = has_organization_projects
        __props__.__dict__["has_repository_projects"] = has_repository_projects
        __props__.__dict__["location"] = location
        __props__.__dict__["members_can_create_internal_repositories"] = members_can_create_internal_repositories
        __props__.__dict__["members_can_create_pages"] = members_can_create_pages
        __props__.__dict__["members_can_create_private_pages"] = members_can_create_private_pages
        __props__.__dict__["members_can_create_private_repositories"] = members_can_create_private_repositories
        __props__.__dict__["members_can_create_public_pages"] = members_can_create_public_pages
        __props__.__dict__["members_can_create_public_repositories"] = members_can_create_public_repositories
        __props__.__dict__["members_can_create_repositories"] = members_can_create_repositories
        __props__.__dict__["members_can_fork_private_repositories"] = members_can_fork_private_repositories
        __props__.__dict__["name"] = name
        __props__.__dict__["secret_scanning_enabled_for_new_repositories"] = secret_scanning_enabled_for_new_repositories
        __props__.__dict__["secret_scanning_push_protection_enabled_for_new_repositories"] = secret_scanning_push_protection_enabled_for_new_repositories
        __props__.__dict__["twitter_username"] = twitter_username
        __props__.__dict__["web_commit_signoff_required"] = web_commit_signoff_required
        return OrganizationSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedSecurityEnabledForNewRepositories")
    def advanced_security_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not advanced security is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_security_enabled_for_new_repositories")

    @property
    @pulumi.getter(name="billingEmail")
    def billing_email(self) -> pulumi.Output[builtins.str]:
        """
        The billing email address for the organization.
        """
        return pulumi.get(self, "billing_email")

    @property
    @pulumi.getter
    def blog(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The blog URL for the organization.
        """
        return pulumi.get(self, "blog")

    @property
    @pulumi.getter
    def company(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The company name for the organization.
        """
        return pulumi.get(self, "company")

    @property
    @pulumi.getter(name="defaultRepositoryPermission")
    def default_repository_permission(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default permission for organization members to create new repositories. Can be one of `read`, `write`, `admin`, or `none`. Defaults to `read`.
        """
        return pulumi.get(self, "default_repository_permission")

    @property
    @pulumi.getter(name="dependabotAlertsEnabledForNewRepositories")
    def dependabot_alerts_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not dependabot alerts are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_alerts_enabled_for_new_repositories")

    @property
    @pulumi.getter(name="dependabotSecurityUpdatesEnabledForNewRepositories")
    def dependabot_security_updates_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not dependabot security updates are enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependabot_security_updates_enabled_for_new_repositories")

    @property
    @pulumi.getter(name="dependencyGraphEnabledForNewRepositories")
    def dependency_graph_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not dependency graph is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "dependency_graph_enabled_for_new_repositories")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The email address for the organization.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="hasOrganizationProjects")
    def has_organization_projects(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization projects are enabled for the organization.
        """
        return pulumi.get(self, "has_organization_projects")

    @property
    @pulumi.getter(name="hasRepositoryProjects")
    def has_repository_projects(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not repository projects are enabled for the organization.
        """
        return pulumi.get(self, "has_repository_projects")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location for the organization.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="membersCanCreateInternalRepositories")
    def members_can_create_internal_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new internal repositories. For Enterprise Organizations only.
        """
        return pulumi.get(self, "members_can_create_internal_repositories")

    @property
    @pulumi.getter(name="membersCanCreatePages")
    def members_can_create_pages(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_pages")

    @property
    @pulumi.getter(name="membersCanCreatePrivatePages")
    def members_can_create_private_pages(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new private pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_pages")

    @property
    @pulumi.getter(name="membersCanCreatePrivateRepositories")
    def members_can_create_private_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new private repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_private_repositories")

    @property
    @pulumi.getter(name="membersCanCreatePublicPages")
    def members_can_create_public_pages(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new public pages. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_pages")

    @property
    @pulumi.getter(name="membersCanCreatePublicRepositories")
    def members_can_create_public_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new public repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_public_repositories")

    @property
    @pulumi.getter(name="membersCanCreateRepositories")
    def members_can_create_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can create new repositories. Defaults to `true`.
        """
        return pulumi.get(self, "members_can_create_repositories")

    @property
    @pulumi.getter(name="membersCanForkPrivateRepositories")
    def members_can_fork_private_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not organization members can fork private repositories. Defaults to `false`.
        """
        return pulumi.get(self, "members_can_fork_private_repositories")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretScanningEnabledForNewRepositories")
    def secret_scanning_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not secret scanning is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_enabled_for_new_repositories")

    @property
    @pulumi.getter(name="secretScanningPushProtectionEnabledForNewRepositories")
    def secret_scanning_push_protection_enabled_for_new_repositories(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not secret scanning push protection is enabled for new repositories. Defaults to `false`.
        """
        return pulumi.get(self, "secret_scanning_push_protection_enabled_for_new_repositories")

    @property
    @pulumi.getter(name="twitterUsername")
    def twitter_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Twitter username for the organization.
        """
        return pulumi.get(self, "twitter_username")

    @property
    @pulumi.getter(name="webCommitSignoffRequired")
    def web_commit_signoff_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not commit signatures are required for commits to the organization. Defaults to `false`.
        """
        return pulumi.get(self, "web_commit_signoff_required")

