# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserSshKeyArgs', 'UserSshKey']

@pulumi.input_type
class UserSshKeyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a UserSshKey resource.
        :param pulumi.Input[builtins.str] key: The public SSH key to add to your GitHub account.
        :param pulumi.Input[builtins.str] title: A descriptive name for the new key. e.g. `Personal MacBook Air`
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The public SSH key to add to your GitHub account.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A descriptive name for the new key. e.g. `Personal MacBook Air`
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class _UserSshKeyState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserSshKey resources.
        :param pulumi.Input[builtins.str] key: The public SSH key to add to your GitHub account.
        :param pulumi.Input[builtins.str] title: A descriptive name for the new key. e.g. `Personal MacBook Air`
        :param pulumi.Input[builtins.str] url: The URL of the SSH key
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public SSH key to add to your GitHub account.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A descriptive name for the new key. e.g. `Personal MacBook Air`
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the SSH key
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("github:index/userSshKey:UserSshKey")
class UserSshKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a GitHub user's SSH key resource.

        This resource allows you to add/remove SSH keys from your user account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github
        import pulumi_std as std

        example = github.UserSshKey("example",
            title="example title",
            key=std.file(input="~/.ssh/id_rsa.pub").result)
        ```

        ## Import

        SSH keys can be imported using their ID e.g.

        ```sh
        $ pulumi import github:index/userSshKey:UserSshKey example 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: The public SSH key to add to your GitHub account.
        :param pulumi.Input[builtins.str] title: A descriptive name for the new key. e.g. `Personal MacBook Air`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserSshKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GitHub user's SSH key resource.

        This resource allows you to add/remove SSH keys from your user account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github
        import pulumi_std as std

        example = github.UserSshKey("example",
            title="example title",
            key=std.file(input="~/.ssh/id_rsa.pub").result)
        ```

        ## Import

        SSH keys can be imported using their ID e.g.

        ```sh
        $ pulumi import github:index/userSshKey:UserSshKey example 1234567
        ```

        :param str resource_name: The name of the resource.
        :param UserSshKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserSshKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserSshKeyArgs.__new__(UserSshKeyArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["etag"] = None
            __props__.__dict__["url"] = None
        super(UserSshKey, __self__).__init__(
            'github:index/userSshKey:UserSshKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'UserSshKey':
        """
        Get an existing UserSshKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: The public SSH key to add to your GitHub account.
        :param pulumi.Input[builtins.str] title: A descriptive name for the new key. e.g. `Personal MacBook Air`
        :param pulumi.Input[builtins.str] url: The URL of the SSH key
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserSshKeyState.__new__(_UserSshKeyState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["key"] = key
        __props__.__dict__["title"] = title
        __props__.__dict__["url"] = url
        return UserSshKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The public SSH key to add to your GitHub account.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        A descriptive name for the new key. e.g. `Personal MacBook Air`
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the SSH key
        """
        return pulumi.get(self, "url")

