# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterV2Args', 'ClusterV2']

@pulumi.input_type
class ClusterV2Args:
    def __init__(__self__, *,
                 kubernetes_version: pulumi.Input[str],
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[str]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[str]] = None,
                 default_pod_security_policy_template_name: Optional[pulumi.Input[str]] = None,
                 enable_network_policy: Optional[pulumi.Input[bool]] = None,
                 fleet_namespace: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rke_config: Optional[pulumi.Input['ClusterV2RkeConfigArgs']] = None):
        """
        The set of arguments for constructing a ClusterV2 resource.
        :param pulumi.Input[str] kubernetes_version: The kubernetes version of the Cluster v2 (list maxitems:1)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]] agent_env_vars: Optional Agent Env Vars for Rancher agent (list)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for cluster registration token object (map)
        :param pulumi.Input[str] cloud_credential_secret_name: Cluster V2 cloud credential secret name (string)
        :param pulumi.Input[str] default_cluster_role_for_project_members: Cluster V2 default cluster role for project members (string)
        :param pulumi.Input[str] default_pod_security_policy_template_name: Cluster V2 default pod security policy template name (string)
        :param pulumi.Input[bool] enable_network_policy: Enable k8s network policy at Cluster V2 (bool)
        :param pulumi.Input[str] fleet_namespace: The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for cluster registration token object (map)
        :param pulumi.Input['ClusterV2LocalAuthEndpointArgs'] local_auth_endpoint: Use rancher2_cluster_v2.local_auth_endpoint instead
        :param pulumi.Input[str] name: Name of cluster registration token (string)
        :param pulumi.Input['ClusterV2RkeConfigArgs'] rke_config: The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cloud_credential_secret_name is not None:
            pulumi.set(__self__, "cloud_credential_secret_name", cloud_credential_secret_name)
        if default_cluster_role_for_project_members is not None:
            pulumi.set(__self__, "default_cluster_role_for_project_members", default_cluster_role_for_project_members)
        if default_pod_security_policy_template_name is not None:
            pulumi.set(__self__, "default_pod_security_policy_template_name", default_pod_security_policy_template_name)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_namespace is not None:
            pulumi.set(__self__, "fleet_namespace", fleet_namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_auth_endpoint is not None:
            pulumi.set(__self__, "local_auth_endpoint", local_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Input[str]:
        """
        The kubernetes version of the Cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]:
        """
        Optional Agent Env Vars for Rancher agent (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Annotations for cluster registration token object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 cloud credential secret name (string)
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @cloud_credential_secret_name.setter
    def cloud_credential_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_credential_secret_name", value)

    @property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 default cluster role for project members (string)
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @default_cluster_role_for_project_members.setter
    def default_cluster_role_for_project_members(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_cluster_role_for_project_members", value)

    @property
    @pulumi.getter(name="defaultPodSecurityPolicyTemplateName")
    def default_pod_security_policy_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 default pod security policy template name (string)
        """
        return pulumi.get(self, "default_pod_security_policy_template_name")

    @default_pod_security_policy_template_name.setter
    def default_pod_security_policy_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pod_security_policy_template_name", value)

    @property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable k8s network policy at Cluster V2 (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        """
        return pulumi.get(self, "fleet_namespace")

    @fleet_namespace.setter
    def fleet_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_namespace", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Labels for cluster registration token object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]:
        """
        Use rancher2_cluster_v2.local_auth_endpoint instead
        """
        return pulumi.get(self, "local_auth_endpoint")

    @local_auth_endpoint.setter
    def local_auth_endpoint(self, value: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]):
        pulumi.set(self, "local_auth_endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of cluster registration token (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterV2RkeConfigArgs']]:
        """
        The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterV2RkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)


@pulumi.input_type
class _ClusterV2State:
    def __init__(__self__, *,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[str]] = None,
                 cluster_registration_token: Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']] = None,
                 cluster_v1_id: Optional[pulumi.Input[str]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[str]] = None,
                 default_pod_security_policy_template_name: Optional[pulumi.Input[str]] = None,
                 enable_network_policy: Optional[pulumi.Input[bool]] = None,
                 fleet_namespace: Optional[pulumi.Input[str]] = None,
                 kube_config: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 rke_config: Optional[pulumi.Input['ClusterV2RkeConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ClusterV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]] agent_env_vars: Optional Agent Env Vars for Rancher agent (list)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for cluster registration token object (map)
        :param pulumi.Input[str] cloud_credential_secret_name: Cluster V2 cloud credential secret name (string)
        :param pulumi.Input['ClusterV2ClusterRegistrationTokenArgs'] cluster_registration_token: (Computed/Sensitive) Cluster Registration Token generated for the cluster v2 (list maxitems:1)
        :param pulumi.Input[str] cluster_v1_id: (Computed) Cluster v1 id for cluster v2. (e.g to be used with `rancher2_sync`) (string)
        :param pulumi.Input[str] default_cluster_role_for_project_members: Cluster V2 default cluster role for project members (string)
        :param pulumi.Input[str] default_pod_security_policy_template_name: Cluster V2 default pod security policy template name (string)
        :param pulumi.Input[bool] enable_network_policy: Enable k8s network policy at Cluster V2 (bool)
        :param pulumi.Input[str] fleet_namespace: The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        :param pulumi.Input[str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster v2. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        :param pulumi.Input[str] kubernetes_version: The kubernetes version of the Cluster v2 (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for cluster registration token object (map)
        :param pulumi.Input['ClusterV2LocalAuthEndpointArgs'] local_auth_endpoint: Use rancher2_cluster_v2.local_auth_endpoint instead
        :param pulumi.Input[str] name: Name of cluster registration token (string)
        :param pulumi.Input[str] resource_version: (Computed) Cluster v2 k8s resource version (string)
        :param pulumi.Input['ClusterV2RkeConfigArgs'] rke_config: The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cloud_credential_secret_name is not None:
            pulumi.set(__self__, "cloud_credential_secret_name", cloud_credential_secret_name)
        if cluster_registration_token is not None:
            pulumi.set(__self__, "cluster_registration_token", cluster_registration_token)
        if cluster_v1_id is not None:
            pulumi.set(__self__, "cluster_v1_id", cluster_v1_id)
        if default_cluster_role_for_project_members is not None:
            pulumi.set(__self__, "default_cluster_role_for_project_members", default_cluster_role_for_project_members)
        if default_pod_security_policy_template_name is not None:
            pulumi.set(__self__, "default_pod_security_policy_template_name", default_pod_security_policy_template_name)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_namespace is not None:
            pulumi.set(__self__, "fleet_namespace", fleet_namespace)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_auth_endpoint is not None:
            pulumi.set(__self__, "local_auth_endpoint", local_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)

    @property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]:
        """
        Optional Agent Env Vars for Rancher agent (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Annotations for cluster registration token object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 cloud credential secret name (string)
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @cloud_credential_secret_name.setter
    def cloud_credential_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_credential_secret_name", value)

    @property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']]:
        """
        (Computed/Sensitive) Cluster Registration Token generated for the cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "cluster_registration_token")

    @cluster_registration_token.setter
    def cluster_registration_token(self, value: Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']]):
        pulumi.set(self, "cluster_registration_token", value)

    @property
    @pulumi.getter(name="clusterV1Id")
    def cluster_v1_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Cluster v1 id for cluster v2. (e.g to be used with `rancher2_sync`) (string)
        """
        return pulumi.get(self, "cluster_v1_id")

    @cluster_v1_id.setter
    def cluster_v1_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_v1_id", value)

    @property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 default cluster role for project members (string)
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @default_cluster_role_for_project_members.setter
    def default_cluster_role_for_project_members(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_cluster_role_for_project_members", value)

    @property
    @pulumi.getter(name="defaultPodSecurityPolicyTemplateName")
    def default_pod_security_policy_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster V2 default pod security policy template name (string)
        """
        return pulumi.get(self, "default_pod_security_policy_template_name")

    @default_pod_security_policy_template_name.setter
    def default_pod_security_policy_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pod_security_policy_template_name", value)

    @property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable k8s network policy at Cluster V2 (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        """
        return pulumi.get(self, "fleet_namespace")

    @fleet_namespace.setter
    def fleet_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_namespace", value)

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster v2. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_config", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes version of the Cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Labels for cluster registration token object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]:
        """
        Use rancher2_cluster_v2.local_auth_endpoint instead
        """
        return pulumi.get(self, "local_auth_endpoint")

    @local_auth_endpoint.setter
    def local_auth_endpoint(self, value: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]):
        pulumi.set(self, "local_auth_endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of cluster registration token (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Cluster v2 k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterV2RkeConfigArgs']]:
        """
        The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterV2RkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)


class ClusterV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterV2AgentEnvVarArgs']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[str]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[str]] = None,
                 default_pod_security_policy_template_name: Optional[pulumi.Input[str]] = None,
                 enable_network_policy: Optional[pulumi.Input[bool]] = None,
                 fleet_namespace: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterV2LocalAuthEndpointArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rke_config: Optional[pulumi.Input[pulumi.InputType['ClusterV2RkeConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cluster v2 resource. This can be used to create RKE2 and K3S Clusters for Rancher v2 environments and retrieve their information. This resource is supported as tech preview from Rancher v2.6.0 and above.

        ## Example Usage
        ### Creating Rancher v2 custom cluster v2

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher v2 K3S custom Cluster v2
        foo = rancher2.ClusterV2("foo",
            default_cluster_role_for_project_members="user",
            enable_network_policy=False,
            fleet_namespace="fleet-ns",
            kubernetes_version="v1.21.4+k3s1")
        ```

        **Note** Once created, get the node command from `rancher2_cluster_v2.foo.cluster_registration_token`

        ## Import

        Clusters v2 can be imported using the Rancher Cluster v2 ID, that is in the form &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;

        ```sh
         $ pulumi import rancher2:index/clusterV2:ClusterV2 foo &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterV2AgentEnvVarArgs']]]] agent_env_vars: Optional Agent Env Vars for Rancher agent (list)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for cluster registration token object (map)
        :param pulumi.Input[str] cloud_credential_secret_name: Cluster V2 cloud credential secret name (string)
        :param pulumi.Input[str] default_cluster_role_for_project_members: Cluster V2 default cluster role for project members (string)
        :param pulumi.Input[str] default_pod_security_policy_template_name: Cluster V2 default pod security policy template name (string)
        :param pulumi.Input[bool] enable_network_policy: Enable k8s network policy at Cluster V2 (bool)
        :param pulumi.Input[str] fleet_namespace: The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        :param pulumi.Input[str] kubernetes_version: The kubernetes version of the Cluster v2 (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for cluster registration token object (map)
        :param pulumi.Input[pulumi.InputType['ClusterV2LocalAuthEndpointArgs']] local_auth_endpoint: Use rancher2_cluster_v2.local_auth_endpoint instead
        :param pulumi.Input[str] name: Name of cluster registration token (string)
        :param pulumi.Input[pulumi.InputType['ClusterV2RkeConfigArgs']] rke_config: The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cluster v2 resource. This can be used to create RKE2 and K3S Clusters for Rancher v2 environments and retrieve their information. This resource is supported as tech preview from Rancher v2.6.0 and above.

        ## Example Usage
        ### Creating Rancher v2 custom cluster v2

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher v2 K3S custom Cluster v2
        foo = rancher2.ClusterV2("foo",
            default_cluster_role_for_project_members="user",
            enable_network_policy=False,
            fleet_namespace="fleet-ns",
            kubernetes_version="v1.21.4+k3s1")
        ```

        **Note** Once created, get the node command from `rancher2_cluster_v2.foo.cluster_registration_token`

        ## Import

        Clusters v2 can be imported using the Rancher Cluster v2 ID, that is in the form &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;

        ```sh
         $ pulumi import rancher2:index/clusterV2:ClusterV2 foo &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;
        ```

        :param str resource_name: The name of the resource.
        :param ClusterV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterV2AgentEnvVarArgs']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[str]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[str]] = None,
                 default_pod_security_policy_template_name: Optional[pulumi.Input[str]] = None,
                 enable_network_policy: Optional[pulumi.Input[bool]] = None,
                 fleet_namespace: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterV2LocalAuthEndpointArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rke_config: Optional[pulumi.Input[pulumi.InputType['ClusterV2RkeConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterV2Args.__new__(ClusterV2Args)

            __props__.__dict__["agent_env_vars"] = agent_env_vars
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["cloud_credential_secret_name"] = cloud_credential_secret_name
            __props__.__dict__["default_cluster_role_for_project_members"] = default_cluster_role_for_project_members
            __props__.__dict__["default_pod_security_policy_template_name"] = default_pod_security_policy_template_name
            __props__.__dict__["enable_network_policy"] = enable_network_policy
            __props__.__dict__["fleet_namespace"] = fleet_namespace
            if kubernetes_version is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_version'")
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["local_auth_endpoint"] = local_auth_endpoint
            __props__.__dict__["name"] = name
            __props__.__dict__["rke_config"] = rke_config
            __props__.__dict__["cluster_registration_token"] = None
            __props__.__dict__["cluster_v1_id"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["resource_version"] = None
        super(ClusterV2, __self__).__init__(
            'rancher2:index/clusterV2:ClusterV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterV2AgentEnvVarArgs']]]]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cloud_credential_secret_name: Optional[pulumi.Input[str]] = None,
            cluster_registration_token: Optional[pulumi.Input[pulumi.InputType['ClusterV2ClusterRegistrationTokenArgs']]] = None,
            cluster_v1_id: Optional[pulumi.Input[str]] = None,
            default_cluster_role_for_project_members: Optional[pulumi.Input[str]] = None,
            default_pod_security_policy_template_name: Optional[pulumi.Input[str]] = None,
            enable_network_policy: Optional[pulumi.Input[bool]] = None,
            fleet_namespace: Optional[pulumi.Input[str]] = None,
            kube_config: Optional[pulumi.Input[str]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            local_auth_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterV2LocalAuthEndpointArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            resource_version: Optional[pulumi.Input[str]] = None,
            rke_config: Optional[pulumi.Input[pulumi.InputType['ClusterV2RkeConfigArgs']]] = None) -> 'ClusterV2':
        """
        Get an existing ClusterV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterV2AgentEnvVarArgs']]]] agent_env_vars: Optional Agent Env Vars for Rancher agent (list)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for cluster registration token object (map)
        :param pulumi.Input[str] cloud_credential_secret_name: Cluster V2 cloud credential secret name (string)
        :param pulumi.Input[pulumi.InputType['ClusterV2ClusterRegistrationTokenArgs']] cluster_registration_token: (Computed/Sensitive) Cluster Registration Token generated for the cluster v2 (list maxitems:1)
        :param pulumi.Input[str] cluster_v1_id: (Computed) Cluster v1 id for cluster v2. (e.g to be used with `rancher2_sync`) (string)
        :param pulumi.Input[str] default_cluster_role_for_project_members: Cluster V2 default cluster role for project members (string)
        :param pulumi.Input[str] default_pod_security_policy_template_name: Cluster V2 default pod security policy template name (string)
        :param pulumi.Input[bool] enable_network_policy: Enable k8s network policy at Cluster V2 (bool)
        :param pulumi.Input[str] fleet_namespace: The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        :param pulumi.Input[str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster v2. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        :param pulumi.Input[str] kubernetes_version: The kubernetes version of the Cluster v2 (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for cluster registration token object (map)
        :param pulumi.Input[pulumi.InputType['ClusterV2LocalAuthEndpointArgs']] local_auth_endpoint: Use rancher2_cluster_v2.local_auth_endpoint instead
        :param pulumi.Input[str] name: Name of cluster registration token (string)
        :param pulumi.Input[str] resource_version: (Computed) Cluster v2 k8s resource version (string)
        :param pulumi.Input[pulumi.InputType['ClusterV2RkeConfigArgs']] rke_config: The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterV2State.__new__(_ClusterV2State)

        __props__.__dict__["agent_env_vars"] = agent_env_vars
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cloud_credential_secret_name"] = cloud_credential_secret_name
        __props__.__dict__["cluster_registration_token"] = cluster_registration_token
        __props__.__dict__["cluster_v1_id"] = cluster_v1_id
        __props__.__dict__["default_cluster_role_for_project_members"] = default_cluster_role_for_project_members
        __props__.__dict__["default_pod_security_policy_template_name"] = default_pod_security_policy_template_name
        __props__.__dict__["enable_network_policy"] = enable_network_policy
        __props__.__dict__["fleet_namespace"] = fleet_namespace
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["local_auth_endpoint"] = local_auth_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_version"] = resource_version
        __props__.__dict__["rke_config"] = rke_config
        return ClusterV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterV2AgentEnvVar']]]:
        """
        Optional Agent Env Vars for Rancher agent (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for cluster registration token object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster V2 cloud credential secret name (string)
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> pulumi.Output['outputs.ClusterV2ClusterRegistrationToken']:
        """
        (Computed/Sensitive) Cluster Registration Token generated for the cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "cluster_registration_token")

    @property
    @pulumi.getter(name="clusterV1Id")
    def cluster_v1_id(self) -> pulumi.Output[str]:
        """
        (Computed) Cluster v1 id for cluster v2. (e.g to be used with `rancher2_sync`) (string)
        """
        return pulumi.get(self, "cluster_v1_id")

    @property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster V2 default cluster role for project members (string)
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @property
    @pulumi.getter(name="defaultPodSecurityPolicyTemplateName")
    def default_pod_security_policy_template_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster V2 default pod security policy template name (string)
        """
        return pulumi.get(self, "default_pod_security_policy_template_name")

    @property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> pulumi.Output[bool]:
        """
        Enable k8s network policy at Cluster V2 (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The fleet namespace of the Cluster v2. Default: `\"fleet-default\"` (string)
        """
        return pulumi.get(self, "fleet_namespace")

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[str]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster v2. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        """
        return pulumi.get(self, "kube_config")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        The kubernetes version of the Cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for cluster registration token object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> pulumi.Output[Optional['outputs.ClusterV2LocalAuthEndpoint']]:
        """
        Use rancher2_cluster_v2.local_auth_endpoint instead
        """
        return pulumi.get(self, "local_auth_endpoint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of cluster registration token (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> pulumi.Output[str]:
        """
        (Computed) Cluster v2 k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> pulumi.Output['outputs.ClusterV2RkeConfig']:
        """
        The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

