# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetCatalogV2Result',
    'AwaitableGetCatalogV2Result',
    'get_catalog_v2',
    'get_catalog_v2_output',
]

@pulumi.output_type
class GetCatalogV2Result:
    """
    A collection of values returned by getCatalogV2.
    """
    def __init__(__self__, annotations=None, ca_bundle=None, cluster_id=None, enabled=None, git_branch=None, git_repo=None, id=None, insecure=None, labels=None, name=None, resource_version=None, secret_name=None, secret_namespace=None, service_account=None, service_account_namespace=None, url=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if ca_bundle and not isinstance(ca_bundle, str):
            raise TypeError("Expected argument 'ca_bundle' to be a str")
        pulumi.set(__self__, "ca_bundle", ca_bundle)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if git_branch and not isinstance(git_branch, str):
            raise TypeError("Expected argument 'git_branch' to be a str")
        pulumi.set(__self__, "git_branch", git_branch)
        if git_repo and not isinstance(git_repo, str):
            raise TypeError("Expected argument 'git_repo' to be a str")
        pulumi.set(__self__, "git_repo", git_repo)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insecure and not isinstance(insecure, bool):
            raise TypeError("Expected argument 'insecure' to be a bool")
        pulumi.set(__self__, "insecure", insecure)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_version and not isinstance(resource_version, str):
            raise TypeError("Expected argument 'resource_version' to be a str")
        pulumi.set(__self__, "resource_version", resource_version)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if secret_namespace and not isinstance(secret_namespace, str):
            raise TypeError("Expected argument 'secret_namespace' to be a str")
        pulumi.set(__self__, "secret_namespace", secret_namespace)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if service_account_namespace and not isinstance(service_account_namespace, str):
            raise TypeError("Expected argument 'service_account_namespace' to be a str")
        pulumi.set(__self__, "service_account_namespace", service_account_namespace)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, Any]:
        """
        (Computed) Annotations for the catalog v2 (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> str:
        """
        (Computed) PEM encoded CA bundle which will be used to validate the repo's certificate (string)
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        (Computed) If disabled the repo clone will not be updated or allowed to be installed from. Default: `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> str:
        """
        (Computed) Git Repository branch containing Helm chart definitions. Default `master` (string)
        """
        return pulumi.get(self, "git_branch")

    @property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> str:
        """
        (Computed) The url of the catalog v2 repo (string)
        """
        return pulumi.get(self, "git_repo")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def insecure(self) -> bool:
        """
        (Computed) Use insecure HTTPS to download the repo's index. Default: `false` (bool)
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (Computed) Labels for the catalog v2 (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        (Computed) The k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        (Computed) K8s secret name to be used to connect to the repo (string)
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretNamespace")
    def secret_namespace(self) -> str:
        """
        (Computed) K8s secret namespace (string)
        """
        return pulumi.get(self, "secret_namespace")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        (Computed) K8s service account used to deploy charts instead of the end users credentials (string)
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountNamespace")
    def service_account_namespace(self) -> str:
        """
        (Computed) The username to access the catalog if needed (string)
        """
        return pulumi.get(self, "service_account_namespace")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        (Computed) URL to an index generated by Helm (string)
        """
        return pulumi.get(self, "url")


class AwaitableGetCatalogV2Result(GetCatalogV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogV2Result(
            annotations=self.annotations,
            ca_bundle=self.ca_bundle,
            cluster_id=self.cluster_id,
            enabled=self.enabled,
            git_branch=self.git_branch,
            git_repo=self.git_repo,
            id=self.id,
            insecure=self.insecure,
            labels=self.labels,
            name=self.name,
            resource_version=self.resource_version,
            secret_name=self.secret_name,
            secret_namespace=self.secret_namespace,
            service_account=self.service_account,
            service_account_namespace=self.service_account_namespace,
            url=self.url)


def get_catalog_v2(cluster_id: Optional[str] = None,
                   name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogV2Result:
    """
    Use this data source to retrieve information about a Rancher2 catalog v2. Catalog v2 resource is available at Rancher v2.5.x and above.


    :param str cluster_id: The cluster id of the catalog V2 (string)
    :param str name: The name of the catalog v2 (string)
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('rancher2:index/getCatalogV2:getCatalogV2', __args__, opts=opts, typ=GetCatalogV2Result).value

    return AwaitableGetCatalogV2Result(
        annotations=__ret__.annotations,
        ca_bundle=__ret__.ca_bundle,
        cluster_id=__ret__.cluster_id,
        enabled=__ret__.enabled,
        git_branch=__ret__.git_branch,
        git_repo=__ret__.git_repo,
        id=__ret__.id,
        insecure=__ret__.insecure,
        labels=__ret__.labels,
        name=__ret__.name,
        resource_version=__ret__.resource_version,
        secret_name=__ret__.secret_name,
        secret_namespace=__ret__.secret_namespace,
        service_account=__ret__.service_account,
        service_account_namespace=__ret__.service_account_namespace,
        url=__ret__.url)


@_utilities.lift_output_func(get_catalog_v2)
def get_catalog_v2_output(cluster_id: Optional[pulumi.Input[str]] = None,
                          name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogV2Result]:
    """
    Use this data source to retrieve information about a Rancher2 catalog v2. Catalog v2 resource is available at Rancher v2.5.x and above.


    :param str cluster_id: The cluster id of the catalog V2 (string)
    :param str name: The name of the catalog v2 (string)
    """
    ...
