# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetClusterTemplateResult',
    'AwaitableGetClusterTemplateResult',
    'get_cluster_template',
    'get_cluster_template_output',
]

@pulumi.output_type
class GetClusterTemplateResult:
    """
    A collection of values returned by getClusterTemplate.
    """
    def __init__(__self__, annotations=None, default_revision_id=None, description=None, id=None, labels=None, members=None, name=None, template_revisions=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if default_revision_id and not isinstance(default_revision_id, str):
            raise TypeError("Expected argument 'default_revision_id' to be a str")
        pulumi.set(__self__, "default_revision_id", default_revision_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if template_revisions and not isinstance(template_revisions, list):
            raise TypeError("Expected argument 'template_revisions' to be a list")
        pulumi.set(__self__, "template_revisions", template_revisions)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, Any]:
        """
        (Computed) Annotations for the cluster template (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="defaultRevisionId")
    def default_revision_id(self) -> str:
        """
        (Computed) Default cluster template revision ID (string)
        """
        return pulumi.get(self, "default_revision_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (Computed) Labels for the cluster template (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetClusterTemplateMemberResult']:
        """
        (Computed) Cluster template members (list)
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateRevisions")
    def template_revisions(self) -> Sequence['outputs.GetClusterTemplateTemplateRevisionResult']:
        """
        (Computed) Cluster template revisions (list)
        """
        return pulumi.get(self, "template_revisions")


class AwaitableGetClusterTemplateResult(GetClusterTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterTemplateResult(
            annotations=self.annotations,
            default_revision_id=self.default_revision_id,
            description=self.description,
            id=self.id,
            labels=self.labels,
            members=self.members,
            name=self.name,
            template_revisions=self.template_revisions)


def get_cluster_template(annotations: Optional[Mapping[str, Any]] = None,
                         description: Optional[str] = None,
                         labels: Optional[Mapping[str, Any]] = None,
                         name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterTemplateResult:
    """
    Use this data source to retrieve information about a Rancher v2 cluster template.

    Cluster Templates are available from Rancher v2.3.x and above.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_template(name="foo")
    ```


    :param Mapping[str, Any] annotations: (Computed) Annotations for the cluster template (map)
    :param Mapping[str, Any] labels: (Computed) Labels for the cluster template (map)
    :param str name: The cluster template name (string)
    """
    __args__ = dict()
    __args__['annotations'] = annotations
    __args__['description'] = description
    __args__['labels'] = labels
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('rancher2:index/getClusterTemplate:getClusterTemplate', __args__, opts=opts, typ=GetClusterTemplateResult).value

    return AwaitableGetClusterTemplateResult(
        annotations=__ret__.annotations,
        default_revision_id=__ret__.default_revision_id,
        description=__ret__.description,
        id=__ret__.id,
        labels=__ret__.labels,
        members=__ret__.members,
        name=__ret__.name,
        template_revisions=__ret__.template_revisions)


@_utilities.lift_output_func(get_cluster_template)
def get_cluster_template_output(annotations: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                                description: Optional[pulumi.Input[Optional[str]]] = None,
                                labels: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                                name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterTemplateResult]:
    """
    Use this data source to retrieve information about a Rancher v2 cluster template.

    Cluster Templates are available from Rancher v2.3.x and above.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_template(name="foo")
    ```


    :param Mapping[str, Any] annotations: (Computed) Annotations for the cluster template (map)
    :param Mapping[str, Any] labels: (Computed) Labels for the cluster template (map)
    :param str name: The cluster template name (string)
    """
    ...
