"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from unkey.py.errors import UnkeyError
from unkey.py.models import baseerror as models_baseerror, meta as models_meta
from unkey.py.types import BaseModel


class ForbiddenErrorResponseData(BaseModel):
    meta: models_meta.Meta
    r"""Metadata object included in every API response. This provides context about the request and is essential for debugging, audit trails, and support inquiries. The `requestId` is particularly important when troubleshooting issues with the Unkey support team."""

    error: models_baseerror.BaseError
    r"""Base error structure following Problem Details for HTTP APIs (RFC 7807). This provides a standardized way to carry machine-readable details of errors in HTTP response content."""


class ForbiddenErrorResponse(UnkeyError):
    r"""Error response when the provided credentials are valid but lack sufficient permissions for the requested operation. This occurs when:
    - The root key doesn't have the required permissions for this endpoint
    - The operation requires elevated privileges that the current key lacks
    - Access to the requested resource is restricted based on workspace settings

    To resolve this error, ensure your root key has the necessary permissions or contact your workspace administrator.
    """

    data: ForbiddenErrorResponseData

    def __init__(
        self,
        data: ForbiddenErrorResponseData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
