"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from unkey.py.errors import UnkeyError
from unkey.py.models import baseerror as models_baseerror, meta as models_meta
from unkey.py.types import BaseModel


class NotFoundErrorResponseData(BaseModel):
    meta: models_meta.Meta
    r"""Metadata object included in every API response. This provides context about the request and is essential for debugging, audit trails, and support inquiries. The `requestId` is particularly important when troubleshooting issues with the Unkey support team."""

    error: models_baseerror.BaseError
    r"""Base error structure following Problem Details for HTTP APIs (RFC 7807). This provides a standardized way to carry machine-readable details of errors in HTTP response content."""


class NotFoundErrorResponse(UnkeyError):
    r"""Error response when the requested resource cannot be found. This occurs when:
    - The specified resource ID doesn't exist in your workspace
    - The resource has been deleted or moved
    - The resource exists but is not accessible with current permissions

    To resolve this error, verify the resource ID is correct and that you have access to it.
    """

    data: NotFoundErrorResponseData

    def __init__(
        self,
        data: NotFoundErrorResponseData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
