"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .keycreditsrefill import KeyCreditsRefill, KeyCreditsRefillTypedDict
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from unkey.py.types import BaseModel, Nullable, UNSET_SENTINEL


class KeyCreditsDataTypedDict(TypedDict):
    r"""Credit configuration and remaining balance for this key."""

    remaining: Nullable[int]
    r"""Number of credits remaining (null for unlimited)."""
    refill: NotRequired[KeyCreditsRefillTypedDict]
    r"""Configuration for automatic credit refill behavior."""


class KeyCreditsData(BaseModel):
    r"""Credit configuration and remaining balance for this key."""

    remaining: Nullable[int]
    r"""Number of credits remaining (null for unlimited)."""

    refill: Optional[KeyCreditsRefill] = None
    r"""Configuration for automatic credit refill behavior."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["refill"]
        nullable_fields = ["remaining"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
