"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class Interval(str, Enum):
    r"""How often credits are automatically refilled."""

    DAILY = "daily"
    MONTHLY = "monthly"


class KeyCreditsRefillTypedDict(TypedDict):
    r"""Configuration for automatic credit refill behavior."""

    interval: Interval
    r"""How often credits are automatically refilled."""
    amount: int
    r"""Number of credits to add during each refill cycle."""
    refill_day: NotRequired[int]
    r"""Day of the month for monthly refills (1-31).
    Only required when interval is 'monthly'.
    For days beyond the month's length, refill occurs on the last day of the month.

    """


class KeyCreditsRefill(BaseModel):
    r"""Configuration for automatic credit refill behavior."""

    interval: Interval
    r"""How often credits are automatically refilled."""

    amount: int
    r"""Number of credits to add during each refill cycle."""

    refill_day: Annotated[Optional[int], pydantic.Field(alias="refillDay")] = None
    r"""Day of the month for monthly refills (1-31).
    Only required when interval is 'monthly'.
    For days beyond the month's length, refill occurs on the last day of the month.

    """
