"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .identity import Identity, IdentityTypedDict
from .keycreditsdata import KeyCreditsData, KeyCreditsDataTypedDict
from .ratelimitresponse import RatelimitResponse, RatelimitResponseTypedDict
import pydantic
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class KeyResponseDataTypedDict(TypedDict):
    key_id: str
    r"""Unique identifier for this key."""
    start: str
    r"""First few characters of the key for identification."""
    enabled: bool
    r"""Whether the key is enabled or disabled."""
    created_at: int
    r"""Unix timestamp in milliseconds when key was created."""
    name: NotRequired[str]
    r"""Human-readable name for this key."""
    meta: NotRequired[Dict[str, Any]]
    r"""Custom metadata associated with this key."""
    updated_at: NotRequired[int]
    r"""Unix timestamp in milliseconds when key was last updated."""
    expires: NotRequired[int]
    r"""Unix timestamp in milliseconds when key expires (if set)."""
    external_id: NotRequired[str]
    r"""External identifier linking this key to an entity in your system."""
    permissions: NotRequired[List[str]]
    roles: NotRequired[List[str]]
    credits: NotRequired[KeyCreditsDataTypedDict]
    r"""Credit configuration and remaining balance for this key."""
    identity: NotRequired[IdentityTypedDict]
    plaintext: NotRequired[str]
    r"""Decrypted key value (only when decrypt=true)."""
    ratelimits: NotRequired[List[RatelimitResponseTypedDict]]


class KeyResponseData(BaseModel):
    key_id: Annotated[str, pydantic.Field(alias="keyId")]
    r"""Unique identifier for this key."""

    start: str
    r"""First few characters of the key for identification."""

    enabled: bool
    r"""Whether the key is enabled or disabled."""

    created_at: Annotated[int, pydantic.Field(alias="createdAt")]
    r"""Unix timestamp in milliseconds when key was created."""

    name: Optional[str] = None
    r"""Human-readable name for this key."""

    meta: Optional[Dict[str, Any]] = None
    r"""Custom metadata associated with this key."""

    updated_at: Annotated[Optional[int], pydantic.Field(alias="updatedAt")] = None
    r"""Unix timestamp in milliseconds when key was last updated."""

    expires: Optional[int] = None
    r"""Unix timestamp in milliseconds when key expires (if set)."""

    external_id: Annotated[Optional[str], pydantic.Field(alias="externalId")] = None
    r"""External identifier linking this key to an entity in your system."""

    permissions: Optional[List[str]] = None

    roles: Optional[List[str]] = None

    credits: Optional[KeyCreditsData] = None
    r"""Credit configuration and remaining balance for this key."""

    identity: Optional[Identity] = None

    plaintext: Optional[str] = None
    r"""Decrypted key value (only when decrypt=true)."""

    ratelimits: Optional[List[RatelimitResponse]] = None
