"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class PaginationTypedDict(TypedDict):
    r"""Pagination metadata for list endpoints. Provides information necessary to traverse through large result sets efficiently using cursor-based pagination."""

    has_more: bool
    r"""Indicates whether additional results exist beyond this page.
    When true, use the cursor to fetch the next page.
    When false, you have reached the end of the result set.

    """
    cursor: NotRequired[str]
    r"""Opaque pagination token for retrieving the next page of results.
    Include this exact value in the cursor field of subsequent requests.
    Cursors are temporary and may expire after extended periods.

    """


class Pagination(BaseModel):
    r"""Pagination metadata for list endpoints. Provides information necessary to traverse through large result sets efficiently using cursor-based pagination."""

    has_more: Annotated[bool, pydantic.Field(alias="hasMore")]
    r"""Indicates whether additional results exist beyond this page.
    When true, use the cursor to fetch the next page.
    When false, you have reached the end of the result set.

    """

    cursor: Optional[str] = None
    r"""Opaque pagination token for retrieving the next page of results.
    Include this exact value in the cursor field of subsequent requests.
    Cursors are temporary and may expire after extended periods.

    """
