"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from unkey.py.types import BaseModel


class PermissionTypedDict(TypedDict):
    id: str
    r"""The unique identifier for this permission within Unkey's system.
    Generated automatically when the permission is created and used to reference this permission in API operations.
    Always begins with 'perm_' followed by alphanumeric characters and underscores.

    """
    name: str
    r"""The human-readable name for this permission that describes its purpose.
    Should be descriptive enough for developers to understand what access it grants.
    Use clear, semantic names that reflect the resources or actions being permitted.
    Names must be unique within your workspace to avoid confusion and conflicts.

    """
    slug: str
    r"""The URL-safe identifier when this permission was created."""
    description: NotRequired[str]
    r"""Optional detailed explanation of what this permission grants access to.
    Helps team members understand the scope and implications of granting this permission.
    Include information about what resources can be accessed and what actions can be performed.
    Not visible to end users - this is for internal documentation and team clarity.

    """


class Permission(BaseModel):
    id: str
    r"""The unique identifier for this permission within Unkey's system.
    Generated automatically when the permission is created and used to reference this permission in API operations.
    Always begins with 'perm_' followed by alphanumeric characters and underscores.

    """

    name: str
    r"""The human-readable name for this permission that describes its purpose.
    Should be descriptive enough for developers to understand what access it grants.
    Use clear, semantic names that reflect the resources or actions being permitted.
    Names must be unique within your workspace to avoid confusion and conflicts.

    """

    slug: str
    r"""The URL-safe identifier when this permission was created."""

    description: Optional[str] = None
    r"""Optional detailed explanation of what this permission grants access to.
    Helps team members understand the scope and implications of granting this permission.
    Include information about what resources can be accessed and what actions can be performed.
    Not visible to end users - this is for internal documentation and team clarity.

    """
