"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing_extensions import Annotated, TypedDict
from unkey.py.types import BaseModel


class RatelimitOverrideTypedDict(TypedDict):
    override_id: str
    r"""The unique identifier of this specific rate limit override. This ID is generated when the override is created and can be used for management operations like updating or deleting the override."""
    duration: int
    r"""The duration in milliseconds for this override's rate limit window. This may differ from the default duration for the namespace, allowing custom time windows for specific entities. After this duration elapses, the rate limit counter for affected identifiers resets to zero."""
    identifier: str
    r"""The identifier pattern this override applies to. This determines which entities receive the custom rate limit.

    This can be:
    - An exact identifier for a specific entity
    - A pattern with wildcards for matching multiple entities

    Wildcard examples:
    - 'admin_*' matches any identifier starting with 'admin_'
    - '*_test' matches any identifier ending with '_test'
    - '*premium*' matches any identifier containing 'premium'

    More complex patterns can combine multiple wildcards. Detailed documentation on pattern matching rules is available at https://www.unkey.com/docs/ratelimiting/overrides#wildcard-rules
    """
    limit: int
    r"""The maximum number of requests allowed for entities matching this override. This replaces the default limit for the namespace when applied.

    Common use cases:
    - Higher limits for premium customers
    - Reduced limits for abusive or suspicious entities
    - Zero limit to completely block specific patterns
    - Custom tier-based limits for different customer segments
    """


class RatelimitOverride(BaseModel):
    override_id: Annotated[str, pydantic.Field(alias="overrideId")]
    r"""The unique identifier of this specific rate limit override. This ID is generated when the override is created and can be used for management operations like updating or deleting the override."""

    duration: int
    r"""The duration in milliseconds for this override's rate limit window. This may differ from the default duration for the namespace, allowing custom time windows for specific entities. After this duration elapses, the rate limit counter for affected identifiers resets to zero."""

    identifier: str
    r"""The identifier pattern this override applies to. This determines which entities receive the custom rate limit.

    This can be:
    - An exact identifier for a specific entity
    - A pattern with wildcards for matching multiple entities

    Wildcard examples:
    - 'admin_*' matches any identifier starting with 'admin_'
    - '*_test' matches any identifier ending with '_test'
    - '*premium*' matches any identifier containing 'premium'

    More complex patterns can combine multiple wildcards. Detailed documentation on pattern matching rules is available at https://www.unkey.com/docs/ratelimiting/overrides#wildcard-rules
    """

    limit: int
    r"""The maximum number of requests allowed for entities matching this override. This replaces the default limit for the namespace when applied.

    Common use cases:
    - Higher limits for premium customers
    - Reduced limits for abusive or suspicious entities
    - Zero limit to completely block specific patterns
    - Custom tier-based limits for different customer segments
    """
